/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpServerTransport;
import com.ericsson.otp.erlang.OtpSocketTransportFactory;
import com.ericsson.otp.erlang.OtpTransport;
import com.ericsson.otp.erlang.OtpTransportFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AbstractNode
implements OtpTransportFactory {
    static String localHost = null;
    String node;
    String host;
    String alive;
    String cookie;
    static String defaultCookie = null;
    final OtpTransportFactory transportFactory;
    static final int NTYPE_R6 = 110;
    static final int NTYPE_R4_ERLANG = 109;
    static final int NTYPE_R4_HIDDEN = 104;
    static final int dFlagPublished = 1;
    static final int dFlagAtomCache = 2;
    static final int dFlagExtendedReferences = 4;
    static final int dFlagDistMonitor = 8;
    static final int dFlagFunTags = 16;
    static final int dFlagDistMonitorName = 32;
    static final int dFlagHiddenAtomCache = 64;
    static final int dflagNewFunTags = 128;
    static final int dFlagExtendedPidsPorts = 256;
    static final int dFlagExportPtrTag = 512;
    static final int dFlagBitBinaries = 1024;
    static final int dFlagNewFloats = 2048;
    static final int dFlagUnicodeIo = 4096;
    static final int dFlagUtf8Atoms = 65536;
    static final int dFlagMapTag = 131072;
    static final int dFlagBigCreation = 262144;
    int ntype = 110;
    int proto = 0;
    int distHigh = 5;
    int distLow = 5;
    int creation = 0;
    int flags = 462740;

    protected AbstractNode(OtpTransportFactory otpTransportFactory) {
        this.transportFactory = otpTransportFactory;
    }

    protected AbstractNode(String string) {
        this(string, defaultCookie, new OtpSocketTransportFactory());
    }

    protected AbstractNode(String string, OtpTransportFactory otpTransportFactory) {
        this(string, defaultCookie, otpTransportFactory);
    }

    protected AbstractNode(String string, String string2) {
        this(string, string2, new OtpSocketTransportFactory());
    }

    protected AbstractNode(String string, String string2, OtpTransportFactory otpTransportFactory) {
        this.cookie = string2;
        this.transportFactory = otpTransportFactory;
        int n = string.indexOf(64, 0);
        if (n < 0) {
            this.alive = string;
            this.host = localHost;
        } else {
            this.alive = string.substring(0, n);
            this.host = string.substring(n + 1, string.length());
        }
        if (this.alive.length() > 255) {
            this.alive = this.alive.substring(0, 255);
        }
        this.node = this.alive + "@" + this.host;
    }

    public String node() {
        return this.node;
    }

    public String host() {
        return this.host;
    }

    public String alive() {
        return this.alive;
    }

    public String cookie() {
        return this.cookie;
    }

    int type() {
        return this.ntype;
    }

    int distHigh() {
        return this.distHigh;
    }

    int distLow() {
        return this.distLow;
    }

    int proto() {
        return this.proto;
    }

    int creation() {
        return this.creation;
    }

    public String setCookie(String string) {
        String string2 = this.cookie;
        this.cookie = string;
        return string2;
    }

    public String toString() {
        return this.node();
    }

    private static String getHomeDir() {
        String string = System.getProperty("user.home");
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            String string2 = System.getenv("HOMEDRIVE");
            String string3 = System.getenv("HOMEPATH");
            return string2 != null && string3 != null ? string2 + string3 : string;
        }
        return string;
    }

    @Override
    public OtpTransport createTransport(String string, int n) throws IOException {
        return this.transportFactory.createTransport(string, n);
    }

    @Override
    public OtpTransport createTransport(InetAddress inetAddress, int n) throws IOException {
        return this.transportFactory.createTransport(inetAddress, n);
    }

    @Override
    public OtpServerTransport createServerTransport(int n) throws IOException {
        return this.transportFactory.createServerTransport(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            localHost = InetAddress.getLocalHost().getHostName();
            int n = localHost.indexOf(".");
            if (n != -1) {
                localHost = localHost.substring(0, n);
            }
        }
        catch (UnknownHostException unknownHostException) {
            localHost = "localhost";
        }
        String string = AbstractNode.getHomeDir();
        String string2 = string + File.separator + ".erlang.cookie";
        BufferedReader bufferedReader = null;
        try {
            File file = new File(string2);
            bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = bufferedReader.readLine();
            defaultCookie = string3 == null ? "" : string3.trim();
        }
        catch (IOException iOException) {
            defaultCookie = "";
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

