/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin.dynamic;

import javax.swing.JPanel;
import org.gephi.statistics.plugin.dynamic.DynamicNbEdges;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.statistics.plugin.dynamic.DynamicNbEdgesPanel;
import org.openide.util.NbBundle;

public class DynamicNbEdgesUI
implements StatisticsUI {
    private final StatSettings settings = new StatSettings();
    private DynamicNbEdges nbEdges;
    private DynamicNbEdgesPanel panel;

    public JPanel getSettingsPanel() {
        this.panel = new DynamicNbEdgesPanel();
        return this.panel;
    }

    public void setup(Statistics statistics) {
        this.nbEdges = (DynamicNbEdges)statistics;
        if (this.panel != null) {
            this.settings.load(this.nbEdges);
        }
    }

    public void unsetup() {
        if (this.panel != null) {
            this.settings.save(this.nbEdges);
        }
        this.nbEdges = null;
    }

    public Class<? extends Statistics> getStatisticsClass() {
        return DynamicNbEdges.class;
    }

    public String getValue() {
        return "";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"DynamicNbEdgesUI.name");
    }

    public String getCategory() {
        return StatisticsUI.CATEGORY_DYNAMIC;
    }

    public int getPosition() {
        return 200;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(this.getClass(), (String)"DynamicNbEdgesUI.shortDescription");
    }

    private static class StatSettings {
        private double window = 0.0;
        private double tick = 0.0;

        private StatSettings() {
        }

        private void save(DynamicNbEdges stat) {
            this.window = stat.getWindow();
            this.tick = stat.getTick();
        }

        private void load(DynamicNbEdges stat) {
            stat.setWindow(this.window);
            stat.setTick(this.tick);
        }
    }
}

