/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.DateWithOffset;
import ch.poole.openinghoursparser.Element;
import ch.poole.openinghoursparser.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DateRange
extends Element {
    DateWithOffset startDate = null;
    DateWithOffset endDate = null;
    int interval = 0;

    public DateRange() {
    }

    public DateRange(@NotNull DateRange dr) {
        this.startDate = dr.startDate != null ? dr.startDate.copy() : null;
        this.endDate = dr.endDate != null ? dr.endDate.copy() : null;
        this.interval = dr.interval;
    }

    public String toString() {
        this.checkStartDate();
        StringBuilder b = new StringBuilder();
        b.append(this.startDate.toString());
        if (this.endDate != null && !this.endDate.isUndefined()) {
            b.append("-");
            b.append(this.endDate.toString());
        }
        if (this.interval > 0) {
            b.append("/");
            b.append(this.interval);
        }
        return b.toString();
    }

    private void checkStartDate() {
        if (this.startDate == null) {
            throw new IllegalStateException("range must have a start date");
        }
    }

    @Override
    public String toDebugString() {
        this.checkStartDate();
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName() + ":");
        b.append(this.startDate.toDebugString());
        if (this.endDate != null && !this.endDate.isUndefined()) {
            b.append("-");
            b.append(this.endDate.toDebugString());
        }
        if (this.interval > 0) {
            b.append("/");
            b.append(this.interval);
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DateRange) {
            DateRange o = (DateRange)other;
            return Util.equals(this.startDate, o.startDate) && Util.equals(this.endDate, o.endDate) && this.interval == o.interval;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = 37 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 37 * result + this.interval;
        return result;
    }

    @NotNull
    public DateWithOffset getStartDate() {
        this.checkStartDate();
        return this.startDate;
    }

    @Nullable
    public DateWithOffset getEndDate() {
        return this.endDate;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setStartDate(@NotNull DateWithOffset startDate) {
        if (startDate == null) {
            throw new NullPointerException("startDate");
        }
        this.startDate = startDate;
    }

    public void setEndDate(@Nullable DateWithOffset endDate) {
        this.endDate = endDate;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    @Override
    public DateRange copy() {
        return new DateRange(this);
    }
}

