/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Command;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.CommandInteger;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.GeometryTypes;
import org.openstreetmap.josm.tools.I18n;

public class Geometry {
    final Collection<Shape> shapes;

    public Geometry(GeometryTypes geometryType, List<CommandInteger> commands) {
        block12: {
            block11: {
                this.shapes = new ArrayList<Shape>();
                if (geometryType != GeometryTypes.POINT) break block11;
                for (CommandInteger command : commands) {
                    short[] operations = command.getOperations();
                    if (command.getType() == Command.MoveTo && operations.length % 2 == 0 && operations.length > 0) {
                        for (int i = 0; i < operations.length / 2; ++i) {
                            this.shapes.add(new Ellipse2D.Float(operations[2 * i], operations[2 * i + 1], 0.0f, 0.0f));
                        }
                        continue;
                    }
                    throw new IllegalArgumentException(I18n.tr("{0} with {1} arguments is not understood", new Object[]{geometryType, operations.length}));
                }
                break block12;
            }
            if (geometryType != GeometryTypes.LINESTRING && geometryType != GeometryTypes.POLYGON) break block12;
            Path2D.Float line = null;
            Area area = null;
            double x = 0.0;
            double y = 0.0;
            double areaAreaSq = 0.0;
            for (CommandInteger command : commands) {
                short[] operations = command.getOperations();
                if (command.getType() == Command.MoveTo && operations.length == 2) {
                    areaAreaSq = 0.0;
                    line = new Path2D.Float();
                    line.moveTo(x += (double)operations[0], y += (double)operations[1]);
                    this.shapes.add(line);
                    continue;
                }
                if (command.getType() == Command.LineTo && operations.length % 2 == 0 && line != null) {
                    for (int i = 0; i < operations.length / 2; ++i) {
                        double lx = x;
                        double ly = y;
                        areaAreaSq += lx * (y += (double)operations[2 * i + 1]) - (x += (double)operations[2 * i]) * ly;
                        line.lineTo(x, y);
                    }
                    continue;
                }
                if (geometryType == GeometryTypes.POLYGON && command.getType() == Command.ClosePath && line != null) {
                    this.shapes.remove(line);
                    if (area == null) {
                        area = new Area();
                        this.shapes.add(area);
                    }
                    Area nArea = new Area(line);
                    if (areaAreaSq > 0.0) {
                        area.add(nArea);
                        continue;
                    }
                    if (areaAreaSq < 0.0) {
                        area.exclusiveOr(nArea);
                        continue;
                    }
                    throw new IllegalArgumentException(I18n.tr("{0} cannot have zero area", new Object[]{geometryType}));
                }
                throw new IllegalArgumentException(I18n.tr("{0} with {1} arguments is not understood", new Object[]{geometryType, operations.length}));
            }
        }
    }

    public Collection<Shape> getShapes() {
        return Collections.unmodifiableCollection(this.shapes);
    }
}

