/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.jms;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.jms.DwrConnection;
import org.directwebremoting.jms.DwrMessage;
import org.directwebremoting.jms.DwrMessageConsumer;
import org.directwebremoting.jms.DwrMessageProducer;
import org.directwebremoting.jms.DwrTopic;
import org.directwebremoting.jms.Unsupported;

public class DwrSession
implements Session {
    private int acknowledgeMode;
    private boolean transacted;
    private MessageListener messageListener;
    private DwrConnection connection;
    private boolean shownTransactionWarning = false;
    private static final Log log = LogFactory.getLog(DwrSession.class);

    public DwrSession(DwrConnection connection, boolean transacted, int acknowledgeMode) {
        if (transacted) {
            throw Unsupported.noTransactions();
        }
        if (acknowledgeMode != 1) {
            throw Unsupported.noManualAcknowledgment();
        }
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.connection = connection;
    }

    public DwrMessage createMessage() throws JMSException {
        return new DwrMessage();
    }

    public DwrMessage createMapMessage() throws JMSException {
        return new DwrMessage();
    }

    public DwrMessage createTextMessage() throws JMSException {
        return new DwrMessage();
    }

    public DwrMessage createTextMessage(String text) throws JMSException {
        return new DwrMessage(text);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        throw Unsupported.noBinaryMessages();
    }

    public BytesMessage createBytesMessage() throws JMSException {
        throw Unsupported.noBinaryMessages();
    }

    public DwrMessage createObjectMessage() throws JMSException {
        return new DwrMessage();
    }

    public DwrMessage createObjectMessage(Serializable object) throws JMSException {
        return new DwrMessage(object);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw Unsupported.noPointToPoint();
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        throw Unsupported.noPointToPoint();
    }

    public DwrMessageConsumer createConsumer(Destination destination) throws JMSException {
        return new DwrMessageConsumer(this.connection, destination);
    }

    public DwrMessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return new DwrMessageConsumer(this.connection, destination, messageSelector);
    }

    public DwrMessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return new DwrMessageConsumer(this.connection, destination, messageSelector, noLocal);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw Unsupported.noDurableSubscriptions();
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw Unsupported.noDurableSubscriptions();
    }

    public DwrMessageProducer createProducer(Destination destination) throws JMSException {
        return new DwrMessageProducer(destination, this.connection);
    }

    public Queue createQueue(String queueName) throws JMSException {
        throw Unsupported.noPointToPoint();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw Unsupported.noPointToPoint();
    }

    public DwrTopic createTopic(String topicName) throws JMSException {
        return new DwrTopic(topicName);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw Unsupported.noTemporaryTopic();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.acknowledgeMode;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.messageListener = messageListener;
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.messageListener;
    }

    public boolean getTransacted() throws JMSException {
        return this.transacted;
    }

    public void commit() throws JMSException {
        if (!this.shownTransactionWarning) {
            log.warn((Object)"DWR's JMS support is not transactional");
            this.shownTransactionWarning = true;
        }
    }

    public void recover() throws JMSException {
        throw Unsupported.noManualAcknowledgment();
    }

    public void rollback() throws JMSException {
        if (!this.shownTransactionWarning) {
            log.warn((Object)"DWR's JMS support is not transactional");
            this.shownTransactionWarning = true;
        }
    }

    public void run() {
    }

    public void close() throws JMSException {
    }

    public void unsubscribe(String name) throws JMSException {
        throw Unsupported.noDurableSubscriptions();
    }
}

