/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SkinParamColors;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class FtileBoxOld
extends AbstractFtile {
    private final ClockwiseTopRightBottomLeft padding;
    private final TextBlock tb;
    private double roundCorner = 25.0;
    private final double shadowing;
    private final HorizontalAlignment horizontalAlignment;
    private double minimumWidth = 0.0;
    private final LinkRendering inRendering;
    private final Swimlane swimlane;
    private final BoxStyle boxStyle;
    private final HColor borderColor;
    private final HColor backColor;
    private final Style style;
    private final String print;

    public static StyleSignature getDefaultStyleDefinitionActivity() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.inRendering;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public static FtileBoxOld create(ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Stereotype stereotype) {
        Style style = null;
        Style styleArrow = null;
        if (UseStyle.useBetaStyle()) {
            style = FtileBoxOld.getDefaultStyleDefinitionActivity().with(stereotype).getMergedStyle(skinParam.getCurrentStyleBuilder());
            styleArrow = FtileBoxOld.getDefaultStyleDefinitionArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
        }
        return new FtileBoxOld(skinParam, label, swimlane, boxStyle, style, styleArrow);
    }

    public static TextBlock createWbs(StyleBuilder styleBuilder, ISkinParam skinParam, Display label, StyleSignature styleDefinition) {
        Style style = null;
        Style styleArrow = null;
        if (UseStyle.useBetaStyle()) {
            styleArrow = style = styleDefinition.getMergedStyle(styleBuilder);
        }
        return new FtileBoxOld(skinParam, label, null, BoxStyle.PLAIN, style, styleArrow);
    }

    public static TextBlock createWbs(Style style, ISkinParam skinParam, Display label) {
        Style styleArrow = null;
        if (UseStyle.useBetaStyle()) {
            styleArrow = style;
        }
        return new FtileBoxOld(skinParam, label, null, BoxStyle.PLAIN, style, styleArrow);
    }

    public static TextBlock createMindMap(StyleBuilder styleBuilder, ISkinParam skinParam, Display label, StyleSignature styleDefinition) {
        Style style;
        Style styleArrow = style = styleDefinition.getMergedStyle(styleBuilder);
        return new FtileBoxOld(skinParam, label, null, BoxStyle.PLAIN, style, styleArrow);
    }

    private FtileBoxOld(ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Style style, Style styleArrow) {
        super(skinParam);
        LineBreakStrategy wrapWidth;
        FontConfiguration fc;
        this.style = style;
        this.boxStyle = boxStyle;
        this.swimlane = swimlane;
        if (UseStyle.useBetaStyle()) {
            this.inRendering = new LinkRendering(Rainbow.build(styleArrow, this.getIHtmlColorSet(), skinParam.getThemeStyle()));
            Colors specBack = null;
            if (skinParam instanceof SkinParamColors) {
                specBack = ((SkinParamColors)skinParam).getColors();
            }
            style = style.eventuallyOverride(specBack);
            this.borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
            this.backColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
            fc = style.getFontConfiguration(skinParam.getThemeStyle(), this.getIHtmlColorSet());
            this.horizontalAlignment = style.getHorizontalAlignment();
            this.padding = style.getPadding();
            this.roundCorner = style.value(PName.RoundCorner).asDouble();
            this.shadowing = style.value(PName.Shadowing).asDouble();
            wrapWidth = style.wrapWidth();
            this.minimumWidth = style.value(PName.MinimumWidth).asDouble();
        } else {
            this.padding = ClockwiseTopRightBottomLeft.same(10.0);
            this.inRendering = new LinkRendering(Rainbow.build(skinParam));
            this.borderColor = SkinParamUtils.getColor(this.skinParam(), null, ColorParam.activityBorder);
            this.backColor = SkinParamUtils.getColor(this.skinParam(), null, ColorParam.activityBackground);
            fc = new FontConfiguration(skinParam, FontParam.ACTIVITY, null);
            this.horizontalAlignment = HorizontalAlignment.LEFT;
            this.shadowing = this.skinParam().shadowing(null) ? 3.0 : 0.0;
            wrapWidth = skinParam.wrapWidth();
        }
        Sheet sheet = Parser.build(fc, skinParam.getDefaultTextAlignment(this.horizontalAlignment), skinParam, CreoleMode.FULL).createSheet(label);
        this.tb = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), new MyStencil(), new UStroke(1.0));
        this.print = label.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    public void drawU(UGraphic ug) {
        FtileGeometry dimTotal = this.calculateDimension(ug.getStringBounder());
        double widthTotal = ((Dimension2D)dimTotal).getWidth();
        double heightTotal = ((Dimension2D)dimTotal).getHeight();
        UDrawable shape = this.boxStyle.getUDrawable(widthTotal, heightTotal, this.shadowing, this.roundCorner);
        UStroke thickness = UseStyle.useBetaStyle() ? this.style.getStroke() : this.getThickness();
        ug = this.borderColor == null ? ug.apply(new HColorNone()) : ug.apply(this.borderColor);
        ug = this.backColor == null ? ug.apply(new HColorNone().bg()) : ug.apply(this.backColor.bg());
        ug = ug.apply(thickness);
        shape.drawU(ug);
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.tb.drawU(ug.apply(new UTranslate(this.padding.getLeft(), this.padding.getTop())));
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            Dimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate(((Dimension2D)dimTotal).getWidth() - dimTb.getWidth() - this.padding.getRight(), this.padding.getBottom())));
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
            Dimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate((((Dimension2D)dimTotal).getWidth() - dimTb.getWidth()) / 2.0, this.padding.getBottom())));
        }
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        Dimension2D dimRaw = this.tb.calculateDimension(stringBounder);
        dimRaw = Dimension2DDouble.delta(dimRaw, this.padding.getLeft() + this.padding.getRight(), this.padding.getBottom() + this.padding.getTop());
        dimRaw = Dimension2DDouble.atLeast(dimRaw, this.minimumWidth, 0.0);
        return new FtileGeometry(dimRaw.getWidth() + this.boxStyle.getShield(), dimRaw.getHeight(), dimRaw.getWidth() / 2.0, 0.0, dimRaw.getHeight());
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    class MyStencil
    implements Stencil {
        MyStencil() {
        }

        @Override
        public double getStartingX(StringBounder stringBounder, double y) {
            return -FtileBoxOld.this.padding.getLeft();
        }

        @Override
        public double getEndingX(StringBounder stringBounder, double y) {
            FtileGeometry dim = FtileBoxOld.this.calculateDimension(stringBounder);
            return ((Dimension2D)dim).getWidth() - FtileBoxOld.this.padding.getRight();
        }
    }
}

