/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLQuantifiedRestrictionImpl;

public abstract class OWLQuantifiedObjectRestrictionImpl
extends OWLQuantifiedRestrictionImpl<OWLClassExpression>
implements OWLObjectRestriction {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLObjectPropertyExpression property;

    public OWLQuantifiedObjectRestrictionImpl(@Nonnull OWLObjectPropertyExpression property, @Nonnull OWLClassExpression filler) {
        super(filler);
        this.property = OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
    }

    @Override
    public OWLObjectPropertyExpression getProperty() {
        return this.property;
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        this.addSignatureEntitiesToSetForValue(entities, this.getProperty());
        this.addSignatureEntitiesToSetForValue(entities, this.getFiller());
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        this.addAnonymousIndividualsToSetForValue(anons, this.getProperty());
        this.addAnonymousIndividualsToSetForValue(anons, this.getFiller());
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLQuantifiedObjectRestriction other = (OWLQuantifiedObjectRestriction)object;
        int diff = this.getProperty().compareTo(other.getProperty());
        if (diff != 0) {
            return diff;
        }
        return ((OWLClassExpression)this.getFiller()).compareTo(other.getFiller());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLObjectRestriction)) {
            return false;
        }
        return this.property.equals(((OWLObjectRestriction)obj).getProperty());
    }
}

