/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import javax.media.j3d.J3dI18N;
import javax.vecmath.Point2f;

public class FontExtrusion {
    float length = 0.2f;
    Shape shape;
    Point2f[] pnts;
    double tessellationTolerance = 0.01;

    public FontExtrusion() {
        this.shape = null;
    }

    public FontExtrusion(Shape shape) {
        this.setExtrusionShape(shape);
    }

    public FontExtrusion(Shape shape, double d) {
        this.tessellationTolerance = d;
        this.setExtrusionShape(shape);
    }

    public void setExtrusionShape(Shape shape) {
        this.shape = shape;
        if (this.shape == null) {
            return;
        }
        PathIterator pathIterator = this.shape.getPathIterator(null, this.tessellationTolerance);
        ArrayList<Point2f> arrayList = new ArrayList<Point2f>();
        float[] fArray = new float[6];
        float f = 0.0f;
        int n = 0;
        int n2 = -1;
        while (!pathIterator.isDone()) {
            Point2f point2f = new Point2f();
            int n3 = pathIterator.currentSegment(fArray);
            if (n3 == 1) {
                point2f.x = fArray[0];
                point2f.y = fArray[1];
                if (n2 == -1) {
                    if (f < point2f.x) {
                        n2 = 0;
                    } else if (f > point2f.x) {
                        n2 = 1;
                    }
                }
                if (n2 == 0 && f > point2f.x || n2 == 1 && f < point2f.x) {
                    throw new IllegalArgumentException(J3dI18N.getString("FontExtrusion0"));
                }
                f = point2f.x;
                ++n;
                arrayList.add(point2f);
            } else if (n3 == 0) {
                if (n != 0) {
                    throw new IllegalArgumentException(J3dI18N.getString("FontExtrusion3"));
                }
                point2f.x = fArray[0];
                point2f.y = fArray[1];
                f = point2f.x;
                ++n;
                arrayList.add(point2f);
            }
            pathIterator.next();
        }
        int n4 = arrayList.size();
        this.pnts = new Point2f[n4];
        if (n2 == 0) {
            for (int i = 0; i < n4; ++i) {
                this.pnts[i] = (Point2f)arrayList.get(i);
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                this.pnts[i] = (Point2f)arrayList.get(n4 - i - 1);
            }
        }
        this.pnts[n4 - 1].y = 0.0f;
        if (this.pnts[0].x != 0.0f) {
            throw new IllegalArgumentException(J3dI18N.getString("FontExtrusion1"));
        }
        float f2 = this.pnts[0].x - this.pnts[n4 - 1].x;
        float f3 = this.pnts[0].y - this.pnts[n4 - 1].y;
        this.length = (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    public Shape getExtrusionShape() {
        return this.shape;
    }

    public double getTessellationTolerance() {
        return this.tessellationTolerance;
    }
}

