/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Rectangle;

class Area {
    private int x0;
    private int y0;
    private int x1;
    private int y1;

    public Area() {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE, -1, -1);
    }

    public Area(int width, int height) {
        this(0, 0, width - 1, height - 1);
    }

    public Area(int x0, int y0, int x1, int y1) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
    }

    public synchronized int getX0() {
        return this.x0;
    }

    public synchronized int getY0() {
        return this.y0;
    }

    public synchronized int getX1() {
        return this.x1;
    }

    public synchronized int getY1() {
        return this.y1;
    }

    private void clear() {
        this.x0 = Integer.MAX_VALUE;
        this.y0 = Integer.MAX_VALUE;
        this.x1 = -1;
        this.y1 = -1;
    }

    public synchronized void add(int newx, int newy) {
        this.x0 = Math.min(this.x0, newx);
        this.x1 = Math.max(this.x1, newx);
        this.y0 = Math.min(this.y0, newy);
        this.y1 = Math.max(this.y1, newy);
    }

    public synchronized void add(Rectangle r) {
        if ((r.x | r.width | r.y | r.height) >= 0) {
            this.x0 = Math.min(this.x0, r.x);
            this.x1 = Math.max(this.x1, r.x + r.width - 1);
            this.y0 = Math.min(this.y0, r.y);
            this.y1 = Math.max(this.y1, r.y + r.height - 1);
        }
    }

    public synchronized boolean isEmpty() {
        return this.x1 < this.x0 || this.y1 < this.y0;
    }

    private synchronized Area getBounds() {
        return new Area(this.x0, this.y0, this.x1, this.y1);
    }

    protected synchronized Area getBoundsAndClear() {
        Area a = this.getBounds();
        this.clear();
        return a;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.x0 + "," + this.y0 + "-" + this.x1 + "," + this.y1 + "]";
    }
}

