/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.protege.editor.core.ui.view.ViewBarIcon;

public class HelpIcon
extends ViewBarIcon {
    private static final String HELP_STRING = "?";
    private static final HelpIcon ICON = new HelpIcon();
    private static final Font font = new Font("Verdana", 1, 10);

    private HelpIcon() {
    }

    public static HelpIcon get() {
        return ICON;
    }

    @Override
    public void paintIcon(Component c, Graphics graphics, int x, int y) {
        Graphics2D g2 = (Graphics2D)graphics.create();
        g2.setColor(Color.WHITE);
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        g2.drawRect(1, 1, width - 2, height - 2);
        g2.setFont(font);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(HELP_STRING, g2);
        float xPos = (float)(((double)width - bounds.getWidth()) / 2.0);
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        float yPos = (height + 1) / 2 - (ascent + descent) / 2 + ascent;
        g2.drawString(HELP_STRING, xPos, yPos);
        g2.translate(-x, -y);
    }
}

