import {Request} from '../lib/request';
import {Response} from '../lib/response';
import {AWSError} from '../lib/error';
import {Service} from '../lib/service';
import {ServiceConfigurationOptions} from '../lib/service';
import {ConfigBase as Config} from '../lib/config-base';
interface Blob {}
declare class AccessAnalyzer extends Service {
  /**
   * Constructs a service object. This object has one method for each API operation.
   */
  constructor(options?: AccessAnalyzer.Types.ClientConfiguration)
  config: Config & AccessAnalyzer.Types.ClientConfiguration;
  /**
   * Retroactively applies the archive rule to existing findings that meet the archive rule criteria.
   */
  applyArchiveRule(params: AccessAnalyzer.Types.ApplyArchiveRuleRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Retroactively applies the archive rule to existing findings that meet the archive rule criteria.
   */
  applyArchiveRule(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Cancels the requested policy generation.
   */
  cancelPolicyGeneration(params: AccessAnalyzer.Types.CancelPolicyGenerationRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.CancelPolicyGenerationResponse) => void): Request<AccessAnalyzer.Types.CancelPolicyGenerationResponse, AWSError>;
  /**
   * Cancels the requested policy generation.
   */
  cancelPolicyGeneration(callback?: (err: AWSError, data: AccessAnalyzer.Types.CancelPolicyGenerationResponse) => void): Request<AccessAnalyzer.Types.CancelPolicyGenerationResponse, AWSError>;
  /**
   * Creates an access preview that allows you to preview Access Analyzer findings for your resource before deploying resource permissions.
   */
  createAccessPreview(params: AccessAnalyzer.Types.CreateAccessPreviewRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.CreateAccessPreviewResponse) => void): Request<AccessAnalyzer.Types.CreateAccessPreviewResponse, AWSError>;
  /**
   * Creates an access preview that allows you to preview Access Analyzer findings for your resource before deploying resource permissions.
   */
  createAccessPreview(callback?: (err: AWSError, data: AccessAnalyzer.Types.CreateAccessPreviewResponse) => void): Request<AccessAnalyzer.Types.CreateAccessPreviewResponse, AWSError>;
  /**
   * Creates an analyzer for your account.
   */
  createAnalyzer(params: AccessAnalyzer.Types.CreateAnalyzerRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.CreateAnalyzerResponse) => void): Request<AccessAnalyzer.Types.CreateAnalyzerResponse, AWSError>;
  /**
   * Creates an analyzer for your account.
   */
  createAnalyzer(callback?: (err: AWSError, data: AccessAnalyzer.Types.CreateAnalyzerResponse) => void): Request<AccessAnalyzer.Types.CreateAnalyzerResponse, AWSError>;
  /**
   * Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet the criteria you define when you create the rule. To learn about filter keys that you can use to create an archive rule, see Access Analyzer filter keys in the IAM User Guide.
   */
  createArchiveRule(params: AccessAnalyzer.Types.CreateArchiveRuleRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet the criteria you define when you create the rule. To learn about filter keys that you can use to create an archive rule, see Access Analyzer filter keys in the IAM User Guide.
   */
  createArchiveRule(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified analyzer. When you delete an analyzer, Access Analyzer is disabled for the account or organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.
   */
  deleteAnalyzer(params: AccessAnalyzer.Types.DeleteAnalyzerRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified analyzer. When you delete an analyzer, Access Analyzer is disabled for the account or organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.
   */
  deleteAnalyzer(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified archive rule.
   */
  deleteArchiveRule(params: AccessAnalyzer.Types.DeleteArchiveRuleRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified archive rule.
   */
  deleteArchiveRule(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Retrieves information about an access preview for the specified analyzer.
   */
  getAccessPreview(params: AccessAnalyzer.Types.GetAccessPreviewRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.GetAccessPreviewResponse) => void): Request<AccessAnalyzer.Types.GetAccessPreviewResponse, AWSError>;
  /**
   * Retrieves information about an access preview for the specified analyzer.
   */
  getAccessPreview(callback?: (err: AWSError, data: AccessAnalyzer.Types.GetAccessPreviewResponse) => void): Request<AccessAnalyzer.Types.GetAccessPreviewResponse, AWSError>;
  /**
   * Retrieves information about a resource that was analyzed.
   */
  getAnalyzedResource(params: AccessAnalyzer.Types.GetAnalyzedResourceRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.GetAnalyzedResourceResponse) => void): Request<AccessAnalyzer.Types.GetAnalyzedResourceResponse, AWSError>;
  /**
   * Retrieves information about a resource that was analyzed.
   */
  getAnalyzedResource(callback?: (err: AWSError, data: AccessAnalyzer.Types.GetAnalyzedResourceResponse) => void): Request<AccessAnalyzer.Types.GetAnalyzedResourceResponse, AWSError>;
  /**
   * Retrieves information about the specified analyzer.
   */
  getAnalyzer(params: AccessAnalyzer.Types.GetAnalyzerRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.GetAnalyzerResponse) => void): Request<AccessAnalyzer.Types.GetAnalyzerResponse, AWSError>;
  /**
   * Retrieves information about the specified analyzer.
   */
  getAnalyzer(callback?: (err: AWSError, data: AccessAnalyzer.Types.GetAnalyzerResponse) => void): Request<AccessAnalyzer.Types.GetAnalyzerResponse, AWSError>;
  /**
   * Retrieves information about an archive rule. To learn about filter keys that you can use to create an archive rule, see Access Analyzer filter keys in the IAM User Guide.
   */
  getArchiveRule(params: AccessAnalyzer.Types.GetArchiveRuleRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.GetArchiveRuleResponse) => void): Request<AccessAnalyzer.Types.GetArchiveRuleResponse, AWSError>;
  /**
   * Retrieves information about an archive rule. To learn about filter keys that you can use to create an archive rule, see Access Analyzer filter keys in the IAM User Guide.
   */
  getArchiveRule(callback?: (err: AWSError, data: AccessAnalyzer.Types.GetArchiveRuleResponse) => void): Request<AccessAnalyzer.Types.GetArchiveRuleResponse, AWSError>;
  /**
   * Retrieves information about the specified finding.
   */
  getFinding(params: AccessAnalyzer.Types.GetFindingRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.GetFindingResponse) => void): Request<AccessAnalyzer.Types.GetFindingResponse, AWSError>;
  /**
   * Retrieves information about the specified finding.
   */
  getFinding(callback?: (err: AWSError, data: AccessAnalyzer.Types.GetFindingResponse) => void): Request<AccessAnalyzer.Types.GetFindingResponse, AWSError>;
  /**
   * Retrieves the policy that was generated using StartPolicyGeneration. 
   */
  getGeneratedPolicy(params: AccessAnalyzer.Types.GetGeneratedPolicyRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.GetGeneratedPolicyResponse) => void): Request<AccessAnalyzer.Types.GetGeneratedPolicyResponse, AWSError>;
  /**
   * Retrieves the policy that was generated using StartPolicyGeneration. 
   */
  getGeneratedPolicy(callback?: (err: AWSError, data: AccessAnalyzer.Types.GetGeneratedPolicyResponse) => void): Request<AccessAnalyzer.Types.GetGeneratedPolicyResponse, AWSError>;
  /**
   * Retrieves a list of access preview findings generated by the specified access preview.
   */
  listAccessPreviewFindings(params: AccessAnalyzer.Types.ListAccessPreviewFindingsRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.ListAccessPreviewFindingsResponse) => void): Request<AccessAnalyzer.Types.ListAccessPreviewFindingsResponse, AWSError>;
  /**
   * Retrieves a list of access preview findings generated by the specified access preview.
   */
  listAccessPreviewFindings(callback?: (err: AWSError, data: AccessAnalyzer.Types.ListAccessPreviewFindingsResponse) => void): Request<AccessAnalyzer.Types.ListAccessPreviewFindingsResponse, AWSError>;
  /**
   * Retrieves a list of access previews for the specified analyzer.
   */
  listAccessPreviews(params: AccessAnalyzer.Types.ListAccessPreviewsRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.ListAccessPreviewsResponse) => void): Request<AccessAnalyzer.Types.ListAccessPreviewsResponse, AWSError>;
  /**
   * Retrieves a list of access previews for the specified analyzer.
   */
  listAccessPreviews(callback?: (err: AWSError, data: AccessAnalyzer.Types.ListAccessPreviewsResponse) => void): Request<AccessAnalyzer.Types.ListAccessPreviewsResponse, AWSError>;
  /**
   * Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..
   */
  listAnalyzedResources(params: AccessAnalyzer.Types.ListAnalyzedResourcesRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.ListAnalyzedResourcesResponse) => void): Request<AccessAnalyzer.Types.ListAnalyzedResourcesResponse, AWSError>;
  /**
   * Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..
   */
  listAnalyzedResources(callback?: (err: AWSError, data: AccessAnalyzer.Types.ListAnalyzedResourcesResponse) => void): Request<AccessAnalyzer.Types.ListAnalyzedResourcesResponse, AWSError>;
  /**
   * Retrieves a list of analyzers.
   */
  listAnalyzers(params: AccessAnalyzer.Types.ListAnalyzersRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.ListAnalyzersResponse) => void): Request<AccessAnalyzer.Types.ListAnalyzersResponse, AWSError>;
  /**
   * Retrieves a list of analyzers.
   */
  listAnalyzers(callback?: (err: AWSError, data: AccessAnalyzer.Types.ListAnalyzersResponse) => void): Request<AccessAnalyzer.Types.ListAnalyzersResponse, AWSError>;
  /**
   * Retrieves a list of archive rules created for the specified analyzer.
   */
  listArchiveRules(params: AccessAnalyzer.Types.ListArchiveRulesRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.ListArchiveRulesResponse) => void): Request<AccessAnalyzer.Types.ListArchiveRulesResponse, AWSError>;
  /**
   * Retrieves a list of archive rules created for the specified analyzer.
   */
  listArchiveRules(callback?: (err: AWSError, data: AccessAnalyzer.Types.ListArchiveRulesResponse) => void): Request<AccessAnalyzer.Types.ListArchiveRulesResponse, AWSError>;
  /**
   * Retrieves a list of findings generated by the specified analyzer. To learn about filter keys that you can use to retrieve a list of findings, see Access Analyzer filter keys in the IAM User Guide.
   */
  listFindings(params: AccessAnalyzer.Types.ListFindingsRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.ListFindingsResponse) => void): Request<AccessAnalyzer.Types.ListFindingsResponse, AWSError>;
  /**
   * Retrieves a list of findings generated by the specified analyzer. To learn about filter keys that you can use to retrieve a list of findings, see Access Analyzer filter keys in the IAM User Guide.
   */
  listFindings(callback?: (err: AWSError, data: AccessAnalyzer.Types.ListFindingsResponse) => void): Request<AccessAnalyzer.Types.ListFindingsResponse, AWSError>;
  /**
   * Lists all of the policy generations requested in the last seven days.
   */
  listPolicyGenerations(params: AccessAnalyzer.Types.ListPolicyGenerationsRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.ListPolicyGenerationsResponse) => void): Request<AccessAnalyzer.Types.ListPolicyGenerationsResponse, AWSError>;
  /**
   * Lists all of the policy generations requested in the last seven days.
   */
  listPolicyGenerations(callback?: (err: AWSError, data: AccessAnalyzer.Types.ListPolicyGenerationsResponse) => void): Request<AccessAnalyzer.Types.ListPolicyGenerationsResponse, AWSError>;
  /**
   * Retrieves a list of tags applied to the specified resource.
   */
  listTagsForResource(params: AccessAnalyzer.Types.ListTagsForResourceRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.ListTagsForResourceResponse) => void): Request<AccessAnalyzer.Types.ListTagsForResourceResponse, AWSError>;
  /**
   * Retrieves a list of tags applied to the specified resource.
   */
  listTagsForResource(callback?: (err: AWSError, data: AccessAnalyzer.Types.ListTagsForResourceResponse) => void): Request<AccessAnalyzer.Types.ListTagsForResourceResponse, AWSError>;
  /**
   * Starts the policy generation request.
   */
  startPolicyGeneration(params: AccessAnalyzer.Types.StartPolicyGenerationRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.StartPolicyGenerationResponse) => void): Request<AccessAnalyzer.Types.StartPolicyGenerationResponse, AWSError>;
  /**
   * Starts the policy generation request.
   */
  startPolicyGeneration(callback?: (err: AWSError, data: AccessAnalyzer.Types.StartPolicyGenerationResponse) => void): Request<AccessAnalyzer.Types.StartPolicyGenerationResponse, AWSError>;
  /**
   * Immediately starts a scan of the policies applied to the specified resource.
   */
  startResourceScan(params: AccessAnalyzer.Types.StartResourceScanRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Immediately starts a scan of the policies applied to the specified resource.
   */
  startResourceScan(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Adds a tag to the specified resource.
   */
  tagResource(params: AccessAnalyzer.Types.TagResourceRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.TagResourceResponse) => void): Request<AccessAnalyzer.Types.TagResourceResponse, AWSError>;
  /**
   * Adds a tag to the specified resource.
   */
  tagResource(callback?: (err: AWSError, data: AccessAnalyzer.Types.TagResourceResponse) => void): Request<AccessAnalyzer.Types.TagResourceResponse, AWSError>;
  /**
   * Removes a tag from the specified resource.
   */
  untagResource(params: AccessAnalyzer.Types.UntagResourceRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.UntagResourceResponse) => void): Request<AccessAnalyzer.Types.UntagResourceResponse, AWSError>;
  /**
   * Removes a tag from the specified resource.
   */
  untagResource(callback?: (err: AWSError, data: AccessAnalyzer.Types.UntagResourceResponse) => void): Request<AccessAnalyzer.Types.UntagResourceResponse, AWSError>;
  /**
   * Updates the criteria and values for the specified archive rule.
   */
  updateArchiveRule(params: AccessAnalyzer.Types.UpdateArchiveRuleRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Updates the criteria and values for the specified archive rule.
   */
  updateArchiveRule(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Updates the status for the specified findings.
   */
  updateFindings(params: AccessAnalyzer.Types.UpdateFindingsRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Updates the status for the specified findings.
   */
  updateFindings(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Requests the validation of a policy and returns a list of findings. The findings help you identify issues and provide actionable recommendations to resolve the issue and enable you to author functional policies that meet security best practices. 
   */
  validatePolicy(params: AccessAnalyzer.Types.ValidatePolicyRequest, callback?: (err: AWSError, data: AccessAnalyzer.Types.ValidatePolicyResponse) => void): Request<AccessAnalyzer.Types.ValidatePolicyResponse, AWSError>;
  /**
   * Requests the validation of a policy and returns a list of findings. The findings help you identify issues and provide actionable recommendations to resolve the issue and enable you to author functional policies that meet security best practices. 
   */
  validatePolicy(callback?: (err: AWSError, data: AccessAnalyzer.Types.ValidatePolicyResponse) => void): Request<AccessAnalyzer.Types.ValidatePolicyResponse, AWSError>;
}
declare namespace AccessAnalyzer {
  export type AccessPointArn = string;
  export type AccessPointPolicy = string;
  export interface AccessPreview {
    /**
     * The ARN of the analyzer used to generate the access preview.
     */
    analyzerArn: AnalyzerArn;
    /**
     * A map of resource ARNs for the proposed resource configuration.
     */
    configurations: ConfigurationsMap;
    /**
     * The time at which the access preview was created.
     */
    createdAt: Timestamp;
    /**
     * The unique ID for the access preview.
     */
    id: AccessPreviewId;
    /**
     * The status of the access preview.    Creating - The access preview creation is in progress.    Completed - The access preview is complete. You can preview findings for external access to the resource.    Failed - The access preview creation has failed.  
     */
    status: AccessPreviewStatus;
    /**
     * Provides more details about the current status of the access preview. For example, if the creation of the access preview fails, a Failed status is returned. This failure can be due to an internal issue with the analysis or due to an invalid resource configuration.
     */
    statusReason?: AccessPreviewStatusReason;
  }
  export interface AccessPreviewFinding {
    /**
     * The action in the analyzed policy statement that an external principal has permission to perform.
     */
    action?: ActionList;
    /**
     * Provides context on how the access preview finding compares to existing access identified in Access Analyzer.    New - The finding is for newly-introduced access.    Unchanged - The preview finding is an existing finding that would remain unchanged.    Changed - The preview finding is an existing finding with a change in status.   For example, a Changed finding with preview status Resolved and existing status Active indicates the existing Active finding would become Resolved as a result of the proposed permissions change.
     */
    changeType: FindingChangeType;
    /**
     * The condition in the analyzed policy statement that resulted in a finding.
     */
    condition?: ConditionKeyMap;
    /**
     * The time at which the access preview finding was created.
     */
    createdAt: Timestamp;
    /**
     * An error.
     */
    error?: String;
    /**
     * The existing ID of the finding in Access Analyzer, provided only for existing findings.
     */
    existingFindingId?: FindingId;
    /**
     * The existing status of the finding, provided only for existing findings.
     */
    existingFindingStatus?: FindingStatus;
    /**
     * The ID of the access preview finding. This ID uniquely identifies the element in the list of access preview findings and is not related to the finding ID in Access Analyzer.
     */
    id: AccessPreviewFindingId;
    /**
     * Indicates whether the policy that generated the finding allows public access to the resource.
     */
    isPublic?: Boolean;
    /**
     * The external principal that has access to a resource within the zone of trust.
     */
    principal?: PrincipalMap;
    /**
     * The resource that an external principal has access to. This is the resource associated with the access preview.
     */
    resource?: String;
    /**
     * The AWS account ID that owns the resource. For most AWS resources, the owning account is the account in which the resource was created.
     */
    resourceOwnerAccount: String;
    /**
     * The type of the resource that can be accessed in the finding.
     */
    resourceType: ResourceType;
    /**
     * The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.
     */
    sources?: FindingSourceList;
    /**
     * The preview status of the finding. This is what the status of the finding would be after permissions deployment. For example, a Changed finding with preview status Resolved and existing status Active indicates the existing Active finding would become Resolved as a result of the proposed permissions change.
     */
    status: FindingStatus;
  }
  export type AccessPreviewFindingId = string;
  export type AccessPreviewFindingsList = AccessPreviewFinding[];
  export type AccessPreviewId = string;
  export type AccessPreviewStatus = "COMPLETED"|"CREATING"|"FAILED"|string;
  export interface AccessPreviewStatusReason {
    /**
     * The reason code for the current status of the access preview.
     */
    code: AccessPreviewStatusReasonCode;
  }
  export type AccessPreviewStatusReasonCode = "INTERNAL_ERROR"|"INVALID_CONFIGURATION"|string;
  export interface AccessPreviewSummary {
    /**
     * The ARN of the analyzer used to generate the access preview.
     */
    analyzerArn: AnalyzerArn;
    /**
     * The time at which the access preview was created.
     */
    createdAt: Timestamp;
    /**
     * The unique ID for the access preview.
     */
    id: AccessPreviewId;
    /**
     * The status of the access preview.    Creating - The access preview creation is in progress.    Completed - The access preview is complete and previews the findings for external access to the resource.    Failed - The access preview creation has failed.  
     */
    status: AccessPreviewStatus;
    statusReason?: AccessPreviewStatusReason;
  }
  export type AccessPreviewsList = AccessPreviewSummary[];
  export type AclCanonicalId = string;
  export interface AclGrantee {
    /**
     * The value specified is the canonical user ID of an AWS account.
     */
    id?: AclCanonicalId;
    /**
     * Used for granting permissions to a predefined group.
     */
    uri?: AclUri;
  }
  export type AclPermission = "READ"|"WRITE"|"READ_ACP"|"WRITE_ACP"|"FULL_CONTROL"|string;
  export type AclUri = string;
  export type ActionList = String[];
  export interface AnalyzedResource {
    /**
     * The actions that an external principal is granted permission to use by the policy that generated the finding.
     */
    actions?: ActionList;
    /**
     * The time at which the resource was analyzed.
     */
    analyzedAt: Timestamp;
    /**
     * The time at which the finding was created.
     */
    createdAt: Timestamp;
    /**
     * An error message.
     */
    error?: String;
    /**
     * Indicates whether the policy that generated the finding grants public access to the resource.
     */
    isPublic: Boolean;
    /**
     * The ARN of the resource that was analyzed.
     */
    resourceArn: ResourceArn;
    /**
     * The AWS account ID that owns the resource.
     */
    resourceOwnerAccount: String;
    /**
     * The type of the resource that was analyzed.
     */
    resourceType: ResourceType;
    /**
     * Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.
     */
    sharedVia?: SharedViaList;
    /**
     * The current status of the finding generated from the analyzed resource.
     */
    status?: FindingStatus;
    /**
     * The time at which the finding was updated.
     */
    updatedAt: Timestamp;
  }
  export interface AnalyzedResourceSummary {
    /**
     * The ARN of the analyzed resource.
     */
    resourceArn: ResourceArn;
    /**
     * The AWS account ID that owns the resource.
     */
    resourceOwnerAccount: String;
    /**
     * The type of resource that was analyzed.
     */
    resourceType: ResourceType;
  }
  export type AnalyzedResourcesList = AnalyzedResourceSummary[];
  export type AnalyzerArn = string;
  export type AnalyzerStatus = "ACTIVE"|"CREATING"|"DISABLED"|"FAILED"|string;
  export interface AnalyzerSummary {
    /**
     * The ARN of the analyzer.
     */
    arn: AnalyzerArn;
    /**
     * A timestamp for the time at which the analyzer was created.
     */
    createdAt: Timestamp;
    /**
     * The resource that was most recently analyzed by the analyzer.
     */
    lastResourceAnalyzed?: String;
    /**
     * The time at which the most recently analyzed resource was analyzed.
     */
    lastResourceAnalyzedAt?: Timestamp;
    /**
     * The name of the analyzer.
     */
    name: Name;
    /**
     * The status of the analyzer. An Active analyzer successfully monitors supported resources and generates new findings. The analyzer is Disabled when a user action, such as removing trusted access for AWS IAM Access Analyzer from AWS Organizations, causes the analyzer to stop generating new findings. The status is Creating when the analyzer creation is in progress and Failed when the analyzer creation has failed. 
     */
    status: AnalyzerStatus;
    /**
     * The statusReason provides more details about the current status of the analyzer. For example, if the creation for the analyzer fails, a Failed status is returned. For an analyzer with organization as the type, this failure can be due to an issue with creating the service-linked roles required in the member accounts of the AWS organization.
     */
    statusReason?: StatusReason;
    /**
     * The tags added to the analyzer.
     */
    tags?: TagsMap;
    /**
     * The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.
     */
    type: Type;
  }
  export type AnalyzersList = AnalyzerSummary[];
  export interface ApplyArchiveRuleRequest {
    /**
     * The Amazon resource name (ARN) of the analyzer.
     */
    analyzerArn: AnalyzerArn;
    /**
     * A client token.
     */
    clientToken?: String;
    /**
     * The name of the rule to apply.
     */
    ruleName: Name;
  }
  export interface ArchiveRuleSummary {
    /**
     * The time at which the archive rule was created.
     */
    createdAt: Timestamp;
    /**
     * A filter used to define the archive rule.
     */
    filter: FilterCriteriaMap;
    /**
     * The name of the archive rule.
     */
    ruleName: Name;
    /**
     * The time at which the archive rule was last updated.
     */
    updatedAt: Timestamp;
  }
  export type ArchiveRulesList = ArchiveRuleSummary[];
  export type Boolean = boolean;
  export interface CancelPolicyGenerationRequest {
    /**
     * The JobId that is returned by the StartPolicyGeneration operation. The JobId can be used with GetGeneratedPolicy to retrieve the generated policies or used with CancelPolicyGeneration to cancel the policy generation request.
     */
    jobId: JobId;
  }
  export interface CancelPolicyGenerationResponse {
  }
  export type CloudTrailArn = string;
  export interface CloudTrailDetails {
    /**
     * The ARN of the service role that Access Analyzer uses to access your CloudTrail trail and service last accessed information.
     */
    accessRole: RoleArn;
    /**
     * The end of the time range for which Access Analyzer reviews your CloudTrail events. Events with a timestamp after this time are not considered to generate a policy. If this is not included in the request, the default value is the current time.
     */
    endTime?: Timestamp;
    /**
     * The start of the time range for which Access Analyzer reviews your CloudTrail events. Events with a timestamp before this time are not considered to generate a policy.
     */
    startTime: Timestamp;
    /**
     * A Trail object that contains settings for a trail.
     */
    trails: TrailList;
  }
  export interface CloudTrailProperties {
    /**
     * The end of the time range for which Access Analyzer reviews your CloudTrail events. Events with a timestamp after this time are not considered to generate a policy. If this is not included in the request, the default value is the current time.
     */
    endTime: Timestamp;
    /**
     * The start of the time range for which Access Analyzer reviews your CloudTrail events. Events with a timestamp before this time are not considered to generate a policy.
     */
    startTime: Timestamp;
    /**
     * A TrailProperties object that contains settings for trail properties.
     */
    trailProperties: TrailPropertiesList;
  }
  export type ConditionKeyMap = {[key: string]: String};
  export interface Configuration {
    /**
     * The access control configuration is for an IAM role. 
     */
    iamRole?: IamRoleConfiguration;
    /**
     * The access control configuration is for a KMS key. 
     */
    kmsKey?: KmsKeyConfiguration;
    /**
     * The access control configuration is for an Amazon S3 Bucket. 
     */
    s3Bucket?: S3BucketConfiguration;
    /**
     * The access control configuration is for a Secrets Manager secret.
     */
    secretsManagerSecret?: SecretsManagerSecretConfiguration;
    /**
     * The access control configuration is for an SQS queue. 
     */
    sqsQueue?: SqsQueueConfiguration;
  }
  export type ConfigurationsMap = {[key: string]: Configuration};
  export type ConfigurationsMapKey = string;
  export interface CreateAccessPreviewRequest {
    /**
     * The ARN of the account analyzer used to generate the access preview. You can only create an access preview for analyzers with an Account type and Active status.
     */
    analyzerArn: AnalyzerArn;
    /**
     * A client token.
     */
    clientToken?: String;
    /**
     * Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.
     */
    configurations: ConfigurationsMap;
  }
  export interface CreateAccessPreviewResponse {
    /**
     * The unique ID for the access preview.
     */
    id: AccessPreviewId;
  }
  export interface CreateAnalyzerRequest {
    /**
     * The name of the analyzer to create.
     */
    analyzerName: Name;
    /**
     * Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.
     */
    archiveRules?: InlineArchiveRulesList;
    /**
     * A client token.
     */
    clientToken?: String;
    /**
     * The tags to apply to the analyzer.
     */
    tags?: TagsMap;
    /**
     * The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.
     */
    type: Type;
  }
  export interface CreateAnalyzerResponse {
    /**
     * The ARN of the analyzer that was created by the request.
     */
    arn?: AnalyzerArn;
  }
  export interface CreateArchiveRuleRequest {
    /**
     * The name of the created analyzer.
     */
    analyzerName: Name;
    /**
     * A client token.
     */
    clientToken?: String;
    /**
     * The criteria for the rule.
     */
    filter: FilterCriteriaMap;
    /**
     * The name of the rule to create.
     */
    ruleName: Name;
  }
  export interface Criterion {
    /**
     * A "contains" operator to match for the filter used to create the rule.
     */
    contains?: ValueList;
    /**
     * An "equals" operator to match for the filter used to create the rule.
     */
    eq?: ValueList;
    /**
     * An "exists" operator to match for the filter used to create the rule. 
     */
    exists?: Boolean;
    /**
     * A "not equals" operator to match for the filter used to create the rule.
     */
    neq?: ValueList;
  }
  export interface DeleteAnalyzerRequest {
    /**
     * The name of the analyzer to delete.
     */
    analyzerName: Name;
    /**
     * A client token.
     */
    clientToken?: String;
  }
  export interface DeleteArchiveRuleRequest {
    /**
     * The name of the analyzer that associated with the archive rule to delete.
     */
    analyzerName: Name;
    /**
     * A client token.
     */
    clientToken?: String;
    /**
     * The name of the rule to delete.
     */
    ruleName: Name;
  }
  export type FilterCriteriaMap = {[key: string]: Criterion};
  export interface Finding {
    /**
     * The action in the analyzed policy statement that an external principal has permission to use.
     */
    action?: ActionList;
    /**
     * The time at which the resource was analyzed.
     */
    analyzedAt: Timestamp;
    /**
     * The condition in the analyzed policy statement that resulted in a finding.
     */
    condition: ConditionKeyMap;
    /**
     * The time at which the finding was generated.
     */
    createdAt: Timestamp;
    /**
     * An error.
     */
    error?: String;
    /**
     * The ID of the finding.
     */
    id: FindingId;
    /**
     * Indicates whether the policy that generated the finding allows public access to the resource.
     */
    isPublic?: Boolean;
    /**
     * The external principal that access to a resource within the zone of trust.
     */
    principal?: PrincipalMap;
    /**
     * The resource that an external principal has access to.
     */
    resource?: String;
    /**
     * The AWS account ID that owns the resource.
     */
    resourceOwnerAccount: String;
    /**
     * The type of the resource identified in the finding.
     */
    resourceType: ResourceType;
    /**
     * The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.
     */
    sources?: FindingSourceList;
    /**
     * The current status of the finding.
     */
    status: FindingStatus;
    /**
     * The time at which the finding was updated.
     */
    updatedAt: Timestamp;
  }
  export type FindingChangeType = "CHANGED"|"NEW"|"UNCHANGED"|string;
  export type FindingId = string;
  export type FindingIdList = FindingId[];
  export interface FindingSource {
    /**
     * Includes details about how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.
     */
    detail?: FindingSourceDetail;
    /**
     * Indicates the type of access that generated the finding.
     */
    type: FindingSourceType;
  }
  export interface FindingSourceDetail {
    /**
     * The ARN of the access point that generated the finding.
     */
    accessPointArn?: String;
  }
  export type FindingSourceList = FindingSource[];
  export type FindingSourceType = "POLICY"|"BUCKET_ACL"|"S3_ACCESS_POINT"|string;
  export type FindingStatus = "ACTIVE"|"ARCHIVED"|"RESOLVED"|string;
  export type FindingStatusUpdate = "ACTIVE"|"ARCHIVED"|string;
  export interface FindingSummary {
    /**
     * The action in the analyzed policy statement that an external principal has permission to use.
     */
    action?: ActionList;
    /**
     * The time at which the resource-based policy that generated the finding was analyzed.
     */
    analyzedAt: Timestamp;
    /**
     * The condition in the analyzed policy statement that resulted in a finding.
     */
    condition: ConditionKeyMap;
    /**
     * The time at which the finding was created.
     */
    createdAt: Timestamp;
    /**
     * The error that resulted in an Error finding.
     */
    error?: String;
    /**
     * The ID of the finding.
     */
    id: FindingId;
    /**
     * Indicates whether the finding reports a resource that has a policy that allows public access.
     */
    isPublic?: Boolean;
    /**
     * The external principal that has access to a resource within the zone of trust.
     */
    principal?: PrincipalMap;
    /**
     * The resource that the external principal has access to.
     */
    resource?: String;
    /**
     * The AWS account ID that owns the resource.
     */
    resourceOwnerAccount: String;
    /**
     * The type of the resource that the external principal has access to.
     */
    resourceType: ResourceType;
    /**
     * The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.
     */
    sources?: FindingSourceList;
    /**
     * The status of the finding.
     */
    status: FindingStatus;
    /**
     * The time at which the finding was most recently updated.
     */
    updatedAt: Timestamp;
  }
  export type FindingsList = FindingSummary[];
  export interface GeneratedPolicy {
    /**
     * The text to use as the content for the new policy. The policy is created using the CreatePolicy action.
     */
    policy: String;
  }
  export type GeneratedPolicyList = GeneratedPolicy[];
  export interface GeneratedPolicyProperties {
    /**
     * Lists details about the Trail used to generated policy.
     */
    cloudTrailProperties?: CloudTrailProperties;
    /**
     * This value is set to true if the generated policy contains all possible actions for a service that Access Analyzer identified from the CloudTrail trail that you specified, and false otherwise.
     */
    isComplete?: Boolean;
    /**
     * The ARN of the IAM entity (user or role) for which you are generating a policy.
     */
    principalArn: PrincipalArn;
  }
  export interface GeneratedPolicyResult {
    /**
     * The text to use as the content for the new policy. The policy is created using the CreatePolicy action.
     */
    generatedPolicies?: GeneratedPolicyList;
    /**
     * A GeneratedPolicyProperties object that contains properties of the generated policy.
     */
    properties: GeneratedPolicyProperties;
  }
  export interface GetAccessPreviewRequest {
    /**
     * The unique ID for the access preview.
     */
    accessPreviewId: AccessPreviewId;
    /**
     * The ARN of the analyzer used to generate the access preview.
     */
    analyzerArn: AnalyzerArn;
  }
  export interface GetAccessPreviewResponse {
    /**
     * An object that contains information about the access preview.
     */
    accessPreview: AccessPreview;
  }
  export interface GetAnalyzedResourceRequest {
    /**
     * The ARN of the analyzer to retrieve information from.
     */
    analyzerArn: AnalyzerArn;
    /**
     * The ARN of the resource to retrieve information about.
     */
    resourceArn: ResourceArn;
  }
  export interface GetAnalyzedResourceResponse {
    /**
     * An AnalyzedResource object that contains information that Access Analyzer found when it analyzed the resource.
     */
    resource?: AnalyzedResource;
  }
  export interface GetAnalyzerRequest {
    /**
     * The name of the analyzer retrieved.
     */
    analyzerName: Name;
  }
  export interface GetAnalyzerResponse {
    /**
     * An AnalyzerSummary object that contains information about the analyzer.
     */
    analyzer: AnalyzerSummary;
  }
  export interface GetArchiveRuleRequest {
    /**
     * The name of the analyzer to retrieve rules from.
     */
    analyzerName: Name;
    /**
     * The name of the rule to retrieve.
     */
    ruleName: Name;
  }
  export interface GetArchiveRuleResponse {
    archiveRule: ArchiveRuleSummary;
  }
  export interface GetFindingRequest {
    /**
     * The ARN of the analyzer that generated the finding.
     */
    analyzerArn: AnalyzerArn;
    /**
     * The ID of the finding to retrieve.
     */
    id: FindingId;
  }
  export interface GetFindingResponse {
    /**
     * A finding object that contains finding details.
     */
    finding?: Finding;
  }
  export interface GetGeneratedPolicyRequest {
    /**
     * The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies. For example, in the resource section of a policy, you can receive a placeholder such as "Resource":"arn:aws:s3:::${BucketName}" instead of "*".
     */
    includeResourcePlaceholders?: Boolean;
    /**
     * The level of detail that you want to generate. You can specify whether to generate service-level policies.  Access Analyzer uses iam:servicelastaccessed to identify services that have been used recently to create this service-level template.
     */
    includeServiceLevelTemplate?: Boolean;
    /**
     * The JobId that is returned by the StartPolicyGeneration operation. The JobId can be used with GetGeneratedPolicy to retrieve the generated policies or used with CancelPolicyGeneration to cancel the policy generation request.
     */
    jobId: JobId;
  }
  export interface GetGeneratedPolicyResponse {
    /**
     * A GeneratedPolicyResult object that contains the generated policies and associated details.
     */
    generatedPolicyResult: GeneratedPolicyResult;
    /**
     * A GeneratedPolicyDetails object that contains details about the generated policy.
     */
    jobDetails: JobDetails;
  }
  export type GranteePrincipal = string;
  export interface IamRoleConfiguration {
    /**
     * The proposed trust policy for the IAM role.
     */
    trustPolicy?: IamTrustPolicy;
  }
  export type IamTrustPolicy = string;
  export interface InlineArchiveRule {
    /**
     * The condition and values for a criterion.
     */
    filter: FilterCriteriaMap;
    /**
     * The name of the rule.
     */
    ruleName: Name;
  }
  export type InlineArchiveRulesList = InlineArchiveRule[];
  export type Integer = number;
  export interface InternetConfiguration {
  }
  export type IssueCode = string;
  export type IssuingAccount = string;
  export interface JobDetails {
    /**
     * A timestamp of when the job was completed.
     */
    completedOn?: Timestamp;
    jobError?: JobError;
    /**
     * The JobId that is returned by the StartPolicyGeneration operation. The JobId can be used with GetGeneratedPolicy to retrieve the generated policies or used with CancelPolicyGeneration to cancel the policy generation request.
     */
    jobId: JobId;
    /**
     * A timestamp of when the job was started.
     */
    startedOn: Timestamp;
    /**
     * The status of the job request.
     */
    status: JobStatus;
  }
  export interface JobError {
    /**
     * The job error code.
     */
    code: JobErrorCode;
    /**
     * Specific information about the error. For example, which service quota was exceeded or which resource was not found.
     */
    message: String;
  }
  export type JobErrorCode = "AUTHORIZATION_ERROR"|"RESOURCE_NOT_FOUND_ERROR"|"SERVICE_QUOTA_EXCEEDED_ERROR"|"SERVICE_ERROR"|string;
  export type JobId = string;
  export type JobStatus = "IN_PROGRESS"|"SUCCEEDED"|"FAILED"|"CANCELED"|string;
  export type KmsConstraintsKey = string;
  export type KmsConstraintsMap = {[key: string]: KmsConstraintsValue};
  export type KmsConstraintsValue = string;
  export interface KmsGrantConfiguration {
    /**
     * Use this structure to propose allowing cryptographic operations in the grant only when the operation request includes the specified encryption context.
     */
    constraints?: KmsGrantConstraints;
    /**
     * The principal that is given permission to perform the operations that the grant permits.
     */
    granteePrincipal: GranteePrincipal;
    /**
     *  The AWS account under which the grant was issued. The account is used to propose KMS grants issued by accounts other than the owner of the key.
     */
    issuingAccount: IssuingAccount;
    /**
     * A list of operations that the grant permits.
     */
    operations: KmsGrantOperationsList;
    /**
     * The principal that is given permission to retire the grant by using RetireGrant operation.
     */
    retiringPrincipal?: RetiringPrincipal;
  }
  export type KmsGrantConfigurationsList = KmsGrantConfiguration[];
  export interface KmsGrantConstraints {
    /**
     * A list of key-value pairs that must match the encryption context in the cryptographic operation request. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint.
     */
    encryptionContextEquals?: KmsConstraintsMap;
    /**
     * A list of key-value pairs that must be included in the encryption context of the cryptographic operation request. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs.
     */
    encryptionContextSubset?: KmsConstraintsMap;
  }
  export type KmsGrantOperation = "CreateGrant"|"Decrypt"|"DescribeKey"|"Encrypt"|"GenerateDataKey"|"GenerateDataKeyPair"|"GenerateDataKeyPairWithoutPlaintext"|"GenerateDataKeyWithoutPlaintext"|"GetPublicKey"|"ReEncryptFrom"|"ReEncryptTo"|"RetireGrant"|"Sign"|"Verify"|string;
  export type KmsGrantOperationsList = KmsGrantOperation[];
  export interface KmsKeyConfiguration {
    /**
     * A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an existing key, the access preview uses the proposed list of grant configurations in place of the existing grants. Otherwise, the access preview uses the existing grants for the key.
     */
    grants?: KmsGrantConfigurationsList;
    /**
     * Resource policy configuration for the KMS key. The only valid value for the name of the key policy is default. For more information, see Default key policy.
     */
    keyPolicies?: KmsKeyPoliciesMap;
  }
  export type KmsKeyPoliciesMap = {[key: string]: KmsKeyPolicy};
  export type KmsKeyPolicy = string;
  export type LearnMoreLink = string;
  export interface ListAccessPreviewFindingsRequest {
    /**
     * The unique ID for the access preview.
     */
    accessPreviewId: AccessPreviewId;
    /**
     * The ARN of the analyzer used to generate the access.
     */
    analyzerArn: AnalyzerArn;
    /**
     * Criteria to filter the returned findings.
     */
    filter?: FilterCriteriaMap;
    /**
     * The maximum number of results to return in the response.
     */
    maxResults?: Integer;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
  }
  export interface ListAccessPreviewFindingsResponse {
    /**
     * A list of access preview findings that match the specified filter criteria.
     */
    findings: AccessPreviewFindingsList;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
  }
  export interface ListAccessPreviewsRequest {
    /**
     * The ARN of the analyzer used to generate the access preview.
     */
    analyzerArn: AnalyzerArn;
    /**
     * The maximum number of results to return in the response.
     */
    maxResults?: Integer;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
  }
  export interface ListAccessPreviewsResponse {
    /**
     * A list of access previews retrieved for the analyzer.
     */
    accessPreviews: AccessPreviewsList;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
  }
  export interface ListAnalyzedResourcesRequest {
    /**
     * The ARN of the analyzer to retrieve a list of analyzed resources from.
     */
    analyzerArn: AnalyzerArn;
    /**
     * The maximum number of results to return in the response.
     */
    maxResults?: Integer;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
    /**
     * The type of resource.
     */
    resourceType?: ResourceType;
  }
  export interface ListAnalyzedResourcesResponse {
    /**
     * A list of resources that were analyzed.
     */
    analyzedResources: AnalyzedResourcesList;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
  }
  export interface ListAnalyzersRequest {
    /**
     * The maximum number of results to return in the response.
     */
    maxResults?: Integer;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
    /**
     * The type of analyzer.
     */
    type?: Type;
  }
  export interface ListAnalyzersResponse {
    /**
     * The analyzers retrieved.
     */
    analyzers: AnalyzersList;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
  }
  export interface ListArchiveRulesRequest {
    /**
     * The name of the analyzer to retrieve rules from.
     */
    analyzerName: Name;
    /**
     * The maximum number of results to return in the request.
     */
    maxResults?: Integer;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
  }
  export interface ListArchiveRulesResponse {
    /**
     * A list of archive rules created for the specified analyzer.
     */
    archiveRules: ArchiveRulesList;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
  }
  export interface ListFindingsRequest {
    /**
     * The ARN of the analyzer to retrieve findings from.
     */
    analyzerArn: AnalyzerArn;
    /**
     * A filter to match for the findings to return.
     */
    filter?: FilterCriteriaMap;
    /**
     * The maximum number of results to return in the response.
     */
    maxResults?: Integer;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
    /**
     * The sort order for the findings returned.
     */
    sort?: SortCriteria;
  }
  export interface ListFindingsResponse {
    /**
     * A list of findings retrieved from the analyzer that match the filter criteria specified, if any.
     */
    findings: FindingsList;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
  }
  export interface ListPolicyGenerationsRequest {
    /**
     * The maximum number of results to return in the response.
     */
    maxResults?: ListPolicyGenerationsRequestMaxResultsInteger;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
    /**
     * The ARN of the IAM entity (user or role) for which you are generating a policy. Use this with ListGeneratedPolicies to filter the results to only include results for a specific principal.
     */
    principalArn?: PrincipalArn;
  }
  export type ListPolicyGenerationsRequestMaxResultsInteger = number;
  export interface ListPolicyGenerationsResponse {
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
    /**
     * A PolicyGeneration object that contains details about the generated policy.
     */
    policyGenerations: PolicyGenerationList;
  }
  export interface ListTagsForResourceRequest {
    /**
     * The ARN of the resource to retrieve tags from.
     */
    resourceArn: String;
  }
  export interface ListTagsForResourceResponse {
    /**
     * The tags that are applied to the specified resource.
     */
    tags?: TagsMap;
  }
  export type Locale = "DE"|"EN"|"ES"|"FR"|"IT"|"JA"|"KO"|"PT_BR"|"ZH_CN"|"ZH_TW"|string;
  export interface Location {
    /**
     * A path in a policy, represented as a sequence of path elements.
     */
    path: PathElementList;
    /**
     * A span in a policy.
     */
    span: Span;
  }
  export type LocationList = Location[];
  export type Name = string;
  export interface NetworkOriginConfiguration {
    /**
     * The configuration for the Amazon S3 access point with an Internet origin.
     */
    internetConfiguration?: InternetConfiguration;
    vpcConfiguration?: VpcConfiguration;
  }
  export type OrderBy = "ASC"|"DESC"|string;
  export interface PathElement {
    /**
     * Refers to an index in a JSON array.
     */
    index?: Integer;
    /**
     * Refers to a key in a JSON object.
     */
    key?: String;
    /**
     * Refers to a substring of a literal string in a JSON object.
     */
    substring?: Substring;
    /**
     * Refers to the value associated with a given key in a JSON object.
     */
    value?: String;
  }
  export type PathElementList = PathElement[];
  export type PolicyDocument = string;
  export interface PolicyGeneration {
    /**
     * A timestamp of when the policy generation was completed.
     */
    completedOn?: Timestamp;
    /**
     * The JobId that is returned by the StartPolicyGeneration operation. The JobId can be used with GetGeneratedPolicy to retrieve the generated policies or used with CancelPolicyGeneration to cancel the policy generation request.
     */
    jobId: JobId;
    /**
     * The ARN of the IAM entity (user or role) for which you are generating a policy.
     */
    principalArn: PrincipalArn;
    /**
     * A timestamp of when the policy generation started.
     */
    startedOn: Timestamp;
    /**
     * The status of the policy generation request.
     */
    status: JobStatus;
  }
  export interface PolicyGenerationDetails {
    /**
     * The ARN of the IAM entity (user or role) for which you are generating a policy.
     */
    principalArn: PrincipalArn;
  }
  export type PolicyGenerationList = PolicyGeneration[];
  export type PolicyName = string;
  export type PolicyType = "IDENTITY_POLICY"|"RESOURCE_POLICY"|"SERVICE_CONTROL_POLICY"|string;
  export interface Position {
    /**
     * The column of the position, starting from 0.
     */
    column: Integer;
    /**
     * The line of the position, starting from 1.
     */
    line: Integer;
    /**
     * The offset within the policy that corresponds to the position, starting from 0.
     */
    offset: Integer;
  }
  export type PrincipalArn = string;
  export type PrincipalMap = {[key: string]: String};
  export type ReasonCode = "AWS_SERVICE_ACCESS_DISABLED"|"DELEGATED_ADMINISTRATOR_DEREGISTERED"|"ORGANIZATION_DELETED"|"SERVICE_LINKED_ROLE_CREATION_FAILED"|string;
  export type RegionList = String[];
  export type ResourceArn = string;
  export type ResourceType = "AWS::S3::Bucket"|"AWS::IAM::Role"|"AWS::SQS::Queue"|"AWS::Lambda::Function"|"AWS::Lambda::LayerVersion"|"AWS::KMS::Key"|"AWS::SecretsManager::Secret"|string;
  export type RetiringPrincipal = string;
  export type RoleArn = string;
  export interface S3AccessPointConfiguration {
    /**
     * The access point policy.
     */
    accessPointPolicy?: AccessPointPolicy;
    /**
     * The proposed Internet and VpcConfiguration to apply to this Amazon S3 access point. If the access preview is for a new resource and neither is specified, the access preview uses Internet for the network origin. If the access preview is for an existing resource and neither is specified, the access preview uses the exiting network origin.
     */
    networkOrigin?: NetworkOriginConfiguration;
    /**
     * The proposed S3PublicAccessBlock configuration to apply to this Amazon S3 Access Point.
     */
    publicAccessBlock?: S3PublicAccessBlockConfiguration;
  }
  export type S3AccessPointConfigurationsMap = {[key: string]: S3AccessPointConfiguration};
  export interface S3BucketAclGrantConfiguration {
    /**
     * The grantee to whom you’re assigning access rights.
     */
    grantee: AclGrantee;
    /**
     * The permissions being granted.
     */
    permission: AclPermission;
  }
  export type S3BucketAclGrantConfigurationsList = S3BucketAclGrantConfiguration[];
  export interface S3BucketConfiguration {
    /**
     * The configuration of Amazon S3 access points for the bucket.
     */
    accessPoints?: S3AccessPointConfigurationsMap;
    /**
     * The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to 100 ACL grants per bucket. If the proposed grant configuration is for an existing bucket, the access preview uses the proposed list of grant configurations in place of the existing grants. Otherwise, the access preview uses the existing grants for the bucket.
     */
    bucketAclGrants?: S3BucketAclGrantConfigurationsList;
    /**
     * The proposed bucket policy for the Amazon S3 bucket.
     */
    bucketPolicy?: S3BucketPolicy;
    /**
     * The proposed block public access configuration for the Amazon S3 bucket.
     */
    bucketPublicAccessBlock?: S3PublicAccessBlockConfiguration;
  }
  export type S3BucketPolicy = string;
  export interface S3PublicAccessBlockConfiguration {
    /**
     *  Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. 
     */
    ignorePublicAcls: Boolean;
    /**
     *  Specifies whether Amazon S3 should restrict public bucket policies for this bucket. 
     */
    restrictPublicBuckets: Boolean;
  }
  export interface SecretsManagerSecretConfiguration {
    /**
     * The proposed ARN, key ID, or alias of the AWS KMS customer master key (CMK).
     */
    kmsKeyId?: SecretsManagerSecretKmsId;
    /**
     * The proposed resource policy defining who can access or manage the secret.
     */
    secretPolicy?: SecretsManagerSecretPolicy;
  }
  export type SecretsManagerSecretKmsId = string;
  export type SecretsManagerSecretPolicy = string;
  export type SharedViaList = String[];
  export interface SortCriteria {
    /**
     * The name of the attribute to sort on.
     */
    attributeName?: String;
    /**
     * The sort order, ascending or descending.
     */
    orderBy?: OrderBy;
  }
  export interface Span {
    /**
     * The end position of the span (exclusive).
     */
    end: Position;
    /**
     * The start position of the span (inclusive).
     */
    start: Position;
  }
  export interface SqsQueueConfiguration {
    /**
     *  The proposed resource policy for the SQS queue. 
     */
    queuePolicy?: SqsQueuePolicy;
  }
  export type SqsQueuePolicy = string;
  export interface StartPolicyGenerationRequest {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect. If you do not specify a client token, one is automatically generated by the AWS SDK.
     */
    clientToken?: String;
    /**
     * A CloudTrailDetails object that contains details about a Trail that you want to analyze to generate policies.
     */
    cloudTrailDetails?: CloudTrailDetails;
    /**
     * Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
     */
    policyGenerationDetails: PolicyGenerationDetails;
  }
  export interface StartPolicyGenerationResponse {
    /**
     * The JobId that is returned by the StartPolicyGeneration operation. The JobId can be used with GetGeneratedPolicy to retrieve the generated policies or used with CancelPolicyGeneration to cancel the policy generation request.
     */
    jobId: JobId;
  }
  export interface StartResourceScanRequest {
    /**
     * The ARN of the analyzer to use to scan the policies applied to the specified resource.
     */
    analyzerArn: AnalyzerArn;
    /**
     * The ARN of the resource to scan.
     */
    resourceArn: ResourceArn;
  }
  export interface StatusReason {
    /**
     * The reason code for the current status of the analyzer.
     */
    code: ReasonCode;
  }
  export type String = string;
  export interface Substring {
    /**
     * The length of the substring.
     */
    length: Integer;
    /**
     * The start index of the substring, starting from 0.
     */
    start: Integer;
  }
  export type TagKeys = String[];
  export interface TagResourceRequest {
    /**
     * The ARN of the resource to add the tag to.
     */
    resourceArn: String;
    /**
     * The tags to add to the resource.
     */
    tags: TagsMap;
  }
  export interface TagResourceResponse {
  }
  export type TagsMap = {[key: string]: String};
  export type Timestamp = Date;
  export type Token = string;
  export interface Trail {
    /**
     * Possible values are true or false. If set to true, Access Analyzer retrieves CloudTrail data from all regions to analyze and generate a policy.
     */
    allRegions?: Boolean;
    /**
     * Specifies the ARN of the trail. The format of a trail ARN is arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail.
     */
    cloudTrailArn: CloudTrailArn;
    /**
     * A list of regions to get CloudTrail data from and analyze to generate a policy.
     */
    regions?: RegionList;
  }
  export type TrailList = Trail[];
  export interface TrailProperties {
    /**
     * Possible values are true or false. If set to true, Access Analyzer retrieves CloudTrail data from all regions to analyze and generate a policy.
     */
    allRegions?: Boolean;
    /**
     * Specifies the ARN of the trail. The format of a trail ARN is arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail.
     */
    cloudTrailArn: CloudTrailArn;
    /**
     * A list of regions to get CloudTrail data from and analyze to generate a policy.
     */
    regions?: RegionList;
  }
  export type TrailPropertiesList = TrailProperties[];
  export type Type = "ACCOUNT"|"ORGANIZATION"|string;
  export interface UntagResourceRequest {
    /**
     * The ARN of the resource to remove the tag from.
     */
    resourceArn: String;
    /**
     * The key for the tag to add.
     */
    tagKeys: TagKeys;
  }
  export interface UntagResourceResponse {
  }
  export interface UpdateArchiveRuleRequest {
    /**
     * The name of the analyzer to update the archive rules for.
     */
    analyzerName: Name;
    /**
     * A client token.
     */
    clientToken?: String;
    /**
     * A filter to match for the rules to update. Only rules that match the filter are updated.
     */
    filter: FilterCriteriaMap;
    /**
     * The name of the rule to update.
     */
    ruleName: Name;
  }
  export interface UpdateFindingsRequest {
    /**
     * The ARN of the analyzer that generated the findings to update.
     */
    analyzerArn: AnalyzerArn;
    /**
     * A client token.
     */
    clientToken?: String;
    /**
     * The IDs of the findings to update.
     */
    ids?: FindingIdList;
    /**
     * The ARN of the resource identified in the finding.
     */
    resourceArn?: ResourceArn;
    /**
     * The state represents the action to take to update the finding Status. Use ARCHIVE to change an Active finding to an Archived finding. Use ACTIVE to change an Archived finding to an Active finding.
     */
    status: FindingStatusUpdate;
  }
  export interface ValidatePolicyFinding {
    /**
     * A localized message that explains the finding and provides guidance on how to address it.
     */
    findingDetails: String;
    /**
     * The impact of the finding. Security warnings report when the policy allows access that we consider overly permissive. Errors report when a part of the policy is not functional. Warnings report non-security issues when a policy does not conform to policy writing best practices. Suggestions recommend stylistic improvements in the policy that do not impact access.
     */
    findingType: ValidatePolicyFindingType;
    /**
     * The issue code provides an identifier of the issue associated with this finding.
     */
    issueCode: IssueCode;
    /**
     * A link to additional documentation about the type of finding.
     */
    learnMoreLink: LearnMoreLink;
    /**
     * The list of locations in the policy document that are related to the finding. The issue code provides a summary of an issue identified by the finding.
     */
    locations: LocationList;
  }
  export type ValidatePolicyFindingList = ValidatePolicyFinding[];
  export type ValidatePolicyFindingType = "ERROR"|"SECURITY_WARNING"|"SUGGESTION"|"WARNING"|string;
  export interface ValidatePolicyRequest {
    /**
     * The locale to use for localizing the findings.
     */
    locale?: Locale;
    /**
     * The maximum number of results to return in the response.
     */
    maxResults?: Integer;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
    /**
     * The JSON policy document to use as the content for the policy.
     */
    policyDocument: PolicyDocument;
    /**
     * The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups. They also include service-control policies (SCPs) that are attached to an AWS organization, organizational unit (OU), or an account. Resource policies grant permissions on AWS resources. Resource policies include trust policies for IAM roles and bucket policies for S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or S3 bucket policy. 
     */
    policyType: PolicyType;
  }
  export interface ValidatePolicyResponse {
    /**
     * The list of findings in a policy returned by Access Analyzer based on its suite of policy checks.
     */
    findings: ValidatePolicyFindingList;
    /**
     * A token used for pagination of results returned.
     */
    nextToken?: Token;
  }
  export type ValueList = String[];
  export interface VpcConfiguration {
    /**
     *  If this field is specified, this access point will only allow connections from the specified VPC ID. 
     */
    vpcId: VpcId;
  }
  export type VpcId = string;
  /**
   * A string in YYYY-MM-DD format that represents the latest possible API version that can be used in this service. Specify 'latest' to use the latest possible version.
   */
  export type apiVersion = "2019-11-01"|"latest"|string;
  export interface ClientApiVersions {
    /**
     * A string in YYYY-MM-DD format that represents the latest possible API version that can be used in this service. Specify 'latest' to use the latest possible version.
     */
    apiVersion?: apiVersion;
  }
  export type ClientConfiguration = ServiceConfigurationOptions & ClientApiVersions;
  /**
   * Contains interfaces for use with the AccessAnalyzer client.
   */
  export import Types = AccessAnalyzer;
}
export = AccessAnalyzer;
