/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.paths;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import xsbt.boot.internal.shaded.coursier.paths.CoursierPaths;
import xsbt.boot.internal.shaded.coursier.paths.Util;

public class CachePath {
    private static ConcurrentHashMap<String, Object> internedStrings = new ConcurrentHashMap();

    private static String escape(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = object[i];
            if (CachePath.isUnsafe((char)object2)) {
                stringBuilder.append('%');
                stringBuilder.append(CachePath.toHex((int)(object2 / 16)));
                stringBuilder.append(CachePath.toHex((int)(object2 % 16)));
                continue;
            }
            stringBuilder.append((char)object2);
        }
        return stringBuilder.toString();
    }

    private static char toHex(int n) {
        return (char)(n < 10 ? n + 48 : n + 65 - 10);
    }

    private static boolean isUnsafe(char c) {
        return c > '\u0080' || " %$&+,:;=?@<>#%".indexOf(c) >= 0;
    }

    public static File localFile(String string, File file, String string2, boolean bl) throws MalformedURLException {
        if (string.startsWith("file:/") && !bl) {
            try {
                return Paths.get(new URI(string)).toFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                if (string.startsWith("file:///")) {
                    return new File(string.substring(7));
                }
                return new File(string.substring(5));
            }
        }
        Object object = string.split(":", 2);
        if (((String[])object).length != 2) {
            throw new MalformedURLException("No protocol found in URL " + string);
        }
        String string3 = object[0];
        if (((String)(object = object[1])).startsWith("///")) {
            object = ((String)object).substring(3);
        } else if (((String)object).startsWith("/")) {
            object = ((String)object).substring(1);
        } else {
            throw new MalformedURLException("URL " + string + " doesn't contain an absolute path");
        }
        if (((String)object).endsWith("/")) {
            object = (String)object + ".directory";
        }
        while (((String)object).startsWith("/")) {
            object = ((String)object).substring(1);
        }
        string = "";
        if (string2 != null) {
            string = string2 + "@";
        }
        return new File(file, CachePath.escape(string3 + "/" + string + (String)object));
    }

    public static File temporaryFile(File object) {
        File file = ((File)object).getParentFile();
        object = ((File)object).getName();
        return new File(file, "." + (String)object + ".part");
    }

    public static File lockFile(File file) {
        return new File(file.getParentFile(), file.getName() + ".lock");
    }

    public static File defaultCacheDirectory() throws IOException {
        return CoursierPaths.cacheDirectory();
    }

    private static Object lockFor(Path object) {
        Object object2 = internedStrings.get(object = "coursier-jvm-lock-" + object.toString());
        if (object2 == null) {
            Object object3 = object = ((String)object).intern();
            internedStrings.putIfAbsent((String)object3, object3);
            object2 = object;
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <V> V withStructureLock(File file, Callable<V> object) throws Exception {
        Object object2 = file.toPath();
        Object object3 = CachePath.lockFor((Path)object2);
        object2 = object3;
        object2 = object3;
        synchronized (object3) {
            file = new File(file, ".structure.lock");
            Util.createDirectories(file.toPath().getParent());
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                FileLock fileLock = null;
                try {
                    Object v;
                    fileLock = fileOutputStream.getChannel().lock();
                    v = v.call();
                    // ** MonitorExit[var2_5] (shouldn't be in output)
                    return v;
                    finally {
                        fileLock.release();
                        fileLock = null;
                        fileOutputStream.close();
                        fileOutputStream = null;
                        file.delete();
                    }
                }
                catch (Throwable throwable) {
                    if (fileLock != null) {
                        fileLock.release();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                throw throwable;
            }
        }
    }
}

