/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ObjectReader {
    private static final Log log = LogFactory.getLog(ObjectReader.class);
    protected static final StringManager sm = StringManager.getManager(ObjectReader.class);
    private XByteBuffer buffer;
    protected long lastAccess = System.currentTimeMillis();
    protected boolean accessed = false;
    private volatile boolean cancelled;

    public ObjectReader(int n) {
        this.buffer = new XByteBuffer(n, true);
    }

    public ObjectReader(SocketChannel socketChannel) {
        this(socketChannel.socket());
    }

    public ObjectReader(Socket socket) {
        try {
            this.buffer = new XByteBuffer(socket.getReceiveBufferSize(), true);
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("objectReader.retrieveFailed.socketReceiverBufferSize"));
            this.buffer = new XByteBuffer(43800, true);
        }
    }

    public synchronized void access() {
        this.accessed = true;
        this.lastAccess = System.currentTimeMillis();
    }

    public synchronized void finish() {
        this.accessed = false;
        this.lastAccess = System.currentTimeMillis();
    }

    public synchronized boolean isAccessed() {
        return this.accessed;
    }

    public int append(ByteBuffer byteBuffer, int n, boolean bl) {
        this.buffer.append(byteBuffer, n);
        int n2 = -1;
        if (bl) {
            n2 = this.buffer.countPackages();
        }
        return n2;
    }

    public int append(byte[] byArray, int n, int n2, boolean bl) {
        this.buffer.append(byArray, n, n2);
        int n3 = -1;
        if (bl) {
            n3 = this.buffer.countPackages();
        }
        return n3;
    }

    public ChannelMessage[] execute() {
        int n = this.buffer.countPackages();
        ChannelMessage[] channelMessageArray = new ChannelMessage[n];
        for (int i = 0; i < n; ++i) {
            ChannelData channelData = this.buffer.extractPackage(true);
            channelMessageArray[i] = channelData;
        }
        return channelMessageArray;
    }

    public int bufferSize() {
        return this.buffer.getLength();
    }

    public boolean hasPackage() {
        return this.buffer.countPackages(true) > 0;
    }

    public int count() {
        return this.buffer.countPackages();
    }

    public void close() {
        this.buffer = null;
    }

    public synchronized long getLastAccess() {
        return this.lastAccess;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized void setLastAccess(long l) {
        this.lastAccess = l;
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }
}

