/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.collections;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ManagedConcurrentWeakHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<Key, V> map = new ConcurrentHashMap<Key, V>();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();

    public void maintain() {
        Key key;
        while ((key = (Key)this.queue.poll()) != null) {
            if (key.isDead()) continue;
            key.ackDeath();
            this.map.remove(key);
        }
    }

    private Key createStoreKey(Object object) {
        return new Key(object, this.queue);
    }

    private Key createLookupKey(Object object) {
        return new Key(object, null);
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        return this.map.containsValue(object);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        return this.map.containsKey(this.createLookupKey(object));
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return null;
        }
        return this.map.get(this.createLookupKey(object));
    }

    @Override
    public V put(K k, V v) {
        ManagedConcurrentWeakHashMap.checkNotNull(v);
        return this.map.put(this.createStoreKey(k), v);
    }

    @Override
    public V remove(Object object) {
        return this.map.remove(this.createLookupKey(object));
    }

    @Override
    public void clear() {
        this.map.clear();
        this.maintain();
    }

    @Override
    public V putIfAbsent(K k, V v) {
        ManagedConcurrentWeakHashMap.checkNotNull(v);
        Key key = this.createStoreKey(k);
        V v2 = this.map.putIfAbsent(key, v);
        if (v2 != null) {
            key.ackDeath();
        }
        return v2;
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (object2 == null) {
            return false;
        }
        return this.map.remove(this.createLookupKey(object), object2);
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        ManagedConcurrentWeakHashMap.checkNotNull(v2);
        return this.map.replace(this.createLookupKey(k), v, v2);
    }

    @Override
    public V replace(K k, V v) {
        ManagedConcurrentWeakHashMap.checkNotNull(v);
        return this.map.replace(this.createLookupKey(k), v);
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public boolean isEmpty() {
                return ManagedConcurrentWeakHashMap.this.map.isEmpty();
            }

            @Override
            public int size() {
                return ManagedConcurrentWeakHashMap.this.map.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<Key, V>> it;
                    {
                        this.it = ManagedConcurrentWeakHashMap.this.map.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new Map.Entry<K, V>(){
                            private final Map.Entry<Key, V> en;
                            {
                                this.en = (Map.Entry)it.next();
                            }

                            @Override
                            public K getKey() {
                                return this.en.getKey().get();
                            }

                            @Override
                            public V getValue() {
                                return this.en.getValue();
                            }

                            @Override
                            public V setValue(V v) {
                                ManagedConcurrentWeakHashMap.checkNotNull(v);
                                return this.en.setValue(v);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }
        };
    }

    private static class Key
    extends WeakReference<Object> {
        private final int hash;
        private boolean dead;

        public Key(Object object, ReferenceQueue<Object> referenceQueue) {
            super(object, referenceQueue);
            this.hash = object.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Object t;
            if (this == object) {
                return true;
            }
            if (this.dead) {
                return false;
            }
            if (!(object instanceof Reference)) {
                return false;
            }
            Object t2 = this.get();
            if (t2 == (t = ((Reference)object).get())) {
                return true;
            }
            if (t2 == null || t == null) {
                return false;
            }
            return t2.equals(t);
        }

        public void ackDeath() {
            this.dead = true;
        }

        public boolean isDead() {
            return this.dead;
        }
    }
}

