/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.StringManager;

public abstract class FactoryBase
implements ObjectFactory {
    private static final StringManager sm = StringManager.getManager(FactoryBase.class);

    @Override
    public final Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        if (this.isReferenceTypeSupported(object)) {
            Reference reference = (Reference)object;
            Object object2 = this.getLinked(reference);
            if (object2 != null) {
                return object2;
            }
            ObjectFactory objectFactory = null;
            RefAddr refAddr = reference.get("factory");
            if (refAddr != null) {
                String string = refAddr.getContent().toString();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = null;
                try {
                    clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NamingException namingException = new NamingException(sm.getString("factoryBase.factoryClassError"));
                    namingException.initCause(classNotFoundException);
                    throw namingException;
                }
                try {
                    objectFactory = (ObjectFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof NamingException) {
                        throw (NamingException)throwable;
                    }
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    if (throwable instanceof VirtualMachineError) {
                        throw (VirtualMachineError)throwable;
                    }
                    NamingException namingException = new NamingException(sm.getString("factoryBase.factoryCreationError"));
                    namingException.initCause(throwable);
                    throw namingException;
                }
            }
            objectFactory = this.getDefaultFactory(reference);
            if (objectFactory != null) {
                return objectFactory.getObjectInstance(object, name, context, hashtable);
            }
            throw new NamingException(sm.getString("factoryBase.instanceCreationError"));
        }
        return null;
    }

    protected abstract boolean isReferenceTypeSupported(Object var1);

    protected abstract ObjectFactory getDefaultFactory(Reference var1) throws NamingException;

    protected abstract Object getLinked(Reference var1) throws NamingException;
}

