/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport;

import java.io.IOException;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.nio.PooledParallelSender;
import org.apache.catalina.tribes.util.StringManager;

public class ReplicationTransmitter
implements ChannelSender {
    private Channel channel;
    private static final String info = "ReplicationTransmitter/3.0";
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.transport");
    private MultiPointSender transport = new PooledParallelSender();

    public String getInfo() {
        return info;
    }

    public MultiPointSender getTransport() {
        return this.transport;
    }

    public void setTransport(MultiPointSender multiPointSender) {
        this.transport = multiPointSender;
    }

    @Override
    public void sendMessage(ChannelMessage channelMessage, Member[] memberArray) throws ChannelException {
        MultiPointSender multiPointSender = this.getTransport();
        multiPointSender.sendMessage(memberArray, channelMessage);
    }

    @Override
    public void start() throws IOException {
        this.getTransport().connect();
    }

    @Override
    public synchronized void stop() {
        this.getTransport().disconnect();
        this.channel = null;
    }

    @Override
    public void heartbeat() {
        if (this.getTransport() != null) {
            this.getTransport().keepalive();
        }
    }

    @Override
    public synchronized void add(Member member) {
        this.getTransport().add(member);
    }

    @Override
    public synchronized void remove(Member member) {
        this.getTransport().remove(member);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

