/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.security.SecurityClassLoad;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.jasper.util.FastRemovalDequeue;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class JspRuntimeContext {
    private final Log log = LogFactory.getLog(JspRuntimeContext.class);
    private final AtomicInteger jspReloadCount = new AtomicInteger(0);
    private final AtomicInteger jspUnloadCount = new AtomicInteger(0);
    private final ServletContext context;
    private final Options options;
    private final ClassLoader parentClassLoader;
    private final PermissionCollection permissionCollection;
    private final CodeSource codeSource;
    private final String classpath;
    private volatile long lastCompileCheck = -1L;
    private volatile long lastJspQueueUpdate = System.currentTimeMillis();
    private long jspIdleTimeout;
    private final Map<String, JspServletWrapper> jsps = new ConcurrentHashMap<String, JspServletWrapper>();
    private FastRemovalDequeue<JspServletWrapper> jspQueue = null;
    private volatile boolean compileCheckInProgress = false;

    public JspRuntimeContext(ServletContext servletContext, Options options) {
        Object object;
        this.context = servletContext;
        this.options = options;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (this.log.isDebugEnabled()) {
            if (classLoader != null) {
                this.log.debug((Object)Localizer.getMessage("jsp.message.parent_class_loader_is", classLoader.toString()));
            } else {
                this.log.debug((Object)Localizer.getMessage("jsp.message.parent_class_loader_is", "<none>"));
            }
        }
        this.parentClassLoader = classLoader;
        this.classpath = this.initClassPath();
        if (servletContext instanceof JspCServletContext) {
            this.codeSource = null;
            this.permissionCollection = null;
            return;
        }
        if (Constants.IS_SECURITY_ENABLED) {
            object = this.initSecurity();
            this.codeSource = ((SecurityHolder)object).cs;
            this.permissionCollection = ((SecurityHolder)object).pc;
        } else {
            this.codeSource = null;
            this.permissionCollection = null;
        }
        object = servletContext.getRealPath("/");
        if (!options.getDevelopment() && object != null && options.getCheckInterval() > 0) {
            this.lastCompileCheck = System.currentTimeMillis();
        }
        if (options.getMaxLoadedJsps() > 0) {
            this.jspQueue = new FastRemovalDequeue(options.getMaxLoadedJsps());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)Localizer.getMessage("jsp.message.jsp_queue_created", "" + options.getMaxLoadedJsps(), servletContext.getContextPath()));
            }
        }
        this.jspIdleTimeout = options.getJspIdleTimeout() * 1000;
    }

    public void addWrapper(String string, JspServletWrapper jspServletWrapper) {
        this.jsps.put(string, jspServletWrapper);
    }

    public JspServletWrapper getWrapper(String string) {
        return this.jsps.get(string);
    }

    public void removeWrapper(String string) {
        this.jsps.remove(string);
    }

    public FastRemovalDequeue.Entry push(JspServletWrapper jspServletWrapper) {
        FastRemovalDequeue.Entry entry;
        JspServletWrapper jspServletWrapper2;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)Localizer.getMessage("jsp.message.jsp_added", jspServletWrapper.getJspUri(), this.context.getContextPath()));
        }
        if ((jspServletWrapper2 = (JspServletWrapper)(entry = this.jspQueue.push(jspServletWrapper)).getReplaced()) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)Localizer.getMessage("jsp.message.jsp_removed_excess", jspServletWrapper2.getJspUri(), this.context.getContextPath()));
            }
            this.unloadJspServletWrapper(jspServletWrapper2);
            entry.clearReplaced();
        }
        return entry;
    }

    public void makeYoungest(FastRemovalDequeue.Entry entry) {
        if (this.log.isTraceEnabled()) {
            JspServletWrapper jspServletWrapper = (JspServletWrapper)entry.getContent();
            this.log.trace((Object)Localizer.getMessage("jsp.message.jsp_queue_update", jspServletWrapper.getJspUri(), this.context.getContextPath()));
        }
        this.jspQueue.moveFirst(entry);
    }

    public int getJspCount() {
        return this.jsps.size();
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    public void destroy() {
        Iterator<JspServletWrapper> iterator = this.jsps.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().destroy();
        }
    }

    public void incrementJspReloadCount() {
        this.jspReloadCount.incrementAndGet();
    }

    public void setJspReloadCount(int n) {
        this.jspReloadCount.set(n);
    }

    public int getJspReloadCount() {
        return this.jspReloadCount.intValue();
    }

    public int getJspQueueLength() {
        if (this.jspQueue != null) {
            return this.jspQueue.getSize();
        }
        return -1;
    }

    public void incrementJspUnloadCount() {
        this.jspUnloadCount.incrementAndGet();
    }

    public int getJspUnloadCount() {
        return this.jspUnloadCount.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCompile() {
        if (this.lastCompileCheck < 0L) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l <= this.lastCompileCheck + (long)this.options.getCheckInterval() * 1000L) {
            return;
        }
        this.lastCompileCheck = l;
        ArrayList<JspServletWrapper> arrayList = new ArrayList<JspServletWrapper>();
        this.compileCheckInProgress = true;
        Object[] objectArray = this.jsps.values().toArray();
        for (Object object : objectArray) {
            JspServletWrapper jspServletWrapper = (JspServletWrapper)object;
            JspCompilationContext jspCompilationContext = jspServletWrapper.getJspEngineContext();
            JspServletWrapper jspServletWrapper2 = jspServletWrapper;
            synchronized (jspServletWrapper2) {
                try {
                    jspCompilationContext.compile();
                    if (jspServletWrapper.getReload()) {
                        arrayList.add(jspServletWrapper);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    jspCompilationContext.incrementRemoved();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    jspServletWrapper.getServletContext().log("Background compile failed", throwable);
                }
            }
        }
        this.compileCheckInProgress = false;
        for (JspServletWrapper jspServletWrapper : arrayList) {
            try {
                if (jspServletWrapper.isTagFile()) {
                    JspRuntimeContext jspRuntimeContext = this;
                    synchronized (jspRuntimeContext) {
                        jspServletWrapper.loadTagFile();
                        continue;
                    }
                }
                jspServletWrapper.getServlet();
            }
            catch (ServletException servletException) {
                jspServletWrapper.getServletContext().log("Servlet reload failed", (Throwable)servletException);
            }
        }
    }

    public boolean isCompileCheckInProgress() {
        return this.compileCheckInProgress;
    }

    public String getClassPath() {
        return this.classpath;
    }

    public long getLastJspQueueUpdate() {
        return this.lastJspQueueUpdate;
    }

    private String initClassPath() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.parentClassLoader instanceof URLClassLoader) {
            object = ((URLClassLoader)this.parentClassLoader).getURLs();
            for (URL uRL : object) {
                if (!uRL.getProtocol().equals("file")) continue;
                stringBuilder.append(uRL.getFile() + File.pathSeparator);
            }
        }
        stringBuilder.append(this.options.getScratchDir() + File.pathSeparator);
        object = (String)this.context.getAttribute(Constants.SERVLET_CLASSPATH);
        if (object == null || ((String)object).equals("")) {
            object = this.options.getClassPath();
        }
        String string = stringBuilder.toString() + (String)object;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Compilation classpath initialized: " + string));
        }
        return string;
    }

    private SecurityHolder initSecurity() {
        Policy policy = Policy.getPolicy();
        CodeSource codeSource = null;
        PermissionCollection permissionCollection = null;
        if (policy != null) {
            try {
                String string;
                String string2 = this.context.getRealPath("/");
                if (string2 == null) {
                    string2 = this.options.getScratchDir().toString();
                }
                if (!(string = string2).endsWith(File.separator)) {
                    string = string + File.separator;
                }
                File file = new File(string);
                URL uRL = file.getCanonicalFile().toURI().toURL();
                codeSource = new CodeSource(uRL, (Certificate[])null);
                permissionCollection = policy.getPermissions(codeSource);
                if (!string2.endsWith(File.separator)) {
                    permissionCollection.add(new FilePermission(string2, "read"));
                    string2 = string2 + File.separator;
                } else {
                    permissionCollection.add(new FilePermission(string2.substring(0, string2.length() - 1), "read"));
                }
                string2 = string2 + "-";
                permissionCollection.add(new FilePermission(string2, "read"));
                String string3 = this.options.getScratchDir().toString();
                if (!string3.endsWith(File.separator)) {
                    permissionCollection.add(new FilePermission(string3, "read,write"));
                    string3 = string3 + File.separator;
                }
                string3 = string3 + "-";
                permissionCollection.add(new FilePermission(string3, "read,write,delete"));
                permissionCollection.add(new RuntimePermission("accessClassInPackage.org.apache.jasper.runtime"));
                if (this.parentClassLoader instanceof URLClassLoader) {
                    URL[] uRLArray = ((URLClassLoader)this.parentClassLoader).getURLs();
                    String string4 = null;
                    String string5 = null;
                    for (int i = 0; i < uRLArray.length; ++i) {
                        if (string5 == null && uRLArray[i].toString().startsWith("jndi:")) {
                            string5 = uRLArray[i].toString() + "-";
                        }
                        if (string4 != null || !uRLArray[i].toString().startsWith("jar:jndi:")) continue;
                        string4 = uRLArray[i].toString();
                        string4 = string4.substring(0, string4.length() - 2);
                        string4 = string4.substring(0, string4.lastIndexOf(47)) + "/-";
                    }
                    if (string4 != null) {
                        permissionCollection.add(new FilePermission(string4, "read"));
                        permissionCollection.add(new FilePermission(string4.substring(4), "read"));
                    }
                    if (string5 != null) {
                        permissionCollection.add(new FilePermission(string5, "read"));
                    }
                }
            }
            catch (IOException iOException) {
                this.context.log(Localizer.getMessage("jsp.error.security"), (Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                this.context.log(Localizer.getMessage("jsp.error.security"), (Throwable)runtimeException);
            }
        }
        return new SecurityHolder(codeSource, permissionCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadJspServletWrapper(JspServletWrapper jspServletWrapper) {
        this.removeWrapper(jspServletWrapper.getJspUri());
        JspServletWrapper jspServletWrapper2 = jspServletWrapper;
        synchronized (jspServletWrapper2) {
            jspServletWrapper.destroy();
        }
        this.jspUnloadCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUnload() {
        if (this.log.isTraceEnabled()) {
            int n = -1;
            if (this.jspQueue != null) {
                n = this.jspQueue.getSize();
            }
            this.log.trace((Object)Localizer.getMessage("jsp.message.jsp_unload_check", this.context.getContextPath(), "" + this.jsps.size(), "" + n));
        }
        long l = System.currentTimeMillis();
        if (this.jspIdleTimeout > 0L) {
            Object[] objectArray;
            long l2 = l - this.jspIdleTimeout;
            for (Object object : objectArray = this.jsps.values().toArray()) {
                JspServletWrapper jspServletWrapper;
                JspServletWrapper jspServletWrapper2 = jspServletWrapper = (JspServletWrapper)object;
                synchronized (jspServletWrapper2) {
                    if (jspServletWrapper.getLastUsageTime() < l2) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)Localizer.getMessage("jsp.message.jsp_removed_idle", jspServletWrapper.getJspUri(), this.context.getContextPath(), "" + (l - jspServletWrapper.getLastUsageTime())));
                        }
                        if (this.jspQueue != null) {
                            this.jspQueue.remove(jspServletWrapper.getUnloadHandle());
                        }
                        this.unloadJspServletWrapper(jspServletWrapper);
                    }
                }
            }
        }
        this.lastJspQueueUpdate = l;
    }

    static {
        JspFactoryImpl jspFactoryImpl = new JspFactoryImpl();
        SecurityClassLoad.securityClassLoad(((Object)((Object)jspFactoryImpl)).getClass().getClassLoader());
        if (System.getSecurityManager() != null) {
            String string = "org.apache.jasper.";
            try {
                ((Object)((Object)jspFactoryImpl)).getClass().getClassLoader().loadClass(string + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                ((Object)((Object)jspFactoryImpl)).getClass().getClassLoader().loadClass(string + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                ((Object)((Object)jspFactoryImpl)).getClass().getClassLoader().loadClass(string + "runtime.JspRuntimeLibrary");
                ((Object)((Object)jspFactoryImpl)).getClass().getClassLoader().loadClass(string + "runtime.ServletResponseWrapperInclude");
                ((Object)((Object)jspFactoryImpl)).getClass().getClassLoader().loadClass(string + "servlet.JspServletWrapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(classNotFoundException);
            }
        }
        JspFactory.setDefaultFactory((JspFactory)jspFactoryImpl);
    }

    private static class SecurityHolder {
        private final CodeSource cs;
        private final PermissionCollection pc;

        private SecurityHolder(CodeSource codeSource, PermissionCollection permissionCollection) {
            this.cs = codeSource;
            this.pc = permissionCollection;
        }
    }
}

