/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import javax.help.HelpSet;
import org.netbeans.modules.javahelp.Installer;
import org.netbeans.modules.javahelp.NbDocsStreamHandler;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public final class HelpSetProcessor
implements Environment.Provider {
    private static final String HELPSET_MERGE_CONTEXT = "OpenIDE";
    private static final String HELPSET_MERGE_ATTR = "mergeIntoMaster";

    public Lookup getEnvironment(final DataObject dataObject) {
        try {
            Class.forName("javax.help.HelpSet");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Lookup.EMPTY;
        }
        Installer.log.log(Level.FINE, "creating help set from ref: {0}", dataObject.getPrimaryFile());
        return Lookups.singleton((Object)new InstanceCookie(){

            public String instanceName() {
                return dataObject.getName();
            }

            public Class<?> instanceClass() throws IOException, ClassNotFoundException {
                return HelpSet.class;
            }

            public Object instanceCreate() throws IOException, ClassNotFoundException {
                try {
                    Document document = XMLUtil.parse((InputSource)new InputSource(dataObject.getPrimaryFile().getURL().toString()), (boolean)true, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), (EntityResolver)EntityCatalog.getDefault());
                    Element element = document.getDocumentElement();
                    if (!element.getNodeName().equals("helpsetref")) {
                        throw new IOException();
                    }
                    String string = element.getAttribute("url");
                    if (string == null || string.isEmpty()) {
                        throw new IOException("no url attr on <helpsetref>! doc.class=" + document.getClass().getName() + " doc.documentElement=" + element);
                    }
                    String string2 = element.getAttribute("merge");
                    boolean bl = string2.isEmpty() || Boolean.valueOf(string2) != false;
                    Class<NbDocsStreamHandler> clazz = NbDocsStreamHandler.class;
                    HelpSet helpSet = new HelpSet((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class), new URL(string));
                    helpSet.setKeyData((Object)HelpSetProcessor.HELPSET_MERGE_CONTEXT, HelpSetProcessor.HELPSET_MERGE_ATTR, (Object)bl);
                    return helpSet;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new IOException(exception);
                }
            }
        });
    }
}

