/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher.linux;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.providers.Notifier;

public final class LinuxNotifier
extends Notifier<LKey> {
    private static final Logger LOG = Logger.getLogger(LinuxNotifier.class.getName());
    final InotifyImpl IMPL;
    private int fd;
    private final ByteBuffer buff = ByteBuffer.allocateDirect(4096);
    private final Map<Integer, LKey> map = new HashMap<Integer, LKey>();

    public LinuxNotifier() {
        this.IMPL = (InotifyImpl)Native.load((String)"c", InotifyImpl.class);
    }

    private String getString(int n) {
        if (n < 1) {
            return null;
        }
        byte[] byArray = new byte[n];
        this.buff.get(byArray);
        return Native.toString((byte[])byArray);
    }

    public String nextEvent() throws IOException {
        String string;
        while ((string = this.nextEventPath()) != null && string.isEmpty()) {
        }
        return string;
    }

    public String nextEventPath() throws IOException {
        int n;
        int n2;
        while (this.buff.remaining() < 16 || this.buff.remaining() < 16 + this.buff.getInt(this.buff.position() + 12)) {
            this.buff.compact();
            n2 = this.IMPL.read(this.fd, this.buff, this.buff.remaining());
            if (n2 <= 0) {
                n = NativeLibrary.getInstance((String)"c").getFunction("errno").getInt(0L);
                if (n == 4) {
                    this.buff.flip();
                    continue;
                }
                throw new IOException("error reading from inotify: " + n);
            }
            this.buff.position(this.buff.position() + n2);
            this.buff.flip();
        }
        n2 = this.buff.getInt();
        n = this.buff.getInt();
        int n3 = this.buff.getInt();
        int n4 = this.buff.getInt();
        String string = this.getString(n4);
        if ((n & 0x8000) == 32768) {
            return "";
        }
        LKey lKey = this.map.get(n2);
        if (lKey == null) {
            return null;
        }
        return lKey.path;
    }

    protected void start() throws IOException {
        this.buff.position(this.buff.capacity());
        this.buff.order(ByteOrder.nativeOrder());
        this.fd = this.IMPL.inotify_init1(524288);
        if (this.fd < 0) {
            LOG.log(Level.INFO, "Linux kernel {0} returned {1} from inotify_init1", new Object[]{System.getProperty("os.version"), this.fd});
            this.fd = this.IMPL.inotify_init();
            LOG.log(Level.INFO, "Trying inotify_init: {0}", this.fd);
        }
        if (this.fd < 0) {
            throw new IOException("inotify_init failed: " + this.fd);
        }
    }

    public LKey addWatch(String string) throws IOException {
        int n = this.IMPL.inotify_add_watch(this.fd, string, 966);
        LOG.log(Level.FINEST, "addWatch{0} res: {1}", new Object[]{string, n});
        if (n <= 0) {
            int n2 = NativeLibrary.getInstance((String)"c").getFunction("errno").getInt(0L);
            throw new IOException("addWatch on " + string + " errno: " + n2);
        }
        LKey lKey = this.map.get(n);
        if (lKey == null) {
            lKey = new LKey(n, string);
            this.map.put(n, lKey);
        }
        return lKey;
    }

    public void removeWatch(LKey lKey) {
        this.map.remove(lKey.id);
        this.IMPL.inotify_rm_watch(this.fd, lKey.id);
    }

    static class LKey {
        int id;
        String path;

        public LKey(int n, String string) {
            this.id = n;
            this.path = string;
        }

        public String toString() {
            return "LKey[" + this.id + " - '" + this.path + "']";
        }
    }

    private static interface InotifyImpl
    extends Library {
        public static final int O_CLOEXEC = 524288;
        public static final int IN_ACCESS = 1;
        public static final int IN_MODIFY = 2;
        public static final int IN_ATTRIB = 4;
        public static final int IN_CLOSE_WRITE = 8;
        public static final int IN_CLOSE_NOWRITE = 16;
        public static final int IN_OPEN = 32;
        public static final int IN_MOVED_FROM = 64;
        public static final int IN_MOVED_TO = 128;
        public static final int IN_CREATE = 256;
        public static final int IN_DELETE = 512;
        public static final int IN_DELETE_SELF = 1024;
        public static final int IN_MOVE_SELF = 2048;
        public static final int IN_UNMOUNT = 8192;
        public static final int IN_Q_OVERFLOW = 16384;
        public static final int IN_IGNORED = 32768;

        public int inotify_init();

        public int inotify_init1(int var1);

        public int close(int var1);

        public int read(int var1, ByteBuffer var2, int var3);

        public int inotify_add_watch(int var1, String var2, int var3);

        public int inotify_rm_watch(int var1, int var2);
    }
}

