/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.socketio;

import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRModelFactory;
import org.graalvm.visualvm.jfr.views.socketio.JFRSnapshotSocketIOViewProvider;
import org.graalvm.visualvm.jfr.views.socketio.SocketIONode;
import org.graalvm.visualvm.jfr.views.socketio.SocketIOViewSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

final class JFRSnapshotSocketIOView
extends DataSourceView {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/socketio.png";
    private JFRModel model;
    private DataViewComponent dvc;
    private SocketIOViewSupport.MasterViewSupport masterView;
    private SocketIOViewSupport.DataViewSupport dataView;

    JFRSnapshotSocketIOView(JFRSnapshot jfrSnapshot) {
        super((DataSource)jfrSnapshot, "Socket IO", new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 34, false);
    }

    protected void willBeAdded() {
        JFRSnapshot snapshot = (JFRSnapshot)this.getDataSource();
        this.model = JFRModelFactory.getJFRModelFor((DataSource)snapshot);
    }

    protected DataViewComponent createComponent() {
        this.masterView = new SocketIOViewSupport.MasterViewSupport(this.model){

            @Override
            void firstShown() {
                this.changeAggregation(SocketIOViewSupport.Aggregation.ADDRESS_PORT, SocketIOViewSupport.Aggregation.NONE);
            }

            @Override
            void changeAggregation(SocketIOViewSupport.Aggregation primary, SocketIOViewSupport.Aggregation secondary) {
                JFRSnapshotSocketIOView.this.setAggregation(primary, secondary);
            }
        };
        boolean hasEvents = this.model != null && this.model.containsEvent(JFRSnapshotSocketIOViewProvider.EventChecker.class);
        this.dvc = new DataViewComponent(this.masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(!hasEvents));
        if (hasEvents) {
            this.dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Data", false), 1);
            this.dataView = new SocketIOViewSupport.DataViewSupport();
            this.dvc.addDetailsView(this.dataView.getDetailsView(), 1);
        }
        return this.dvc;
    }

    private void setAggregation(final SocketIOViewSupport.Aggregation primary, final SocketIOViewSupport.Aggregation secondary) {
        this.masterView.showProgress();
        this.dataView.setData(new SocketIONode.Root(), false);
        new RequestProcessor("JFR SocketIO Initializer").post(new Runnable(){

            @Override
            public void run() {
                final SocketIONode.Root root = new SocketIONode.Root(primary, secondary);
                JFRSnapshotSocketIOView.this.model.visitEvents(root);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFRSnapshotSocketIOView.this.dataView.setData(root, !SocketIOViewSupport.Aggregation.NONE.equals((Object)secondary));
                        JFRSnapshotSocketIOView.this.masterView.hideProgress();
                    }
                });
            }
        });
    }
}

