/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import org.openide.awt.AlwaysEnabledAction;
import org.openide.awt.ContextAction;
import org.openide.awt.ContextSelection;
import org.openide.awt.GlobalManager;
import org.openide.awt.PropertyMonitor;
import org.openide.awt.StatefulAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.ActionInvoker;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.Presenter;

final class GeneralAction {
    static final Logger LOG = Logger.getLogger(GeneralAction.class.getName());

    private GeneralAction() {
    }

    public static ContextAwareAction callback(String string, Action action, Lookup lookup, boolean bl, boolean bl2) {
        if (string == null) {
            throw new NullPointerException();
        }
        return new DelegateAction(null, string, lookup, action, bl, bl2);
    }

    public static Action alwaysEnabled(Map map) {
        return new AlwaysEnabledAction(map);
    }

    public static ContextAwareAction callback(Map map) {
        Action action = (Action)map.get("fallback");
        DelegateAction delegateAction = new DelegateAction(map, action);
        Parameters.notNull((CharSequence)"key", (Object)delegateAction.key);
        return delegateAction;
    }

    public static <T> ContextAwareAction context(ContextAction.Performer<? super T> performer, ContextSelection contextSelection, Lookup lookup, Class<T> clazz) {
        return new ContextAction<T>(performer, contextSelection, lookup, clazz, false, null);
    }

    public static ContextAwareAction context(Map map) {
        return GeneralAction.context(map, false);
    }

    static ContextAwareAction context(Map map, boolean bl) {
        Class<?> clazz = GeneralAction.readClass(map.get("type"));
        ContextAwareAction contextAwareAction = GeneralAction._context(map, clazz, Utilities.actionsGlobalContext(), bl);
        if (contextAwareAction.getValue("SwingSelectedKey") != null) {
            return new StateDelegateAction(map, (Action)contextAwareAction);
        }
        return new DelegateAction(map, (Action)contextAwareAction);
    }

    public static Action bindContext(Map map, Lookup lookup) {
        Class<?> clazz = GeneralAction.readClass(map.get("type"));
        return new BaseDelAction(map, (Action)GeneralAction._context(map, clazz, lookup, false));
    }

    private static <T> ContextAwareAction _context(Map map, Class<T> clazz, Lookup lookup, boolean bl) {
        StatefulAction<Object> statefulAction;
        ContextSelection contextSelection = GeneralAction.readSelection(map.get("selectionType"));
        ContextAction.Performer performer = new ContextAction.Performer(map);
        boolean bl2 = Boolean.TRUE.equals(map.get("surviveFocusChange"));
        PropertyMonitor<Object> propertyMonitor = null;
        PropertyMonitor<Object> propertyMonitor2 = null;
        Class<Object> clazz2 = GeneralAction.tryReadClass(map.get("enableOnType"));
        if (clazz2 == null) {
            clazz2 = clazz;
        }
        Object v = map.get("enableOnActionProperty");
        Object v2 = map.get("enableOnProperty");
        if (v2 instanceof String || v2 == null && v instanceof String) {
            propertyMonitor = new PropertyMonitor(clazz2, (String)v2, "enableOn", map);
        }
        if ((v2 = map.get("checkedOnProperty")) instanceof String && (statefulAction = GeneralAction.tryReadClass(map.get("checkedOnType"))) != null) {
            propertyMonitor2 = new PropertyMonitor((Class<?>)((Object)statefulAction), (String)v2, "checkedOn", map);
        }
        if (bl) {
            propertyMonitor = new PropertyMonitor<Action>(Action.class, "enabled");
            statefulAction = map.get("delegate");
            if (statefulAction instanceof Action && ((Action)statefulAction).getValue("SwingSelectedKey") != null) {
                propertyMonitor2 = new PropertyMonitor<Action>(Action.class, "SwingSelectedKey");
            }
        }
        if (propertyMonitor2 == null) {
            statefulAction = new ContextAction(performer, contextSelection, lookup, clazz, bl2, propertyMonitor);
        } else {
            statefulAction = new StatefulAction(performer, contextSelection, lookup, clazz, bl2, propertyMonitor, propertyMonitor2);
            LOG.log(Level.FINE, "Created stateful delegate for {0}, instance {1}, value monitor {2}", new Object[]{map, statefulAction, propertyMonitor2});
        }
        return statefulAction;
    }

    private static ContextSelection readSelection(Object object) {
        if (object instanceof ContextSelection) {
            return (ContextSelection)((Object)object);
        }
        if (object instanceof String) {
            return ContextSelection.valueOf((String)object);
        }
        throw new IllegalStateException("Cannot parse 'selectionType' value: " + object);
    }

    static Class<?> readClass(Object object) {
        Class<?> clazz = GeneralAction.tryReadClass(object);
        if (clazz == null) {
            throw new IllegalStateException("Cannot read 'type' value: " + object);
        }
        return clazz;
    }

    static Class<?> tryReadClass(Object object) {
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object instanceof String) {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader == null) {
                classLoader = GeneralAction.class.getClassLoader();
            }
            try {
                return Class.forName((String)object, false, classLoader);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return null;
    }

    static final Object extractCommonAttribute(Map map, Action action, String string) {
        return AlwaysEnabledAction.extractCommonAttribute(map, string);
    }

    public Logger getLOG() {
        return LOG;
    }

    static class BaseDelAction
    implements Action,
    PropertyChangeListener {
        final Map map;
        final Action fallback;
        final Object key;
        final boolean async;
        final GlobalManager global;
        private PropertyChangeSupport support;
        PropertyChangeListener weakL;
        Map<String, Object> attrs;

        protected BaseDelAction(Map map, Object object, Lookup lookup, Action action, boolean bl, boolean bl2) {
            this.map = map;
            this.key = object;
            this.fallback = action;
            this.global = GlobalManager.findManager(lookup, bl);
            this.weakL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)action);
            this.async = bl2;
            if (action != null) {
                LOG.log(Level.FINER, "Action {0}: Attaching propchange to {1}", new Object[]{this, action});
                action.addPropertyChangeListener(this.weakL);
            }
        }

        protected BaseDelAction(Map map, Action action) {
            this(map, map.get("key"), Utilities.actionsGlobalContext(), action, Boolean.TRUE.equals(map.get("surviveFocusChange")), Boolean.TRUE.equals(map.get("asynchronous")));
        }

        public String toString() {
            return super.toString() + "[key=" + this.key + ", map=" + this.map + "]";
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            assert (EventQueue.isDispatchThread());
            Action action = this.findAction();
            if (action != null) {
                ActionInvoker.invokeAction((Action)action, (ActionEvent)actionEvent, (boolean)this.async, null);
            }
        }

        @Override
        public boolean isEnabled() {
            assert (EventQueue.isDispatchThread());
            Action action = this.findAction();
            return action == null ? false : action.isEnabled();
        }

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            boolean bl = false;
            if (this.support == null) {
                this.support = new PropertyChangeSupport(this);
                bl = true;
            }
            this.support.addPropertyChangeListener(propertyChangeListener);
            if (bl) {
                LOG.log(Level.FINER, "Action {0}: Adding global listener for key {1}", new Object[]{this, this.key});
                this.global.registerListener(this.key, this);
            }
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.support != null) {
                this.support.removePropertyChangeListener(propertyChangeListener);
                if (!this.support.hasListeners(null)) {
                    this.global.unregisterListener(this.key, this);
                    LOG.log(Level.FINER, "Action {0}: Removed global listener for key {1}", new Object[]{this, this.key});
                    this.support = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putValue(String string, Object object) {
            PropertyChangeSupport propertyChangeSupport;
            if (this.attrs == null) {
                this.attrs = new HashMap<String, Object>();
            }
            Object object2 = this;
            synchronized (object2) {
                propertyChangeSupport = this.support;
            }
            object2 = null;
            if (propertyChangeSupport != null) {
                object2 = this.getValue(string);
            }
            this.attrs.put(string, object);
            if (propertyChangeSupport != null) {
                propertyChangeSupport.firePropertyChange(string, object2, object2 != null ? object : null);
            }
        }

        @Override
        public Object getValue(String string) {
            if (this.attrs != null && this.attrs.containsKey(string)) {
                return this.attrs.get(string);
            }
            Object object = GeneralAction.extractCommonAttribute(this.map, this, string);
            if (object != null) {
                return object;
            }
            Action action = this.findAction();
            return action == null ? null : action.getValue(string);
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        void updateState(ActionMap actionMap, ActionMap actionMap2, boolean bl) {
            Action action;
            if (this.key == null) {
                return;
            }
            boolean bl2 = false;
            if (actionMap != null && (action = actionMap.get(this.key)) != null) {
                bl2 = bl && action.isEnabled();
                action.removePropertyChangeListener(this.weakL);
            }
            if (actionMap2 != null) {
                PropertyChangeSupport propertyChangeSupport;
                boolean bl3;
                action = actionMap2.get(this.key);
                if (action != null) {
                    action.addPropertyChangeListener(this.weakL);
                    bl3 = action.isEnabled();
                } else {
                    bl3 = this.fallback != null && this.fallback.isEnabled();
                }
                PropertyChangeSupport propertyChangeSupport2 = propertyChangeSupport = bl ? this.support : null;
                if (propertyChangeSupport != null && bl3 != bl2) {
                    propertyChangeSupport.firePropertyChange("enabled", bl2, !bl2);
                }
            }
        }

        private Action findAction() {
            Action action = this.global.findGlobalAction(this.key);
            return action == null ? this.fallback : action;
        }

        protected BaseDelAction copyDelegate(Action action, Lookup lookup) {
            return new DelegateAction(this.map, this.key, lookup, action, this.global.isSurvive(), this.async);
        }

        public Action createContextAwareInstance(Lookup lookup) {
            Action action = this.fallback;
            if (action instanceof ContextAwareAction) {
                action = ((ContextAwareAction)action).createContextAwareInstance(lookup);
            }
            BaseDelAction baseDelAction = this.copyDelegate(action, lookup);
            if (this.attrs != null) {
                if (baseDelAction.attrs == null) {
                    baseDelAction.attrs = new HashMap<String, Object>(this.attrs);
                } else {
                    for (String string : this.attrs.keySet()) {
                        baseDelAction.attrs.putIfAbsent(string, this.attrs.get(string));
                    }
                }
            }
            return baseDelAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                PropertyChangeSupport propertyChangeSupport;
                LOG.log(Level.FINE, "Action {0}: got property change from fallback {1}", new Object[]{this, this.fallback});
                BaseDelAction baseDelAction = this;
                synchronized (baseDelAction) {
                    propertyChangeSupport = this.support;
                }
                if (propertyChangeSupport != null) {
                    propertyChangeSupport.firePropertyChange("enabled", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            }
        }

        public int hashCode() {
            int n = this.key == null ? 37 : this.key.hashCode();
            int n2 = this.map == null ? 17 : this.map.hashCode();
            int n3 = this.fallback == null ? 7 : this.fallback.hashCode();
            return (n << 2) + (n2 << 1) + n3;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DelegateAction) {
                DelegateAction delegateAction = (DelegateAction)object;
                if (this.key != null && !this.key.equals(delegateAction.key)) {
                    return false;
                }
                if (this.map != null && !this.map.equals(delegateAction.map)) {
                    return false;
                }
                return this.fallback == null || this.fallback.equals(delegateAction.fallback);
            }
            return false;
        }
    }

    static final class StateDelegateAction
    extends BaseDelAction
    implements ContextAwareAction,
    Presenter.Toolbar,
    Presenter.Menu,
    Presenter.Popup,
    PropertyChangeListener {
        public StateDelegateAction(Map map, Object object, Lookup lookup, Action action, boolean bl, boolean bl2) {
            super(map, object, lookup, action, bl, bl2);
            this.putValue("SwingSelectedKey", action.getValue("SwingSelectedKey"));
        }

        public StateDelegateAction(Map map, Action action) {
            super(map, action);
        }

        public Component getToolbarPresenter() {
            return ActionPresenterProvider.getDefault().createToolbarPresenter((Action)this);
        }

        public JMenuItem getMenuPresenter() {
            return ActionPresenterProvider.getDefault().createMenuPresenter((Action)this);
        }

        public JMenuItem getPopupPresenter() {
            return ActionPresenterProvider.getDefault().createPopupPresenter((Action)this);
        }

        @Override
        void updateState(ActionMap actionMap, ActionMap actionMap2, boolean bl) {
            Boolean bl2;
            Action action;
            super.updateState(actionMap, actionMap2, bl);
            if (this.key == null) {
                return;
            }
            Action action2 = actionMap.get(this.key);
            if (action2 == (action = actionMap2.get(this.key))) {
                return;
            }
            Boolean bl3 = action2 != null ? Boolean.valueOf(Boolean.TRUE.equals(action2.getValue("SwingSelectedKey"))) : Boolean.valueOf(Boolean.TRUE.equals(this.fallback.getValue("SwingSelectedKey")));
            if (bl3 != (bl2 = action != null ? Boolean.valueOf(Boolean.TRUE.equals(action.getValue("SwingSelectedKey"))) : Boolean.valueOf(Boolean.TRUE.equals(this.fallback.getValue("SwingSelectedKey"))))) {
                this.putValue("SwingSelectedKey", bl2);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if ("SwingSelectedKey".equals(propertyChangeEvent.getPropertyName())) {
                Object object = propertyChangeEvent.getNewValue();
                this.putValue("SwingSelectedKey", object != null ? this.fallback.getValue("SwingSelectedKey") : object);
            }
        }

        @Override
        protected BaseDelAction copyDelegate(Action action, Lookup lookup) {
            return new StateDelegateAction(this.map, this.key, lookup, action, this.global.isSurvive(), this.async);
        }
    }

    static final class DelegateAction
    extends BaseDelAction
    implements ContextAwareAction {
        public DelegateAction(Map map, Object object, Lookup lookup, Action action, boolean bl, boolean bl2) {
            super(map, object, lookup, action, bl, bl2);
        }

        public DelegateAction(Map map, Action action) {
            super(map, action);
        }
    }
}

