/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.views.threads;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.views.threads.DeadlockDetector;
import org.graalvm.visualvm.application.views.threads.VisualVMThreadsDataManager;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.lib.jfluid.client.MonitoredData;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.MonitoredNumbersResponse;

class ThreadMXBeanDataManager
extends VisualVMThreadsDataManager {
    private static final long[] dummyLong = new long[0];
    private static final Logger LOGGER = Logger.getLogger(ThreadMXBeanDataManager.class.getName());
    static final String DEADLOCK_PROP = "Deadlock";
    private ThreadMXBean threadBean;
    private Set<Long> threadIdSet = new HashSet<Long>();
    private boolean refreshRunning;
    private DeadlockDetector deadlockDetector;
    private PropertyChangeSupport changeSupport;
    private long[] deadlockThreadIds;
    private int threadCount;
    private int daemonThreadCount;

    ThreadMXBeanDataManager(ThreadMXBean tb) {
        this.threadBean = tb;
        this.deadlockDetector = new DeadlockDetector(tb);
        this.changeSupport = new PropertyChangeSupport((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshThreadsAsync() {
        ThreadMXBeanDataManager threadMXBeanDataManager = this;
        synchronized (threadMXBeanDataManager) {
            if (this.refreshRunning) {
                return;
            }
            this.refreshRunning = true;
        }
        VisualVM.getInstance().runTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long[] oldDeadlockThreadIds = ThreadMXBeanDataManager.this.deadlockThreadIds;
                ThreadMXBeanDataManager.this.refreshThreadsSync();
                ThreadMXBeanDataManager.access$002(ThreadMXBeanDataManager.this, ThreadMXBeanDataManager.this.deadlockDetector.detectDeadlock());
                if (ThreadMXBeanDataManager.this.deadlockThreadIds != null && !Arrays.equals(oldDeadlockThreadIds, ThreadMXBeanDataManager.this.deadlockThreadIds)) {
                    ThreadMXBeanDataManager.this.changeSupport.firePropertyChange(ThreadMXBeanDataManager.DEADLOCK_PROP, oldDeadlockThreadIds, ThreadMXBeanDataManager.this.deadlockThreadIds);
                }
                ThreadMXBeanDataManager threadMXBeanDataManager = ThreadMXBeanDataManager.this;
                synchronized (threadMXBeanDataManager) {
                    ThreadMXBeanDataManager.this.refreshRunning = false;
                }
            }
        });
    }

    void refreshThreadsSync() {
        try {
            ThreadMonitoredDataResponse resp = new ThreadMonitoredDataResponse();
            resp.fillInThreadData();
            this.threadCount = this.threadBean.getThreadCount();
            this.daemonThreadCount = this.threadBean.getDaemonThreadCount();
            final MonitoredData monitoredData = MonitoredData.getMonitoredData((MonitoredNumbersResponse)resp);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ThreadMXBeanDataManager.this.processData(monitoredData);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.throwing(ThreadMXBeanDataManager.class.getName(), "refreshThreads", ex);
        }
    }

    @Override
    int getDaemonThreadCount() {
        return this.daemonThreadCount;
    }

    @Override
    int getThreadCount() {
        return this.threadCount;
    }

    void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    static /* synthetic */ long[] access$002(ThreadMXBeanDataManager x0, long[] x1) {
        x0.deadlockThreadIds = x1;
        return x1;
    }

    class ThreadMonitoredDataResponse
    extends MonitoredNumbersResponse {
        ThreadMonitoredDataResponse() {
            super(dummyLong, 0, -1);
            this.setGCstartFinishData(dummyLong, dummyLong);
        }

        private void fillInThreadData() {
            long[] currentThreadIds = ThreadMXBeanDataManager.this.threadBean.getAllThreadIds();
            ThreadInfo[] threadInfos = ThreadMXBeanDataManager.this.threadBean.getThreadInfo(currentThreadIds, 1);
            HashSet<Long> currentIdSet = new HashSet<Long>(currentThreadIds.length * 4 / 3);
            int nThreads = 0;
            long[] timeStamps = new long[]{System.currentTimeMillis()};
            int maxThreads = currentThreadIds.length + ThreadMXBeanDataManager.this.threadIdSet.size();
            int[] tids = new int[maxThreads];
            byte[] states = new byte[maxThreads];
            int nNewThreads = 0;
            int[] newThreadsId = new int[currentThreadIds.length];
            String[] newThreadsNames = new String[currentThreadIds.length];
            String[] newThreadsClasses = new String[currentThreadIds.length];
            for (int i = 0; i < currentThreadIds.length; ++i) {
                ThreadInfo tinfo = threadInfos[i];
                long threadId = currentThreadIds[i];
                if (tinfo == null) continue;
                Long threadIdLong = threadId;
                currentIdSet.add(threadIdLong);
                tids[nThreads] = (int)threadId;
                states[nThreads] = this.getState(tinfo);
                ++nThreads;
                if (ThreadMXBeanDataManager.this.threadIdSet.remove(threadIdLong)) continue;
                newThreadsId[nNewThreads] = (int)threadId;
                newThreadsNames[nNewThreads] = tinfo.getThreadName();
                newThreadsClasses[nNewThreads] = "";
                ++nNewThreads;
            }
            for (Long elem : ThreadMXBeanDataManager.this.threadIdSet) {
                tids[nThreads] = elem.intValue();
                states[nThreads] = 0;
                ++nThreads;
            }
            ThreadMXBeanDataManager.this.threadIdSet = currentIdSet;
            this.setDataOnNewThreads(nNewThreads, newThreadsId, newThreadsNames, newThreadsClasses);
            this.setDataOnThreads(nThreads, timeStamps.length, tids, timeStamps, states);
        }

        byte getState(ThreadInfo threadInfo) {
            Thread.State state = threadInfo.getThreadState();
            switch (state) {
                case BLOCKED: {
                    return 3;
                }
                case RUNNABLE: {
                    return 1;
                }
                case TIMED_WAITING: 
                case WAITING: {
                    StackTraceElement[] stack = threadInfo.getStackTrace();
                    if (stack.length > 0) {
                        StackTraceElement el = stack[0];
                        if (this.isSleeping(el)) {
                            return 2;
                        }
                        if (this.isParked(el)) {
                            return 5;
                        }
                    }
                    return 4;
                }
                case TERMINATED: 
                case NEW: {
                    return 0;
                }
            }
            return -1;
        }

        boolean isSleeping(StackTraceElement element) {
            return Thread.class.getName().equals(element.getClassName()) && "sleep".equals(element.getMethodName());
        }

        boolean isParked(StackTraceElement element) {
            String className = element.getClassName();
            if ("jdk.internal.misc.Unsafe".equals(className) || "sun.misc.Unsafe".equals(className)) {
                return "park".equals(element.getMethodName());
            }
            return false;
        }
    }
}

