/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.gpx.GpxExtension;
import org.openstreetmap.josm.data.gpx.IWithAttributes;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.Attributes;

public class GpxExtensionCollection
extends ArrayList<GpxExtension> {
    private static final long serialVersionUID = 1L;
    private Stack<GpxExtension> childStack;
    private IWithAttributes parent;

    public GpxExtensionCollection() {
    }

    public GpxExtensionCollection(IWithAttributes parent) {
        this.parent = parent;
    }

    public void openChild(String namespaceURI, String qName, Attributes atts) {
        if (this.childStack == null) {
            this.childStack = new Stack();
        }
        GpxExtension child = new GpxExtension(namespaceURI, qName, atts);
        if (!this.childStack.isEmpty()) {
            ((GpxExtension)this.childStack.lastElement()).getExtensions().add(child);
        } else {
            this.add(child);
        }
        this.childStack.add(child);
    }

    public void closeChild(String qName, String value) {
        if (this.childStack == null || this.childStack.isEmpty()) {
            Logging.warn("Can''t close child ''{0}'', no element in stack.", qName);
            return;
        }
        GpxExtension child = this.childStack.pop();
        String childQN = child.getQualifiedName();
        if (!childQN.equals(qName)) {
            Logging.warn("Couldn''t close child ''{0}'', closed ''{1}'' instead.", qName, childQN);
        }
        child.setValue(value);
    }

    @Override
    public boolean add(GpxExtension gpx) {
        gpx.setParent(this.parent);
        return super.add(gpx);
    }

    public GpxExtension add(String prefix, String key) {
        return this.add(prefix, key, null);
    }

    public GpxExtension add(String prefix, String key, String value) {
        GpxExtension gpx = new GpxExtension(prefix, key, value);
        this.add(gpx);
        return gpx;
    }

    public GpxExtension addIfNotPresent(String prefix, String key) {
        GpxExtension gpx = this.get(prefix, key);
        if (gpx != null) {
            gpx.show();
            return gpx;
        }
        return this.add(prefix, key);
    }

    public GpxExtension addOrUpdate(String prefix, String key, String value) {
        GpxExtension gpx = this.get(prefix, key);
        if (gpx != null) {
            gpx.show();
            gpx.setValue(value);
            return gpx;
        }
        return this.add(prefix, key, value);
    }

    @Override
    public boolean addAll(Collection<? extends GpxExtension> extensions) {
        extensions.forEach((? super T e) -> e.setParent(this.parent));
        return super.addAll(extensions);
    }

    public void addFlat(String[] chain, String value) {
        if (chain.length >= 3 && "extension".equals(chain[0])) {
            String prefix = "other".equals(chain[1]) ? "" : chain[1];
            GpxExtensionCollection previous = this;
            for (int i = 2; i < chain.length; ++i) {
                if (i == 2 && "segment".equals(chain[2])) continue;
                previous = previous.add(prefix, chain[i], i == chain.length - 1 ? value : null).getExtensions();
            }
        }
    }

    public GpxExtension get(String prefix, String key) {
        return this.stream(prefix, key).findAny().orElse(null);
    }

    public GpxExtensionCollection getAll(String prefix, String key) {
        GpxExtensionCollection copy = new GpxExtensionCollection(this.parent);
        copy.addAll(this.stream(prefix, key).collect(Collectors.toList()));
        return copy;
    }

    public Stream<GpxExtension> stream(String prefix, String key) {
        return this.stream().filter(e -> Objects.equals(prefix, e.getPrefix()) && Objects.equals(key, e.getKey()));
    }

    public GpxExtension find(String prefix, String key) {
        return this.stream().map(child -> child.findExtension(prefix, key)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void findAndRemove(String prefix, String key) {
        Optional.ofNullable(this.find(prefix, key)).ifPresent(GpxExtension::remove);
    }

    public void remove(String prefix, String key) {
        this.stream(prefix, key).collect(Collectors.toList()).forEach((? super T e) -> super.remove(e));
    }

    public void removeAllWithPrefix(String prefix) {
        this.stream().filter(e -> Objects.equals(prefix, e.getPrefix())).collect(Collectors.toList()).forEach((? super T e) -> super.remove(e));
    }

    public Stream<String> getPrefixesStream() {
        return this.stream().filter(GpxExtension::isVisible).map(GpxExtension::getPrefix).distinct();
    }

    public boolean isVisible() {
        return this.stream().anyMatch(GpxExtension::isVisible);
    }

    @Override
    public void clear() {
        if (this.childStack != null) {
            this.childStack.clear();
            this.childStack = null;
        }
        super.clear();
    }
}

