/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory1;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory2;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.UnsafeCall;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u008a\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\t2\u001c\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00150\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182 \b\u0002\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u0019\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015\u0018\u00010\u00132\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirForLoopChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBlockChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkSpecialFunctionCall", "", "call", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "reportSource", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "ambiguityFactory", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory1;", "Lcom/intellij/psi/PsiElement;", "", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "missingFactory", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "noneApplicableFactory", "unsafeCallFactory", "checkers"})
public final class FirForLoopChecker
extends FirExpressionChecker<FirBlock> {
    @NotNull
    public static final FirForLoopChecker INSTANCE = new FirForLoopChecker();

    private FirForLoopChecker() {
    }

    @Override
    public void check(@NotNull FirBlock expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirPureAbstractElement firPureAbstractElement;
        FirSourceElement source;
        FirProperty firProperty;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSourceElement firSourceElement = expression2.getSource();
        if (!Intrinsics.areEqual(firSourceElement == null ? null : firSourceElement.getKind(), FirFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
            return;
        }
        List<FirStatement> statements2 = expression2.getStatements();
        Object object = statements2.get(0);
        FirProperty firProperty2 = firProperty = object instanceof FirProperty ? (FirProperty)object : null;
        if (firProperty == null) {
            return;
        }
        FirProperty iteratorDeclaration = firProperty;
        FirStatement firStatement = statements2.get(1);
        Object object2 = object = firStatement instanceof FirWhileLoop ? (FirWhileLoop)firStatement : null;
        if (object == null) {
            return;
        }
        FirStatement whileLoop = object;
        object = iteratorDeclaration.getSource();
        if (!Intrinsics.areEqual(object == null ? null : ((FirSourceElement)object).getKind(), FirFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
            return;
        }
        firStatement = iteratorDeclaration.getInitializer();
        if (firStatement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
        }
        FirFunctionCall iteratorCall = (FirFunctionCall)firStatement;
        FirExpression firExpression2 = iteratorCall.getExplicitReceiver();
        FirSourceElement firSourceElement2 = firExpression2 == null ? null : firExpression2.getSource();
        FirSourceElement firSourceElement3 = source = firSourceElement2 == null ? iteratorCall.getSource() : firSourceElement2;
        if (FirForLoopChecker.checkSpecialFunctionCall$default(this, iteratorCall, reporter, source, context2, FirErrors.INSTANCE.getITERATOR_AMBIGUITY(), FirErrors.INSTANCE.getITERATOR_MISSING(), null, FirErrors.INSTANCE.getITERATOR_ON_NULLABLE(), 64, null)) {
            return;
        }
        FirFunctionCall hasNextCall = (FirFunctionCall)((FirWhileLoop)whileLoop).getCondition();
        FirForLoopChecker.checkSpecialFunctionCall$default(this, hasNextCall, reporter, source, context2, FirErrors.INSTANCE.getHAS_NEXT_FUNCTION_AMBIGUITY(), FirErrors.INSTANCE.getHAS_NEXT_MISSING(), FirErrors.INSTANCE.getHAS_NEXT_FUNCTION_NONE_APPLICABLE(), null, 128, null);
        Object object3 = CollectionsKt.firstOrNull(((FirWhileLoop)whileLoop).getBlock().getStatements());
        FirPureAbstractElement firPureAbstractElement2 = firPureAbstractElement = object3 instanceof FirProperty ? (FirProperty)object3 : null;
        if (firPureAbstractElement == null) {
            return;
        }
        FirPureAbstractElement elementDeclaration = firPureAbstractElement;
        if (!Intrinsics.areEqual((firPureAbstractElement = elementDeclaration.getInitializer()) == null ? null : ((object3 = ((FirExpression)firPureAbstractElement).getSource()) == null ? null : ((FirSourceElement)object3).getKind()), FirFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
            return;
        }
        object3 = elementDeclaration.getInitializer();
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
        }
        FirFunctionCall nextCall = (FirFunctionCall)object3;
        FirForLoopChecker.checkSpecialFunctionCall$default(this, nextCall, reporter, source, context2, FirErrors.INSTANCE.getNEXT_AMBIGUITY(), FirErrors.INSTANCE.getNEXT_MISSING(), FirErrors.INSTANCE.getNEXT_NONE_APPLICABLE(), null, 128, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSpecialFunctionCall(FirFunctionCall call2, DiagnosticReporter reporter, FirSourceElement reportSource, CheckerContext context2, FirDiagnosticFactory1<PsiElement, Collection<AbstractFirBasedSymbol<?>>> ambiguityFactory, FirDiagnosticFactory0<KtExpression> missingFactory, FirDiagnosticFactory1<KtExpression, Collection<AbstractFirBasedSymbol<?>>> noneApplicableFactory, FirDiagnosticFactory0<KtExpression> unsafeCallFactory) {
        AbstractFirBasedSymbol<?> symbol2;
        FirNamedReference calleeReference = call2.getCalleeReference();
        if (calleeReference instanceof FirErrorNamedReference) {
            ConeDiagnostic diagnostic = ((FirErrorNamedReference)calleeReference).getDiagnostic();
            if (diagnostic instanceof ConeAmbiguityError) {
                if (CandidateApplicabilityKt.isSuccess(((ConeAmbiguityError)diagnostic).getApplicability())) {
                    Collection<AbstractFirBasedSymbol<?>> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
                    FirDiagnosticFactory1<PsiElement, Collection<AbstractFirBasedSymbol<?>>> firDiagnosticFactory1 = ambiguityFactory;
                    FirSourceElement firSourceElement = reportSource;
                    DiagnosticReporter diagnosticReporter = reporter;
                    boolean $i$f$map = false;
                    void var13_26 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Candidate candidate2 = (Candidate)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = it.getSymbol();
                        collection.add(abstractFirBasedSymbol);
                    }
                    collection = (List)destination$iv$iv;
                    DiagnosticReporterKt.reportOn(diagnosticReporter, firSourceElement, firDiagnosticFactory1, collection, context2);
                } else if (noneApplicableFactory != null) {
                    Collection<AbstractFirBasedSymbol<?>> collection;
                    Iterable $this$map$iv = ((ConeAmbiguityError)diagnostic).getCandidates();
                    FirDiagnosticFactory1<KtExpression, Collection<AbstractFirBasedSymbol<?>>> firDiagnosticFactory1 = noneApplicableFactory;
                    FirSourceElement firSourceElement = reportSource;
                    DiagnosticReporter diagnosticReporter = reporter;
                    boolean $i$f$map = false;
                    Iterable $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Candidate it = (Candidate)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = it.getSymbol();
                        collection.add(abstractFirBasedSymbol);
                    }
                    collection = (List)destination$iv$iv;
                    DiagnosticReporterKt.reportOn(diagnosticReporter, firSourceElement, firDiagnosticFactory1, collection, context2);
                }
            } else if (diagnostic instanceof ConeUnresolvedNameError) {
                DiagnosticReporterKt.reportOn(reporter, reportSource, missingFactory, context2);
            } else if (diagnostic instanceof ConeInapplicableCandidateError && (unsafeCallFactory != null || noneApplicableFactory != null)) {
                void $this$forEach$iv;
                Iterator $this$filterTo$iv$iv;
                Iterable $this$filter$iv = ((ConeInapplicableCandidateError)diagnostic).getCandidate().getDiagnostics();
                boolean $i$f$filter = false;
                Iterable $this$mapTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    ResolutionDiagnostic it = (ResolutionDiagnostic)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getApplicability() == ((ConeInapplicableCandidateError)diagnostic).getApplicability())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResolutionDiagnostic it = (ResolutionDiagnostic)element$iv;
                    boolean bl = false;
                    if (!(it instanceof UnsafeCall)) continue;
                    if (unsafeCallFactory != null) {
                        DiagnosticReporterKt.reportOn(reporter, reportSource, unsafeCallFactory, context2);
                    } else {
                        Intrinsics.checkNotNull(noneApplicableFactory);
                        DiagnosticReporterKt.reportOn(reporter, reportSource, noneApplicableFactory, CollectionsKt.listOf(((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol()), context2);
                    }
                    return true;
                }
            }
            return true;
        }
        if (calleeReference instanceof FirResolvedNamedReference && (symbol2 = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol()) instanceof FirNamedFunctionSymbol) {
            FirSimpleFunction function2 = (FirSimpleFunction)((FirNamedFunctionSymbol)symbol2).getFir();
            FirMemberDeclaration $this$isOperator$iv = function2;
            boolean $i$f$isOperator = false;
            if (!$this$isOperator$iv.getStatus().isOperator()) {
                FirDiagnosticFactory2<PsiElement, FirNamedFunctionSymbol, String> firDiagnosticFactory2 = FirErrors.INSTANCE.getOPERATOR_MODIFIER_REQUIRED();
                String string2 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "function.name.asString()");
                DiagnosticReporterKt.reportOn(reporter, reportSource, firDiagnosticFactory2, symbol2, string2, context2);
            }
        }
        return false;
    }

    static /* synthetic */ boolean checkSpecialFunctionCall$default(FirForLoopChecker firForLoopChecker, FirFunctionCall firFunctionCall, DiagnosticReporter diagnosticReporter, FirSourceElement firSourceElement, CheckerContext checkerContext, FirDiagnosticFactory1 firDiagnosticFactory1, FirDiagnosticFactory0 firDiagnosticFactory0, FirDiagnosticFactory1 firDiagnosticFactory12, FirDiagnosticFactory0 firDiagnosticFactory02, int n, Object object) {
        if ((n & 0x40) != 0) {
            firDiagnosticFactory12 = null;
        }
        if ((n & 0x80) != 0) {
            firDiagnosticFactory02 = null;
        }
        return firForLoopChecker.checkSpecialFunctionCall(firFunctionCall, diagnosticReporter, firSourceElement, checkerContext, firDiagnosticFactory1, firDiagnosticFactory0, firDiagnosticFactory12, firDiagnosticFactory02);
    }
}

