# This file has been autogenerated by the pywayland scanner

# Copyright © 2015, 2016 Red Hat
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlSeat
from .zwp_primary_selection_device_v1 import ZwpPrimarySelectionDeviceV1
from .zwp_primary_selection_source_v1 import ZwpPrimarySelectionSourceV1


class ZwpPrimarySelectionDeviceManagerV1(Interface):
    """X primary selection emulation

    The primary selection device manager is a singleton global object that
    provides access to the primary selection. It allows to create
    wp_primary_selection_source objects, as well as retrieving the per-seat
    wp_primary_selection_device objects.
    """

    name = "zwp_primary_selection_device_manager_v1"
    version = 1


class ZwpPrimarySelectionDeviceManagerV1Proxy(Proxy):
    interface = ZwpPrimarySelectionDeviceManagerV1

    @ZwpPrimarySelectionDeviceManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZwpPrimarySelectionSourceV1),
    )
    def create_source(self):
        """Create a new primary selection source

        Create a new primary selection source.

        :returns:
            :class:`~pywayland.protocol.wp_primary_selection_unstable_v1.ZwpPrimarySelectionSourceV1`
        """
        id = self._marshal_constructor(0, ZwpPrimarySelectionSourceV1)
        return id

    @ZwpPrimarySelectionDeviceManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZwpPrimarySelectionDeviceV1),
        Argument(ArgumentType.Object, interface=WlSeat),
    )
    def get_device(self, seat):
        """Create a new primary selection device

        Create a new data device for a given seat.

        :param seat:
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :returns:
            :class:`~pywayland.protocol.wp_primary_selection_unstable_v1.ZwpPrimarySelectionDeviceV1`
        """
        id = self._marshal_constructor(1, ZwpPrimarySelectionDeviceV1, seat)
        return id

    @ZwpPrimarySelectionDeviceManagerV1.request()
    def destroy(self):
        """Destroy the primary selection device manager

        Destroy the primary selection device manager.
        """
        self._marshal(2)
        self._destroy()


class ZwpPrimarySelectionDeviceManagerV1Resource(Resource):
    interface = ZwpPrimarySelectionDeviceManagerV1


class ZwpPrimarySelectionDeviceManagerV1Global(Global):
    interface = ZwpPrimarySelectionDeviceManagerV1


ZwpPrimarySelectionDeviceManagerV1._gen_c()
ZwpPrimarySelectionDeviceManagerV1.proxy_class = ZwpPrimarySelectionDeviceManagerV1Proxy
ZwpPrimarySelectionDeviceManagerV1.resource_class = ZwpPrimarySelectionDeviceManagerV1Resource
ZwpPrimarySelectionDeviceManagerV1.global_class = ZwpPrimarySelectionDeviceManagerV1Global
