/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.text.TextHandler;
import net.sf.sdedit.ui.impl.SequenceDiagramTextTab;
import net.sf.sdedit.util.Grep;

class ExportMapAction
extends AbstractAction {
    private Editor editor;

    ExportMapAction(Editor editor) {
        this.editor = editor;
        this.putValue("Name", "Export &HTML map file");
        this.putValue("ShortDescription", "Create an HTML file with an image map for the diagram currently being displayed");
        this.putValue("SmallIcon", Icons.getIcon("map"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SequenceDiagramTextTab tab = (SequenceDiagramTextTab)this.editor.getUI().currentTab();
        SequenceDiagram diagram = (SequenceDiagram)tab.getDiagram();
        if (diagram == null || diagram.getLifelines().isEmpty()) {
            return;
        }
        TextHandler textHandler = (TextHandler)diagram.getDataProvider();
        File currentFile = this.editor.getUI().getCurrentFile();
        if (currentFile == null) {
            this.editor.getUI().message("Please save the diagram as a file first.");
            return;
        }
        String name = currentFile.getName();
        int dot = Math.min(name.length(), name.lastIndexOf(46));
        name = currentFile.getName().substring(0, dot);
        File target = new File(currentFile.getParent(), name + ".html");
        boolean exists = target.exists();
        if (!exists || 1 == this.editor.getUI().confirmOrCancel("Overwrite existing file:\n" + target.getAbsolutePath() + "?")) {
            try {
                this.generateMapFile(diagram, textHandler, name, target);
                if (!exists) {
                    this.editor.getUI().message("HTML map saved as:\n" + target.getAbsolutePath());
                }
            }
            catch (IOException ex) {
                this.editor.getUI().errorMessage(ex, "The map file could not be saved due to an exception of type\n" + ex.getClass().getSimpleName() + " with the message: " + ex.getMessage(), "I/O error");
            }
        }
    }

    private void generateMapFile(SequenceDiagram diagram, TextHandler textHandler, String mapName, File target) throws IOException {
        String encoding = ConfigurationManager.getGlobalConfiguration().getFileEncoding();
        FileOutputStream fos = new FileOutputStream(target);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);
        PrintWriter pw = new PrintWriter(osw);
        pw.println("<!-- Generated by Quick Sequence Diagram Editor -->");
        pw.println("<!-- encoding: " + encoding + " -->");
        pw.println("<!-- You may append '#!href=\"<url>\"' to an object declaration\nin order to set the 'href' attribute of an AREA tag -->");
        pw.println("<map id=\"" + mapName + "\" name=\"" + mapName + "\">");
        Grep grep = new Grep(Grep.NO_UNESCAPE);
        for (Lifeline lifeline : diagram) {
            String[] href;
            String annotation = textHandler.getAnnotation(lifeline);
            String file = lifeline.getName();
            if (annotation != null && (href = grep.parse("^.*?href=\"(.*?)\".*$", annotation)) != null) {
                file = href[0];
            }
            Drawable drawable = lifeline.getHead();
            int x1 = drawable.getLeft();
            int y1 = drawable.getTop();
            int x2 = drawable.getRight();
            int y2 = drawable.getBottom();
            String coords = x1 + "," + y1 + "," + x2 + "," + y2;
            pw.println("  <area shape=\"rect\" coords=\"" + coords + "\" href=\"" + file + "\"/>");
        }
        pw.println("</map>");
        pw.flush();
        pw.close();
    }
}

