/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.carrotsearch.hppc.FloatArrayList;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.IntLongHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import com.carrotsearch.hppc.cursors.IntLongCursor;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.QueryElevationComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SortSpecParsing;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.uninverting.UninvertingReader;
import org.apache.solr.util.IntFloatDynamicMap;
import org.apache.solr.util.IntIntDynamicMap;
import org.apache.solr.util.IntLongDynamicMap;

public class CollapsingQParserPlugin
extends QParserPlugin {
    public static final String NAME = "collapse";
    public static final String HINT_TOP_FC = "top_fc";
    @Deprecated
    public static final String NULL_COLLAPSE = "collapse";
    @Deprecated
    public static final String NULL_IGNORE = "ignore";
    @Deprecated
    public static final String NULL_EXPAND = "expand";
    @Deprecated
    public static final String HINT_MULTI_DOCVALUES = "multi_docvalues";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
        return new CollapsingQParser(qstr, localParams, params, request);
    }

    public static LeafReader getTopFieldCacheReader(SolrIndexSearcher searcher, String collapseField) {
        UninvertingReader.Type type = null;
        SchemaField f = searcher.getSchema().getFieldOrNull(collapseField);
        assert (null != f);
        assert (!f.multiValued());
        assert (f.getType() instanceof StrField);
        if (f.indexed() && f.isUninvertible()) {
            type = UninvertingReader.Type.SORTED;
        }
        return UninvertingReader.wrap((LeafReader)new ReaderWrapper(searcher.getSlowAtomicReader(), collapseField), Collections.singletonMap(collapseField, type)::get);
    }

    private static final int numNotNull(Object ... args) {
        int r = 0;
        for (Object o : args) {
            if (null == o) continue;
            ++r;
        }
        return r;
    }

    public static Sort rewriteSort(SortSpec sortSpec, IndexSearcher searcher) throws IOException {
        assert (null != sortSpec) : "SortSpec must not be null";
        assert (null != searcher) : "Searcher must not be null";
        Sort orig = sortSpec.getSort();
        if (null == orig) {
            orig = Sort.RELEVANCE;
        }
        return orig.rewrite(searcher);
    }

    private static class CollapsingQParser
    extends QParser {
        public CollapsingQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
            super(qstr, localParams, params, request);
        }

        @Override
        public Query parse() throws SyntaxError {
            try {
                return new CollapsingPostFilter(this.localParams, this.params, this.req);
            }
            catch (Exception e) {
                throw new SyntaxError(e.getMessage(), e);
            }
        }
    }

    private static class ReaderWrapper
    extends FilterLeafReader {
        private final FieldInfos fieldInfos;

        ReaderWrapper(LeafReader leafReader, String field) {
            super(leafReader);
            FieldInfos infos;
            ArrayList<FieldInfo> newInfos = new ArrayList<FieldInfo>(this.in.getFieldInfos().size());
            for (FieldInfo fieldInfo : this.in.getFieldInfos()) {
                if (fieldInfo.name.equals(field)) {
                    FieldInfo f = new FieldInfo(fieldInfo.name, fieldInfo.number, fieldInfo.hasVectors(), fieldInfo.hasNorms(), fieldInfo.hasPayloads(), fieldInfo.getIndexOptions(), DocValuesType.NONE, fieldInfo.getDocValuesGen(), fieldInfo.attributes(), fieldInfo.getPointDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), fieldInfo.isSoftDeletesField());
                    newInfos.add(f);
                    continue;
                }
                newInfos.add(fieldInfo);
            }
            this.fieldInfos = infos = new FieldInfos(newInfos.toArray(new FieldInfo[newInfos.size()]));
        }

        public FieldInfos getFieldInfos() {
            return this.fieldInfos;
        }

        public SortedDocValues getSortedDocValues(String field) {
            return null;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    private static class MinLongComp
    implements LongCompare {
        private MinLongComp() {
        }

        @Override
        public boolean test(long i1, long i2) {
            return i1 < i2;
        }
    }

    private static class MaxLongComp
    implements LongCompare {
        private MaxLongComp() {
        }

        @Override
        public boolean test(long i1, long i2) {
            return i1 > i2;
        }
    }

    private static class MinFloatComp
    implements FloatCompare {
        private MinFloatComp() {
        }

        @Override
        public boolean test(float i1, float i2) {
            return i1 < i2;
        }
    }

    private static class MaxFloatComp
    implements FloatCompare {
        private MaxFloatComp() {
        }

        @Override
        public boolean test(float i1, float i2) {
            return i1 > i2;
        }
    }

    private static class MinIntComp
    implements IntCompare {
        private MinIntComp() {
        }

        @Override
        public boolean test(int i1, int i2) {
            return i1 < i2;
        }
    }

    private static class MaxIntComp
    implements IntCompare {
        private MaxIntComp() {
        }

        @Override
        public boolean test(int i1, int i2) {
            return i1 > i2;
        }
    }

    private static interface LongCompare {
        public boolean test(long var1, long var3);
    }

    private static interface FloatCompare {
        public boolean test(float var1, float var2);
    }

    private static interface IntCompare {
        public boolean test(int var1, int var2);
    }

    private static class SortFieldsCompare {
        private final int numClauses;
        private final SortField[] sorts;
        private final int[] reverseMul;
        private final FieldComparator[] fieldComparators;
        private final LeafFieldComparator[] leafFieldComparators;
        private Object[][] groupHeadValues;
        private final Object[] nullGroupValues;

        public SortFieldsCompare(SortField[] sorts, int initNumGroups) {
            this.sorts = sorts;
            this.numClauses = sorts.length;
            this.fieldComparators = new FieldComparator[this.numClauses];
            this.leafFieldComparators = new LeafFieldComparator[this.numClauses];
            this.reverseMul = new int[this.numClauses];
            for (int clause = 0; clause < this.numClauses; ++clause) {
                SortField sf = sorts[clause];
                this.fieldComparators[clause] = sf.getComparator(1, clause);
                this.reverseMul[clause] = sf.getReverse() ? -1 : 1;
            }
            this.groupHeadValues = new Object[initNumGroups][];
            this.nullGroupValues = new Object[this.numClauses];
        }

        public void setNextReader(LeafReaderContext context) throws IOException {
            for (int clause = 0; clause < this.numClauses; ++clause) {
                this.leafFieldComparators[clause] = this.fieldComparators[clause].getLeafComparator(context);
            }
        }

        public void setScorer(Scorable s) throws IOException {
            for (int clause = 0; clause < this.numClauses; ++clause) {
                this.leafFieldComparators[clause].setScorer(s);
            }
        }

        private static Object cloneIfBytesRef(Object val) {
            if (val instanceof BytesRef) {
                return BytesRef.deepCopyOf((BytesRef)((BytesRef)val));
            }
            return val;
        }

        private Object[] getOrInitGroupHeadValues(int collapseKey) {
            Object[] values = this.groupHeadValues[collapseKey];
            if (null == values) {
                values = new Object[this.numClauses];
                this.groupHeadValues[collapseKey] = values;
            }
            return values;
        }

        public void setGroupValues(int collapseKey, int contextDoc) throws IOException {
            assert (0 <= collapseKey) : "negative collapseKey";
            if (collapseKey >= this.groupHeadValues.length) {
                this.grow(collapseKey + 1);
            }
            this.setGroupValues(this.getOrInitGroupHeadValues(collapseKey), contextDoc);
        }

        public void setNullGroupValues(int contextDoc) throws IOException {
            this.setGroupValues(this.nullGroupValues, contextDoc);
        }

        private void setGroupValues(Object[] values, int contextDoc) throws IOException {
            for (int clause = 0; clause < this.numClauses; ++clause) {
                this.leafFieldComparators[clause].copy(0, contextDoc);
                values[clause] = SortFieldsCompare.cloneIfBytesRef(this.fieldComparators[clause].value(0));
            }
        }

        public boolean testAndSetGroupValues(int collapseKey, int contextDoc) throws IOException {
            assert (0 <= collapseKey) : "negative collapseKey";
            if (collapseKey >= this.groupHeadValues.length) {
                this.grow(collapseKey + 1);
            }
            return this.testAndSetGroupValues(this.getOrInitGroupHeadValues(collapseKey), contextDoc);
        }

        public boolean testAndSetNullGroupValues(int contextDoc) throws IOException {
            return this.testAndSetGroupValues(this.nullGroupValues, contextDoc);
        }

        private boolean testAndSetGroupValues(Object[] values, int contextDoc) throws IOException {
            int testClause;
            Object[] stash = new Object[this.numClauses];
            int lastCompare = 0;
            for (testClause = 0; testClause < this.numClauses; ++testClause) {
                this.leafFieldComparators[testClause].copy(0, contextDoc);
                FieldComparator fcomp = this.fieldComparators[testClause];
                stash[testClause] = SortFieldsCompare.cloneIfBytesRef(fcomp.value(0));
                lastCompare = this.reverseMul[testClause] * fcomp.compareValues(stash[testClause], values[testClause]);
                if (0 != lastCompare) break;
            }
            if (0 <= lastCompare) {
                return false;
            }
            System.arraycopy(stash, 0, values, 0, ++testClause);
            for (int copyClause = testClause; copyClause < this.numClauses; ++copyClause) {
                this.leafFieldComparators[copyClause].copy(0, contextDoc);
                values[copyClause] = SortFieldsCompare.cloneIfBytesRef(this.fieldComparators[copyClause].value(0));
            }
            return true;
        }

        public void grow(int minSize) {
            this.groupHeadValues = (Object[][])ArrayUtil.grow((Object[])this.groupHeadValues, (int)minSize);
        }
    }

    static class MergeBoost {
        private int[] boostDocs;
        private int index = 0;

        public MergeBoost(int[] boostDocs) {
            this.boostDocs = boostDocs;
        }

        public void reset() {
            this.index = 0;
        }

        public boolean boost(int globalDoc) {
            if (this.index == Integer.MIN_VALUE) {
                return false;
            }
            while (true) {
                if (this.index >= this.boostDocs.length) {
                    this.index = Integer.MIN_VALUE;
                    return false;
                }
                int comp = this.boostDocs[this.index];
                if (comp == globalDoc) {
                    ++this.index;
                    return true;
                }
                if (comp >= globalDoc) break;
                ++this.index;
            }
            return false;
        }
    }

    private static class BoostedDocsCollector {
        private final IntIntHashMap boostDocsMap;
        private final int[] sortedGlobalDocIds;
        private final boolean hasBoosts;
        private final IntArrayList boostedKeys = new IntArrayList();
        private final IntArrayList boostedDocs = new IntArrayList();
        private boolean boostedNullGroup = false;
        private final MergeBoost boostedDocsIdsIter;

        public static BoostedDocsCollector build(IntIntHashMap boostDocsMap) {
            if (null != boostDocsMap && !boostDocsMap.isEmpty()) {
                return new BoostedDocsCollector(boostDocsMap);
            }
            return new BoostedDocsCollector(new IntIntHashMap()){

                @Override
                public boolean collectIfBoosted(int groupKey, int globalDoc) {
                    return false;
                }

                @Override
                public boolean collectInNullGroupIfBoosted(int globalDoc) {
                    return false;
                }

                @Override
                public void purgeGroupsThatHaveBoostedDocs(FixedBitSet collapsedSet, IntProcedure removeGroupKey, Runnable resetNullGroupHead) {
                }
            };
        }

        private BoostedDocsCollector(IntIntHashMap boostDocsMap) {
            this.boostDocsMap = boostDocsMap;
            this.hasBoosts = !boostDocsMap.isEmpty();
            this.sortedGlobalDocIds = new int[boostDocsMap.size()];
            Iterator it = boostDocsMap.iterator();
            int index = -1;
            while (it.hasNext()) {
                IntIntCursor cursor = (IntIntCursor)it.next();
                this.sortedGlobalDocIds[++index] = cursor.key;
            }
            Arrays.sort(this.sortedGlobalDocIds);
            this.boostedDocsIdsIter = this.getMergeBoost();
        }

        public boolean hasBoosts() {
            return this.hasBoosts;
        }

        public MergeBoost getMergeBoost() {
            return new MergeBoost(this.sortedGlobalDocIds);
        }

        public boolean collectIfBoosted(int groupKey, int globalDoc) {
            if (this.boostedDocsIdsIter.boost(globalDoc)) {
                this.boostedDocs.add(globalDoc);
                this.boostedKeys.add(groupKey);
                return true;
            }
            return false;
        }

        public boolean collectInNullGroupIfBoosted(int globalDoc) {
            if (this.boostedDocsIdsIter.boost(globalDoc)) {
                this.boostedDocs.add(globalDoc);
                this.boostedNullGroup = true;
                return true;
            }
            return false;
        }

        public void purgeGroupsThatHaveBoostedDocs(final FixedBitSet collapsedSet, IntProcedure removeGroupKey, Runnable resetNullGroupHead) {
            this.boostedDocs.forEach(new IntProcedure(){

                public void apply(int globalDoc) {
                    collapsedSet.set(globalDoc);
                }
            });
            this.boostedKeys.forEach(removeGroupKey);
            if (this.boostedNullGroup) {
                resetNullGroupHead.run();
            }
        }
    }

    private static class IntSortSpecStrategy
    extends IntFieldValueStrategy {
        private final SortFieldsCompare compareState;
        private final SortSpec sortSpec;
        private final Sort sort;
        private int index = -1;
        private boolean needsScores4Collapsing;

        public IntSortSpecStrategy(int maxDoc, int size, String collapseField, int nullPolicy, GroupHeadSelector groupHeadSelector, boolean needsScores4Collapsing, boolean needsScores, BoostedDocsCollector boostedDocsCollector, SortSpec sortSpec, IndexSearcher searcher) throws IOException {
            super(maxDoc, size, collapseField, nullPolicy, needsScores, boostedDocsCollector);
            this.needsScores4Collapsing = needsScores4Collapsing;
            assert (GroupHeadSelectorType.SORT.equals((Object)groupHeadSelector.type));
            this.sortSpec = sortSpec;
            this.sort = CollapsingQParserPlugin.rewriteSort(sortSpec, searcher);
            this.compareState = new SortFieldsCompare(this.sort.getSort(), size);
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.compareState.setNextReader(context);
        }

        @Override
        public void setScorer(Scorable s) throws IOException {
            super.setScorer(s);
            this.compareState.setScorer(s);
        }

        private float computeScoreIfNeeded4Collapse() throws IOException {
            return this.needsScores4Collapsing ? this.scorer.score() : 0.0f;
        }

        @Override
        public void collapse(int collapseKey, int contextDoc, int globalDoc) throws IOException {
            float score = this.computeScoreIfNeeded4Collapse();
            int idx = this.cmap.indexOf(collapseKey);
            if (idx >= 0) {
                int pointer = this.cmap.indexGet(idx);
                if (this.compareState.testAndSetGroupValues(pointer, contextDoc)) {
                    this.docs.put(pointer, globalDoc);
                    if (this.needsScores) {
                        if (!this.needsScores4Collapsing) {
                            score = this.scorer.score();
                        }
                        this.scores.put(pointer, score);
                    }
                }
            } else {
                ++this.index;
                this.cmap.put(collapseKey, this.index);
                this.docs.put(this.index, globalDoc);
                this.compareState.setGroupValues(this.index, contextDoc);
                if (this.needsScores) {
                    if (!this.needsScores4Collapsing) {
                        score = this.scorer.score();
                    }
                    this.scores.put(this.index, score);
                }
            }
        }

        @Override
        public void collapseNullGroup(int contextDoc, int globalDoc) throws IOException {
            assert (NullPolicy.IGNORE.getCode() != this.nullPolicy);
            float score = this.computeScoreIfNeeded4Collapse();
            if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                if (-1 == this.nullDoc) {
                    this.compareState.setNullGroupValues(contextDoc);
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        if (!this.needsScores4Collapsing) {
                            score = this.scorer.score();
                        }
                        this.nullScore = score;
                    }
                } else if (this.compareState.testAndSetNullGroupValues(contextDoc)) {
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        if (!this.needsScores4Collapsing) {
                            score = this.scorer.score();
                        }
                        this.nullScore = score;
                    }
                }
            } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    if (!this.needsScores4Collapsing) {
                        score = this.scorer.score();
                    }
                    this.nullScores.add(score);
                }
            }
        }
    }

    private static class IntValueSourceStrategy
    extends IntFieldValueStrategy {
        private FloatCompare comp;
        private IntFloatDynamicMap testValues;
        private float nullCompVal;
        private ValueSource valueSource;
        private FunctionValues functionValues;
        private Map rcontext;
        private final CollapseScore collapseScore = new CollapseScore();
        private int index = -1;
        private boolean needsScores4Collapsing;

        public IntValueSourceStrategy(int maxDoc, int size, String collapseField, int nullPolicy, GroupHeadSelector groupHeadSelector, boolean needsScores4Collapsing, boolean needsScores, BoostedDocsCollector boostedDocsCollector, FunctionQuery funcQuery, IndexSearcher searcher) throws IOException {
            super(maxDoc, size, collapseField, nullPolicy, needsScores, boostedDocsCollector);
            this.needsScores4Collapsing = needsScores4Collapsing;
            this.testValues = new IntFloatDynamicMap(size, 0.0f);
            this.valueSource = funcQuery.getValueSource();
            this.rcontext = ValueSource.newContext((IndexSearcher)searcher);
            assert (GroupHeadSelectorType.MIN_MAX.contains((Object)groupHeadSelector.type));
            if (GroupHeadSelectorType.MAX.equals((Object)groupHeadSelector.type)) {
                this.nullCompVal = -3.4028235E38f;
                this.comp = new MaxFloatComp();
            } else {
                this.nullCompVal = Float.MAX_VALUE;
                this.comp = new MinFloatComp();
            }
            this.collapseScore.setupIfNeeded(groupHeadSelector, this.rcontext);
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.functionValues = this.valueSource.getValues(this.rcontext, context);
        }

        private float computeScoreIfNeeded4Collapse() throws IOException {
            if (this.needsScores4Collapsing) {
                this.collapseScore.score = this.scorer.score();
                return this.collapseScore.score;
            }
            return 0.0f;
        }

        @Override
        public void collapse(int collapseKey, int contextDoc, int globalDoc) throws IOException {
            float score = this.computeScoreIfNeeded4Collapse();
            float currentVal = this.functionValues.floatVal(contextDoc);
            int idx = this.cmap.indexOf(collapseKey);
            if (idx >= 0) {
                int pointer = this.cmap.indexGet(idx);
                if (this.comp.test(currentVal, this.testValues.get(pointer))) {
                    this.testValues.put(pointer, currentVal);
                    this.docs.put(pointer, globalDoc);
                    if (this.needsScores) {
                        if (!this.needsScores4Collapsing) {
                            score = this.scorer.score();
                        }
                        this.scores.put(pointer, score);
                    }
                }
            } else {
                ++this.index;
                this.cmap.put(collapseKey, this.index);
                this.docs.put(this.index, globalDoc);
                this.testValues.put(this.index, currentVal);
                if (this.needsScores) {
                    if (!this.needsScores4Collapsing) {
                        score = this.scorer.score();
                    }
                    this.scores.put(this.index, score);
                }
            }
        }

        @Override
        public void collapseNullGroup(int contextDoc, int globalDoc) throws IOException {
            assert (NullPolicy.IGNORE.getCode() != this.nullPolicy);
            float score = this.computeScoreIfNeeded4Collapse();
            float currentVal = this.functionValues.floatVal(contextDoc);
            if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                if (this.comp.test(currentVal, this.nullCompVal)) {
                    this.nullCompVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        if (!this.needsScores4Collapsing) {
                            score = this.scorer.score();
                        }
                        this.nullScore = score;
                    }
                }
            } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    if (!this.needsScores4Collapsing) {
                        score = this.scorer.score();
                    }
                    this.nullScores.add(score);
                }
            }
        }
    }

    private static class IntFloatStrategy
    extends IntFieldValueStrategy {
        private final String field;
        private NumericDocValues minMaxVals;
        private IntFloatDynamicMap testValues;
        private FloatCompare comp;
        private float nullCompVal;
        private int index = -1;

        public IntFloatStrategy(int maxDoc, int size, String collapseField, int nullPolicy, GroupHeadSelector groupHeadSelector, boolean needsScores, BoostedDocsCollector boostedDocsCollector) throws IOException {
            super(maxDoc, size, collapseField, nullPolicy, needsScores, boostedDocsCollector);
            this.field = groupHeadSelector.selectorText;
            this.testValues = new IntFloatDynamicMap(size, 0.0f);
            assert (GroupHeadSelectorType.MIN_MAX.contains((Object)groupHeadSelector.type));
            if (GroupHeadSelectorType.MAX.equals((Object)groupHeadSelector.type)) {
                this.comp = new MaxFloatComp();
                this.nullCompVal = -3.4028235E38f;
            } else {
                this.comp = new MinFloatComp();
                this.nullCompVal = Float.MAX_VALUE;
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.minMaxVals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        private float advanceAndGetCurrentVal(int contextDoc) throws IOException {
            if (this.minMaxVals.advanceExact(contextDoc)) {
                return Float.intBitsToFloat((int)this.minMaxVals.longValue());
            }
            return Float.intBitsToFloat(0);
        }

        @Override
        public void collapse(int collapseKey, int contextDoc, int globalDoc) throws IOException {
            float currentVal = this.advanceAndGetCurrentVal(contextDoc);
            int idx = this.cmap.indexOf(collapseKey);
            if (idx >= 0) {
                int pointer = this.cmap.indexGet(idx);
                if (this.comp.test(currentVal, this.testValues.get(pointer))) {
                    this.testValues.put(pointer, currentVal);
                    this.docs.put(pointer, globalDoc);
                    if (this.needsScores) {
                        this.scores.put(pointer, this.scorer.score());
                    }
                }
            } else {
                ++this.index;
                this.cmap.put(collapseKey, this.index);
                this.testValues.put(this.index, currentVal);
                this.docs.put(this.index, globalDoc);
                if (this.needsScores) {
                    this.scores.put(this.index, this.scorer.score());
                }
            }
        }

        @Override
        public void collapseNullGroup(int contextDoc, int globalDoc) throws IOException {
            assert (NullPolicy.IGNORE.getCode() != this.nullPolicy);
            float currentVal = this.advanceAndGetCurrentVal(contextDoc);
            if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                if (this.comp.test(currentVal, this.nullCompVal)) {
                    this.nullCompVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.scorer.score());
                }
            }
        }
    }

    private static class IntIntStrategy
    extends IntFieldValueStrategy {
        private final String field;
        private NumericDocValues minMaxVals;
        private IntIntDynamicMap testValues;
        private IntCompare comp;
        private int nullCompVal;
        private int index = -1;

        public IntIntStrategy(int maxDoc, int size, String collapseField, int nullPolicy, GroupHeadSelector groupHeadSelector, boolean needsScores, BoostedDocsCollector boostedDocsCollector) throws IOException {
            super(maxDoc, size, collapseField, nullPolicy, needsScores, boostedDocsCollector);
            this.field = groupHeadSelector.selectorText;
            this.testValues = new IntIntDynamicMap(size, 0);
            assert (GroupHeadSelectorType.MIN_MAX.contains((Object)groupHeadSelector.type));
            if (GroupHeadSelectorType.MAX.equals((Object)groupHeadSelector.type)) {
                this.comp = new MaxIntComp();
                this.nullCompVal = Integer.MIN_VALUE;
            } else {
                this.comp = new MinIntComp();
                this.nullCompVal = Integer.MAX_VALUE;
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.minMaxVals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        private int advanceAndGetCurrentVal(int contextDoc) throws IOException {
            if (this.minMaxVals.advanceExact(contextDoc)) {
                return (int)this.minMaxVals.longValue();
            }
            return 0;
        }

        @Override
        public void collapse(int collapseKey, int contextDoc, int globalDoc) throws IOException {
            int currentVal = this.advanceAndGetCurrentVal(contextDoc);
            int idx = this.cmap.indexOf(collapseKey);
            if (idx >= 0) {
                int pointer = this.cmap.indexGet(idx);
                if (this.comp.test(currentVal, this.testValues.get(pointer))) {
                    this.testValues.put(pointer, currentVal);
                    this.docs.put(pointer, globalDoc);
                    if (this.needsScores) {
                        this.scores.put(pointer, this.scorer.score());
                    }
                }
            } else {
                ++this.index;
                this.cmap.put(collapseKey, this.index);
                this.testValues.put(this.index, currentVal);
                this.docs.put(this.index, globalDoc);
                if (this.needsScores) {
                    this.scores.put(this.index, this.scorer.score());
                }
            }
        }

        @Override
        public void collapseNullGroup(int contextDoc, int globalDoc) throws IOException {
            assert (NullPolicy.IGNORE.getCode() != this.nullPolicy);
            int currentVal = this.advanceAndGetCurrentVal(contextDoc);
            if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                if (this.comp.test(currentVal, this.nullCompVal)) {
                    this.nullCompVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.scorer.score());
                }
            }
        }
    }

    private static abstract class IntFieldValueStrategy {
        protected int nullPolicy;
        protected IntIntHashMap cmap;
        protected Scorable scorer;
        protected FloatArrayList nullScores;
        protected float nullScore;
        protected IntFloatDynamicMap scores;
        protected FixedBitSet collapsedSet;
        protected int nullDoc = -1;
        protected boolean needsScores;
        protected String collapseField;
        protected IntIntDynamicMap docs;
        private final BoostedDocsCollector boostedDocsCollector;

        public abstract void collapseNullGroup(int var1, int var2) throws IOException;

        public abstract void collapse(int var1, int var2, int var3) throws IOException;

        public abstract void setNextReader(LeafReaderContext var1) throws IOException;

        public IntFieldValueStrategy(int maxDoc, int size, String collapseField, int nullPolicy, boolean needsScores, BoostedDocsCollector boostedDocsCollector) {
            this.collapseField = collapseField;
            this.nullPolicy = nullPolicy;
            this.needsScores = needsScores;
            this.collapsedSet = new FixedBitSet(maxDoc);
            this.cmap = new IntIntHashMap(size);
            this.docs = new IntIntDynamicMap(size, 0);
            this.boostedDocsCollector = boostedDocsCollector;
            if (needsScores) {
                this.scores = new IntFloatDynamicMap(size, 0.0f);
                if (nullPolicy == NullPolicy.EXPAND.getCode()) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        public FixedBitSet getCollapsedSet() {
            this.boostedDocsCollector.purgeGroupsThatHaveBoostedDocs(this.collapsedSet, key -> this.cmap.remove(key), () -> {
                this.nullDoc = -1;
            });
            if (this.nullDoc > -1) {
                this.collapsedSet.set(this.nullDoc);
            }
            for (IntIntCursor cursor : this.cmap) {
                int pointer = cursor.value;
                this.collapsedSet.set(this.docs.get(pointer));
            }
            return this.collapsedSet;
        }

        public void setScorer(Scorable scorer) throws IOException {
            this.scorer = scorer;
        }

        public FloatArrayList getNullScores() {
            return this.nullScores;
        }

        public IntIntHashMap getCollapseMap() {
            return this.cmap;
        }

        public float getNullScore() {
            return this.nullScore;
        }

        public IntFloatDynamicMap getScores() {
            return this.scores;
        }

        public IntIntDynamicMap getDocs() {
            return this.docs;
        }
    }

    private static class OrdSortSpecStrategy
    extends OrdFieldValueStrategy {
        private final SortFieldsCompare compareState;
        private final Sort sort;
        private float score;
        private boolean needsScores4Collapsing;

        public OrdSortSpecStrategy(int maxDoc, int nullPolicy, int valueCount, GroupHeadSelector groupHeadSelector, boolean needsScores4Collapsing, boolean needsScores, BoostedDocsCollector boostedDocsCollector, SortSpec sortSpec, IndexSearcher searcher, SortedDocValues values) throws IOException {
            super(maxDoc, valueCount, nullPolicy, needsScores, boostedDocsCollector, values);
            this.needsScores4Collapsing = needsScores4Collapsing;
            assert (GroupHeadSelectorType.SORT.equals((Object)groupHeadSelector.type));
            this.sort = CollapsingQParserPlugin.rewriteSort(sortSpec, searcher);
            this.compareState = new SortFieldsCompare(this.sort.getSort(), valueCount);
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.compareState.setNextReader(context);
        }

        @Override
        public void setScorer(Scorable s) throws IOException {
            super.setScorer(s);
            this.compareState.setScorer(s);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            if (this.needsScores4Collapsing) {
                this.score = this.scorer.score();
            }
            if (ord > -1) {
                if (-1 == this.ords.get(ord)) {
                    this.compareState.setGroupValues(ord, contextDoc);
                    this.ords.put(ord, globalDoc);
                    if (this.needsScores) {
                        if (!this.needsScores4Collapsing) {
                            this.score = this.scorer.score();
                        }
                        this.scores.put(ord, this.score);
                    }
                } else if (this.compareState.testAndSetGroupValues(ord, contextDoc)) {
                    this.ords.put(ord, globalDoc);
                    if (this.needsScores) {
                        if (!this.needsScores4Collapsing) {
                            this.score = this.scorer.score();
                        }
                        this.scores.put(ord, this.score);
                    }
                }
            } else if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                if (-1 == this.nullDoc) {
                    this.compareState.setNullGroupValues(contextDoc);
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        if (!this.needsScores4Collapsing) {
                            this.score = this.scorer.score();
                        }
                        this.nullScore = this.score;
                    }
                } else if (this.compareState.testAndSetNullGroupValues(contextDoc)) {
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        if (!this.needsScores4Collapsing) {
                            this.score = this.scorer.score();
                        }
                        this.nullScore = this.score;
                    }
                }
            } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    if (!this.needsScores4Collapsing) {
                        this.score = this.scorer.score();
                    }
                    this.nullScores.add(this.score);
                }
            }
        }
    }

    private static class OrdValueSourceStrategy
    extends OrdFieldValueStrategy {
        private FloatCompare comp;
        private float nullVal;
        private ValueSource valueSource;
        private FunctionValues functionValues;
        private IntFloatDynamicMap ordVals;
        private Map rcontext;
        private final CollapseScore collapseScore = new CollapseScore();
        private boolean needsScores4Collapsing;

        public OrdValueSourceStrategy(int maxDoc, int nullPolicy, int valueCount, GroupHeadSelector groupHeadSelector, boolean needsScores4Collapsing, boolean needsScores, BoostedDocsCollector boostedDocsCollector, FunctionQuery funcQuery, IndexSearcher searcher, SortedDocValues values) throws IOException {
            super(maxDoc, valueCount, nullPolicy, needsScores, boostedDocsCollector, values);
            this.needsScores4Collapsing = needsScores4Collapsing;
            this.valueSource = funcQuery.getValueSource();
            this.rcontext = ValueSource.newContext((IndexSearcher)searcher);
            assert (GroupHeadSelectorType.MIN_MAX.contains((Object)groupHeadSelector.type));
            if (GroupHeadSelectorType.MAX.equals((Object)groupHeadSelector.type)) {
                this.comp = new MaxFloatComp();
                this.ordVals = new IntFloatDynamicMap(valueCount, -3.4028235E38f);
            } else {
                this.nullVal = Float.MAX_VALUE;
                this.comp = new MinFloatComp();
                this.ordVals = new IntFloatDynamicMap(valueCount, Float.MAX_VALUE);
            }
            this.collapseScore.setupIfNeeded(groupHeadSelector, this.rcontext);
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.functionValues = this.valueSource.getValues(this.rcontext, context);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            float score = 0.0f;
            if (this.needsScores4Collapsing) {
                this.collapseScore.score = score = this.scorer.score();
            }
            float currentVal = this.functionValues.floatVal(contextDoc);
            if (ord > -1) {
                if (this.comp.test(currentVal, this.ordVals.get(ord))) {
                    this.ords.put(ord, globalDoc);
                    this.ordVals.put(ord, currentVal);
                    if (this.needsScores) {
                        if (!this.needsScores4Collapsing) {
                            score = this.scorer.score();
                        }
                        this.scores.put(ord, score);
                    }
                }
            } else if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                if (this.comp.test(currentVal, this.nullVal)) {
                    this.nullVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        if (!this.needsScores4Collapsing) {
                            score = this.scorer.score();
                        }
                        this.nullScore = score;
                    }
                }
            } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    if (!this.needsScores4Collapsing) {
                        score = this.scorer.score();
                    }
                    this.nullScores.add(score);
                }
            }
        }
    }

    private static class OrdLongStrategy
    extends OrdFieldValueStrategy {
        private final String field;
        private NumericDocValues minMaxVals;
        private LongCompare comp;
        private long nullVal;
        private IntLongDynamicMap ordVals;

        public OrdLongStrategy(int maxDoc, int nullPolicy, int valueCount, GroupHeadSelector groupHeadSelector, boolean needsScores, BoostedDocsCollector boostedDocsCollector, SortedDocValues values) throws IOException {
            super(maxDoc, valueCount, nullPolicy, needsScores, boostedDocsCollector, values);
            this.field = groupHeadSelector.selectorText;
            assert (GroupHeadSelectorType.MIN_MAX.contains((Object)groupHeadSelector.type));
            if (GroupHeadSelectorType.MAX.equals((Object)groupHeadSelector.type)) {
                this.comp = new MaxLongComp();
                this.ordVals = new IntLongDynamicMap(valueCount, Long.MIN_VALUE);
            } else {
                this.nullVal = Long.MAX_VALUE;
                this.comp = new MinLongComp();
                this.ordVals = new IntLongDynamicMap(valueCount, Long.MAX_VALUE);
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.minMaxVals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            long currentVal = this.minMaxVals.advanceExact(contextDoc) ? this.minMaxVals.longValue() : 0L;
            if (ord > -1) {
                if (this.comp.test(currentVal, this.ordVals.get(ord))) {
                    this.ords.put(ord, globalDoc);
                    this.ordVals.put(ord, currentVal);
                    if (this.needsScores) {
                        this.scores.put(ord, this.scorer.score());
                    }
                }
            } else if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                if (this.comp.test(currentVal, this.nullVal)) {
                    this.nullVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.scorer.score());
                }
            }
        }
    }

    private static class OrdFloatStrategy
    extends OrdFieldValueStrategy {
        private final String field;
        private NumericDocValues minMaxValues;
        private FloatCompare comp;
        private float nullVal;
        private IntFloatDynamicMap ordVals;

        public OrdFloatStrategy(int maxDoc, int nullPolicy, int valueCount, GroupHeadSelector groupHeadSelector, boolean needsScores, BoostedDocsCollector boostedDocsCollector, SortedDocValues values) throws IOException {
            super(maxDoc, valueCount, nullPolicy, needsScores, boostedDocsCollector, values);
            this.field = groupHeadSelector.selectorText;
            assert (GroupHeadSelectorType.MIN_MAX.contains((Object)groupHeadSelector.type));
            if (GroupHeadSelectorType.MAX.equals((Object)groupHeadSelector.type)) {
                this.comp = new MaxFloatComp();
                this.ordVals = new IntFloatDynamicMap(valueCount, -3.4028235E38f);
                this.nullVal = -3.4028235E38f;
            } else {
                this.comp = new MinFloatComp();
                this.ordVals = new IntFloatDynamicMap(valueCount, Float.MAX_VALUE);
                this.nullVal = Float.MAX_VALUE;
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.minMaxValues = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            int currentMinMax = this.minMaxValues.advanceExact(contextDoc) ? (int)this.minMaxValues.longValue() : 0;
            float currentVal = Float.intBitsToFloat(currentMinMax);
            if (ord > -1) {
                if (this.comp.test(currentVal, this.ordVals.get(ord))) {
                    this.ords.put(ord, globalDoc);
                    this.ordVals.put(ord, currentVal);
                    if (this.needsScores) {
                        this.scores.put(ord, this.scorer.score());
                    }
                }
            } else if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                if (this.comp.test(currentVal, this.nullVal)) {
                    this.nullVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.scorer.score());
                }
            }
        }
    }

    private static class OrdIntStrategy
    extends OrdFieldValueStrategy {
        private final String field;
        private NumericDocValues minMaxValues;
        private IntCompare comp;
        private int nullVal;
        private IntIntDynamicMap ordVals;

        public OrdIntStrategy(int maxDoc, int nullPolicy, int valueCount, GroupHeadSelector groupHeadSelector, boolean needsScores, BoostedDocsCollector boostedDocsCollector, SortedDocValues values) throws IOException {
            super(maxDoc, valueCount, nullPolicy, needsScores, boostedDocsCollector, values);
            this.field = groupHeadSelector.selectorText;
            assert (GroupHeadSelectorType.MIN_MAX.contains((Object)groupHeadSelector.type));
            if (GroupHeadSelectorType.MAX.equals((Object)groupHeadSelector.type)) {
                this.comp = new MaxIntComp();
                this.ordVals = new IntIntDynamicMap(valueCount, Integer.MIN_VALUE);
            } else {
                this.comp = new MinIntComp();
                this.ordVals = new IntIntDynamicMap(valueCount, Integer.MAX_VALUE);
                this.nullVal = Integer.MAX_VALUE;
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.minMaxValues = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            int currentVal = this.minMaxValues.advanceExact(contextDoc) ? (int)this.minMaxValues.longValue() : 0;
            if (ord > -1) {
                if (this.comp.test(currentVal, this.ordVals.get(ord))) {
                    this.ords.put(ord, globalDoc);
                    this.ordVals.put(ord, currentVal);
                    if (this.needsScores) {
                        this.scores.put(ord, this.scorer.score());
                    }
                }
            } else if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                if (this.comp.test(currentVal, this.nullVal)) {
                    this.nullVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.scorer.score());
                }
            }
        }
    }

    private static abstract class OrdFieldValueStrategy {
        protected int nullPolicy;
        protected IntIntDynamicMap ords;
        protected Scorable scorer;
        protected FloatArrayList nullScores;
        protected float nullScore;
        protected IntFloatDynamicMap scores;
        protected FixedBitSet collapsedSet;
        protected int nullDoc = -1;
        protected boolean needsScores;
        private final BoostedDocsCollector boostedDocsCollector;

        public abstract void collapse(int var1, int var2, int var3) throws IOException;

        public abstract void setNextReader(LeafReaderContext var1) throws IOException;

        public OrdFieldValueStrategy(int maxDoc, int valueCount, int nullPolicy, boolean needsScores, BoostedDocsCollector boostedDocsCollector, SortedDocValues values) {
            this.ords = new IntIntDynamicMap(valueCount, -1);
            this.nullPolicy = nullPolicy;
            this.needsScores = needsScores;
            this.collapsedSet = new FixedBitSet(maxDoc);
            this.boostedDocsCollector = boostedDocsCollector;
            if (this.needsScores) {
                this.scores = new IntFloatDynamicMap(valueCount, 0.0f);
                if (nullPolicy == NullPolicy.EXPAND.getCode()) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        public FixedBitSet getCollapsedSet() {
            this.boostedDocsCollector.purgeGroupsThatHaveBoostedDocs(this.collapsedSet, ord -> this.ords.remove(ord), () -> {
                this.nullDoc = -1;
            });
            if (this.nullDoc > -1) {
                this.collapsedSet.set(this.nullDoc);
            }
            this.ords.forEachValue(doc -> this.collapsedSet.set(doc));
            return this.collapsedSet;
        }

        public void setScorer(Scorable scorer) throws IOException {
            this.scorer = scorer;
        }

        public FloatArrayList getNullScores() {
            return this.nullScores;
        }

        public float getNullScore() {
            return this.nullScore;
        }

        public IntFloatDynamicMap getScores() {
            return this.scores;
        }
    }

    public static final class CollapseScore {
        public float score;

        public boolean setupIfNeeded(GroupHeadSelector groupHeadSelector, Map readerContext) {
            if (CollapseScore.wantsCScore(groupHeadSelector.selectorText)) {
                readerContext.put("CSCORE", this);
                return true;
            }
            return false;
        }

        public static boolean wantsCScore(String text) {
            return 0 <= text.indexOf("cscore()");
        }

        private CollapseScore() {
        }
    }

    private static class CollectorFactory {
        private static final EnumSet<NumberType> NUMERIC_COLLAPSIBLE_TYPES = EnumSet.of(NumberType.INTEGER, NumberType.FLOAT);

        private CollectorFactory() {
        }

        private boolean isNumericCollapsible(FieldType collapseFieldType) {
            return NUMERIC_COLLAPSIBLE_TYPES.contains((Object)collapseFieldType.getNumberType());
        }

        public DelegatingCollector getCollector(final String collapseField, GroupHeadSelector groupHeadSelector, SortSpec sortSpec, int nullPolicy, String hint, boolean needsScores4Collapsing, boolean needsScores, int size, IntIntHashMap boostDocs, final SolrIndexSearcher searcher) throws IOException {
            EmptyDocValuesProducer docValuesProducer = null;
            FunctionQuery funcQuery = null;
            FieldType collapseFieldType = searcher.getSchema().getField(collapseField).getType();
            if (collapseFieldType instanceof StrField) {
                if (CollapsingQParserPlugin.HINT_TOP_FC.equals(hint)) {
                    final LeafReader uninvertingReader = CollapsingQParserPlugin.getTopFieldCacheReader(searcher, collapseField);
                    docValuesProducer = new EmptyDocValuesProducer(){

                        public SortedDocValues getSorted(FieldInfo ignored) throws IOException {
                            return uninvertingReader.getSortedDocValues(collapseField);
                        }
                    };
                } else {
                    docValuesProducer = new EmptyDocValuesProducer(){

                        public SortedDocValues getSorted(FieldInfo ignored) throws IOException {
                            return DocValues.getSorted((LeafReader)searcher.getSlowAtomicReader(), (String)collapseField);
                        }
                    };
                }
            } else if (CollapsingQParserPlugin.HINT_TOP_FC.equals(hint)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "top_fc hint is only supported when collapsing on String Fields");
            }
            FieldType minMaxFieldType = null;
            if (GroupHeadSelectorType.MIN_MAX.contains((Object)groupHeadSelector.type)) {
                String text = groupHeadSelector.selectorText;
                if (text.indexOf("(") == -1) {
                    minMaxFieldType = searcher.getSchema().getField(text).getType();
                } else {
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    try (LocalSolrQueryRequest request = new LocalSolrQueryRequest(searcher.getCore(), (SolrParams)params);){
                        FunctionQParser functionQParser = new FunctionQParser(text, null, null, request);
                        funcQuery = (FunctionQuery)functionQParser.parse();
                    }
                    catch (SyntaxError e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                }
            }
            int maxDoc = searcher.maxDoc();
            int leafCount = searcher.getTopReaderContext().leaves().size();
            if (GroupHeadSelectorType.SCORE.equals((Object)groupHeadSelector.type)) {
                if (collapseFieldType instanceof StrField) {
                    return new OrdScoreCollector(maxDoc, leafCount, (DocValuesProducer)docValuesProducer, nullPolicy, boostDocs, searcher);
                }
                if (this.isNumericCollapsible(collapseFieldType)) {
                    return new IntScoreCollector(maxDoc, leafCount, nullPolicy, size, collapseField, boostDocs, searcher);
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collapsing field should be of either String, Int or Float type");
            }
            if (collapseFieldType instanceof StrField) {
                return new OrdFieldValueCollector(maxDoc, leafCount, (DocValuesProducer)docValuesProducer, nullPolicy, groupHeadSelector, sortSpec, needsScores4Collapsing, needsScores, minMaxFieldType, boostDocs, funcQuery, searcher);
            }
            if (this.isNumericCollapsible(collapseFieldType)) {
                return new IntFieldValueCollector(maxDoc, size, leafCount, nullPolicy, collapseField, groupHeadSelector, sortSpec, needsScores4Collapsing, needsScores, minMaxFieldType, boostDocs, funcQuery, searcher);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collapsing field should be of either String, Int or Float type");
        }
    }

    private static class IntFieldValueCollector
    extends DelegatingCollector {
        private LeafReaderContext[] contexts;
        private NumericDocValues collapseValues;
        private int maxDoc;
        private int nullPolicy;
        private IntFieldValueStrategy collapseStrategy;
        private boolean needsScores4Collapsing;
        private boolean needsScores;
        private String collapseField;
        private final BoostedDocsCollector boostedDocsCollector;

        public IntFieldValueCollector(int maxDoc, int size, int segments, int nullPolicy, String collapseField, GroupHeadSelector groupHeadSelector, SortSpec sortSpec, boolean needsScores4Collapsing, boolean needsScores, FieldType fieldType, IntIntHashMap boostDocsMap, FunctionQuery funcQuery, IndexSearcher searcher) throws IOException {
            assert (!GroupHeadSelectorType.SCORE.equals((Object)groupHeadSelector.type));
            this.maxDoc = maxDoc;
            this.contexts = new LeafReaderContext[segments];
            List con = searcher.getTopReaderContext().leaves();
            for (int i = 0; i < con.size(); ++i) {
                this.contexts[i] = (LeafReaderContext)con.get(i);
            }
            this.collapseField = collapseField;
            this.nullPolicy = nullPolicy;
            this.needsScores4Collapsing = needsScores4Collapsing;
            this.needsScores = needsScores;
            this.boostedDocsCollector = BoostedDocsCollector.build(boostDocsMap);
            if (null != sortSpec) {
                this.collapseStrategy = new IntSortSpecStrategy(maxDoc, size, collapseField, nullPolicy, groupHeadSelector, this.needsScores4Collapsing, this.needsScores, this.boostedDocsCollector, sortSpec, searcher);
            } else if (funcQuery != null) {
                this.collapseStrategy = new IntValueSourceStrategy(maxDoc, size, collapseField, nullPolicy, groupHeadSelector, this.needsScores4Collapsing, this.needsScores, this.boostedDocsCollector, funcQuery, searcher);
            } else {
                NumberType numType = fieldType.getNumberType();
                assert (null != numType);
                switch (numType) {
                    case INTEGER: {
                        this.collapseStrategy = new IntIntStrategy(maxDoc, size, collapseField, nullPolicy, groupHeadSelector, this.needsScores, this.boostedDocsCollector);
                        break;
                    }
                    case FLOAT: {
                        this.collapseStrategy = new IntFloatStrategy(maxDoc, size, collapseField, nullPolicy, groupHeadSelector, this.needsScores, this.boostedDocsCollector);
                        break;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "min/max must be Int or Float field types when collapsing on numeric fields");
                    }
                }
            }
        }

        @Override
        public ScoreMode scoreMode() {
            return this.needsScores ? ScoreMode.COMPLETE : super.scoreMode();
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.collapseStrategy.setScorer(scorer);
        }

        @Override
        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.contexts[context.ord] = context;
            this.docBase = context.docBase;
            this.collapseStrategy.setNextReader(context);
            this.collapseValues = DocValues.getNumeric((LeafReader)context.reader(), (String)this.collapseField);
        }

        @Override
        public void collect(int contextDoc) throws IOException {
            int globalDoc = contextDoc + this.docBase;
            if (this.collapseValues.advanceExact(contextDoc)) {
                int collapseKey = (int)this.collapseValues.longValue();
                if (this.boostedDocsCollector.collectIfBoosted(collapseKey, globalDoc)) {
                    return;
                }
                this.collapseStrategy.collapse(collapseKey, contextDoc, globalDoc);
            } else {
                if (this.boostedDocsCollector.collectInNullGroupIfBoosted(globalDoc)) {
                    return;
                }
                if (NullPolicy.IGNORE.getCode() != this.nullPolicy) {
                    this.collapseStrategy.collapseNullGroup(contextDoc, globalDoc);
                }
            }
        }

        @Override
        public void finish() throws IOException {
            if (this.contexts.length == 0) {
                return;
            }
            int currentContext = 0;
            int currentDocBase = 0;
            this.collapseValues = DocValues.getNumeric((LeafReader)this.contexts[currentContext].reader(), (String)this.collapseField);
            int nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
            this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
            ScoreAndDoc dummy = new ScoreAndDoc();
            this.leafDelegate.setScorer((Scorable)dummy);
            BitSetIterator it = new BitSetIterator((BitSet)this.collapseStrategy.getCollapsedSet(), 0L);
            int globalDoc = -1;
            int nullScoreIndex = 0;
            IntIntHashMap cmap = this.collapseStrategy.getCollapseMap();
            IntFloatDynamicMap scores = this.collapseStrategy.getScores();
            FloatArrayList nullScores = this.collapseStrategy.getNullScores();
            float nullScore = this.collapseStrategy.getNullScore();
            MergeBoost mergeBoost = this.boostedDocsCollector.getMergeBoost();
            while ((globalDoc = it.nextDoc()) != Integer.MAX_VALUE) {
                while (globalDoc >= nextDocBase) {
                    currentDocBase = this.contexts[++currentContext].docBase;
                    nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
                    this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
                    this.leafDelegate.setScorer((Scorable)dummy);
                    this.collapseValues = DocValues.getNumeric((LeafReader)this.contexts[currentContext].reader(), (String)this.collapseField);
                }
                int contextDoc = globalDoc - currentDocBase;
                if (this.needsScores) {
                    if (this.collapseValues.advanceExact(contextDoc)) {
                        int collapseValue = (int)this.collapseValues.longValue();
                        int pointer = cmap.get(collapseValue);
                        dummy.score = scores.get(pointer);
                    } else if (mergeBoost.boost(globalDoc)) {
                        dummy.score = 0.0f;
                    } else if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                        dummy.score = nullScore;
                    } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                        dummy.score = nullScores.get(nullScoreIndex++);
                    }
                }
                dummy.docId = contextDoc;
                this.leafDelegate.collect(contextDoc);
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }
    }

    private static class OrdFieldValueCollector
    extends DelegatingCollector {
        private LeafReaderContext[] contexts;
        private DocValuesProducer collapseValuesProducer;
        private SortedDocValues collapseValues;
        protected OrdinalMap ordinalMap;
        protected SortedDocValues segmentValues;
        protected LongValues segmentOrdinalMap;
        protected MultiDocValues.MultiSortedDocValues multiSortedDocValues;
        private int maxDoc;
        private int nullPolicy;
        private OrdFieldValueStrategy collapseStrategy;
        private boolean needsScores4Collapsing;
        private boolean needsScores;
        private final BoostedDocsCollector boostedDocsCollector;

        public OrdFieldValueCollector(int maxDoc, int segments, DocValuesProducer collapseValuesProducer, int nullPolicy, GroupHeadSelector groupHeadSelector, SortSpec sortSpec, boolean needsScores4Collapsing, boolean needsScores, FieldType fieldType, IntIntHashMap boostDocsMap, FunctionQuery funcQuery, IndexSearcher searcher) throws IOException {
            assert (!GroupHeadSelectorType.SCORE.equals((Object)groupHeadSelector.type));
            this.maxDoc = maxDoc;
            this.contexts = new LeafReaderContext[segments];
            List con = searcher.getTopReaderContext().leaves();
            for (int i = 0; i < con.size(); ++i) {
                this.contexts[i] = (LeafReaderContext)con.get(i);
            }
            this.collapseValuesProducer = collapseValuesProducer;
            this.collapseValues = collapseValuesProducer.getSorted(null);
            if (this.collapseValues instanceof MultiDocValues.MultiSortedDocValues) {
                this.multiSortedDocValues = (MultiDocValues.MultiSortedDocValues)this.collapseValues;
                this.ordinalMap = this.multiSortedDocValues.mapping;
            }
            this.boostedDocsCollector = BoostedDocsCollector.build(boostDocsMap);
            int valueCount = this.collapseValues.getValueCount();
            this.nullPolicy = nullPolicy;
            this.needsScores4Collapsing = needsScores4Collapsing;
            this.needsScores = needsScores;
            if (null != sortSpec) {
                this.collapseStrategy = new OrdSortSpecStrategy(maxDoc, nullPolicy, valueCount, groupHeadSelector, this.needsScores4Collapsing, this.needsScores, this.boostedDocsCollector, sortSpec, searcher, this.collapseValues);
            } else if (funcQuery != null) {
                this.collapseStrategy = new OrdValueSourceStrategy(maxDoc, nullPolicy, valueCount, groupHeadSelector, this.needsScores4Collapsing, this.needsScores, this.boostedDocsCollector, funcQuery, searcher, this.collapseValues);
            } else {
                NumberType numType = fieldType.getNumberType();
                if (null == numType) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "min/max must be either Int/Long/Float based field types");
                }
                switch (numType) {
                    case INTEGER: {
                        this.collapseStrategy = new OrdIntStrategy(maxDoc, nullPolicy, valueCount, groupHeadSelector, this.needsScores, this.boostedDocsCollector, this.collapseValues);
                        break;
                    }
                    case FLOAT: {
                        this.collapseStrategy = new OrdFloatStrategy(maxDoc, nullPolicy, valueCount, groupHeadSelector, this.needsScores, this.boostedDocsCollector, this.collapseValues);
                        break;
                    }
                    case LONG: {
                        this.collapseStrategy = new OrdLongStrategy(maxDoc, nullPolicy, valueCount, groupHeadSelector, this.needsScores, this.boostedDocsCollector, this.collapseValues);
                        break;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "min/max must be either Int/Long/Float field types");
                    }
                }
            }
        }

        @Override
        public ScoreMode scoreMode() {
            return this.needsScores ? ScoreMode.COMPLETE : super.scoreMode();
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.collapseStrategy.setScorer(scorer);
        }

        @Override
        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.contexts[context.ord] = context;
            this.docBase = context.docBase;
            this.collapseStrategy.setNextReader(context);
            if (this.ordinalMap != null) {
                this.segmentValues = this.multiSortedDocValues.values[context.ord];
                this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(context.ord);
            } else {
                this.segmentValues = this.collapseValues;
            }
        }

        @Override
        public void collect(int contextDoc) throws IOException {
            int globalDoc = contextDoc + this.docBase;
            int ord = -1;
            if (this.ordinalMap != null) {
                if (this.segmentValues.advanceExact(contextDoc)) {
                    ord = (int)this.segmentOrdinalMap.get((long)this.segmentValues.ordValue());
                }
            } else if (this.segmentValues.advanceExact(globalDoc)) {
                ord = this.segmentValues.ordValue();
            }
            if (-1 == ord ? this.boostedDocsCollector.collectInNullGroupIfBoosted(globalDoc) : this.boostedDocsCollector.collectIfBoosted(ord, globalDoc)) {
                return;
            }
            this.collapseStrategy.collapse(ord, contextDoc, globalDoc);
        }

        @Override
        public void finish() throws IOException {
            if (this.contexts.length == 0) {
                return;
            }
            int currentContext = 0;
            int currentDocBase = 0;
            this.collapseValues = this.collapseValuesProducer.getSorted(null);
            if (this.collapseValues instanceof MultiDocValues.MultiSortedDocValues) {
                this.multiSortedDocValues = (MultiDocValues.MultiSortedDocValues)this.collapseValues;
                this.ordinalMap = this.multiSortedDocValues.mapping;
            }
            if (this.ordinalMap != null) {
                this.segmentValues = this.multiSortedDocValues.values[currentContext];
                this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(currentContext);
            } else {
                this.segmentValues = this.collapseValues;
            }
            int nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
            this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
            ScoreAndDoc dummy = new ScoreAndDoc();
            this.leafDelegate.setScorer((Scorable)dummy);
            BitSetIterator it = new BitSetIterator((BitSet)this.collapseStrategy.getCollapsedSet(), 0L);
            int globalDoc = -1;
            int nullScoreIndex = 0;
            IntFloatDynamicMap scores = this.collapseStrategy.getScores();
            FloatArrayList nullScores = this.collapseStrategy.getNullScores();
            float nullScore = this.collapseStrategy.getNullScore();
            MergeBoost mergeBoost = this.boostedDocsCollector.getMergeBoost();
            while ((globalDoc = it.nextDoc()) != Integer.MAX_VALUE) {
                while (globalDoc >= nextDocBase) {
                    currentDocBase = this.contexts[++currentContext].docBase;
                    nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
                    this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
                    this.leafDelegate.setScorer((Scorable)dummy);
                    if (this.ordinalMap == null) continue;
                    this.segmentValues = this.multiSortedDocValues.values[currentContext];
                    this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(currentContext);
                }
                int contextDoc = globalDoc - currentDocBase;
                if (this.needsScores) {
                    int ord = -1;
                    if (this.ordinalMap != null) {
                        if (this.segmentValues.advanceExact(contextDoc)) {
                            ord = (int)this.segmentOrdinalMap.get((long)this.segmentValues.ordValue());
                        }
                    } else if (this.segmentValues.advanceExact(globalDoc)) {
                        ord = this.segmentValues.ordValue();
                    }
                    if (ord > -1) {
                        dummy.score = scores.get(ord);
                    } else if (mergeBoost.boost(globalDoc)) {
                        dummy.score = 0.0f;
                    } else if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                        dummy.score = nullScore;
                    } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                        dummy.score = nullScores.get(nullScoreIndex++);
                    }
                }
                dummy.docId = contextDoc;
                this.leafDelegate.collect(contextDoc);
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }
    }

    private static class IntScoreCollector
    extends DelegatingCollector {
        private LeafReaderContext[] contexts;
        private FixedBitSet collapsedSet;
        private NumericDocValues collapseValues;
        private IntLongHashMap cmap;
        private int maxDoc;
        private int nullPolicy;
        private float nullScore = -3.4028235E38f;
        private int nullDoc = -1;
        private FloatArrayList nullScores;
        private String field;
        private final BoostedDocsCollector boostedDocsCollector;

        public IntScoreCollector(int maxDoc, int segments, int nullPolicy, int size, String field, IntIntHashMap boostDocsMap, IndexSearcher searcher) {
            this.maxDoc = maxDoc;
            this.contexts = new LeafReaderContext[segments];
            List con = searcher.getTopReaderContext().leaves();
            for (int i = 0; i < con.size(); ++i) {
                this.contexts[i] = (LeafReaderContext)con.get(i);
            }
            this.collapsedSet = new FixedBitSet(maxDoc);
            this.nullPolicy = nullPolicy;
            if (nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.nullScores = new FloatArrayList();
            }
            this.cmap = new IntLongHashMap(size);
            this.field = field;
            this.boostedDocsCollector = BoostedDocsCollector.build(boostDocsMap);
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.contexts[context.ord] = context;
            this.docBase = context.docBase;
            this.collapseValues = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void collect(int contextDoc) throws IOException {
            int globalDoc = this.docBase + contextDoc;
            if (this.collapseValues.advanceExact(contextDoc)) {
                int collapseValue = (int)this.collapseValues.longValue();
                if (this.boostedDocsCollector.collectIfBoosted(collapseValue, globalDoc)) {
                    return;
                }
                float score = this.scorer.score();
                int idx = this.cmap.indexOf(collapseValue);
                if (idx >= 0) {
                    long scoreDoc = this.cmap.indexGet(idx);
                    int testScore = (int)(scoreDoc >> 32);
                    int currentScore = Float.floatToRawIntBits(score);
                    if (currentScore > testScore) {
                        this.cmap.indexReplace(idx, ((long)currentScore << 32) + (long)globalDoc);
                    }
                } else {
                    long scoreDoc = ((long)Float.floatToRawIntBits(score) << 32) + (long)globalDoc;
                    this.cmap.indexInsert(idx, collapseValue, scoreDoc);
                }
            } else {
                if (this.boostedDocsCollector.collectInNullGroupIfBoosted(globalDoc)) {
                    return;
                }
                if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                    float score = this.scorer.score();
                    if (score > this.nullScore) {
                        this.nullScore = score;
                        this.nullDoc = globalDoc;
                    }
                } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                    this.collapsedSet.set(globalDoc);
                    this.nullScores.add(this.scorer.score());
                }
            }
        }

        @Override
        public void finish() throws IOException {
            if (this.contexts.length == 0) {
                return;
            }
            this.boostedDocsCollector.purgeGroupsThatHaveBoostedDocs(this.collapsedSet, key -> this.cmap.remove(key), () -> {
                this.nullDoc = -1;
            });
            if (this.nullDoc > -1) {
                this.collapsedSet.set(this.nullDoc);
            }
            for (IntLongCursor cursor : this.cmap) {
                int doc = (int)cursor.value;
                this.collapsedSet.set(doc);
            }
            int currentContext = 0;
            int currentDocBase = 0;
            this.collapseValues = DocValues.getNumeric((LeafReader)this.contexts[currentContext].reader(), (String)this.field);
            int nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
            this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
            ScoreAndDoc dummy = new ScoreAndDoc();
            this.leafDelegate.setScorer((Scorable)dummy);
            BitSetIterator it = new BitSetIterator((BitSet)this.collapsedSet, 0L);
            MergeBoost mergeBoost = this.boostedDocsCollector.getMergeBoost();
            int globalDoc = -1;
            int nullScoreIndex = 0;
            while ((globalDoc = it.nextDoc()) != Integer.MAX_VALUE) {
                while (globalDoc >= nextDocBase) {
                    currentDocBase = this.contexts[++currentContext].docBase;
                    nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
                    this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
                    this.leafDelegate.setScorer((Scorable)dummy);
                    this.collapseValues = DocValues.getNumeric((LeafReader)this.contexts[currentContext].reader(), (String)this.field);
                }
                int contextDoc = globalDoc - currentDocBase;
                if (this.collapseValues.advanceExact(contextDoc)) {
                    int collapseValue = (int)this.collapseValues.longValue();
                    long scoreDoc = this.cmap.get(collapseValue);
                    dummy.score = Float.intBitsToFloat((int)(scoreDoc >> 32));
                } else if (mergeBoost.boost(globalDoc)) {
                    dummy.score = 0.0f;
                } else if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                    dummy.score = this.nullScore;
                } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                    dummy.score = this.nullScores.get(nullScoreIndex++);
                }
                dummy.docId = contextDoc;
                this.leafDelegate.collect(contextDoc);
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }
    }

    private static class OrdScoreCollector
    extends DelegatingCollector {
        private LeafReaderContext[] contexts;
        private final DocValuesProducer collapseValuesProducer;
        private FixedBitSet collapsedSet;
        private SortedDocValues collapseValues;
        private OrdinalMap ordinalMap;
        private SortedDocValues segmentValues;
        private LongValues segmentOrdinalMap;
        private MultiDocValues.MultiSortedDocValues multiSortedDocValues;
        private IntIntDynamicMap ords;
        private IntFloatDynamicMap scores;
        private int maxDoc;
        private int nullPolicy;
        private float nullScore = -3.4028235E38f;
        private int nullDoc = -1;
        private FloatArrayList nullScores;
        private final BoostedDocsCollector boostedDocsCollector;

        public OrdScoreCollector(int maxDoc, int segments, DocValuesProducer collapseValuesProducer, int nullPolicy, IntIntHashMap boostDocsMap, IndexSearcher searcher) throws IOException {
            this.maxDoc = maxDoc;
            this.contexts = new LeafReaderContext[segments];
            List con = searcher.getTopReaderContext().leaves();
            for (int i = 0; i < con.size(); ++i) {
                this.contexts[i] = (LeafReaderContext)con.get(i);
            }
            this.collapsedSet = new FixedBitSet(maxDoc);
            this.collapseValuesProducer = collapseValuesProducer;
            this.collapseValues = collapseValuesProducer.getSorted(null);
            int valueCount = this.collapseValues.getValueCount();
            if (this.collapseValues instanceof MultiDocValues.MultiSortedDocValues) {
                this.multiSortedDocValues = (MultiDocValues.MultiSortedDocValues)this.collapseValues;
                this.ordinalMap = this.multiSortedDocValues.mapping;
            }
            this.ords = new IntIntDynamicMap(valueCount, -1);
            this.scores = new IntFloatDynamicMap(valueCount, -3.4028235E38f);
            this.nullPolicy = nullPolicy;
            if (nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.nullScores = new FloatArrayList();
            }
            this.boostedDocsCollector = BoostedDocsCollector.build(boostDocsMap);
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.contexts[context.ord] = context;
            this.docBase = context.docBase;
            if (this.ordinalMap != null) {
                this.segmentValues = this.multiSortedDocValues.values[context.ord];
                this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(context.ord);
            } else {
                this.segmentValues = this.collapseValues;
            }
        }

        @Override
        public void collect(int contextDoc) throws IOException {
            int globalDoc = contextDoc + this.docBase;
            int ord = -1;
            ord = this.ordinalMap != null ? (this.segmentValues.advanceExact(contextDoc) ? (int)this.segmentOrdinalMap.get((long)this.segmentValues.ordValue()) : -1) : (this.segmentValues.advanceExact(globalDoc) ? this.segmentValues.ordValue() : -1);
            if (0 <= ord ? this.boostedDocsCollector.collectIfBoosted(ord, globalDoc) : this.boostedDocsCollector.collectInNullGroupIfBoosted(globalDoc)) {
                return;
            }
            if (ord > -1) {
                float score = this.scorer.score();
                if (score > this.scores.get(ord)) {
                    this.ords.put(ord, globalDoc);
                    this.scores.put(ord, score);
                }
            } else if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                float score = this.scorer.score();
                if (score > this.nullScore) {
                    this.nullScore = score;
                    this.nullDoc = globalDoc;
                }
            } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                this.collapsedSet.set(globalDoc);
                this.nullScores.add(this.scorer.score());
            }
        }

        @Override
        public void finish() throws IOException {
            if (this.contexts.length == 0) {
                return;
            }
            this.boostedDocsCollector.purgeGroupsThatHaveBoostedDocs(this.collapsedSet, ord -> this.ords.remove(ord), () -> {
                this.nullDoc = -1;
            });
            if (this.nullDoc > -1) {
                this.collapsedSet.set(this.nullDoc);
            }
            this.ords.forEachValue(doc -> this.collapsedSet.set(doc));
            int currentContext = 0;
            int currentDocBase = 0;
            this.collapseValues = this.collapseValuesProducer.getSorted(null);
            if (this.collapseValues instanceof MultiDocValues.MultiSortedDocValues) {
                this.multiSortedDocValues = (MultiDocValues.MultiSortedDocValues)this.collapseValues;
                this.ordinalMap = this.multiSortedDocValues.mapping;
            }
            if (this.ordinalMap != null) {
                this.segmentValues = this.multiSortedDocValues.values[currentContext];
                this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(currentContext);
            } else {
                this.segmentValues = this.collapseValues;
            }
            int nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
            this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
            ScoreAndDoc dummy = new ScoreAndDoc();
            this.leafDelegate.setScorer((Scorable)dummy);
            BitSetIterator it = new BitSetIterator((BitSet)this.collapsedSet, 0L);
            MergeBoost mergeBoost = this.boostedDocsCollector.getMergeBoost();
            int docId = -1;
            int index = -1;
            while ((docId = it.nextDoc()) != Integer.MAX_VALUE) {
                while (docId >= nextDocBase) {
                    currentDocBase = this.contexts[++currentContext].docBase;
                    nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
                    this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
                    this.leafDelegate.setScorer((Scorable)dummy);
                    if (this.ordinalMap == null) continue;
                    this.segmentValues = this.multiSortedDocValues.values[currentContext];
                    this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(currentContext);
                }
                int contextDoc = docId - currentDocBase;
                int ord2 = -1;
                if (this.ordinalMap != null) {
                    if (this.segmentValues.advanceExact(contextDoc)) {
                        ord2 = (int)this.segmentOrdinalMap.get((long)this.segmentValues.ordValue());
                    }
                } else if (this.segmentValues.advanceExact(docId)) {
                    ord2 = this.segmentValues.ordValue();
                }
                if (ord2 > -1) {
                    dummy.score = this.scores.get(ord2);
                } else if (!mergeBoost.boost(docId)) {
                    if (this.nullPolicy == NullPolicy.COLLAPSE.getCode()) {
                        dummy.score = this.nullScore;
                    } else if (this.nullPolicy == NullPolicy.EXPAND.getCode()) {
                        dummy.score = this.nullScores.get(++index);
                    }
                }
                dummy.docId = contextDoc;
                this.leafDelegate.collect(contextDoc);
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }
    }

    private static class ScoreAndDoc
    extends Scorable {
        public float score;
        public int docId;

        private ScoreAndDoc() {
        }

        public float score() {
            return this.score;
        }

        public int docID() {
            return this.docId;
        }
    }

    public static class CollapsingPostFilter
    extends ExtendedQueryBase
    implements PostFilter {
        private String collapseField;
        private final GroupHeadSelector groupHeadSelector;
        private final SortSpec sortSpec;
        public String hint;
        private boolean needsScores = true;
        private boolean needsScores4Collapsing = false;
        private NullPolicy nullPolicy;
        private Set<BytesRef> boosted;
        private int size;

        public String getField() {
            return this.collapseField;
        }

        @Override
        public void setCache(boolean cache) {
        }

        @Override
        public void setCacheSep(boolean cacheSep) {
        }

        @Override
        public boolean getCacheSep() {
            return false;
        }

        @Override
        public boolean getCache() {
            return false;
        }

        public int hashCode() {
            int hashCode = this.classHash();
            hashCode = 31 * hashCode + this.collapseField.hashCode();
            hashCode = 31 * hashCode + this.groupHeadSelector.hashCode();
            hashCode = 31 * hashCode + this.nullPolicy.hashCode();
            return hashCode;
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((CollapsingPostFilter)this.getClass().cast(other));
        }

        private boolean equalsTo(CollapsingPostFilter other) {
            return this.collapseField.equals(other.collapseField) && this.groupHeadSelector.equals(other.groupHeadSelector) && this.nullPolicy == other.nullPolicy;
        }

        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf((Query)this);
        }

        @Override
        public int getCost() {
            return Math.max(super.getCost(), 100);
        }

        @Override
        public String toString(String s) {
            return "CollapsingPostFilter(field=" + this.collapseField + ", nullPolicy=" + this.nullPolicy.getName() + ", " + this.groupHeadSelector + (this.hint == null ? "" : ", hint=" + this.hint) + ", size=" + this.size + ")";
        }

        public CollapsingPostFilter(SolrParams localParams, SolrParams params, SolrQueryRequest request) {
            if (request.getParams().getBool("group", false)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not use collapse with Grouping enabled");
            }
            this.collapseField = localParams.get("field");
            if (this.collapseField == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required 'field' param is missing.");
            }
            SchemaField collapseFieldSf = request.getSchema().getField(this.collapseField);
            if (!collapseFieldSf.isUninvertible() && !collapseFieldSf.hasDocValues()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collapsing field '" + this.collapseField + "' should be either docValues enabled or indexed with uninvertible enabled");
            }
            if (collapseFieldSf.multiValued()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collapsing not supported on multivalued fields");
            }
            this.groupHeadSelector = GroupHeadSelector.build(localParams);
            if (this.groupHeadSelector.type.equals((Object)GroupHeadSelectorType.SORT) && CollapseScore.wantsCScore(this.groupHeadSelector.selectorText)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Using cscore() as a function in the 'sort' local param of the collapse parser is not supported");
            }
            this.sortSpec = GroupHeadSelectorType.SORT.equals((Object)this.groupHeadSelector.type) ? SortSpecParsing.parseSortSpec(this.groupHeadSelector.selectorText, request) : null;
            this.hint = localParams.get("hint");
            this.size = localParams.getInt("size", 100000);
            SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
            assert (null != info);
            ResponseBuilder rb = info.getResponseBuilder();
            SortSpec topSort = null == rb ? null : rb.getSortSpec();
            this.needsScores4Collapsing = GroupHeadSelectorType.SCORE.equals((Object)this.groupHeadSelector.type) || GroupHeadSelectorType.SORT.equals((Object)this.groupHeadSelector.type) && this.sortSpec.includesScore() || GroupHeadSelectorType.MIN_MAX.contains((Object)this.groupHeadSelector.type) && CollapseScore.wantsCScore(this.groupHeadSelector.selectorText);
            boolean bl = this.needsScores = this.needsScores4Collapsing || info.getRsp().getReturnFields().wantsScore() || null != topSort && topSort.includesScore() || this.boosted != null;
            if (this.needsScores && null != rb) {
                rb.setFieldFlags(rb.getFieldFlags() | 1);
            }
            this.nullPolicy = NullPolicy.fromString(localParams.get("nullPolicy"));
        }

        @Override
        public DelegatingCollector getFilterCollector(IndexSearcher indexSearcher) {
            try {
                SolrIndexSearcher searcher = (SolrIndexSearcher)indexSearcher;
                CollectorFactory collectorFactory = new CollectorFactory();
                IntIntHashMap boostDocsMap = null;
                Map<Object, Object> context = null;
                SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
                if (info != null) {
                    context = info.getReq().getContext();
                }
                if (this.boosted == null && context != null) {
                    this.boosted = (Set)context.get("BOOSTED");
                }
                boostDocsMap = QueryElevationComponent.getBoostDocs(searcher, this.boosted, context);
                return collectorFactory.getCollector(this.collapseField, this.groupHeadSelector, this.sortSpec, this.nullPolicy.getCode(), this.hint, this.needsScores4Collapsing, this.needsScores, this.size, boostDocsMap, searcher);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class GroupHeadSelector {
        public final String selectorText;
        public final GroupHeadSelectorType type;

        private GroupHeadSelector(String s, GroupHeadSelectorType type) {
            assert (null != s);
            assert (null != type);
            this.selectorText = s;
            this.type = type;
        }

        public boolean equals(Object other) {
            if (other instanceof GroupHeadSelector) {
                GroupHeadSelector that = (GroupHeadSelector)other;
                return this.type == that.type && this.selectorText.equals(that.selectorText);
            }
            return false;
        }

        public int hashCode() {
            return 17 * (31 + this.selectorText.hashCode()) * (31 + this.type.hashCode());
        }

        public String toString() {
            return "GroupHeadSelector(selectorText=" + this.selectorText + ", type=" + (Object)((Object)this.type) + ")";
        }

        public static GroupHeadSelector build(SolrParams localParams) {
            String sortString = (String)StringUtils.defaultIfBlank((CharSequence)localParams.get("sort"), null);
            String max = (String)StringUtils.defaultIfBlank((CharSequence)localParams.get("max"), null);
            String min = (String)StringUtils.defaultIfBlank((CharSequence)localParams.get("min"), null);
            if (1 < CollapsingQParserPlugin.numNotNull(new Object[]{min, max, sortString})) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At most one localparam for selecting documents (min, max, sort) may be specified: " + localParams.toString());
            }
            if (null != sortString) {
                return new GroupHeadSelector(sortString, GroupHeadSelectorType.SORT);
            }
            if (null != min) {
                return new GroupHeadSelector(min, GroupHeadSelectorType.MIN);
            }
            if (null != max) {
                return new GroupHeadSelector(max, GroupHeadSelectorType.MAX);
            }
            return new GroupHeadSelector("score", GroupHeadSelectorType.SCORE);
        }
    }

    public static enum GroupHeadSelectorType {
        MIN,
        MAX,
        SORT,
        SCORE;

        public static EnumSet<GroupHeadSelectorType> MIN_MAX;

        static {
            MIN_MAX = EnumSet.of(MIN, MAX);
        }
    }

    public static enum NullPolicy {
        IGNORE("ignore", 0),
        COLLAPSE("collapse", 1),
        EXPAND("expand", 2);

        private final String name;
        private final int code;
        static NullPolicy DEFAULT_POLICY;

        private NullPolicy(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }

        public static NullPolicy fromString(String nullPolicy) {
            if (StringUtils.isEmpty((CharSequence)nullPolicy)) {
                return DEFAULT_POLICY;
            }
            switch (nullPolicy) {
                case "ignore": {
                    return IGNORE;
                }
                case "collapse": {
                    return COLLAPSE;
                }
                case "expand": {
                    return EXPAND;
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid nullPolicy: " + nullPolicy);
        }

        static {
            DEFAULT_POLICY = IGNORE;
        }
    }
}

