/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.ProfilerTopComponent;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.FieldAccessor;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.ImageBuilder;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.ImageExportAction;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.InstanceBuilder;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;
import org.openide.util.HelpCtx;

public class ImageDetailProvider
extends DetailsProvider.Basic {
    private static final int CHECKER_SIZE = 8;
    private static final int PREVIEW_BORDER = 4;
    private static final Color CHECKER_BG = Color.LIGHT_GRAY;
    private static final Color CHECKER_FG = Color.DARK_GRAY;

    private static void drawChecker(Graphics g, int x, int y, int width, int height) {
        g.setColor(CHECKER_BG);
        g.fillRect(x, y, width, height);
        g.setColor(CHECKER_FG);
        for (int i = 0; i < width; i += 8) {
            for (int j = 0; j < height; j += 8) {
                if ((i / 8 + j / 8) % 2 != 0) continue;
                g.fillRect(x + i, y + j, Math.min(8, width - i), Math.min(8, height - j));
            }
        }
    }

    public ImageDetailProvider() {
        super(ImageBuilder.BUILDERS.getMasks(Image.class, String.class));
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        try {
            InstanceBuilder<String> builder = ImageBuilder.BUILDERS.getBuilder(instance, String.class);
            if (builder != null) {
                return builder.convert(new FieldAccessor(ImageBuilder.BUILDERS), instance);
            }
            ImageBuilder.LOGGER.log(Level.FINE, "Unable to get String builder for {0}", className);
        }
        catch (FieldAccessor.InvalidFieldException ex) {
            ImageBuilder.LOGGER.log(Level.FINE, "Unable to get text for instance, error: {0}", ex.getMessage());
        }
        return null;
    }

    @Override
    public DetailsProvider.View getDetailsView(String className, Instance instance) {
        return new ImageView(instance);
    }

    private static class ImageTopComponent
    extends ProfilerTopComponent {
        private static final String HELP_CTX_KEY = "HeapWalker.ImagePreview.HelpCtx";
        private static final HelpCtx HELP_CTX = new HelpCtx("HeapWalker.ImagePreview.HelpCtx");

        ImageTopComponent(Image image, String className, int instanceNumber) {
            this.setName(BrowserUtils.getSimpleType(className) + "#" + instanceNumber);
            this.setToolTipText("Preview of " + className + "#" + instanceNumber);
            this.setLayout(new BorderLayout());
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            BufferedImage displayedImage = new BufferedImage(width, height, 1);
            Graphics2D g = displayedImage.createGraphics();
            ImageDetailProvider.drawChecker(g, 0, 0, width, height);
            g.drawImage(image, 0, 0, null);
            JScrollPane c = new JScrollPane(new JLabel(new ImageIcon(displayedImage)));
            this.add(c, "Center");
            JToolBar toolBar = new JToolBar();
            toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            toolBar.setFloatable(false);
            toolBar.setName(Bundle.ImageDetailProvider_Toolbar());
            toolBar.add(new ImageExportAction(image));
            this.add(toolBar, "North");
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }
    }

    private static class ImageView
    extends DetailsProvider.View
    implements Scrollable {
        private final String instanceName;
        private final int instanceNumber;
        private Image instanceImage = null;
        private JLabel paintLabel;

        public ImageView(Instance instance) {
            super(instance);
            this.instanceName = instance.getJavaClass().getName();
            this.instanceNumber = instance.getInstanceNumber();
            this.addMouseListener(new MouseHandler());
        }

        @Override
        protected void computeView(Instance instance) {
            FieldAccessor fa = new FieldAccessor(ImageBuilder.BUILDERS);
            Image image = null;
            JLabel label = null;
            try {
                image = ImageBuilder.buildImageInternal(instance);
            }
            catch (FieldAccessor.InvalidFieldException ex) {
                ImageBuilder.LOGGER.log(Level.FINE, "Unable to get image for instance, error: {0}", ex.getMessage());
                label = new JLabel(Bundle.ImageDetailProvider_NotSupported(), 0);
                label.setEnabled(false);
            }
            final JLabel component = label;
            final Image im = image;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.removeAll();
                    if (component != null) {
                        this.add((Component)component, "Center");
                    }
                    this.revalidate();
                    this.doLayout();
                    this.repaint();
                    instanceImage = im;
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.instanceImage == null) {
                return;
            }
            int lineHeight = g.getFontMetrics().getHeight();
            int lineAscent = g.getFontMetrics().getAscent();
            int viewWidth = this.getWidth() - 8;
            int viewHeight = this.getHeight() - 12 - 2 * lineHeight;
            if (viewWidth < 1 || viewHeight < 1) {
                return;
            }
            int imgWidth = this.instanceImage.getWidth(null);
            int imgHeight = this.instanceImage.getHeight(null);
            if (imgWidth < 1 || imgHeight < 1) {
                return;
            }
            int width = imgWidth;
            int height = imgHeight;
            int scale = 1;
            int scaleX = (int)Math.ceil((float)imgWidth / (float)viewWidth);
            int scaleY = (int)Math.ceil((float)imgHeight / (float)viewHeight);
            if (scaleX > 1 || scaleY > 1) {
                scale = Math.max(scaleX, scaleY);
                width = (int)((float)imgWidth / (float)scale);
                height = (int)((float)imgHeight / (float)scale);
            }
            int x = 4 + (viewWidth - width) / 2;
            int y = 4 + (viewHeight - height) / 2;
            ImageDetailProvider.drawChecker(g, x, y, width, height);
            g.drawImage(this.instanceImage, x, y, x + width, y + height, 0, 0, imgWidth, imgHeight, null);
            g.setColor(this.getForeground());
            int nextY = this.getHeight() - this.drawText(g, 4, this.getHeight(), Bundle.ImageDetailProvider_Dimension(imgWidth, imgHeight));
            if (scale != 1) {
                this.drawText(g, 4, nextY, Bundle.ImageDetailProvider_Zoom(scale));
            }
        }

        private int drawText(Graphics g, int x, int y, String text) {
            if (this.paintLabel == null) {
                this.paintLabel = new JLabel();
            }
            this.paintLabel.setFont(g.getFont());
            this.paintLabel.setText(text);
            this.paintLabel.setSize(this.paintLabel.getPreferredSize());
            g.translate(x, y - this.paintLabel.getHeight());
            this.paintLabel.paint(g);
            g.translate(-x, this.paintLabel.getHeight() - y);
            return this.paintLabel.getHeight();
        }

        private void showPopup(MouseEvent e) {
            if (this.instanceImage == null) {
                return;
            }
            JMenuItem showItem = new JMenuItem(Bundle.ImageDetailProvider_Action_Show()){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    this.openNewWindow();
                }
            };
            showItem.setFont(showItem.getFont().deriveFont(1));
            JPopupMenu popup = new JPopupMenu();
            popup.add(showItem);
            popup.add(new ImageExportAction(this.instanceImage));
            popup.show(e.getComponent(), e.getX(), e.getY());
        }

        private void openNewWindow() {
            if (this.instanceImage == null) {
                return;
            }
            ImageTopComponent itc = new ImageTopComponent(this.instanceImage, this.instanceName, this.instanceNumber);
            itc.open();
            itc.requestActive();
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 50;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        private class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ImageView.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ImageView.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    ImageView.this.openNewWindow();
                }
            }
        }
    }
}

