/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import mediathek.config.MVConfig;
import mediathek.gui.dialog.DialogProgrammOrdnerOeffnen;
import mediathek.gui.messages.ProgramLocationChangedEvent;
import mediathek.tool.MessageBus;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UrlHyperlinkAction
extends AbstractAction {
    private final JFrame jFrameParent;
    private static final Logger logger = LogManager.getLogger(UrlHyperlinkAction.class);

    public UrlHyperlinkAction(JFrame jjFrameParent, String url) {
        this.jFrameParent = jjFrameParent;
        super.putValue("Name", url);
        super.putValue("ShortDescription", url);
    }

    private static void configureAndStartCustomWebBrowser(JFrame paFrame, String url) {
        try {
            String programm = "";
            if (MVConfig.get(MVConfig.Configs.SYSTEM_URL_OEFFNEN).isEmpty()) {
                String text = "\n Der Browser zum Anzeigen der URL wird nicht gefunden.\n Browser selbst ausw\u00e4hlen.";
                DialogProgrammOrdnerOeffnen dialog = new DialogProgrammOrdnerOeffnen(paFrame, true, "", "Browser suchen", text);
                dialog.setVisible(true);
                if (dialog.ok) {
                    programm = dialog.ziel;
                }
            } else {
                programm = MVConfig.get(MVConfig.Configs.SYSTEM_URL_OEFFNEN);
            }
            UrlHyperlinkAction.launchApplication(programm, url);
            MVConfig.add(MVConfig.Configs.SYSTEM_URL_OEFFNEN, programm);
            MessageBus.getMessageBus().publishAsync(new ProgramLocationChangedEvent());
        }
        catch (Exception ex) {
            MVConfig.add(MVConfig.Configs.SYSTEM_URL_OEFFNEN, "");
            logger.error("Failed to launch URL {} with custom browser", (Object)url);
        }
    }

    private static void launchApplication(String app, String url) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(app, url);
        Map<String, String> env = builder.environment();
        env.remove("GDK_SCALE");
        builder.start();
    }

    private static void launchMacDefaultBrowser(String url) throws IOException {
        ProcessBuilder builder = new ProcessBuilder("/usr/bin/osascript", "-e");
        String command = "open location \"" + url + "\"";
        builder.command().add(command);
        builder.start();
    }

    public static void openURL(JFrame paFrame, String url) throws URISyntaxException {
        boolean launchFailed = false;
        if (SystemUtils.IS_OS_MAC_OSX) {
            try {
                logger.trace("trying to launch macOS default web browser");
                UrlHyperlinkAction.launchMacDefaultBrowser(url);
            }
            catch (IOException e) {
                logger.error("Failed to launch default macOS web browser, using custom...");
                launchFailed = true;
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            try {
                logger.trace("trying to use xdg-open to start web browser");
                UrlHyperlinkAction.launchApplication("xdg-open", url);
            }
            catch (IOException e) {
                logger.error("Failed to launch web browser with xdg-open");
                launchFailed = true;
            }
        } else if (Desktop.isDesktopSupported()) {
            logger.trace("trying to launch java desktop default web browser");
            try {
                Desktop d = Desktop.getDesktop();
                if (d.isSupported(Desktop.Action.BROWSE)) {
                    d.browse(new URI(url));
                }
            }
            catch (IOException e) {
                logger.error("Failed to launch java desktop supported web browser, using custom...");
                launchFailed = true;
            }
        } else {
            logger.trace("trying to launch custom web browser");
            UrlHyperlinkAction.configureAndStartCustomWebBrowser(paFrame, url);
        }
        if (launchFailed) {
            UrlHyperlinkAction.configureAndStartCustomWebBrowser(paFrame, url);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            UrlHyperlinkAction.openURL(this.jFrameParent, e.getActionCommand());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }
}

