#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for junos_logging_global
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "network",
}

DOCUMENTATION = """
---
module: junos_logging_global
version_added: 2.4.0
short_description: Manage logging configuration on Junos devices.
description: This module manages logging configuration on devices running Junos.
author: Rohit Thakur (@rohitthakur2590)
requirements:
  - ncclient (>=v0.6.4)
  - xmltodict (>=0.12.0)
notes:
  - This module requires the netconf system service be enabled on the device being managed.
  - This module works with connection C(netconf).
  - See L(the Junos OS Platform Options,https://docs.ansible.com/ansible/latest/network/user_guide/platform_junos.html).
  - Tested against JunOS v18.4R1
options:
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the Junos device
      by executing the command B(show system syslog).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  config:
    description: A dictionary of logging configuration.
    type: dict
    suboptions:
      allow_duplicates: &allow_duplicates
        description: Do not suppress the repeated message for all targets.
        type: bool
      archive:
        description: Specify archive file information.
        type: dict
        suboptions:
          set:
            description: Set archive file information.
            type: bool
          binary_data:
            description: Mark file as if it contains binary data.
            type: bool
          files:
            description: Specify number of files to be archived (1..1000).
            type: int
          no_binary_data:
            description: Don't mark file as if it contains binary data.
            type: bool
          no_world_readable:
            description: Don't allow any user to read the log file.
            type: bool
          file_size:
            description: Size of files to be archived (65536..1073741824 bytes).
            type: int
          world_readable:
            description: Allow any user to read the log file.
            type: bool
      console:
        description: Set console logging parameters.
        type: dict
        suboptions:
          any: &any
            description: Set All facilities.
            type: dict
            suboptions:
              level: &level
                description: Set severity logging level.
                type: str
                required: true
                choices: ["alert", "any", "critical", "emergency", "error", "info", "none", "notice", "warning"]
          authorization: &authorization
            description: Specify authorization system.
            type: dict
            suboptions:
              level: *level
          change_log: &change_log
            description: Specify configuration change log.
            type: dict
            suboptions:
              level: *level
          conflict_log: &conflict_log
            description: Specify configuration conflict log.
            type: dict
            suboptions:
              level: *level
          daemon: &daemon
            description: Specify various system processes.
            type: dict
            suboptions:
              level: *level
          dfc: &dfc
            description: Specify dynamic flow capture.
            type: dict
            suboptions:
              level: *level
          external: &external
            description: Specify Local external applications.
            type: dict
            suboptions:
              level: *level
          firewall: &firewall
            description: Specify Firewall filtering system.
            type: dict
            suboptions:
              level: *level
          ftp: &ftp
            description: Specify FTP process.
            type: dict
            suboptions:
              level: *level
          interactive_commands: &interactive_commands
            description: Specify commands executed by the UI.
            type: dict
            suboptions:
              level: *level
          kernel: &kernel
            description: Specify Kernel specific logging.
            type: dict
            suboptions:
              level: *level
          ntp: &ntp
            description: Specify NTP process specific logging.
            type: dict
            suboptions:
              level: *level
          pfe: &pfe
            description: Specify Packet Forwarding Engine specific logging.
            type: dict
            suboptions:
              level: *level
          security: &security
            description: Specify Security related logging.
            type: dict
            suboptions:
              level: *level
          user: &user
            description: Specify user specific logging.
            type: dict
            suboptions:
              level: *level
      files:
        description: Specify files logging.
        type: list
        elements: dict
        suboptions:
          name:
            description: Specify filename in which to log data.
            type: str
          allow_duplicates: *allow_duplicates
          any: *any
          archive:
            description: Specify archive file information.
            type: dict
            suboptions:
              set:
                description: Set archive file information.
                type: bool
              archive_sites:
                description: Specify Primary and failover URLs to receive archive facilities.
                type: list
                elements: str
              binary_data:
                description: Mark file as if it contains binary data.
                type: bool
              files:
                description: Specify number of files to be archived (1..1000).
                type: int
              no_binary_data:
                description: Don't mark file as if it contains binary data.
                type: bool
              no_world_readable:
                description: Don't allow any user to read the log file.
                type: bool
              file_size:
                description: Size of files to be archived (65536..1073741824 bytes).
                type: int
              start_time:
                description: Specify start time for file transmission (yyyy-mm-dd.hh:mm).
                type: str
              transfer_interval:
                description: Specify frequency at which to transfer files to archive sites (5..2880 minutes).
                type: int
              world_readable:
                description: Allow any user to read the log file.
                type: bool
          authorization: *authorization
          change_log: *change_log
          conflict_log: *conflict_log
          daemon: *daemon
          dfc: *dfc
          explicit_priority: &explicit_priority
            description: Include priority and facility in messages.
            type: bool
          external: *external
          firewall: *firewall
          ftp: *ftp
          interactive_commands: *interactive_commands
          kernel: *kernel
          match: &match
            description: Specify regular expression for lines to be logged.
            type: str
          match_strings: &match_strings
            description: Specify matching string(s) for lines to be logged.
            type: list
            elements: str
          ntp: *ntp
          pfe: *pfe
          security: *security
          structured_data: &structured_data
            description: Specify Log system message in structured format.
            type: dict
            suboptions:
              set:
                description: Set Log system message in structured format.
                type: bool
              brief:
                description: Omit English-language text from end of logged messages.
                type: bool
          user: *user
      hosts: &hosts
        description: Specify hosts  to be notified.
        type: list
        elements: dict
        suboptions:
          name:
            description: Specify the host name.
            type: str
          allow_duplicates: *allow_duplicates
          any: *any
          authorization: *authorization
          change_log: *change_log
          conflict_log: *conflict_log
          daemon: *daemon
          dfc: *dfc
          exclude_hostname:
            description: Specify exclude hostname field in messages.
            type: bool
          explicit_priority: *explicit_priority
          external: *external
          facility_override:
            description: Specify alternate facility for logging to remote host.
            type: str
          firewall: *firewall
          ftp: *ftp
          interactive_commands: *interactive_commands
          kernel: *kernel
          log_prefix:
            description: Prefix for all logging to this host.
            type: str
          match: *match
          match_strings: *match_strings
          ntp: *ntp
          pfe: *pfe
          port:
            description: Specify port number.
            type: int
          routing_instance:
            description: Specify routing-instance.
            type: str
          security: *security
          source_address:
            description: Specify address as source address.
            type: str
          structured_data: *structured_data
          user: *user
      log_rotate_frequency:
        description: Specify Rotate log frequency (1..59 minutes).
        type: int
      routing_instance:
        description: Specify Routing routing-instance.
        type: str
      server:
        description: Specify syslog server logging.
        type: dict
        suboptions:
          set:
            description: Enable syslog server.
            type: bool
          routing_instance:
            description: nable/disable syslog server in routing-instances.
            type: dict
            suboptions:
              all:
                description: Enable/disable all routing instances.
                type: bool
              default:
                description: Enable/disable default routing instances.
                type: bool
              routing_instances:
                description: Specify routing-instances.
                type: list
                elements: dict
                suboptions:
                  name:
                    description: Specify routing-instance name.
                    type: str
                  disable:
                    description: Disable syslog server in this routing instances.
                    type: bool
      source_address:
        description: Specify address as source address.
        type: str
      time_format:
        description: Specify additional information to include in system log timestamp.
        type: dict
        suboptions:
          set:
            description: Set time-format
            type: bool
          millisecond:
            description: Include milliseconds in timestamp.
            type: bool
          year:
            description: Include year in timestamp.
            type: bool
      users:
        description: Specify user logging
        type: list
        elements: dict
        suboptions:
          name:
            description: Specify user name.
            type: str
          allow_duplicates: *allow_duplicates
          any: *any
          authorization: *authorization
          change_log: *change_log
          conflict_log: *conflict_log
          daemon: *daemon
          dfc: *dfc
          external: *external
          firewall: *firewall
          ftp: *ftp
          interactive_commands: *interactive_commands
          kernel: *kernel
          match:
            description: Specify regular expression for lines to be logged.
            type: str
          match_strings:
            description: Specify matching string(s) for lines to be logged.
            type: list
            elements: str
          ntp: *ntp
          pfe: *pfe
          security: *security
          user: *user
  state:
    description:
    - The state the configuration should be left in.
    - Refer to examples for more details.
    type: str
    choices:
    - merged
    - replaced
    - deleted
    - overridden
    - parsed
    - gathered
    - rendered
    default: merged
"""
EXAMPLES = """
# Using merged
#
# Before state
# ------------
#
# vagrant@vsrx# show system syslog
#
# [edit]
# vagrant@vsrx# show routing-instances
# inst11 {
#     description inst11;
# }
- name: Merge provided logging configuration into running configuration.
  junipernetworks.junos.junos_logging_global:
    config:
      allow_duplicates: true
      archive:
        set: true
        no_binary_data: true
        files: 10
        file_size: 65578
        no_world_readable: true
      console:
        any:
          level: "info"
        authorization:
          level: "any"
        change_log:
          level: "critical"
        ftp:
          level: "none"
      files:
        - name: "file101"
          allow_duplicates: true
        - name: "file102"
          allow_duplicates: true
          any:
            level: "any"
          structured_data:
            set: true
        - name: "file103"
          archive:
            set: true
            no_binary_data: true
            files: 10
            file_size: 65578
            no_world_readable: true
          explicit_priority: true
          match: "^set*"
          match_strings:
            - "^delete"
            - "^prompt"
      hosts:
        - name: host111
          exclude_hostname: true
          allow_duplicates: true
          any:
            level: "any"
          structured_data:
            set: true
            brief: true
          facility_override: "ftp"
          log_prefix: "field"
          match: "^set*"
          match_strings:
            - "^delete"
            - "^prompt"
          port: 1231
          routing_instance: "inst11"
          source_address: "11.1.1.11"
      routing_instance: "inst11"
      log_rotate_frequency: 45
      source_address: "33.33.33.33"
      time_format:
        millisecond: true
        year: true
      users:
        - name: "user1"
          allow_duplicates: true
        - name: "user2"
          allow_duplicates: true
          any:
            level: "any"
          user:
            level: info
    state: merged
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "allow_duplicates": true,
#         "archive": {
#             "file_size": 65578,
#             "files": 10,
#             "no_binary_data": true,
#             "no_world_readable": true
#         },
#         "console": {
#             "any": {
#                 "level": "info"
#             },
#             "authorization": {
#                 "level": "any"
#             },
#             "change_log": {
#                 "level": "critical"
#             },
#             "ftp": {
#                 "level": "none"
#             }
#         },
#         "files": [
#             {
#                 "allow_duplicates": true,
#                 "name": "file101"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "file102",
#                 "structured_data": {
#                     "set": true
#                 }
#             },
#             {
#                 "archive": {
#                     "file_size": 65578,
#                     "files": 10,
#                     "no_binary_data": true,
#                     "no_world_readable": true
#                 },
#                 "explicit_priority": true,
#                 "match": "^set*",
#                 "match_strings": [
#                     "^delete",
#                     "^prompt"
#                 ],
#                 "name": "file103"
#             }
#         ],
#         "hosts": [
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "exclude_hostname": true,
#                 "facility_override": "ftp",
#                 "log_prefix": "field",
#                 "match": "^set*",
#                 "match_strings": [
#                     "^delete",
#                     "^prompt"
#                 ],
#                 "name": "host111",
#                 "port": 1231,
#                 "routing_instance": "inst11",
#                 "source_address": "11.1.1.11",
#                 "structured_data": {
#                     "brief": true
#                 }
#             }
#         ],
#         "log_rotate_frequency": 45,
#         "routing_instance": "inst11",
#         "source_address": "33.33.33.33",
#         "time_format": {
#             "millisecond": true,
#             "year": true
#         },
#         "users": [
#             {
#                 "allow_duplicates": true,
#                 "name": "user1"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "user2",
#                 "user": {
#                     "level": "info"
#                 }
#             }
#         ]
#     },
#     "before": {},
#     "changed": true,
#     "commands": [
#         "<nc:system xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#         "<nc:syslog><nc:allow-duplicates/><nc:archive><nc:files>10</nc:files>"
#         "<nc:no-binary-data/><nc:size>65578</nc:size><nc:no-world-readable/></nc:archive>"
#         "<nc:console><nc:name>change-log</nc:name><nc:critical/></nc:console><nc:console>"
#         "<nc:name>any</nc:name><nc:info/></nc:console><nc:console><nc:name>authorization</nc:name>"
#         "<nc:any/></nc:console><nc:console><nc:name>ftp</nc:name><nc:none/></nc:console><nc:file>"
#         "<nc:name>file101</nc:name><nc:allow-duplicates/></nc:file><nc:file><nc:name>file102</nc:name>"
#         "<nc:allow-duplicates/><nc:contents><nc:name>any</nc:name><nc:any/></nc:contents><nc:structured-data/>"
#         "</nc:file><nc:file><nc:name>file103</nc:name><nc:archive><nc:files>10</nc:files><nc:no-binary-data/>"
#         "<nc:size>65578</nc:size><nc:no-world-readable/></nc:archive><nc:explicit-priority/>"
#         "<nc:match>^set*</nc:match><nc:match-strings>^delete</nc:match-strings>"
#         "<nc:match-strings>^prompt</nc:match-strings></nc:file><nc:host><nc:name>host111</nc:name>"
#         "<nc:allow-duplicates/><nc:contents><nc:name>any</nc:name><nc:any/></nc:contents>"
#         "<nc:exclude-hostname/><nc:facility-override>ftp</nc:facility-override>"
#         "<nc:log-prefix>field</nc:log-prefix><nc:match>^set*</nc:match><nc:match-strings>^delete</nc:match-strings>"
#         "<nc:match-strings>^prompt</nc:match-strings><nc:port>1231</nc:port>"
#         "<nc:routing-instance>inst11</nc:routing-instance><nc:source-address>11.1.1.11</nc:source-address>"
#         "<nc:structured-data><nc:brief/></nc:structured-data></nc:host>"
#         "<nc:log-rotate-frequency>45</nc:log-rotate-frequency><nc:routing-instance>inst11</nc:routing-instance>"
#         "<nc:source-address>33.33.33.33</nc:source-address><nc:time-format><nc:millisecond/>"
#         "<nc:year/></nc:time-format><nc:user><nc:name>user1</nc:name><nc:allow-duplicates/></nc:user>"
#         "<nc:user><nc:name>user2</nc:name><nc:allow-duplicates/><nc:contents><nc:name>any</nc:name><nc:any/>"
#         "</nc:contents><nc:contents><nc:name>user</nc:name><nc:info/></nc:contents></nc:user></nc:syslog></nc:system>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show system syslog
# archive size 65578 files 10 no-world-readable no-binary-data;
# user user1 {
#     allow-duplicates;
# }
# user user2 {
#     any any;
#     user info;
#     allow-duplicates;
# }
# host host111 {
#     any any;
#     match "^set*";
#     allow-duplicates;
#     port 1231;
#     facility-override ftp;
#     log-prefix field;
#     source-address 11.1.1.11;
#     routing-instance inst11;
#     exclude-hostname;
#     match-strings [ "^delete" "^prompt" ];
#     structured-data {
#         brief;
#     }
# }
# allow-duplicates;
# file file101 {
#     allow-duplicates;
# }
# file file102 {
#     any any;
#     allow-duplicates;
#     structured-data;
# }
# file file103 {
#     match "^set*";
#     archive size 65578 files 10 no-world-readable no-binary-data;
#     explicit-priority;
#     match-strings [ "^delete" "^prompt" ];
# }
# console {
#     any info;
#     authorization any;
#     ftp none;
#     change-log critical;
# }
# time-format year millisecond;
# source-address 33.33.33.33;
# routing-instance inst11;
# log-rotate-frequency 45;

# Using replaced
#
# Before state
# ------------
#
# vagrant@vsrx# show system syslog
# archive size 65578 files 10 no-world-readable no-binary-data;
# user user1 {
#     allow-duplicates;
# }
# user user2 {
#     any any;
#     user info;
#     allow-duplicates;
# }
# host host111 {
#     any any;
#     match "^set*";
#     allow-duplicates;
#     port 1231;
#     facility-override ftp;
#     log-prefix field;
#     source-address 11.1.1.11;
#     routing-instance inst11;
#     exclude-hostname;
#     match-strings [ "^delete" "^prompt" ];
#     structured-data {
#         brief;
#     }
# }
# allow-duplicates;
# file file101 {
#     allow-duplicates;
# }
# file file102 {
#     any any;
#     allow-duplicates;
#     structured-data;
# }
# file file103 {
#     match "^set*";
#     archive size 65578 files 10 no-world-readable no-binary-data;
#     explicit-priority;
#     match-strings [ "^delete" "^prompt" ];
# }
# console {
#     any info;
#     authorization any;
#     ftp none;
#     change-log critical;
# }
# time-format year millisecond;
# source-address 33.33.33.33;
# routing-instance inst11;
# log-rotate-frequency 45;

- name: Replaced running logging global configuration with provided configuration
  junipernetworks.junos.junos_logging_global:
    config:
      files:
        - name: "file104"
          allow_duplicates: true
        - name: "file102"
          allow_duplicates: true
          any:
            level: "any"
          structured_data:
            set: true
      hosts:
        - name: host222
          exclude_hostname: true
          allow_duplicates: true
          any:
            level: "any"
          structured_data:
            set: true
            brief: true
          facility_override: "ftp"
          log_prefix: "field"
          match: "^set*"
          match_strings:
            - "^delete"
            - "^prompt"
          port: 1231
          routing_instance: "inst11"
          source_address: "11.1.1.11"
      users:
        - name: "user1"
          allow_duplicates: true
        - name: "user2"
          allow_duplicates: true
          any:
            level: "any"
          user:
            level: info
    state: replaced
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "files": [
#             {
#                 "allow_duplicates": true,
#                 "name": "file104"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "file102",
#                 "structured_data": {
#                     "set": true
#                 }
#             }
#         ],
#         "hosts": [
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "exclude_hostname": true,
#                 "facility_override": "ftp",
#                 "log_prefix": "field",
#                 "match": "^set*",
#                 "match_strings": [
#                     "^delete",
#                     "^prompt"
#                 ],
#                 "name": "host222",
#                 "port": 1231,
#                 "routing_instance": "inst11",
#                 "source_address": "11.1.1.11",
#                 "structured_data": {
#                     "brief": true
#                 }
#             }
#         ],
#         "users": [
#             {
#                 "allow_duplicates": true,
#                 "name": "user1"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "user2",
#                 "user": {
#                     "level": "info"
#                 }
#             }
#         ]
#     },
#     "before": {
#         "allow_duplicates": true,
#         "archive": {
#             "file_size": 65578,
#             "files": 10,
#             "no_binary_data": true,
#             "no_world_readable": true
#         },
#         "console": {
#             "any": {
#                 "level": "info"
#             },
#             "authorization": {
#                 "level": "any"
#             },
#             "change_log": {
#                 "level": "critical"
#             },
#             "ftp": {
#                 "level": "none"
#             }
#         },
#         "files": [
#             {
#                 "allow_duplicates": true,
#                 "name": "file101"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "file102",
#                 "structured_data": {
#                     "set": true
#                 }
#             },
#             {
#                 "archive": {
#                     "file_size": 65578,
#                     "files": 10,
#                     "no_binary_data": true,
#                     "no_world_readable": true
#                 },
#                 "explicit_priority": true,
#                 "match": "^set*",
#                 "match_strings": [
#                     "^delete",
#                     "^prompt"
#                 ],
#                 "name": "file103"
#             }
#         ],
#         "hosts": [
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "exclude_hostname": true,
#                 "facility_override": "ftp",
#                 "log_prefix": "field",
#                 "match": "^set*",
#                 "match_strings": [
#                     "^delete",
#                     "^prompt"
#                 ],
#                 "name": "host111",
#                 "port": 1231,
#                 "routing_instance": "inst11",
#                 "source_address": "11.1.1.11",
#                 "structured_data": {
#                     "brief": true
#                 }
#             }
#         ],
#         "log_rotate_frequency": 45,
#         "routing_instance": "inst11",
#         "source_address": "33.33.33.33",
#         "time_format": {
#             "millisecond": true,
#             "year": true
#         },
#         "users": [
#             {
#                 "allow_duplicates": true,
#                 "name": "user1"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "user2",
#                 "user": {
#                     "level": "info"
#                 }
#             }
#         ]
#     },
#     "changed": true,
#     "commands": [
#             "<nc:system xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#             "<nc:syslog delete=\"delete\"/><nc:syslog><nc:file><nc:name>file104</nc:name>"
#             "<nc:allow-duplicates/></nc:file><nc:file><nc:name>file102</nc:name><nc:allow-duplicates/>"
#             "<nc:contents><nc:name>any</nc:name><nc:any/></nc:contents><nc:structured-data/></nc:file>"
#             "<nc:host><nc:name>host222</nc:name><nc:allow-duplicates/><nc:contents><nc:name>any</nc:name>"
#             "<nc:any/></nc:contents><nc:exclude-hostname/><nc:facility-override>ftp</nc:facility-override>"
#             "<nc:log-prefix>field</nc:log-prefix><nc:match>^set*</nc:match>"
#             "<nc:match-strings>^delete</nc:match-strings>"
#             "<nc:match-strings>^prompt</nc:match-strings><nc:port>1231</nc:port>"
#             "<nc:routing-instance>inst11</nc:routing-instance><nc:source-address>11.1.1.11</nc:source-address>"
#             "<nc:structured-data><nc:brief/></nc:structured-data></nc:host><nc:user><nc:name>user1</nc:name>"
#             "<nc:allow-duplicates/></nc:user><nc:user><nc:name>user2</nc:name><nc:allow-duplicates/><nc:contents>"
#             "<nc:name>any</nc:name><nc:any/></nc:contents>"
#             "<nc:contents><nc:name>user</nc:name><nc:info/></nc:contents></nc:user></nc:syslog></nc:system>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show system syslog
# user user1 {
#     allow-duplicates;
# }
# user user2 {
#     any any;
#     user info;
#     allow-duplicates;
# }
# host host222 {
#     any any;
#     match "^set*";
#     allow-duplicates;
#     port 1231;
#     facility-override ftp;
#     log-prefix field;
#     source-address 11.1.1.11;
#     routing-instance inst11;
#     exclude-hostname;
#     match-strings [ "^delete" "^prompt" ];
#     structured-data {
#         brief;
#     }
# }
# file file104 {
#     allow-duplicates;
# }
# file file102 {
#     any any;
#     allow-duplicates;
#     structured-data;
# }

# Using overridden
#
# Before state
# ------------
#
# vagrant@vsrx# show system syslog
# archive size 65578 files 10 no-world-readable no-binary-data;
# user user1 {
#     allow-duplicates;
# }
# user user2 {
#     any any;
#     user info;
#     allow-duplicates;
# }
# host host111 {
#     any any;
#     match "^set*";
#     allow-duplicates;
#     port 1231;
#     facility-override ftp;
#     log-prefix field;
#     source-address 11.1.1.11;
#     routing-instance inst11;
#     exclude-hostname;
#     match-strings [ "^delete" "^prompt" ];
#     structured-data {
#         brief;
#     }
# }
# allow-duplicates;
# file file101 {
#     allow-duplicates;
# }
# file file102 {
#     any any;
#     allow-duplicates;
#     structured-data;
# }
# file file103 {
#     match "^set*";
#     archive size 65578 files 10 no-world-readable no-binary-data;
#     explicit-priority;
#     match-strings [ "^delete" "^prompt" ];
# }
# console {
#     any info;
#     authorization any;
#     ftp none;
#     change-log critical;
# }
# time-format year millisecond;
# source-address 33.33.33.33;
# routing-instance inst11;
# log-rotate-frequency 45;

- name: Override running logging global configuration with provided configuration
  junipernetworks.junos.junos_logging_global:
    config:
      files:
        - name: "file104"
          allow_duplicates: true
        - name: "file102"
          allow_duplicates: true
          any:
            level: "any"
          structured_data:
            set: true
      hosts:
        - name: host222
          exclude_hostname: true
          allow_duplicates: true
          any:
            level: "any"
          structured_data:
            set: true
            brief: true
          facility_override: "ftp"
          log_prefix: "field"
          match: "^set*"
          match_strings:
            - "^delete"
            - "^prompt"
          port: 1231
          routing_instance: "inst11"
          source_address: "11.1.1.11"
      users:
        - name: "user1"
          allow_duplicates: true
        - name: "user2"
          allow_duplicates: true
          any:
            level: "any"
          user:
            level: info
    state: overridden
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "files": [
#             {
#                 "allow_duplicates": true,
#                 "name": "file104"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "file102",
#                 "structured_data": {
#                     "set": true
#                 }
#             }
#         ],
#         "hosts": [
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "exclude_hostname": true,
#                 "facility_override": "ftp",
#                 "log_prefix": "field",
#                 "match": "^set*",
#                 "match_strings": [
#                     "^delete",
#                     "^prompt"
#                 ],
#                 "name": "host222",
#                 "port": 1231,
#                 "routing_instance": "inst11",
#                 "source_address": "11.1.1.11",
#                 "structured_data": {
#                     "brief": true
#                 }
#             }
#         ],
#         "users": [
#             {
#                 "allow_duplicates": true,
#                 "name": "user1"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "user2",
#                 "user": {
#                     "level": "info"
#                 }
#             }
#         ]
#     },
#     "before": {
#         "allow_duplicates": true,
#         "archive": {
#             "file_size": 65578,
#             "files": 10,
#             "no_binary_data": true,
#             "no_world_readable": true
#         },
#         "console": {
#             "any": {
#                 "level": "info"
#             },
#             "authorization": {
#                 "level": "any"
#             },
#             "change_log": {
#                 "level": "critical"
#             },
#             "ftp": {
#                 "level": "none"
#             }
#         },
#         "files": [
#             {
#                 "allow_duplicates": true,
#                 "name": "file101"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "file102",
#                 "structured_data": {
#                     "set": true
#                 }
#             },
#             {
#                 "archive": {
#                     "file_size": 65578,
#                     "files": 10,
#                     "no_binary_data": true,
#                     "no_world_readable": true
#                 },
#                 "explicit_priority": true,
#                 "match": "^set*",
#                 "match_strings": [
#                     "^delete",
#                     "^prompt"
#                 ],
#                 "name": "file103"
#             }
#         ],
#         "hosts": [
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "exclude_hostname": true,
#                 "facility_override": "ftp",
#                 "log_prefix": "field",
#                 "match": "^set*",
#                 "match_strings": [
#                     "^delete",
#                     "^prompt"
#                 ],
#                 "name": "host111",
#                 "port": 1231,
#                 "routing_instance": "inst11",
#                 "source_address": "11.1.1.11",
#                 "structured_data": {
#                     "brief": true
#                 }
#             }
#         ],
#         "log_rotate_frequency": 45,
#         "routing_instance": "inst11",
#         "source_address": "33.33.33.33",
#         "time_format": {
#             "millisecond": true,
#             "year": true
#         },
#         "users": [
#             {
#                 "allow_duplicates": true,
#                 "name": "user1"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "user2",
#                 "user": {
#                     "level": "info"
#                 }
#             }
#         ]
#     },
#     "changed": true,
#     "commands": [
#             "<nc:system xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#             "<nc:syslog delete=\"delete\"/><nc:syslog><nc:file><nc:name>file104</nc:name>"
#             "<nc:allow-duplicates/></nc:file><nc:file><nc:name>file102</nc:name><nc:allow-duplicates/>"
#             "<nc:contents><nc:name>any</nc:name><nc:any/></nc:contents><nc:structured-data/></nc:file>"
#             "<nc:host><nc:name>host222</nc:name><nc:allow-duplicates/><nc:contents><nc:name>any</nc:name>"
#             "<nc:any/></nc:contents><nc:exclude-hostname/><nc:facility-override>ftp</nc:facility-override>"
#             "<nc:log-prefix>field</nc:log-prefix><nc:match>^set*</nc:match>"
#             "<nc:match-strings>^delete</nc:match-strings>"
#             "<nc:match-strings>^prompt</nc:match-strings><nc:port>1231</nc:port>"
#             "<nc:routing-instance>inst11</nc:routing-instance><nc:source-address>11.1.1.11</nc:source-address>"
#             "<nc:structured-data><nc:brief/></nc:structured-data></nc:host><nc:user><nc:name>user1</nc:name>"
#             "<nc:allow-duplicates/></nc:user><nc:user><nc:name>user2</nc:name><nc:allow-duplicates/><nc:contents>"
#             "<nc:name>any</nc:name><nc:any/></nc:contents>"
#             "<nc:contents><nc:name>user</nc:name><nc:info/></nc:contents></nc:user></nc:syslog></nc:system>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show system syslog
# user user1 {
#     allow-duplicates;
# }
# user user2 {
#     any any;
#     user info;
#     allow-duplicates;
# }
# host host222 {
#     any any;
#     match "^set*";
#     allow-duplicates;
#     port 1231;
#     facility-override ftp;
#     log-prefix field;
#     source-address 11.1.1.11;
#     routing-instance inst11;
#     exclude-hostname;
#     match-strings [ "^delete" "^prompt" ];
#     structured-data {
#         brief;
#     }
# }
# file file104 {
#     allow-duplicates;
# }
# file file102 {
#     any any;
#     allow-duplicates;
#     structured-data;
# }

# Using deleted
#
# Before state
# ------------
#
# vagrant@vsrx# show system syslog
# user user1 {
#     allow-duplicates;
# }
# user user2 {
#     any any;
#     user info;
#     allow-duplicates;
# }
# host host222 {
#     any any;
#     match "^set*";
#     allow-duplicates;
#     port 1231;
#     facility-override ftp;
#     log-prefix field;
#     source-address 11.1.1.11;
#     routing-instance inst11;
#     exclude-hostname;
#     match-strings [ "^delete" "^prompt" ];
#     structured-data {
#         brief;
#     }
# }
# file file104 {
#     allow-duplicates;
# }
# file file102 {
#     any any;
#     allow-duplicates;
#     structured-data;
# }

- name: Delete running logging global configuration
  junipernetworks.junos.junos_logging_global:
    config:
    state: deleted
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {},
#     "before": {
#         "files": [
#             {
#                 "allow_duplicates": true,
#                 "name": "file104"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "file102",
#                 "structured_data": {
#                     "set": true
#                 }
#             }
#         ],
#         "hosts": [
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "exclude_hostname": true,
#                 "facility_override": "ftp",
#                 "log_prefix": "field",
#                 "match": "^set*",
#                 "match_strings": [
#                     "^delete",
#                     "^prompt"
#                 ],
#                 "name": "host222",
#                 "port": 1231,
#                 "routing_instance": "inst11",
#                 "source_address": "11.1.1.11",
#                 "structured_data": {
#                     "brief": true
#                 }
#             }
#         ],
#         "users": [
#             {
#                 "allow_duplicates": true,
#                 "name": "user1"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "user2",
#                 "user": {
#                     "level": "info"
#                 }
#             }
#         ]
#     },
#     "changed": true,
#     "commands": [
#               "<nc:system xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#               "<nc:syslog delete=\"delete\"/></nc:system>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show system syslog
#
# [edit]

# Using gathered
#
# Before state
# ------------
#
# vagrant@vsrx# show system syslog
# user user1 {
#     allow-duplicates;
# }
# user user2 {
#     any any;
#     user info;
#     allow-duplicates;
# }
# host host222 {
#     any any;
#     match "^set*";
#     allow-duplicates;
#     port 1231;
#     facility-override ftp;
#     log-prefix field;
#     source-address 11.1.1.11;
#     routing-instance inst11;
#     exclude-hostname;
#     match-strings [ "^delete" "^prompt" ];
#     structured-data {
#         brief;
#     }
# }
# file file104 {
#     allow-duplicates;
# }
# file file102 {
#     any any;
#     allow-duplicates;
#     structured-data;
# }

- name: Gather running logging global configuration
  junipernetworks.junos.junos_logging_global:
    state: gathered
#
# -------------------------
# Module Execution Result
# -------------------------
#     "gathered": {
#         "files": [
#             {
#                 "allow_duplicates": true,
#                 "name": "file104"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "file102",
#                 "structured_data": {
#                     "set": true
#                 }
#             }
#         ],
#         "hosts": [
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "exclude_hostname": true,
#                 "facility_override": "ftp",
#                 "log_prefix": "field",
#                 "match": "^set*",
#                 "match_strings": [
#                     "^delete",
#                     "^prompt"
#                 ],
#                 "name": "host222",
#                 "port": 1231,
#                 "routing_instance": "inst11",
#                 "source_address": "11.1.1.11",
#                 "structured_data": {
#                     "brief": true
#                 }
#             }
#         ],
#         "users": [
#             {
#                 "allow_duplicates": true,
#                 "name": "user1"
#             },
#             {
#                 "allow_duplicates": true,
#                 "any": {
#                     "level": "any"
#                 },
#                 "name": "user2",
#                 "user": {
#                     "level": "info"
#                 }
#             }
#         ]
#     },
#     "changed": false,

# Using rendered
#
# Before state
# ------------
#
# vagrant@vsrx# show system syslog
#
# [edit]
# vagrant@vsrx# show routing-instances
# inst11 {
#     description inst11;
# }
- name: Render xml for provided facts.
  junipernetworks.junos.junos_logging_global:
    config:
      allow_duplicates: true
      archive:
        set: true
        no_binary_data: true
        files: 10
        file_size: 65578
        no_world_readable: true
      console:
        any:
          level: "info"
        authorization:
          level: "any"
        change_log:
          level: "critical"
        ftp:
          level: "none"
      files:
        - name: "file101"
          allow_duplicates: true
        - name: "file102"
          allow_duplicates: true
          any:
            level: "any"
          structured_data:
            set: true
        - name: "file103"
          archive:
            set: true
            no_binary_data: true
            files: 10
            file_size: 65578
            no_world_readable: true
          explicit_priority: true
          match: "^set*"
          match_strings:
            - "^delete"
            - "^prompt"
      hosts:
        - name: host111
          exclude_hostname: true
          allow_duplicates: true
          any:
            level: "any"
          structured_data:
            set: true
            brief: true
          facility_override: "ftp"
          log_prefix: "field"
          match: "^set*"
          match_strings:
            - "^delete"
            - "^prompt"
          port: 1231
          routing_instance: "inst11"
          source_address: "11.1.1.11"
      routing_instance: "inst11"
      log_rotate_frequency: 45
      source_address: "33.33.33.33"
      time_format:
        millisecond: true
        year: true
      users:
        - name: "user1"
          allow_duplicates: true
        - name: "user2"
          allow_duplicates: true
          any:
            level: "any"
          user:
            level: info
    state: rendered
#
# -------------------------
# Module Execution Result
# -------------------------
#     "rendered": [
#         "<nc:system xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#         "<nc:syslog><nc:allow-duplicates/><nc:archive><nc:files>10</nc:files>"
#         "<nc:no-binary-data/><nc:size>65578</nc:size><nc:no-world-readable/></nc:archive>"
#         "<nc:console><nc:name>change-log</nc:name><nc:critical/></nc:console><nc:console>"
#         "<nc:name>any</nc:name><nc:info/></nc:console><nc:console><nc:name>authorization</nc:name>"
#         "<nc:any/></nc:console><nc:console><nc:name>ftp</nc:name><nc:none/></nc:console><nc:file>"
#         "<nc:name>file101</nc:name><nc:allow-duplicates/></nc:file><nc:file><nc:name>file102</nc:name>"
#         "<nc:allow-duplicates/><nc:contents><nc:name>any</nc:name><nc:any/></nc:contents><nc:structured-data/>"
#         "</nc:file><nc:file><nc:name>file103</nc:name><nc:archive><nc:files>10</nc:files><nc:no-binary-data/>"
#         "<nc:size>65578</nc:size><nc:no-world-readable/></nc:archive><nc:explicit-priority/>"
#         "<nc:match>^set*</nc:match><nc:match-strings>^delete</nc:match-strings>"
#         "<nc:match-strings>^prompt</nc:match-strings></nc:file><nc:host><nc:name>host111</nc:name>"
#         "<nc:allow-duplicates/><nc:contents><nc:name>any</nc:name><nc:any/></nc:contents>"
#         "<nc:exclude-hostname/><nc:facility-override>ftp</nc:facility-override>"
#         "<nc:log-prefix>field</nc:log-prefix><nc:match>^set*</nc:match><nc:match-strings>^delete</nc:match-strings>"
#         "<nc:match-strings>^prompt</nc:match-strings><nc:port>1231</nc:port>"
#         "<nc:routing-instance>inst11</nc:routing-instance><nc:source-address>11.1.1.11</nc:source-address>"
#         "<nc:structured-data><nc:brief/></nc:structured-data></nc:host>"
#         "<nc:log-rotate-frequency>45</nc:log-rotate-frequency><nc:routing-instance>inst11</nc:routing-instance>"
#         "<nc:source-address>33.33.33.33</nc:source-address><nc:time-format><nc:millisecond/>"
#         "<nc:year/></nc:time-format><nc:user><nc:name>user1</nc:name><nc:allow-duplicates/></nc:user>"
#         "<nc:user><nc:name>user2</nc:name><nc:allow-duplicates/><nc:contents><nc:name>any</nc:name><nc:any/>"
#         "</nc:contents><nc:contents><nc:name>user</nc:name><nc:info/></nc:contents></nc:user></nc:syslog></nc:system>"
#     ]

# Using parsed
# parsed.cfg
# ------------
# <?xml version="1.0" encoding="UTF-8"?>
# <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
#     <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
#         <version>18.4R1-S2.4</version>
#         <system xmlns="http://yang.juniper.net/junos-es/conf/system">
#         <syslog>
#             <user>
#                 <name>*</name>
#                 <contents>
#                     <name>any</name>
#                     <emergency/>
#                 </contents>
#             </user>
#             <file>
#                 <name>messages</name>
#                 <contents>
#                     <name>any</name>
#                     <any/>
#                 </contents>
#                 <contents>
#                     <name>authorization</name>
#                     <info/>
#                 </contents>
#             </file>
#             <file>
#                 <name>interactive-commands</name>
#                 <contents>
#                     <name>interactive-commands</name>
#                     <any/>
#                 </contents>
#             </file>
#         </syslog>
#     </system>
#     </configuration>
# </rpc-reply>

- name: Parse routing instance running config
  junipernetworks.junos.junos_routing_instances:
    running_config: "{{ lookup('file', './parsed.cfg') }}"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed":  {
#         "files": [
#             {
#                 "any": {
#                     "level": "any"
#                 },
#                 "authorization": {
#                     "level": "info"
#                 },
#                 "name": "messages"
#             },
#             {
#                 "interactive_commands": {
#                     "level": "any"
#                 },
#                 "name": "interactive-commands"
#             }
#         ],
#         "users": [
#             {
#                 "any": {
#                     "level": "emergency"
#                 },
#                 "name": "*"
#             }
#         ]
#     }
#
#
"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
after:
  description: The resulting configuration model invocation.
  returned: when changed
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['<nc:allow-duplicates/></nc:user><nc:user><nc:name>user2</nc:name>
           <nc:allow-duplicates/><nc:contents><nc:name>any</nc:name><nc:any/>
           </nc:contents><nc:contents><nc:name>user</nc:name><nc:info/></nc:contents>
           </nc:user></nc:syslog></nc:system>"', 'xml 2', 'xml 3']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.argspec.logging_global.logging_global import (
    Logging_globalArgs,
)
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.logging_global.logging_global import (
    Logging_global,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    module = AnsibleModule(
        argument_spec=Logging_globalArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )
    result = Logging_global(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
