/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.I18nManager;
import tim.prune.data.TrackInfo;
import tim.prune.gui.GenericDisplay;
import tim.prune.gui.MediaListModel;
import tim.prune.gui.WaypointListModel;

public class SelectorDisplay
extends GenericDisplay {
    private JLabel _trackpointsLabel = null;
    private JLabel _filenameLabel = null;
    private JScrollBar _scroller = null;
    private boolean _ignoreScrollEvents = false;
    private JPanel _listsPanel = null;
    private int _visiblePanels = 1;
    private JPanel _waypointListPanel = null;
    private JList<String> _waypointList = null;
    private WaypointListModel _waypointListModel = null;
    private JPanel _photoListPanel = null;
    private JList<String> _photoList = null;
    private MediaListModel _photoListModel = null;
    private JPanel _audioListPanel = null;
    private JList<String> _audioList = null;
    private MediaListModel _audioListModel = null;
    private static final int SCROLLBAR_INTERVAL = 50;
    private static final int NUM_LIST_ENTRIES = 7;

    public SelectorDisplay(TrackInfo trackInfo) {
        super(trackInfo);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        JLabel jLabel = new JLabel(I18nManager.getText("details.trackdetails"));
        Font font = jLabel.getFont();
        font = font.deriveFont(1, font.getSize2D() + 2.0f);
        jLabel.setFont(font);
        jPanel2.add(jLabel);
        this._trackpointsLabel = new JLabel(I18nManager.getText("details.notrack"));
        jPanel2.add(this._trackpointsLabel);
        this._filenameLabel = new JLabel("");
        this._filenameLabel.setMinimumSize(new Dimension(120, 10));
        jPanel2.add(this._filenameLabel);
        this._scroller = new JScrollBar(0, 0, 50, 0, 100);
        this._scroller.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                SelectorDisplay.this.selectPoint(adjustmentEvent.getValue());
            }
        });
        this._scroller.setEnabled(false);
        this._listsPanel = new JPanel();
        this._listsPanel.setLayout(new GridLayout(0, 1));
        this._listsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this._waypointListModel = new WaypointListModel(this._trackInfo.getTrack());
        this._waypointList = new JList<String>(this._waypointListModel);
        this._waypointList.setVisibleRowCount(7);
        this._waypointList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SelectorDisplay.this.selectWaypoint(SelectorDisplay.this._waypointList.getSelectedIndex());
                }
            }
        });
        this._waypointListPanel = SelectorDisplay.makeListPanel("details.lists.waypoints", this._waypointList);
        this._listsPanel.add(this._waypointListPanel);
        this._photoListModel = new MediaListModel(this._trackInfo.getPhotoList());
        this._photoList = new JList<String>(this._photoListModel);
        this._photoList.setVisibleRowCount(7);
        this._photoList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SelectorDisplay.this.selectPhoto(SelectorDisplay.this._photoList.getSelectedIndex());
                }
            }
        });
        this._photoListPanel = SelectorDisplay.makeListPanel("details.lists.photos", this._photoList);
        this._audioListModel = new MediaListModel(this._trackInfo.getAudioList());
        this._audioList = new JList<String>(this._audioListModel);
        this._audioList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SelectorDisplay.this.selectAudio(SelectorDisplay.this._audioList.getSelectedIndex());
                }
            }
        });
        this._audioListPanel = SelectorDisplay.makeListPanel("details.lists.audio", this._audioList);
        this._listsPanel.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this._scroller);
        jPanel.add(Box.createVerticalStrut(5));
        this.add((Component)jPanel, "North");
        this.add((Component)this._listsPanel, "Center");
        this.setPreferredSize(new Dimension(100, 100));
    }

    private void selectPoint(int n) {
        if (this._track != null && !this._ignoreScrollEvents) {
            this._trackInfo.selectPoint(n);
        }
    }

    private void selectPhoto(int n) {
        this._trackInfo.selectPhoto(n);
    }

    private void selectAudio(int n) {
        this._trackInfo.selectAudio(n);
    }

    private void selectWaypoint(int n) {
        if (n >= 0) {
            this._trackInfo.selectPoint(this._waypointListModel.getWaypoint(n));
        }
    }

    @Override
    public void dataUpdated(byte by) {
        int n;
        int n2;
        if (this._track == null || this._track.getNumPoints() <= 0) {
            this._trackpointsLabel.setText(I18nManager.getText("details.notrack"));
            this._filenameLabel.setText("");
            this._filenameLabel.setToolTipText("");
        } else {
            String string;
            this._trackpointsLabel.setText(String.valueOf(I18nManager.getText("details.track.points")) + ": " + this._track.getNumPoints());
            n2 = this._trackInfo.getFileInfo().getNumFiles();
            if (n2 == 1) {
                string = this._trackInfo.getFileInfo().getFilename();
                this._filenameLabel.setText(String.valueOf(I18nManager.getText("details.track.file")) + ": " + string);
                this._filenameLabel.setToolTipText(string);
            } else if (n2 > 1) {
                string = String.valueOf(I18nManager.getText("details.track.numfiles")) + ": " + n2;
                this._filenameLabel.setText(string);
                this._filenameLabel.setToolTipText(string);
            } else {
                this._filenameLabel.setText("");
                this._filenameLabel.setToolTipText("");
            }
        }
        n2 = this._trackInfo.getSelection().getCurrentPointIndex();
        this._ignoreScrollEvents = true;
        if (this._track == null || this._track.getNumPoints() < 2) {
            this._scroller.setEnabled(false);
        } else {
            this._scroller.setMaximum(this._track.getNumPoints() - 1 + 50);
            if (n2 >= 0) {
                this._scroller.setValue(n2);
            }
            this._scroller.setEnabled(true);
        }
        this._ignoreScrollEvents = false;
        if ((by | 0xB) > 0) {
            this._waypointListModel.fireChanged();
        }
        if ((by & 0x13) > 0) {
            this._photoListModel.fireChanged();
            this._audioListModel.fireChanged();
        }
        if (!(this._waypointList.getSelectedIndex() < 0 || this._trackInfo.getCurrentPoint() != null && this._waypointList.getSelectedIndex() < this._waypointListModel.getSize() && this._waypointListModel.getWaypoint(this._waypointList.getSelectedIndex()).equals(this._trackInfo.getCurrentPoint()))) {
            this._waypointList.clearSelection();
        }
        this.redrawLists(this._photoListModel.getSize() > 0, this._audioListModel.getSize() > 0);
        if (this._photoListModel.getSize() > 0) {
            int n3 = this._trackInfo.getSelection().getCurrentPhotoIndex();
            n = this._photoList.getSelectedIndex();
            if (n != n3) {
                if (n3 < 0) {
                    this._photoList.clearSelection();
                } else {
                    this._photoList.setSelectedIndex(n3);
                }
            }
        }
        if (this._audioListModel.getSize() > 0) {
            int n4 = this._trackInfo.getSelection().getCurrentAudioIndex();
            n = this._audioList.getSelectedIndex();
            if (n != n4) {
                if (n4 < 0) {
                    this._audioList.clearSelection();
                } else {
                    this._audioList.setSelectedIndex(n4);
                }
            }
        }
    }

    private static JPanel makeListPanel(String string, JList<String> jList) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(I18nManager.getText(string)), "North");
        jList.setSelectionMode(0);
        jPanel.add((Component)new JScrollPane(jList), "Center");
        return jPanel;
    }

    private void redrawLists(boolean bl, boolean bl2) {
        int n = 1 + (bl ? 2 : 0) + (bl2 ? 4 : 0);
        if (n == this._visiblePanels) {
            return;
        }
        this._visiblePanels = n;
        this._listsPanel.removeAll();
        this._listsPanel.setLayout(new GridLayout(0, 1));
        this._listsPanel.add(this._waypointListPanel);
        if (bl) {
            this._listsPanel.add(this._photoListPanel);
        }
        if (bl2) {
            this._listsPanel.add(this._audioListPanel);
        }
        this._listsPanel.invalidate();
        this._listsPanel.getParent().validate();
    }
}

