/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.threedee;

import com.sun.j3d.utils.behaviors.vp.ViewPlatformAWTBehavior;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class UprightOrbiter
extends ViewPlatformAWTBehavior {
    private Transform3D _longitudeTransform = new Transform3D();
    private Transform3D _latitudeTransform = new Transform3D();
    private Transform3D _rotateTransform = new Transform3D();
    private Transform3D _temp1 = new Transform3D();
    private Transform3D _temp2 = new Transform3D();
    private Transform3D _translation = new Transform3D();
    private Vector3d _transVector = new Vector3d();
    private Vector3d _distanceVector = new Vector3d();
    private Vector3d _centerVector = new Vector3d();
    private Vector3d _invertCenterVector = new Vector3d();
    private double _deltaYaw = 0.0;
    private double _deltaPitch = 0.0;
    private double _startDistanceFromCenter = 20.0;
    private double _distanceFromCenter = 20.0;
    private Point3d _rotationCenter = new Point3d();
    private Matrix3d _rotMatrix = new Matrix3d();
    private int _mouseX = 0;
    private int _mouseY = 0;
    private double _xtrans = 0.0;
    private double _ytrans = 0.0;
    private double _ztrans = 0.0;
    private static final double MIN_RADIUS = 0.0;
    private static final float wheelZoomFactor = 50.0f;
    private static final double NOMINAL_ZOOM_FACTOR = 0.01;
    private static final double NOMINAL_ROT_FACTOR = 0.008;
    private static final double NOMINAL_TRANS_FACTOR = 0.003;
    private double _pitchAngle = 0.0;

    public UprightOrbiter(Canvas3D canvas3D, double d) {
        super(canvas3D, 11);
        this._pitchAngle = Math.toRadians(d);
    }

    protected synchronized void processAWTEvents(AWTEvent[] aWTEventArray) {
        this.motion = false;
        int n = 0;
        while (n < aWTEventArray.length) {
            if (aWTEventArray[n] instanceof MouseEvent) {
                this.processMouseEvent((MouseEvent)aWTEventArray[n]);
            }
            ++n;
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this._mouseX = mouseEvent.getX();
            this._mouseY = mouseEvent.getY();
            this.motion = true;
        } else if (mouseEvent.getID() == 506) {
            int n = mouseEvent.getX() - this._mouseX;
            int n2 = mouseEvent.getY() - this._mouseY;
            if (this.isRotateEvent(mouseEvent)) {
                this._deltaYaw -= (double)n * 0.008;
                this._deltaPitch -= (double)n2 * 0.008;
            } else if (this.isTranslateEvent(mouseEvent)) {
                this._xtrans -= (double)n * 0.003;
                this._ytrans += (double)n2 * 0.003;
            } else if (this.isZoomEvent(mouseEvent)) {
                this.doZoomOperations(n2);
            }
            this._mouseX = mouseEvent.getX();
            this._mouseY = mouseEvent.getY();
            this.motion = true;
        } else if (mouseEvent.getID() == 507 && this.isZoomEvent(mouseEvent) && mouseEvent instanceof MouseWheelEvent) {
            int n = (int)((float)((MouseWheelEvent)mouseEvent).getWheelRotation() * 50.0f);
            this.doZoomOperations(n);
            this.motion = true;
        }
    }

    private void doZoomOperations(int n) {
        this._distanceFromCenter = this._distanceFromCenter - (double)n * 0.01 > 0.0 ? (this._distanceFromCenter -= (double)n * 0.01) : 0.0;
    }

    public void setViewingPlatform(ViewingPlatform viewingPlatform) {
        super.setViewingPlatform(viewingPlatform);
        if (viewingPlatform != null) {
            this.resetView();
            this.integrateTransforms();
        }
    }

    private void resetView() {
        Vector3d vector3d = new Vector3d();
        this.targetTG.getTransform(this.targetTransform);
        this.targetTransform.get(this._rotMatrix, this._transVector);
        vector3d.sub((Tuple3d)this._transVector, (Tuple3d)this._rotationCenter);
        this._startDistanceFromCenter = this._distanceFromCenter = vector3d.length();
        this.targetTransform.get(this._rotMatrix);
        this._rotateTransform.set(this._rotMatrix);
        this._temp1.set(vector3d);
        this._rotateTransform.invert();
        this._rotateTransform.mul(this._temp1);
        this._rotateTransform.get(vector3d);
        this._xtrans = vector3d.x;
        this._ytrans = vector3d.y;
        this._ztrans = vector3d.z;
        this._rotateTransform.set(this._rotMatrix);
    }

    protected synchronized void integrateTransforms() {
        Transform3D transform3D = new Transform3D();
        this.targetTG.getTransform(transform3D);
        if (!this.targetTransform.equals(transform3D)) {
            this.resetView();
        }
        this._latitudeTransform.rotX(this._pitchAngle);
        this._rotateTransform.mul(this._rotateTransform, this._latitudeTransform);
        this._longitudeTransform.rotY(this._deltaYaw);
        this._rotateTransform.mul(this._rotateTransform, this._longitudeTransform);
        this._pitchAngle = Math.min(Math.max(0.0, this._pitchAngle - this._deltaPitch), 1.5707963267948966);
        this._latitudeTransform.rotX(-this._pitchAngle);
        this._rotateTransform.mul(this._rotateTransform, this._latitudeTransform);
        this._distanceVector.z = this._distanceFromCenter - this._startDistanceFromCenter;
        this._temp1.set(this._distanceVector);
        this._temp1.mul(this._rotateTransform, this._temp1);
        this._transVector.x = this._rotationCenter.x + this._xtrans;
        this._transVector.y = this._rotationCenter.y + this._ytrans;
        this._transVector.z = this._rotationCenter.z + this._ztrans;
        this._translation.set(this._transVector);
        this.targetTransform.mul(this._temp1, this._translation);
        this._temp1.set(this._centerVector);
        this._temp1.mul(this.targetTransform);
        this._invertCenterVector.x = -this._centerVector.x;
        this._invertCenterVector.y = -this._centerVector.y;
        this._invertCenterVector.z = -this._centerVector.z;
        this._temp2.set(this._invertCenterVector);
        this.targetTransform.mul(this._temp1, this._temp2);
        Vector3d vector3d = new Vector3d();
        this.targetTransform.get(vector3d);
        this.targetTG.setTransform(this.targetTransform);
        this._deltaYaw = 0.0;
        this._deltaPitch = 0.0;
    }

    private boolean isRotateEvent(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = (mouseEvent.getModifiersEx() & 0x1000) > 0;
        return !mouseEvent.isAltDown() && !bl;
    }

    private boolean isZoomEvent(MouseEvent mouseEvent) {
        if (mouseEvent instanceof MouseWheelEvent) {
            return true;
        }
        return mouseEvent.isAltDown() && !mouseEvent.isMetaDown();
    }

    private boolean isTranslateEvent(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = (mouseEvent.getModifiersEx() & 0x1000) > 0;
        return !mouseEvent.isAltDown() && bl;
    }
}

