/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.DataProviderHolder;
import org.testng.IClass;
import org.testng.IInstanceInfo;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IObjectFactoryAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.BaseClassFinder;
import org.testng.internal.ClassHelper;
import org.testng.internal.ClassInfoMap;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.FactoryMethod;
import org.testng.internal.IConfiguration;
import org.testng.internal.IParameterInfo;
import org.testng.internal.ObjectFactoryImpl;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;

public class TestNGClassFinder
extends BaseClassFinder {
    private static final String PREFIX = "[TestNGClassFinder]";
    private final ITestContext m_testContext;
    private final Map<Class<?>, List<Object>> m_instanceMap = Maps.newHashMap();
    private final DataProviderHolder holder;
    private final ITestObjectFactory objectFactory;
    private final IAnnotationFinder annotationFinder;
    private String m_factoryCreationFailedMessage = null;

    public String getFactoryCreationFailedMessage() {
        return this.m_factoryCreationFailedMessage;
    }

    public TestNGClassFinder(ClassInfoMap cim, Map<Class<?>, List<Object>> instanceMap, IConfiguration configuration, ITestContext testContext, DataProviderHolder holder) {
        if (instanceMap == null) {
            throw new IllegalArgumentException("instanceMap must not be null");
        }
        this.m_testContext = testContext;
        this.holder = holder;
        this.annotationFinder = configuration.getAnnotationFinder();
        Set<Class<?>> allClasses = cim.getClasses();
        this.objectFactory = configuration.getObjectFactory() == null ? this.createObjectFactory(allClasses) : configuration.getObjectFactory();
        for (Class<?> clazz : allClasses) {
            this.processClass(cim, instanceMap, configuration, clazz);
        }
        for (Map.Entry entry : this.m_instanceMap.entrySet()) {
            Class clazz = (Class)entry.getKey();
            for (Object instance : (List)entry.getValue()) {
                IClass ic = this.getIClass(clazz);
                if (null == ic) continue;
                ic.addInstance(instance);
            }
        }
    }

    private void processClass(ClassInfoMap cim, Map<Class<?>, List<Object>> instanceMap, IConfiguration configuration, Class<?> cls) {
        Object thisInstance;
        if (null == cls) {
            Utils.log(PREFIX, 5, "[WARN] FOUND NULL CLASS");
            return;
        }
        if (TestNGClassFinder.isNotTestNGClass(cls, this.annotationFinder)) {
            Utils.log(PREFIX, 3, "SKIPPING CLASS " + cls + " no TestNG annotations found");
            return;
        }
        List<Object> allInstances = instanceMap.get(cls);
        Object object = thisInstance = allInstances != null && !allInstances.isEmpty() ? allInstances.get(0) : null;
        if (null == thisInstance && Modifier.isAbstract(cls.getModifiers())) {
            Utils.log("", 5, "[WARN] Found an abstract class with no valid instance attached: " + cls);
            return;
        }
        if (null == thisInstance && cls.isAnonymousClass()) {
            Utils.log("", 5, "[WARN] Found an anonymous class with no valid instance attached" + cls);
            return;
        }
        IClass ic = this.findOrCreateIClass(this.m_testContext, cls, cim.getXmlClass(cls), thisInstance, this.annotationFinder, this.objectFactory);
        if (ic == null) {
            return;
        }
        this.putIClass(cls, ic);
        List<ConstructorOrMethod> factoryMethods = ClassHelper.findDeclaredFactoryMethods(cls, this.annotationFinder);
        for (ConstructorOrMethod factoryMethod : factoryMethods) {
            this.processMethod(configuration, ic, factoryMethod);
        }
    }

    private void processMethod(IConfiguration configuration, IClass ic, ConstructorOrMethod factoryMethod) {
        if (!factoryMethod.getEnabled()) {
            return;
        }
        ClassInfoMap moreClasses = this.processFactory(ic, factoryMethod);
        if (moreClasses.isEmpty()) {
            return;
        }
        TestNGClassFinder finder = new TestNGClassFinder(moreClasses, this.m_instanceMap, configuration, this.m_testContext, new DataProviderHolder());
        for (IClass ic2 : finder.findTestClasses()) {
            this.putIClass(ic2.getRealClass(), ic2);
        }
    }

    private static boolean excludeFactory(FactoryMethod fm, ITestContext ctx) {
        return fm.getGroups().length != 0 && ctx.getCurrentXmlTest().getExcludedGroups().containsAll(Arrays.asList(fm.getGroups()));
    }

    private ClassInfoMap processFactory(IClass ic, ConstructorOrMethod factoryMethod) {
        Object[] theseInstances = ic.getInstances(false);
        Object instance = theseInstances.length != 0 ? theseInstances[0] : null;
        FactoryMethod fm = new FactoryMethod(factoryMethod, instance, this.annotationFinder, this.m_testContext, this.objectFactory, this.holder);
        ClassInfoMap moreClasses = new ClassInfoMap();
        if (TestNGClassFinder.excludeFactory(fm, this.m_testContext)) {
            return moreClasses;
        }
        int i = 0;
        for (IParameterInfo o : fm.invoke()) {
            Class<Object> oneMoreClass;
            if (o == null) {
                throw new TestNGException("The factory " + fm + " returned a null instanceat index " + i);
            }
            Object objToInspect = IParameterInfo.embeddedInstance(o);
            if (IInstanceInfo.class.isAssignableFrom(objToInspect.getClass())) {
                IInstanceInfo ii = (IInstanceInfo)objToInspect;
                this.addInstance(ii);
                oneMoreClass = ii.getInstanceClass();
            } else {
                this.addInstance(o);
                oneMoreClass = objToInspect.getClass();
            }
            if (!this.classExists(oneMoreClass)) {
                moreClasses.addClass(oneMoreClass);
            }
            ++i;
        }
        this.m_factoryCreationFailedMessage = fm.getFactoryCreationFailedMessage();
        return moreClasses;
    }

    private ITestObjectFactory createObjectFactory(Set<Class<?>> allClasses) {
        ITestObjectFactory objectFactory = new ObjectFactoryImpl();
        for (Class<?> cls : allClasses) {
            try {
                Method[] ms;
                if (cls == null) continue;
                try {
                    ms = cls.getMethods();
                }
                catch (NoClassDefFoundError e) {
                    Utils.log(PREFIX, 5, "[WARN] Can't link and determine methods of " + cls + "(" + e.getMessage() + ")");
                    ms = new Method[]{};
                }
                for (Method m : ms) {
                    IObjectFactoryAnnotation a = this.annotationFinder.findAnnotation(m, IObjectFactoryAnnotation.class);
                    if (a == null) continue;
                    if (!ITestObjectFactory.class.isAssignableFrom(m.getReturnType())) {
                        throw new TestNGException("Return type of " + m + " is not IObjectFactory");
                    }
                    try {
                        Object instance = cls.newInstance();
                        objectFactory = m.getParameterTypes().length > 0 && m.getParameterTypes()[0].equals(ITestContext.class) ? (ITestObjectFactory)m.invoke(instance, this.m_testContext) : (ITestObjectFactory)m.invoke(instance, new Object[0]);
                        return objectFactory;
                    }
                    catch (Exception ex) {
                        throw new TestNGException("Error creating object factory: " + cls, ex);
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                Utils.log(PREFIX, 1, "Unable to read methods on class " + cls.getName() + " - unable to resolve class reference " + e.getMessage());
                for (XmlClass xmlClass : this.m_testContext.getCurrentXmlTest().getXmlClasses()) {
                    if (!xmlClass.loadClasses() || !xmlClass.getName().equals(cls.getName())) continue;
                    throw e;
                }
            }
        }
        return objectFactory;
    }

    private static boolean isNotTestNGClass(Class<?> c, IAnnotationFinder annotationFinder) {
        return !TestNGClassFinder.isTestNGClass(c, annotationFinder);
    }

    private static boolean isTestNGClass(Class<?> c, IAnnotationFinder annotationFinder) {
        Class<?> cls = c;
        boolean result = false;
        try {
            for (Class<? extends IAnnotation> annotation : AnnotationHelper.getAllAnnotations()) {
                for (cls = c; cls != null; cls = cls.getSuperclass()) {
                    for (Method m : ClassHelper.getAvailableMethods(cls)) {
                        IAnnotation ma = annotationFinder.findAnnotation(cls, m, annotation);
                        if (null == ma) continue;
                        result = true;
                    }
                    IAnnotation a = annotationFinder.findAnnotation(cls, annotation);
                    if (null != a) {
                        result = true;
                    }
                    for (Constructor<?> ctor : cls.getConstructors()) {
                        IAnnotation ca = annotationFinder.findAnnotation(ctor, annotation);
                        if (null == ca) continue;
                        result = true;
                    }
                }
            }
            return result;
        }
        catch (NoClassDefFoundError e) {
            Utils.log(PREFIX, 1, "Unable to read methods on class " + cls.getName() + " - unable to resolve class reference " + e.getMessage());
            return false;
        }
    }

    private <T> void addInstance(IInstanceInfo<T> ii) {
        this.addInstance(ii.getInstanceClass(), ii.getInstance());
    }

    private void addInstance(Object o) {
        this.addInstance(IParameterInfo.embeddedInstance(o).getClass(), o);
    }

    private <T, S extends T> void addInstance(Class<S> clazz, T instance) {
        List instances = this.m_instanceMap.computeIfAbsent(clazz, key -> Lists.newArrayList());
        instances.add(instance);
    }
}

