/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.ConstantArgumentKind;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConstChecksKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirPartiallyResolvedArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationArgumentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkAnnotationArgumentWithSubElements", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers"})
public final class FirAnnotationArgumentChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirAnnotationArgumentChecker INSTANCE = new FirAnnotationArgumentChecker();

    private FirAnnotationArgumentChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(declaration2 instanceof FirAnnotationContainer)) {
            return;
        }
        for (FirAnnotationCall declarationOfAnnotation : ((FirAnnotationContainer)((Object)declaration2)).getAnnotations()) {
            FirCall $this$argumentMapping$iv22 = declarationOfAnnotation;
            boolean $i$f$getArgumentMapping2 = false;
            FirArgumentList argumentList$iv = $this$argumentMapping$iv22.getArgumentList();
            Map map = argumentList$iv instanceof FirResolvedArgumentList ? (Map)((FirResolvedArgumentList)argumentList$iv).getMapping() : (argumentList$iv instanceof FirPartiallyResolvedArgumentList ? (Map)((FirPartiallyResolvedArgumentList)argumentList$iv).getMapping() : null);
            if (map == null) continue;
            boolean $this$argumentMapping$iv22 = false;
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object object2;
                Map $i$f$getArgumentMapping2 = map = iterator2.next();
                boolean bl = false;
                FirExpression arg = (FirExpression)$i$f$getArgumentMapping2.getKey();
                Object object3 = object2 = arg instanceof FirNamedArgumentExpression ? (FirNamedArgumentExpression)arg : null;
                Object expression2 = object2 == null ? arg : ((object = ((FirNamedArgumentExpression)object2).getExpression()) == null ? arg : object);
                if ((object2 = this.checkAnnotationArgumentWithSubElements((FirExpression)expression2, context2.getSession(), reporter, context2)) == null) continue;
                object = object2;
                boolean bl2 = false;
                boolean bl3 = false;
                Object it = object;
                boolean bl4 = false;
                DiagnosticReporterKt.reportOn(reporter, ((FirExpression)expression2).getSource(), it, context2);
            }
        }
    }

    private final FirDiagnosticFactory0<KtExpression> checkAnnotationArgumentWithSubElements(FirExpression expression2, FirSession session2, DiagnosticReporter reporter, CheckerContext context2) {
        FirExpression firExpression2 = expression2;
        if (firExpression2 instanceof FirArrayOfCall) {
            boolean usedNonConst = false;
            for (FirExpression arg : ((FirArrayOfCall)expression2).getArgumentList().getArguments()) {
                FirSourceElement sourceForReport = arg.getSource();
                FirDiagnosticFactory0<KtExpression> err = this.checkAnnotationArgumentWithSubElements(arg, session2, reporter, context2);
                if (err == null) continue;
                if (!Intrinsics.areEqual(err, FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL())) {
                    usedNonConst = true;
                }
                DiagnosticReporterKt.reportOn(reporter, sourceForReport, err, context2);
            }
            if (usedNonConst) {
                return FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION();
            }
        } else if (firExpression2 instanceof FirVarargArgumentsExpression) {
            for (FirExpression arg : ((FirVarargArgumentsExpression)expression2).getArguments()) {
                FirDiagnosticFactory0<KtExpression> firDiagnosticFactory0 = this.checkAnnotationArgumentWithSubElements(arg, session2, reporter, context2);
                if (firDiagnosticFactory0 == null) continue;
                FirDiagnosticFactory0<KtExpression> firDiagnosticFactory02 = firDiagnosticFactory0;
                boolean bl = false;
                boolean bl2 = false;
                FirDiagnosticFactory0<KtExpression> it = firDiagnosticFactory02;
                boolean bl3 = false;
                DiagnosticReporterKt.reportOn(reporter, arg.getSource(), it, context2);
            }
        } else {
            FirDiagnosticFactory0<KtExpression> firDiagnosticFactory0;
            ConstantArgumentKind constantArgumentKind = FirConstChecksKt.checkConstantArguments(expression2, session2);
            int n = constantArgumentKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[constantArgumentKind.ordinal()];
            switch (n) {
                case 1: {
                    firDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_CONST();
                    break;
                }
                case 2: {
                    firDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_ENUM_CONST();
                    break;
                }
                case 3: {
                    firDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL();
                    break;
                }
                case 4: {
                    firDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR();
                    break;
                }
                case 5: {
                    firDiagnosticFactory0 = FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION();
                    break;
                }
                case -1: {
                    firDiagnosticFactory0 = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return firDiagnosticFactory0;
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstantArgumentKind.values().length];
            nArray[ConstantArgumentKind.NOT_CONST.ordinal()] = 1;
            nArray[ConstantArgumentKind.ENUM_NOT_CONST.ordinal()] = 2;
            nArray[ConstantArgumentKind.NOT_KCLASS_LITERAL.ordinal()] = 3;
            nArray[ConstantArgumentKind.KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR.ordinal()] = 4;
            nArray[ConstantArgumentKind.NOT_CONST_VAL_IN_CONST_EXPRESSION.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

