/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.DOMGroupManager;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.DefaultErrorHandler;
import org.apache.batik.svggen.DefaultStyleHandler;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.GenericImageHandler;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.SVGCSSStyler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphicContext;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.svggen.SVGShape;
import org.apache.batik.svggen.SVGSyntax;
import org.apache.batik.svggen.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGGraphics2D
extends AbstractGraphics2D
implements Cloneable,
SVGSyntax,
ErrorConstants {
    public static final String DEFAULT_XML_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_MAX_GC_OVERRIDES = 3;
    protected DOMTreeManager domTreeManager;
    protected DOMGroupManager domGroupManager;
    protected SVGGeneratorContext generatorCtx;
    protected SVGShape shapeConverter;
    protected Dimension svgCanvasSize;
    protected Graphics2D fmg;
    protected Set unsupportedAttributes;

    public final Dimension getSVGCanvasSize() {
        return this.svgCanvasSize;
    }

    public final void setSVGCanvasSize(Dimension dimension) {
        this.svgCanvasSize = new Dimension(dimension);
    }

    public final SVGGeneratorContext getGeneratorContext() {
        return this.generatorCtx;
    }

    public final SVGShape getShapeConverter() {
        return this.shapeConverter;
    }

    public final DOMTreeManager getDOMTreeManager() {
        return this.domTreeManager;
    }

    protected final void setDOMTreeManager(DOMTreeManager dOMTreeManager) {
        this.domTreeManager = dOMTreeManager;
        this.generatorCtx.genericImageHandler.setDOMTreeManager(this.domTreeManager);
    }

    protected final DOMGroupManager getDOMGroupManager() {
        return this.domGroupManager;
    }

    protected final void setDOMGroupManager(DOMGroupManager dOMGroupManager) {
        this.domGroupManager = dOMGroupManager;
    }

    public final Document getDOMFactory() {
        return this.generatorCtx.domFactory;
    }

    public final ImageHandler getImageHandler() {
        return this.generatorCtx.imageHandler;
    }

    public final GenericImageHandler getGenericImageHandler() {
        return this.generatorCtx.genericImageHandler;
    }

    public final ExtensionHandler getExtensionHandler() {
        return this.generatorCtx.extensionHandler;
    }

    public final void setExtensionHandler(ExtensionHandler extensionHandler) {
        this.generatorCtx.setExtensionHandler(extensionHandler);
    }

    public SVGGraphics2D(Document document) {
        this(SVGGeneratorContext.createDefault(document), false);
    }

    public SVGGraphics2D(Document document, ImageHandler imageHandler, ExtensionHandler extensionHandler, boolean bl) {
        this(SVGGraphics2D.buildSVGGeneratorContext(document, imageHandler, extensionHandler), bl);
    }

    public static SVGGeneratorContext buildSVGGeneratorContext(Document document, ImageHandler imageHandler, ExtensionHandler extensionHandler) {
        SVGGeneratorContext sVGGeneratorContext = new SVGGeneratorContext(document);
        sVGGeneratorContext.setIDGenerator(new SVGIDGenerator());
        sVGGeneratorContext.setExtensionHandler(extensionHandler);
        sVGGeneratorContext.setImageHandler(imageHandler);
        sVGGeneratorContext.setStyleHandler(new DefaultStyleHandler());
        sVGGeneratorContext.setComment("Generated by the Batik Graphics2D SVG Generator");
        sVGGeneratorContext.setErrorHandler(new DefaultErrorHandler());
        return sVGGeneratorContext;
    }

    public SVGGraphics2D(SVGGeneratorContext sVGGeneratorContext, boolean bl) {
        super(bl);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.unsupportedAttributes = new HashSet();
        this.unsupportedAttributes.add(TextAttribute.BACKGROUND);
        this.unsupportedAttributes.add(TextAttribute.BIDI_EMBEDDING);
        this.unsupportedAttributes.add(TextAttribute.CHAR_REPLACEMENT);
        this.unsupportedAttributes.add(TextAttribute.JUSTIFICATION);
        this.unsupportedAttributes.add(TextAttribute.RUN_DIRECTION);
        this.unsupportedAttributes.add(TextAttribute.SUPERSCRIPT);
        this.unsupportedAttributes.add(TextAttribute.SWAP_COLORS);
        this.unsupportedAttributes.add(TextAttribute.TRANSFORM);
        this.unsupportedAttributes.add(TextAttribute.WIDTH);
        if (sVGGeneratorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        this.setGeneratorContext(sVGGeneratorContext);
    }

    protected void setGeneratorContext(SVGGeneratorContext sVGGeneratorContext) {
        this.generatorCtx = sVGGeneratorContext;
        this.gc = new GraphicContext(new AffineTransform());
        SVGGeneratorContext.GraphicContextDefaults graphicContextDefaults = sVGGeneratorContext.getGraphicContextDefaults();
        if (graphicContextDefaults != null) {
            if (graphicContextDefaults.getPaint() != null) {
                this.gc.setPaint(graphicContextDefaults.getPaint());
            }
            if (graphicContextDefaults.getStroke() != null) {
                this.gc.setStroke(graphicContextDefaults.getStroke());
            }
            if (graphicContextDefaults.getComposite() != null) {
                this.gc.setComposite(graphicContextDefaults.getComposite());
            }
            if (graphicContextDefaults.getClip() != null) {
                this.gc.setClip(graphicContextDefaults.getClip());
            }
            if (graphicContextDefaults.getRenderingHints() != null) {
                this.gc.setRenderingHints(graphicContextDefaults.getRenderingHints());
            }
            if (graphicContextDefaults.getFont() != null) {
                this.gc.setFont(graphicContextDefaults.getFont());
            }
            if (graphicContextDefaults.getBackground() != null) {
                this.gc.setBackground(graphicContextDefaults.getBackground());
            }
        }
        this.shapeConverter = new SVGShape(sVGGeneratorContext);
        this.domTreeManager = new DOMTreeManager(this.gc, sVGGeneratorContext, 3);
        this.domGroupManager = new DOMGroupManager(this.gc, this.domTreeManager);
        this.domTreeManager.addGroupManager(this.domGroupManager);
        sVGGeneratorContext.genericImageHandler.setDOMTreeManager(this.domTreeManager);
    }

    public SVGGraphics2D(SVGGraphics2D sVGGraphics2D) {
        super(sVGGraphics2D);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.unsupportedAttributes = new HashSet();
        this.unsupportedAttributes.add(TextAttribute.BACKGROUND);
        this.unsupportedAttributes.add(TextAttribute.BIDI_EMBEDDING);
        this.unsupportedAttributes.add(TextAttribute.CHAR_REPLACEMENT);
        this.unsupportedAttributes.add(TextAttribute.JUSTIFICATION);
        this.unsupportedAttributes.add(TextAttribute.RUN_DIRECTION);
        this.unsupportedAttributes.add(TextAttribute.SUPERSCRIPT);
        this.unsupportedAttributes.add(TextAttribute.SWAP_COLORS);
        this.unsupportedAttributes.add(TextAttribute.TRANSFORM);
        this.unsupportedAttributes.add(TextAttribute.WIDTH);
        this.generatorCtx = sVGGraphics2D.generatorCtx;
        this.gc.validateTransformStack();
        this.shapeConverter = sVGGraphics2D.shapeConverter;
        this.domTreeManager = sVGGraphics2D.domTreeManager;
        this.domGroupManager = new DOMGroupManager(this.gc, this.domTreeManager);
        this.domTreeManager.addGroupManager(this.domGroupManager);
    }

    public void stream(String string) throws SVGGraphics2DIOException {
        this.stream(string, false);
    }

    public void stream(String string, boolean bl) throws SVGGraphics2DIOException {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), DEFAULT_XML_ENCODING);
            this.stream(outputStreamWriter, bl);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            throw sVGGraphics2DIOException;
        }
        catch (IOException iOException) {
            this.generatorCtx.errorHandler.handleError(new SVGGraphics2DIOException(iOException));
        }
    }

    public void stream(Writer writer) throws SVGGraphics2DIOException {
        this.stream(writer, false);
    }

    public void stream(Writer writer, boolean bl, boolean bl2) throws SVGGraphics2DIOException {
        Element element = this.getRoot();
        this.stream(element, writer, bl, bl2);
    }

    public void stream(Writer writer, boolean bl) throws SVGGraphics2DIOException {
        Element element = this.getRoot();
        this.stream(element, writer, bl, false);
    }

    public void stream(Element element, Writer writer) throws SVGGraphics2DIOException {
        this.stream(element, writer, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stream(Element element, Writer writer, boolean bl, boolean bl2) throws SVGGraphics2DIOException {
        Node node;
        Node node2;
        block10: {
            node2 = element.getParentNode();
            node = element.getNextSibling();
            try {
                try {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
                    DocumentFragment documentFragment = element.getOwnerDocument().createDocumentFragment();
                    documentFragment.appendChild(element);
                    if (bl) {
                        SVGCSSStyler.style(documentFragment);
                    }
                    XmlWriter.writeXml(documentFragment, writer, bl2);
                    writer.flush();
                }
                catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
                    this.generatorCtx.errorHandler.handleError(sVGGraphics2DIOException);
                    Object var9_11 = null;
                    if (node2 == null) return;
                    if (node == null) {
                        node2.appendChild(element);
                        return;
                    }
                    node2.insertBefore(element, node);
                    return;
                }
                catch (IOException iOException) {
                    this.generatorCtx.errorHandler.handleError(new SVGGraphics2DIOException(iOException));
                    Object var9_12 = null;
                    if (node2 == null) return;
                    if (node == null) {
                        node2.appendChild(element);
                        return;
                    }
                    node2.insertBefore(element, node);
                    return;
                }
                Object var9_10 = null;
                if (node2 == null) return;
                if (node != null) break block10;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (node2 == null) throw throwable;
                if (node == null) {
                    node2.appendChild(element);
                    throw throwable;
                }
                node2.insertBefore(element, node);
                throw throwable;
            }
            node2.appendChild(element);
            return;
        }
        node2.insertBefore(element, node);
    }

    public List getDefinitionSet() {
        return this.domTreeManager.getDefinitionSet();
    }

    public Element getTopLevelGroup() {
        return this.getTopLevelGroup(true);
    }

    public Element getTopLevelGroup(boolean bl) {
        return this.domTreeManager.getTopLevelGroup(bl);
    }

    public void setTopLevelGroup(Element element) {
        this.domTreeManager.setTopLevelGroup(element);
    }

    public Element getRoot() {
        return this.getRoot(null);
    }

    public Element getRoot(Element element) {
        element = this.domTreeManager.getRoot(element);
        if (this.svgCanvasSize != null) {
            element.setAttributeNS(null, "width", String.valueOf(this.svgCanvasSize.width));
            element.setAttributeNS(null, "height", String.valueOf(this.svgCanvasSize.height));
        }
        return element;
    }

    public Graphics create() {
        return new SVGGraphics2D(this);
    }

    public void setXORMode(Color color) {
        this.generatorCtx.errorHandler.handleError(new SVGGraphics2DRuntimeException("XOR Mode is not supported by Graphics2D SVG Generator"));
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.fmg.getFontMetrics(font);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform = this.getGenericImageHandler().handleImage(image, element, n, n2, image.getWidth(null), image.getHeight(null), this.getGeneratorContext());
        if (affineTransform == null) {
            this.domGroupManager.addElement(element);
        } else {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform2);
        }
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform = this.getGenericImageHandler().handleImage(image, element, n, n2, n3, n4, this.getGeneratorContext());
        if (affineTransform == null) {
            this.domGroupManager.addElement(element);
        } else {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform2);
        }
        return true;
    }

    public void dispose() {
        this.domTreeManager.removeGroupManager(this.domGroupManager);
    }

    public void draw(Shape shape) {
        Stroke stroke = this.gc.getStroke();
        if (stroke instanceof BasicStroke) {
            Element element = this.shapeConverter.toSVG(shape);
            if (element != null) {
                this.domGroupManager.addElement(element, (short)1);
            }
        } else {
            Shape shape2 = stroke.createStrokedShape(shape);
            this.fill(shape2);
        }
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        boolean bl = true;
        if (affineTransform == null) {
            bl = this.drawImage(image, 0, 0, null);
        } else if (affineTransform.getDeterminant() != 0.0) {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform);
            bl = this.drawImage(image, 0, 0, null);
            this.gc.transform(affineTransform2);
        } else {
            AffineTransform affineTransform3 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform);
            bl = this.drawImage(image, 0, 0, null);
            this.gc.setTransform(affineTransform3);
        }
        return bl;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage((Image)bufferedImage, n, n2, null);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform3 = this.getGenericImageHandler().handleImage(renderedImage, element, renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), this.getGeneratorContext());
        if (affineTransform == null) {
            affineTransform2 = affineTransform3;
        } else if (affineTransform3 == null) {
            affineTransform2 = affineTransform;
        } else {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(affineTransform3);
        }
        if (affineTransform2 == null) {
            this.domGroupManager.addElement(element);
        } else if (affineTransform2.getDeterminant() != 0.0) {
            AffineTransform affineTransform4 = null;
            try {
                affineTransform4 = affineTransform2.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform4);
        } else {
            AffineTransform affineTransform5 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.setTransform(affineTransform5);
        }
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform3 = this.getGenericImageHandler().handleImage(renderableImage, element, renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight(), this.getGeneratorContext());
        if (affineTransform == null) {
            affineTransform2 = affineTransform3;
        } else if (affineTransform3 == null) {
            affineTransform2 = affineTransform;
        } else {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(affineTransform3);
        }
        if (affineTransform2 == null) {
            this.domGroupManager.addElement(element);
        } else if (affineTransform2.getDeterminant() != 0.0) {
            AffineTransform affineTransform4 = null;
            try {
                affineTransform4 = affineTransform2.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform4);
        } else {
            AffineTransform affineTransform5 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.setTransform(affineTransform5);
        }
    }

    public void drawString(String string, float f, float f2) {
        if (this.textAsShapes) {
            GlyphVector glyphVector = this.getFont().createGlyphVector(this.getFontRenderContext(), string);
            this.drawGlyphVector(glyphVector, f, f2);
            return;
        }
        if (this.generatorCtx.svgFont) {
            this.domTreeManager.gcConverter.getFontConverter().recordFontUsage(string, this.getFont());
        }
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = this.transformText(f, f2);
        Element element = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "text");
        element.setAttributeNS(null, "x", this.generatorCtx.doubleString(f));
        element.setAttributeNS(null, "y", this.generatorCtx.doubleString(f2));
        element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        element.appendChild(this.getDOMFactory().createTextNode(string));
        this.domGroupManager.addElement(element, (short)16);
        if (affineTransform2 != null) {
            this.setTransform(affineTransform);
        }
    }

    private AffineTransform transformText(float f, float f2) {
        AffineTransform affineTransform = null;
        Font font = this.getFont();
        if (font != null) {
            affineTransform = font.getTransform();
            if (affineTransform != null && !affineTransform.isIdentity()) {
                AffineTransform affineTransform2 = new AffineTransform();
                affineTransform2.translate(f, f2);
                affineTransform2.concatenate(affineTransform);
                affineTransform2.translate(-f, -f2);
                this.transform(affineTransform2);
            } else {
                affineTransform = null;
            }
        }
        return affineTransform;
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        if (this.textAsShapes || this.usesUnsupportedAttributes(attributedCharacterIterator)) {
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
            textLayout.draw(this, f, f2);
            return;
        }
        boolean bl = false;
        if (attributedCharacterIterator.getRunLimit() < attributedCharacterIterator.getEndIndex()) {
            bl = true;
        }
        Element element = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "text");
        element.setAttributeNS(null, "x", this.generatorCtx.doubleString(f));
        element.setAttributeNS(null, "y", this.generatorCtx.doubleString(f2));
        element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        Font font = this.getFont();
        Paint paint = this.getPaint();
        char c = attributedCharacterIterator.first();
        this.setTextElementFill(attributedCharacterIterator);
        this.setTextFontAttributes(attributedCharacterIterator, font);
        SVGGraphicContext sVGGraphicContext = this.domTreeManager.getGraphicContextConverter().toSVG(this.gc);
        this.domGroupManager.addElement(element, (short)16);
        sVGGraphicContext.getContext().put("stroke", "none");
        sVGGraphicContext.getGroupContext().put("stroke", "none");
        boolean bl2 = true;
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = null;
        while (c != '\uffff') {
            Element element2 = element;
            if (bl) {
                element2 = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "tspan");
                element.appendChild(element2);
            }
            this.setTextElementFill(attributedCharacterIterator);
            boolean bl3 = this.setTextFontAttributes(attributedCharacterIterator, font);
            if (bl3 || bl2) {
                affineTransform2 = this.transformText(f, f2);
                bl2 = false;
            }
            int n = attributedCharacterIterator.getIndex();
            int n2 = attributedCharacterIterator.getRunLimit() - 1;
            StringBuffer stringBuffer = new StringBuffer(n2 - n);
            stringBuffer.append(c);
            for (int i = n; i < n2; ++i) {
                c = attributedCharacterIterator.next();
                stringBuffer.append(c);
            }
            String string = stringBuffer.toString();
            if (this.generatorCtx.isEmbeddedFontsOn()) {
                this.getDOMTreeManager().getGraphicContextConverter().getFontConverter().recordFontUsage(string, this.getFont());
            }
            SVGGraphicContext sVGGraphicContext2 = this.domTreeManager.gcConverter.toSVG(this.gc);
            sVGGraphicContext2.getGroupContext().put("stroke", "none");
            SVGGraphicContext sVGGraphicContext3 = DOMGroupManager.processDeltaGC(sVGGraphicContext2, sVGGraphicContext);
            this.setTextElementAttributes(sVGGraphicContext3, attributedCharacterIterator);
            this.domTreeManager.getStyleHandler().setStyle(element2, sVGGraphicContext3.getContext(), this.domTreeManager.getGeneratorContext());
            element2.appendChild(this.getDOMFactory().createTextNode(string));
            if ((bl3 || bl2) && affineTransform2 != null) {
                this.setTransform(affineTransform);
            }
            c = attributedCharacterIterator.next();
        }
        this.setFont(font);
        this.setPaint(paint);
    }

    public void fill(Shape shape) {
        Element element = this.shapeConverter.toSVG(shape);
        if (element != null) {
            this.domGroupManager.addElement(element, (short)16);
        }
    }

    private boolean setTextFontAttributes(AttributedCharacterIterator attributedCharacterIterator, Font font) {
        boolean bl = false;
        if (attributedCharacterIterator.getAttribute(TextAttribute.FONT) != null || attributedCharacterIterator.getAttribute(TextAttribute.FAMILY) != null || attributedCharacterIterator.getAttribute(TextAttribute.WEIGHT) != null || attributedCharacterIterator.getAttribute(TextAttribute.POSTURE) != null || attributedCharacterIterator.getAttribute(TextAttribute.SIZE) != null) {
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            Font font2 = font.deriveFont(map);
            this.setFont(font2);
            bl = true;
        }
        return bl;
    }

    private void setTextElementFill(AttributedCharacterIterator attributedCharacterIterator) {
        if (attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND) != null) {
            Color color = (Color)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
            this.setPaint(color);
        }
    }

    private void setTextElementAttributes(SVGGraphicContext sVGGraphicContext, AttributedCharacterIterator attributedCharacterIterator) {
        int n;
        String string = "";
        if (this.isUnderline(attributedCharacterIterator)) {
            string = string + "underline ";
        }
        if (this.isStrikeThrough(attributedCharacterIterator)) {
            string = string + "line-through ";
        }
        if ((n = string.length()) != 0) {
            sVGGraphicContext.getContext().put("text-decoration", string.substring(0, n - 1));
        }
    }

    private boolean isBold(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.WEIGHT);
        if (object == null) {
            return false;
        }
        if (object.equals(TextAttribute.WEIGHT_REGULAR)) {
            return false;
        }
        if (object.equals(TextAttribute.WEIGHT_DEMILIGHT)) {
            return false;
        }
        if (object.equals(TextAttribute.WEIGHT_EXTRA_LIGHT)) {
            return false;
        }
        return !object.equals(TextAttribute.WEIGHT_LIGHT);
    }

    private boolean isItalic(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.POSTURE);
        return TextAttribute.POSTURE_OBLIQUE.equals(object);
    }

    private boolean isUnderline(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.UNDERLINE);
        return TextAttribute.UNDERLINE_ON.equals(object);
    }

    private boolean isStrikeThrough(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.STRIKETHROUGH);
        return TextAttribute.STRIKETHROUGH_ON.equals(object);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public void setUnsupportedAttributes(Set set) {
        this.unsupportedAttributes = set == null ? null : new HashSet(set);
    }

    public boolean usesUnsupportedAttributes(AttributedCharacterIterator attributedCharacterIterator) {
        if (this.unsupportedAttributes == null) {
            return false;
        }
        Set<AttributedCharacterIterator.Attribute> set = attributedCharacterIterator.getAllAttributeKeys();
        Iterator<AttributedCharacterIterator.Attribute> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!this.unsupportedAttributes.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }
}

