from typing import Text

class GeoIP2Error(RuntimeError): ...
class AddressNotFoundError(GeoIP2Error): ...
class AuthenticationError(GeoIP2Error): ...

class HTTPError(GeoIP2Error):
    http_status: int | None
    uri: Text | None
    def __init__(self, message: Text, http_status: int | None = ..., uri: Text | None = ...) -> None: ...

class InvalidRequestError(GeoIP2Error): ...
class OutOfQueriesError(GeoIP2Error): ...
class PermissionRequiredError(GeoIP2Error): ...
