/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.TabDecorator;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.swing.tabcontrol.TabData;

public class ProjectColorTabDecorator
extends TabDecorator {
    private static final Map<Object, Color> project2color;
    private static final Map<TabData, Color> tab2color;
    private static final List<Color> backGroundColors;
    private static Color foregroundColor;
    private static final ChangeListener projectsListener;

    public static void setActive(boolean bl) {
        if (bl) {
            ProjectSupport.getDefault().addChangeListener(projectsListener);
            ProjectColorTabDecorator.updateColorMapping();
        } else {
            ProjectSupport.getDefault().removeChangeListener(projectsListener);
        }
    }

    public ProjectColorTabDecorator() {
        ProjectColorTabDecorator.updateColorMapping();
    }

    @Override
    public String getText(TabData tabData) {
        return null;
    }

    @Override
    public Icon getIcon(TabData tabData) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color getBackground(TabData tabData, boolean bl) {
        if (bl || !Settings.getDefault().isSameProjectSameColor()) {
            return null;
        }
        Color color = null;
        Map<TabData, Color> map = tab2color;
        synchronized (map) {
            color = tab2color.get(tabData);
            if (null == color && null != (color = ProjectColorTabDecorator.getColorForTab(tabData))) {
                tab2color.put(tabData, color);
            }
        }
        return color;
    }

    @Override
    public Color getForeground(TabData tabData, boolean bl) {
        if (bl || !Settings.getDefault().isSameProjectSameColor()) {
            return null;
        }
        return null == this.getBackground(tabData, bl) ? null : foregroundColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintAfter(TabData tabData, Graphics graphics, Rectangle rectangle, boolean bl) {
        if (!bl || !Settings.getDefault().isSameProjectSameColor()) {
            return;
        }
        Color color = null;
        Object object = tab2color;
        synchronized (object) {
            color = tab2color.get(tabData);
            if (null == color) {
                color = ProjectColorTabDecorator.getColorForTab(tabData);
                if (null == color) {
                    return;
                }
                tab2color.put(tabData, color);
            }
        }
        graphics.setColor(color);
        object = new Rectangle(rectangle);
        ((Rectangle)object).y += ((Rectangle)object).height - 3;
        ((Rectangle)object).grow(-1, -1);
        graphics.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateColorMapping() {
        ProjectSupport.ProjectProxy[] projectProxyArray = ProjectSupport.getDefault().getOpenProjects();
        Map<Object, Color> map = project2color;
        synchronized (map) {
            Color color;
            HashMap<Object, Color> hashMap = new HashMap<Object, Color>(project2color);
            project2color.clear();
            ArrayList<Color> arrayList = new ArrayList<Color>(backGroundColors);
            for (ProjectSupport.ProjectProxy projectProxy : projectProxyArray) {
                color = (Color)hashMap.get(projectProxy.getToken());
                if (null == color) continue;
                arrayList.remove(color);
                project2color.put(projectProxy.getToken(), color);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            for (ProjectSupport.ProjectProxy projectProxy : projectProxyArray) {
                color = project2color.get(projectProxy.getToken());
                if (null != color) continue;
                color = (Color)arrayList.get(0);
                project2color.put(projectProxy.getToken(), color);
                arrayList.remove(color);
                if (arrayList.isEmpty()) break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Color getColorForTab(TabData tabData) {
        ProjectSupport.ProjectProxy projectProxy = ProjectSupport.getDefault().getProjectForTab(tabData);
        if (null != projectProxy) {
            Map<Object, Color> map = project2color;
            synchronized (map) {
                return project2color.get(projectProxy.getToken());
            }
        }
        return null;
    }

    static {
        ProjectSupport projectSupport;
        project2color = new WeakHashMap<Object, Color>(10);
        tab2color = new WeakHashMap<TabData, Color>(10);
        projectsListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ProjectColorTabDecorator.updateColorMapping();
            }
        };
        backGroundColors = new ArrayList<Color>(10);
        if (UIManager.getColor("nb.multitabs.project.1.background") != null) {
            Color color;
            for (int i = 1; i <= 100 && (color = UIManager.getColor("nb.multitabs.project." + i + ".background")) != null; ++i) {
                backGroundColors.add(color);
            }
        } else {
            backGroundColors.add(new Color(216, 255, 237));
            backGroundColors.add(new Color(255, 221, 221));
            backGroundColors.add(new Color(255, 247, 214));
            backGroundColors.add(new Color(216, 239, 255));
            backGroundColors.add(new Color(241, 255, 209));
            backGroundColors.add(new Color(255, 225, 209));
            backGroundColors.add(new Color(228, 255, 216));
            backGroundColors.add(new Color(227, 255, 158));
            backGroundColors.add(new Color(238, 209, 255));
        }
        foregroundColor = UIManager.getColor("nb.multitabs.project.foreground");
        if (foregroundColor == null) {
            foregroundColor = Color.BLACK;
        }
        if ((projectSupport = ProjectSupport.getDefault()).isEnabled() && Settings.getDefault().isSameProjectSameColor()) {
            projectSupport.addChangeListener(projectsListener);
        }
        ProjectColorTabDecorator.updateColorMapping();
    }
}

