# This file has been autogenerated by the pywayland scanner

# Copyright © 2017 Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Global, Interface, Proxy, Resource


class ZwpKeyboardShortcutsInhibitorV1(Interface):
    """Context object for keyboard shortcuts inhibitor

    A keyboard shortcuts inhibitor instructs the compositor to ignore its own
    keyboard shortcuts when the associated surface has keyboard focus. As a
    result, when the surface has keyboard focus on the given seat, it will
    receive all key events originating from the specified seat, even those
    which would normally be caught by the compositor for its own shortcuts.

    The Wayland compositor is however under no obligation to disable all of its
    shortcuts, and may keep some special key combo for its own use, including
    but not limited to one allowing the user to forcibly restore normal
    keyboard events routing in the case of an unwilling client. The compositor
    may also use the same key combo to reactivate an existing shortcut
    inhibitor that was previously deactivated on user request.

    When the compositor restores its own keyboard shortcuts, an "inactive"
    event is emitted to notify the client that the keyboard shortcuts inhibitor
    is not effectively active for the surface and seat any more, and the client
    should not expect to receive all keyboard events.

    When the keyboard shortcuts inhibitor is inactive, the client has no way to
    forcibly reactivate the keyboard shortcuts inhibitor.

    The user can chose to re-enable a previously deactivated keyboard shortcuts
    inhibitor using any mechanism the compositor may offer, in which case the
    compositor will send an "active" event to notify the client.

    If the surface is destroyed, unmapped, or loses the seat's keyboard focus,
    the keyboard shortcuts inhibitor becomes irrelevant and the compositor will
    restore its own keyboard shortcuts but no "inactive" event is emitted in
    this case.
    """

    name = "zwp_keyboard_shortcuts_inhibitor_v1"
    version = 1


class ZwpKeyboardShortcutsInhibitorV1Proxy(Proxy):
    interface = ZwpKeyboardShortcutsInhibitorV1

    @ZwpKeyboardShortcutsInhibitorV1.request()
    def destroy(self):
        """Destroy the keyboard shortcuts inhibitor object

        Remove the keyboard shortcuts inhibitor from the associated
        :class:`~pywayland.protocol.wayland.WlSurface`.
        """
        self._marshal(0)
        self._destroy()


class ZwpKeyboardShortcutsInhibitorV1Resource(Resource):
    interface = ZwpKeyboardShortcutsInhibitorV1

    @ZwpKeyboardShortcutsInhibitorV1.event()
    def active(self):
        """Shortcuts are inhibited

        This event indicates that the shortcut inhibitor is active.

        The compositor sends this event every time compositor shortcuts are
        inhibited on behalf of the surface. When active, the client may receive
        input events normally reserved by the compositor (see
        :class:`ZwpKeyboardShortcutsInhibitorV1`).

        This occurs typically when the initial request "inhibit_shortcuts"
        first becomes active or when the user instructs the compositor to re-
        enable and existing shortcuts inhibitor using any mechanism offered by
        the compositor.
        """
        self._post_event(0)

    @ZwpKeyboardShortcutsInhibitorV1.event()
    def inactive(self):
        """Shortcuts are restored

        This event indicates that the shortcuts inhibitor is inactive, normal
        shortcuts processing is restored by the compositor.
        """
        self._post_event(1)


class ZwpKeyboardShortcutsInhibitorV1Global(Global):
    interface = ZwpKeyboardShortcutsInhibitorV1


ZwpKeyboardShortcutsInhibitorV1._gen_c()
ZwpKeyboardShortcutsInhibitorV1.proxy_class = ZwpKeyboardShortcutsInhibitorV1Proxy
ZwpKeyboardShortcutsInhibitorV1.resource_class = ZwpKeyboardShortcutsInhibitorV1Resource
ZwpKeyboardShortcutsInhibitorV1.global_class = ZwpKeyboardShortcutsInhibitorV1Global
