/**
 * SECTION:birthday-details
 * @short_description: Birthday details for a contact.
 * 
 * <para>This allows representation of the birth date and associated calendar event ID of a contact.</para>
 *
 * Since: 0.4.0
 */
/**
 * folks_birthday_details_change_birthday:
 * @self: the <link linkend="FolksBirthdayDetails"><type>FolksBirthdayDetails</type></link> instance
 * @birthday: (in) (allow-none): &nbsp;.  <para>the new birthday (or <code>null</code> to unset the birthday) </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s birthday.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksBirthdayDetails--birthday"><type>"birthday"</type></link> directly, as this method gives error notification and will only return once the birthday has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the birthday failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-birthday-details-change-birthday-finish"><function>folks_birthday_details_change_birthday_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_birthday_details_change_birthday_finish:
 * @self: the <link linkend="FolksBirthdayDetails"><type>FolksBirthdayDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s birthday.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksBirthdayDetails--birthday"><type>"birthday"</type></link> directly, as this method gives error notification and will only return once the birthday has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the birthday failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-birthday-details-change-birthday"><function>folks_birthday_details_change_birthday()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_birthday_details_change_calendar_event_id:
 * @self: the <link linkend="FolksBirthdayDetails"><type>FolksBirthdayDetails</type></link> instance
 * @event_id: (in) (allow-none): &nbsp;.  <para>the new birthday event ID (or <code>null</code> to unset the event ID) </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s birthday event ID.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksBirthdayDetails--calendar-event-id"><type>"calendar-event-id"</type></link> directly, as this method gives error notification and will only return once the event has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the birthday event ID failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-birthday-details-change-calendar-event-id-finish"><function>folks_birthday_details_change_calendar_event_id_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_birthday_details_change_calendar_event_id_finish:
 * @self: the <link linkend="FolksBirthdayDetails"><type>FolksBirthdayDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s birthday event ID.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksBirthdayDetails--calendar-event-id"><type>"calendar-event-id"</type></link> directly, as this method gives error notification and will only return once the event has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the birthday event ID failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-birthday-details-change-calendar-event-id"><function>folks_birthday_details_change_calendar_event_id()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksBirthdayDetails:birthday:
 * 
 * The birthday of the <link linkend="FolksPersona"><type>FolksPersona</type></link> and <link linkend="FolksIndividual"><type>FolksIndividual</type></link>. This is assumed to be in UTC.
 * 
 * <para>If this is <code>null</code>, the contact&apos;s birthday isn&apos;t known.</para>
 *
 * Since: 0.4.0
 */
/**
 * folks_birthday_details_get_birthday:
 * @self: the <link linkend="FolksBirthdayDetails"><type>FolksBirthdayDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksBirthdayDetails--birthday"><type>"birthday"</type></link> property.
 * 
 * The birthday of the <link linkend="FolksPersona"><type>FolksPersona</type></link> and <link linkend="FolksIndividual"><type>FolksIndividual</type></link>. This is assumed to be in UTC.
 * 
 * <para>If this is <code>null</code>, the contact&apos;s birthday isn&apos;t known.</para>
 * 
 * Returns: the value of the <link linkend="FolksBirthdayDetails--birthday"><type>"birthday"</type></link> property
 *
 * Since: 0.4.0
 */
/**
 * folks_birthday_details_set_birthday:
 * @self: the <link linkend="FolksBirthdayDetails"><type>FolksBirthdayDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksBirthdayDetails--birthday"><type>"birthday"</type></link> property
 * 
 * Set the value of the <link linkend="FolksBirthdayDetails--birthday"><type>"birthday"</type></link> property to @value.
 * 
 * The birthday of the <link linkend="FolksPersona"><type>FolksPersona</type></link> and <link linkend="FolksIndividual"><type>FolksIndividual</type></link>. This is assumed to be in UTC.
 * 
 * <para>If this is <code>null</code>, the contact&apos;s birthday isn&apos;t known.</para>
 *
 * Since: 0.4.0
 */
/**
 * FolksBirthdayDetails:calendar-event-id:
 * 
 * The event ID of the birthday event from the source calendar.
 * 
 * <para>If this is <code>null</code>, the birthday event is unknown. The semantics of the event ID are left unspecified by folks.</para>
 *
 * Since: 0.4.0
 */
/**
 * folks_birthday_details_get_calendar_event_id:
 * @self: the <link linkend="FolksBirthdayDetails"><type>FolksBirthdayDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksBirthdayDetails--calendar-event-id"><type>"calendar-event-id"</type></link> property.
 * 
 * The event ID of the birthday event from the source calendar.
 * 
 * <para>If this is <code>null</code>, the birthday event is unknown. The semantics of the event ID are left unspecified by folks.</para>
 * 
 * Returns: the value of the <link linkend="FolksBirthdayDetails--calendar-event-id"><type>"calendar-event-id"</type></link> property
 *
 * Since: 0.4.0
 */
/**
 * folks_birthday_details_set_calendar_event_id:
 * @self: the <link linkend="FolksBirthdayDetails"><type>FolksBirthdayDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksBirthdayDetails--calendar-event-id"><type>"calendar-event-id"</type></link> property
 * 
 * Set the value of the <link linkend="FolksBirthdayDetails--calendar-event-id"><type>"calendar-event-id"</type></link> property to @value.
 * 
 * The event ID of the birthday event from the source calendar.
 * 
 * <para>If this is <code>null</code>, the birthday event is unknown. The semantics of the event ID are left unspecified by folks.</para>
 *
 * Since: 0.4.0
 */
/**
 * FolksBirthdayDetails:
 * 
 * Birthday details for a contact.
 * 
 * <para>This allows representation of the birth date and associated calendar event ID of a contact.</para>
 *
 * Since: 0.4.0
 */
/**
 * FolksBirthdayDetailsIface:
 * @change_birthday: virtual method called by <link linkend="folks-birthday-details-change-birthday"><function>folks_birthday_details_change_birthday()</function></link>
 * @change_birthday_finish: asynchronous finish function for <structfield>change_birthday</structfield>, called by <link linkend="folks-birthday-details-change-birthday"><function>folks_birthday_details_change_birthday()</function></link>
 * @change_calendar_event_id: virtual method called by <link linkend="folks-birthday-details-change-calendar-event-id"><function>folks_birthday_details_change_calendar_event_id()</function></link>
 * @change_calendar_event_id_finish: asynchronous finish function for <structfield>change_calendar_event_id</structfield>, called by <link linkend="folks-birthday-details-change-calendar-event-id"><function>folks_birthday_details_change_calendar_event_id()</function></link>
 * @get_birthday: getter method for the abstract property <link linkend="FolksBirthdayDetails--birthday"><type>"birthday"</type></link>
 * @set_birthday: setter method for the abstract property <link linkend="FolksBirthdayDetails--birthday"><type>"birthday"</type></link>
 * @get_calendar_event_id: getter method for the abstract property <link linkend="FolksBirthdayDetails--calendar-event-id"><type>"calendar-event-id"</type></link>
 * @set_calendar_event_id: setter method for the abstract property <link linkend="FolksBirthdayDetails--calendar-event-id"><type>"calendar-event-id"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksBirthdayDetails"><type>FolksBirthdayDetails</type></link> implementations.
 */
