/*
 * Decompiled with CFR 0.152.
 */
package mediathek.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import mediathek.config.Config;
import mediathek.config.Konstanten;
import mediathek.filmlisten.FilmListDownloadType;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0013H\u0007J\b\u0010\u0015\u001a\u00020\u0013H\u0007J\b\u0010\u0016\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lmediathek/config/StandardLocations;", "", "()V", "LOCKFILE_NAME", "", "OSX_CACHE_DIRECTORY_NAME", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "portableBaseDirectory", "getPortableBaseDirectory", "()Ljava/lang/String;", "setPortableBaseDirectory", "(Ljava/lang/String;)V", "getFilmListUrl", "type", "Lmediathek/filmlisten/FilmListDownloadType;", "getFilmlistFilePath", "getLockFilePath", "Ljava/nio/file/Path;", "getMediathekXmlFile", "getSettingsDirectory", "getStandardDownloadPath", "MediathekView"})
public final class StandardLocations {
    @NotNull
    public static final StandardLocations INSTANCE = new StandardLocations();
    @Nullable
    private static String portableBaseDirectory;
    private static final Logger logger;
    @NotNull
    private static final String OSX_CACHE_DIRECTORY_NAME = "Library/Caches/MediathekView";
    @NotNull
    private static final String LOCKFILE_NAME = "MediathekView.lock";

    private StandardLocations() {
    }

    @Nullable
    public final String getPortableBaseDirectory() {
        return portableBaseDirectory;
    }

    public final void setPortableBaseDirectory(@Nullable String string) {
        portableBaseDirectory = string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @JvmStatic
    @NotNull
    public static final Path getSettingsDirectory() throws IllegalStateException {
        if (StandardLocations.portableBaseDirectory == null) ** GOTO lbl-1000
        var1 = StandardLocations.portableBaseDirectory;
        Intrinsics.checkNotNull(var1);
        var1 = (CharSequence)var1;
        var2_2 = false;
        if (var1.length() == 0) lbl-1000:
        // 2 sources

        {
            var2_3 /* !! */  = new String[]{".mediathek3"};
            var1 = Paths.get(SystemUtils.USER_HOME, var2_3 /* !! */ );
            Intrinsics.checkNotNullExpressionValue(var1, "{\n            Paths.get(SystemUtils.USER_HOME, Konstanten.VERZEICHNIS_EINSTELLUNGEN)\n        }");
            v0 = var1;
        } else {
            var2_3 /* !! */  = StandardLocations.portableBaseDirectory;
            Intrinsics.checkNotNull(var2_3 /* !! */ );
            var1 = Paths.get((String)var2_3 /* !! */ , new String[0]);
            Intrinsics.checkNotNullExpressionValue(var1, "{\n            Paths.get(portableBaseDirectory!!)\n        }");
            v0 = baseDirectoryPath = var1;
        }
        if (Files.notExists((Path)baseDirectoryPath, new LinkOption[0])) {
            try {
                Files.createDirectories((Path)baseDirectoryPath, new FileAttribute[0]);
            }
            catch (IOException ioException) {
                var3_5 = StringCompanionObject.INSTANCE;
                var4_6 = "Der Ordner \"%s\" konnte nicht angelegt werden.%n Bitte pr\u00fcfen Sie die Dateirechte.";
                var5_7 = new Object[]{baseDirectoryPath.toString()};
                var6_8 = false;
                v1 = String.format(var4_6, Arrays.copyOf(var5_7, var5_7.length));
                Intrinsics.checkNotNullExpressionValue(v1, "java.lang.String.format(format, *args)");
                errMsg = v1;
                StandardLocations.logger.error(errMsg, (Throwable)ioException);
                throw new IllegalStateException(errMsg, ioException);
            }
        }
        return baseDirectoryPath;
    }

    @JvmStatic
    @NotNull
    public static final Path getMediathekXmlFile() throws InvalidPathException {
        Path path = INSTANCE.getSettingsDirectory().resolve("mediathek.xml");
        Intrinsics.checkNotNullExpressionValue(path, "getSettingsDirectory().resolve(Konstanten.CONFIG_FILE)");
        return path;
    }

    @JvmStatic
    @NotNull
    public static final String getStandardDownloadPath() throws InvalidPathException {
        Path path;
        String[] stringArray;
        String userHome = SystemUtils.USER_HOME;
        if (SystemUtils.IS_OS_MAC_OSX) {
            stringArray = new String[]{"Downloads"};
            path = Paths.get(userHome, stringArray);
        } else {
            stringArray = new String[]{"MediathekView"};
            path = Paths.get(userHome, stringArray);
        }
        Path path2 = path;
        return ((Object)path2.toAbsolutePath()).toString();
    }

    @JvmStatic
    @NotNull
    public static final String getFilmListUrl(@NotNull FilmListDownloadType type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        FilmListDownloadType filmListDownloadType = type;
        int n = WhenMappings.$EnumSwitchMapping$0[filmListDownloadType.ordinal()];
        return switch (n) {
            case 1 -> String.valueOf(Konstanten.ROUTER_BASE_URL.resolve("Filmliste-akt.xz"));
            case 2 -> String.valueOf(Konstanten.ROUTER_BASE_URL.resolve("Filmliste-diff.xz"));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @JvmStatic
    @NotNull
    public static final String getFilmlistFilePath() {
        String filePart = Intrinsics.stringPlus(File.separator, "filme.json");
        return Config.isPortableMode() ? INSTANCE.getSettingsDirectory() + filePart : (SystemUtils.IS_OS_MAC_OSX ? SystemUtils.USER_HOME + File.separator + OSX_CACHE_DIRECTORY_NAME + filePart : INSTANCE.getSettingsDirectory() + filePart);
    }

    @JvmStatic
    @NotNull
    public static final Path getLockFilePath() {
        Path path;
        if (SystemUtils.IS_OS_MAC_OSX) {
            Path path2 = Paths.get(SystemUtils.JAVA_IO_TMPDIR, new String[0]).resolve(LOCKFILE_NAME);
            Intrinsics.checkNotNullExpressionValue(path2, "get(SystemUtils.JAVA_IO_TMPDIR).resolve(LOCKFILE_NAME)");
            path = path2;
        } else {
            Path path3 = INSTANCE.getSettingsDirectory().resolve(LOCKFILE_NAME);
            Intrinsics.checkNotNullExpressionValue(path3, "{\n            getSettingsDirectory().resolve(LOCKFILE_NAME)\n        }");
            path = path3;
        }
        return path;
    }

    static {
        logger = LogManager.getLogger();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilmListDownloadType.values().length];
            nArray[FilmListDownloadType.FULL.ordinal()] = 1;
            nArray[FilmListDownloadType.DIFF_ONLY.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

