/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.gui.messages.GeoStateChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import org.apache.commons.configuration2.Configuration;
import org.jdesktop.swingx.VerticalLayout;

public class PanelEinstellungenGeo
extends JPanel {
    private final JFrame parentComponent;
    private JCheckBox jCheckBoxMarkieren;
    private JRadioButton jRadioButtonDe;
    private JRadioButton jRadioButtonCH;
    private JRadioButton jRadioButtonAt;
    private JRadioButton jRadioButtonEu;
    private JRadioButton jRadioButtonSonst;
    private JButton jButtonHilfe;

    public PanelEinstellungenGeo(JFrame pparentComponent) {
        this.parentComponent = pparentComponent;
        this.initComponents();
        this.init();
    }

    private void init() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        switch (config.getString("geo.location")) {
            case "CH": {
                this.jRadioButtonCH.setSelected(true);
                break;
            }
            case "AT": {
                this.jRadioButtonAt.setSelected(true);
                break;
            }
            case "EU": {
                this.jRadioButtonEu.setSelected(true);
                break;
            }
            case "WELT": {
                this.jRadioButtonSonst.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonDe.setSelected(true);
            }
        }
        this.jRadioButtonDe.addActionListener(e -> {
            config.setProperty("geo.location", "DE");
            this.filterBlacklistAndNotifyChanges();
        });
        this.jRadioButtonCH.addActionListener(e -> {
            config.setProperty("geo.location", "CH");
            this.filterBlacklistAndNotifyChanges();
        });
        this.jRadioButtonAt.addActionListener(e -> {
            config.setProperty("geo.location", "AT");
            this.filterBlacklistAndNotifyChanges();
        });
        this.jRadioButtonEu.addActionListener(e -> {
            config.setProperty("geo.location", "EU");
            this.filterBlacklistAndNotifyChanges();
        });
        this.jRadioButtonSonst.addActionListener(e -> {
            config.setProperty("geo.location", "WELT");
            this.filterBlacklistAndNotifyChanges();
        });
        this.jCheckBoxMarkieren.setSelected(config.getBoolean("geo.report"));
        this.jCheckBoxMarkieren.addActionListener(e -> {
            config.setProperty("geo.report", this.jCheckBoxMarkieren.isSelected());
            this.filterBlacklistAndNotifyChanges();
        });
        this.jButtonHilfe.setIcon(IconFontSwing.buildIcon(FontAwesome.QUESTION_CIRCLE_O, 16.0f));
        this.jButtonHilfe.addActionListener(e -> new DialogHilfe(this.parentComponent, true, new GetFile().getHilfeSuchen("/mediathek/file/hilfetext_geo.txt")).setVisible(true));
    }

    private void filterBlacklistAndNotifyChanges() {
        Daten daten = Daten.getInstance();
        daten.getListeBlacklist().filterListe();
        MessageBus.getMessageBus().publishAsync(new GeoStateChangedEvent());
        MessageBus.getMessageBus().publishAsync(new BlacklistChangedEvent());
    }

    private void initComponents() {
        JPanel jPanel6 = new JPanel();
        this.jCheckBoxMarkieren = new JCheckBox();
        JPanel panel1 = new JPanel();
        this.jRadioButtonDe = new JRadioButton();
        this.jRadioButtonCH = new JRadioButton();
        this.jRadioButtonAt = new JRadioButton();
        this.jRadioButtonEu = new JRadioButton();
        this.jRadioButtonSonst = new JRadioButton();
        this.jButtonHilfe = new JButton();
        jPanel6.setBorder(new TitledBorder("Geogeblockte Filme"));
        this.jCheckBoxMarkieren.setText("geblockte Sendungen gelb markieren");
        panel1.setBorder(new TitledBorder("Mein Standort"));
        panel1.setLayout(new VerticalLayout());
        this.jRadioButtonDe.setSelected(true);
        this.jRadioButtonDe.setText("DE - Deutschland");
        panel1.add(this.jRadioButtonDe);
        this.jRadioButtonCH.setText("CH - Schweiz");
        panel1.add(this.jRadioButtonCH);
        this.jRadioButtonAt.setText("AT - \u00d6sterreich");
        panel1.add(this.jRadioButtonAt);
        this.jRadioButtonEu.setText("EU (EBU - European Broadcasting Union)");
        panel1.add(this.jRadioButtonEu);
        this.jRadioButtonSonst.setText("Sonstiger");
        panel1.add(this.jRadioButtonSonst);
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jCheckBoxMarkieren).addGap(0, 150, Short.MAX_VALUE)).addComponent(panel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addGap(0, 331, Short.MAX_VALUE).addComponent(this.jButtonHilfe))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxMarkieren).addGap(18, 18, 18).addComponent(panel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfe).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel6, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel6, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.jRadioButtonDe);
        buttonGroup1.add(this.jRadioButtonCH);
        buttonGroup1.add(this.jRadioButtonAt);
        buttonGroup1.add(this.jRadioButtonEu);
        buttonGroup1.add(this.jRadioButtonSonst);
    }
}

