# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2011 Kristian Høgsberg
# Copyright © 2010-2011 Intel Corporation
# Copyright © 2012-2013 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

import enum

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource


class WlOutput(Interface):
    """Compositor output region

    An output describes part of the compositor geometry.  The compositor works
    in the 'compositor coordinate system' and an output corresponds to a
    rectangular area in that space that is actually visible.  This typically
    corresponds to a monitor that displays part of the compositor space.  This
    object is published as global during start up, or when a monitor is
    hotplugged.
    """

    name = "wl_output"
    version = 3

    class subpixel(enum.IntEnum):
        unknown = 0
        none = 1
        horizontal_rgb = 2
        horizontal_bgr = 3
        vertical_rgb = 4
        vertical_bgr = 5

    class transform(enum.IntEnum):
        normal = 0
        transform_90 = 1
        transform_180 = 2
        transform_270 = 3
        flipped = 4
        flipped_90 = 5
        flipped_180 = 6
        flipped_270 = 7

    class mode(enum.IntFlag):
        current = 0x1
        preferred = 0x2


class WlOutputProxy(Proxy):
    interface = WlOutput

    @WlOutput.request(version=3)
    def release(self):
        """Release the output object

        Using this request a client can tell the server that it is not going to
        use the output object anymore.
        """
        self._marshal(0)
        self._destroy()


class WlOutputResource(Resource):
    interface = WlOutput

    @WlOutput.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.String),
        Argument(ArgumentType.String),
        Argument(ArgumentType.Int),
    )
    def geometry(self, x, y, physical_width, physical_height, subpixel, make, model, transform):
        """Properties of the output

        The geometry event describes geometric properties of the output. The
        event is sent when binding to the output object and whenever any of the
        properties change.

        The physical size can be set to zero if it doesn't make sense for this
        output (e.g. for projectors or virtual outputs).

        Note: :class:`WlOutput` only advertises partial information about the
        output position and identification. Some compositors, for instance
        those not implementing a desktop-style output layout or those exposing
        virtual outputs, might fake this information. Instead of using x and y,
        clients should use xdg_output.logical_position. Instead of using make
        and model, clients should use xdg_output.name and
        xdg_output.description.

        :param x:
            x position within the global compositor space
        :type x:
            `ArgumentType.Int`
        :param y:
            y position within the global compositor space
        :type y:
            `ArgumentType.Int`
        :param physical_width:
            width in millimeters of the output
        :type physical_width:
            `ArgumentType.Int`
        :param physical_height:
            height in millimeters of the output
        :type physical_height:
            `ArgumentType.Int`
        :param subpixel:
            subpixel orientation of the output
        :type subpixel:
            `ArgumentType.Int`
        :param make:
            textual description of the manufacturer
        :type make:
            `ArgumentType.String`
        :param model:
            textual description of the model
        :type model:
            `ArgumentType.String`
        :param transform:
            transform that maps framebuffer to output
        :type transform:
            `ArgumentType.Int`
        """
        self._post_event(0, x, y, physical_width, physical_height, subpixel, make, model, transform)

    @WlOutput.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def mode(self, flags, width, height, refresh):
        """Advertise available modes for the output

        The mode event describes an available mode for the output.

        The event is sent when binding to the output object and there will
        always be one mode, the current mode.  The event is sent again if an
        output changes mode, for the mode that is now current.  In other words,
        the current mode is always the last mode that was received with the
        current flag set.

        Non-current modes are deprecated. A compositor can decide to only
        advertise the current mode and never send other modes. Clients should
        not rely on non-current modes.

        The size of a mode is given in physical hardware units of the output
        device. This is not necessarily the same as the output size in the
        global compositor space. For instance, the output may be scaled, as
        described in :func:`WlOutput.scale()`, or transformed, as described in
        :func:`WlOutput.transform()`. Clients willing to retrieve the output
        size in the global compositor space should use xdg_output.logical_size
        instead.

        The vertical refresh rate can be set to zero if it doesn't make sense
        for this output (e.g. for virtual outputs).

        Clients should not use the refresh rate to schedule frames. Instead,
        they should use the :func:`WlSurface.frame()
        <pywayland.protocol.wayland.WlSurface.frame>` event or the
        presentation-time protocol.

        Note: this information is not always meaningful for all outputs. Some
        compositors, such as those exposing virtual outputs, might fake the
        refresh rate or the size.

        :param flags:
            bitfield of mode flags
        :type flags:
            `ArgumentType.Uint`
        :param width:
            width of the mode in hardware units
        :type width:
            `ArgumentType.Int`
        :param height:
            height of the mode in hardware units
        :type height:
            `ArgumentType.Int`
        :param refresh:
            vertical refresh rate in mHz
        :type refresh:
            `ArgumentType.Int`
        """
        self._post_event(1, flags, width, height, refresh)

    @WlOutput.event(version=2)
    def done(self):
        """Sent all information about output

        This event is sent after all other properties have been sent after
        binding to the output object and after any other property changes done
        after that. This allows changes to the output properties to be seen as
        atomic, even if they happen via multiple events.
        """
        self._post_event(2)

    @WlOutput.event(
        Argument(ArgumentType.Int),
        version=2,
    )
    def scale(self, factor):
        """Output scaling properties

        This event contains scaling geometry information that is not in the
        geometry event. It may be sent after binding the output object or if
        the output scale changes later. If it is not sent, the client should
        assume a scale of 1.

        A scale larger than 1 means that the compositor will automatically
        scale surface buffers by this amount when rendering. This is used for
        very high resolution displays where applications rendering at the
        native resolution would be too small to be legible.

        It is intended that scaling aware clients track the current output of a
        surface, and if it is on a scaled output it should use
        :func:`WlSurface.set_buffer_scale()
        <pywayland.protocol.wayland.WlSurface.set_buffer_scale>` with the scale
        of the output. That way the compositor can avoid scaling the surface,
        and the client can supply a higher detail image.

        :param factor:
            scaling factor of output
        :type factor:
            `ArgumentType.Int`
        """
        self._post_event(3, factor)


class WlOutputGlobal(Global):
    interface = WlOutput


WlOutput._gen_c()
WlOutput.proxy_class = WlOutputProxy
WlOutput.resource_class = WlOutputResource
WlOutput.global_class = WlOutputGlobal
