/*===---- riscv_vector.h - RISC-V V-extension RVVIntrinsics -------------------===
 *
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

#ifndef __RISCV_VECTOR_H
#define __RISCV_VECTOR_H

#include <stdint.h>
#include <stddef.h>

#ifndef __riscv_vector
#error "Vector intrinsics require the vector extension."
#endif

#ifdef __cplusplus
extern "C" {
#endif


#define vsetvl_e8mf8(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 5)
#define vsetvl_e8mf4(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 6)
#define vsetvl_e8mf2(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 7)
#define vsetvl_e8m1(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 0)
#define vsetvl_e8m2(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 1)
#define vsetvl_e8m4(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 2)
#define vsetvl_e8m8(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 3)

#define vsetvl_e16mf4(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 6)
#define vsetvl_e16mf2(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 7)
#define vsetvl_e16m1(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 0)
#define vsetvl_e16m2(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 1)
#define vsetvl_e16m4(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 2)
#define vsetvl_e16m8(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 3)

#define vsetvl_e32mf2(avl) __builtin_rvv_vsetvli((size_t)(avl), 2, 7)
#define vsetvl_e32m1(avl) __builtin_rvv_vsetvli((size_t)(avl), 2, 0)
#define vsetvl_e32m2(avl) __builtin_rvv_vsetvli((size_t)(avl), 2, 1)
#define vsetvl_e32m4(avl) __builtin_rvv_vsetvli((size_t)(avl), 2, 2)
#define vsetvl_e32m8(avl) __builtin_rvv_vsetvli((size_t)(avl), 2, 3)

#define vsetvl_e64m1(avl) __builtin_rvv_vsetvli((size_t)(avl), 3, 0)
#define vsetvl_e64m2(avl) __builtin_rvv_vsetvli((size_t)(avl), 3, 1)
#define vsetvl_e64m4(avl) __builtin_rvv_vsetvli((size_t)(avl), 3, 2)
#define vsetvl_e64m8(avl) __builtin_rvv_vsetvli((size_t)(avl), 3, 3)


#define vsetvlmax_e8mf8() __builtin_rvv_vsetvlimax(0, 5)
#define vsetvlmax_e8mf4() __builtin_rvv_vsetvlimax(0, 6)
#define vsetvlmax_e8mf2() __builtin_rvv_vsetvlimax(0, 7)
#define vsetvlmax_e8m1() __builtin_rvv_vsetvlimax(0, 0)
#define vsetvlmax_e8m2() __builtin_rvv_vsetvlimax(0, 1)
#define vsetvlmax_e8m4() __builtin_rvv_vsetvlimax(0, 2)
#define vsetvlmax_e8m8() __builtin_rvv_vsetvlimax(0, 3)

#define vsetvlmax_e16mf4() __builtin_rvv_vsetvlimax(1, 6)
#define vsetvlmax_e16mf2() __builtin_rvv_vsetvlimax(1, 7)
#define vsetvlmax_e16m1() __builtin_rvv_vsetvlimax(1, 0)
#define vsetvlmax_e16m2() __builtin_rvv_vsetvlimax(1, 1)
#define vsetvlmax_e16m4() __builtin_rvv_vsetvlimax(1, 2)
#define vsetvlmax_e16m8() __builtin_rvv_vsetvlimax(1, 3)

#define vsetvlmax_e32mf2() __builtin_rvv_vsetvlimax(2, 7)
#define vsetvlmax_e32m1() __builtin_rvv_vsetvlimax(2, 0)
#define vsetvlmax_e32m2() __builtin_rvv_vsetvlimax(2, 1)
#define vsetvlmax_e32m4() __builtin_rvv_vsetvlimax(2, 2)
#define vsetvlmax_e32m8() __builtin_rvv_vsetvlimax(2, 3)

#define vsetvlmax_e64m1() __builtin_rvv_vsetvlimax(3, 0)
#define vsetvlmax_e64m2() __builtin_rvv_vsetvlimax(3, 1)
#define vsetvlmax_e64m4() __builtin_rvv_vsetvlimax(3, 2)
#define vsetvlmax_e64m8() __builtin_rvv_vsetvlimax(3, 3)

typedef __rvv_bool64_t vbool64_t;
typedef __rvv_bool32_t vbool32_t;
typedef __rvv_bool16_t vbool16_t;
typedef __rvv_bool8_t vbool8_t;
typedef __rvv_bool4_t vbool4_t;
typedef __rvv_bool2_t vbool2_t;
typedef __rvv_bool1_t vbool1_t;
typedef __rvv_int8mf8_t vint8mf8_t;
typedef __rvv_uint8mf8_t vuint8mf8_t;
typedef __rvv_int8mf4_t vint8mf4_t;
typedef __rvv_uint8mf4_t vuint8mf4_t;
typedef __rvv_int8mf2_t vint8mf2_t;
typedef __rvv_uint8mf2_t vuint8mf2_t;
typedef __rvv_int8m1_t vint8m1_t;
typedef __rvv_uint8m1_t vuint8m1_t;
typedef __rvv_int8m2_t vint8m2_t;
typedef __rvv_uint8m2_t vuint8m2_t;
typedef __rvv_int8m4_t vint8m4_t;
typedef __rvv_uint8m4_t vuint8m4_t;
typedef __rvv_int8m8_t vint8m8_t;
typedef __rvv_uint8m8_t vuint8m8_t;
typedef __rvv_int16mf4_t vint16mf4_t;
typedef __rvv_uint16mf4_t vuint16mf4_t;
typedef __rvv_int16mf2_t vint16mf2_t;
typedef __rvv_uint16mf2_t vuint16mf2_t;
typedef __rvv_int16m1_t vint16m1_t;
typedef __rvv_uint16m1_t vuint16m1_t;
typedef __rvv_int16m2_t vint16m2_t;
typedef __rvv_uint16m2_t vuint16m2_t;
typedef __rvv_int16m4_t vint16m4_t;
typedef __rvv_uint16m4_t vuint16m4_t;
typedef __rvv_int16m8_t vint16m8_t;
typedef __rvv_uint16m8_t vuint16m8_t;
typedef __rvv_int32mf2_t vint32mf2_t;
typedef __rvv_uint32mf2_t vuint32mf2_t;
typedef __rvv_int32m1_t vint32m1_t;
typedef __rvv_uint32m1_t vuint32m1_t;
typedef __rvv_int32m2_t vint32m2_t;
typedef __rvv_uint32m2_t vuint32m2_t;
typedef __rvv_int32m4_t vint32m4_t;
typedef __rvv_uint32m4_t vuint32m4_t;
typedef __rvv_int32m8_t vint32m8_t;
typedef __rvv_uint32m8_t vuint32m8_t;
typedef __rvv_int64m1_t vint64m1_t;
typedef __rvv_uint64m1_t vuint64m1_t;
typedef __rvv_int64m2_t vint64m2_t;
typedef __rvv_uint64m2_t vuint64m2_t;
typedef __rvv_int64m4_t vint64m4_t;
typedef __rvv_uint64m4_t vuint64m4_t;
typedef __rvv_int64m8_t vint64m8_t;
typedef __rvv_uint64m8_t vuint64m8_t;
#if defined(__riscv_zfh)
typedef __rvv_float16mf4_t vfloat16mf4_t;
typedef __rvv_float16mf2_t vfloat16mf2_t;
typedef __rvv_float16m1_t vfloat16m1_t;
typedef __rvv_float16m2_t vfloat16m2_t;
typedef __rvv_float16m4_t vfloat16m4_t;
typedef __rvv_float16m8_t vfloat16m8_t;
#endif
#if defined(__riscv_f)
typedef __rvv_float32mf2_t vfloat32mf2_t;
typedef __rvv_float32m1_t vfloat32m1_t;
typedef __rvv_float32m2_t vfloat32m2_t;
typedef __rvv_float32m4_t vfloat32m4_t;
typedef __rvv_float32m8_t vfloat32m8_t;
#endif
#if defined(__riscv_d)
typedef __rvv_float64m1_t vfloat64m1_t;
typedef __rvv_float64m2_t vfloat64m2_t;
typedef __rvv_float64m4_t vfloat64m4_t;
typedef __rvv_float64m8_t vfloat64m8_t;
#endif

#define vadd_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vadd_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vadd_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vadd_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vadd_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vadd_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vadd_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vadd_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vadd_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vadd_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vadd_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vadd_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vadd_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vadd_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vadd_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vadd_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vadd_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vadd_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vadd_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vadd_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vadd_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vadd_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vadd_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vadd_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vadd_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vadd_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vadd_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vadd_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vadd_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vadd_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vadd_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vadd_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vadd_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vadd_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vadd_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vadd_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vadd_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vadd_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vadd_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vadd_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vadd_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vadd_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vadd_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vadd_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vadd_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vadd_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vadd_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vadd_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vadd_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vadd_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vadd_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vadd_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vadd_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vadd_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vadd_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vadd_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vadd_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vadd_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vadd_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vadd_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vadd_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vadd_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vadd_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vadd_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vadd_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vadd_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vwaddu_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u16mf4((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vwaddu_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vwaddu_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u16mf2((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vwaddu_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vwaddu_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u16m1((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vwaddu_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vwaddu_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u16m2((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vwaddu_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vwaddu_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u16m4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vwaddu_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vwaddu_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u16m8((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vwaddu_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vwaddu_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u32mf2((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vwaddu_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vwaddu_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u32m1((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vwaddu_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vwaddu_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u32m2((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vwaddu_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vwaddu_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u32m4((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vwaddu_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vwaddu_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u32m8((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vwaddu_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vwaddu_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u64m1((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vwaddu_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vwaddu_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u64m2((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vwaddu_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vwaddu_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u64m4((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vwaddu_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vwaddu_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vwaddu_vv_u64m8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vwaddu_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vluxei8_v_u8m1(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u8m1((const uint8_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vluxei8_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (const uint8_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vluxei8_v_u8m2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u8m2((const uint8_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vluxei8_v_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (const uint8_t *)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vluxei8_v_u8m4(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u8m4((const uint8_t *)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vluxei8_v_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (const uint8_t *)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vluxei8_v_u8m8(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u8m8((const uint8_t *)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vluxei8_v_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (const uint8_t *)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vluxei8_v_u8mf2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u8mf2((const uint8_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vluxei8_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (const uint8_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vluxei8_v_u8mf4(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u8mf4((const uint8_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vluxei8_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (const uint8_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vluxei8_v_u8mf8(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u8mf8((const uint8_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vluxei8_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (const uint8_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vlse64_v_u64m1(op0, op1, op2) \
__builtin_rvv_vlse64_v_u64m1((const uint64_t *)(op0), (ptrdiff_t)(op1), (size_t)(op2))
#define vlse64_v_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vlse64_v_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (const uint64_t *)(op2), (ptrdiff_t)(op3), (size_t)(op4))
#define vlse64_v_u64m2(op0, op1, op2) \
__builtin_rvv_vlse64_v_u64m2((const uint64_t *)(op0), (ptrdiff_t)(op1), (size_t)(op2))
#define vlse64_v_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vlse64_v_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (const uint64_t *)(op2), (ptrdiff_t)(op3), (size_t)(op4))
#define vlse64_v_u64m4(op0, op1, op2) \
__builtin_rvv_vlse64_v_u64m4((const uint64_t *)(op0), (ptrdiff_t)(op1), (size_t)(op2))
#define vlse64_v_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vlse64_v_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (const uint64_t *)(op2), (ptrdiff_t)(op3), (size_t)(op4))
#define vlse64_v_u64m8(op0, op1, op2) \
__builtin_rvv_vlse64_v_u64m8((const uint64_t *)(op0), (ptrdiff_t)(op1), (size_t)(op2))
#define vlse64_v_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vlse64_v_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (const uint64_t *)(op2), (ptrdiff_t)(op3), (size_t)(op4))
#define vsse16_v_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_i16m1((int16_t *)(op0), (ptrdiff_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vsse16_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_i16m1_m((vbool16_t)(op0), (int16_t *)(op1), (ptrdiff_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vsse16_v_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_i16m2((int16_t *)(op0), (ptrdiff_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vsse16_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_i16m2_m((vbool8_t)(op0), (int16_t *)(op1), (ptrdiff_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vsse16_v_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_i16m4((int16_t *)(op0), (ptrdiff_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vsse16_v_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_i16m4_m((vbool4_t)(op0), (int16_t *)(op1), (ptrdiff_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vsse16_v_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_i16m8((int16_t *)(op0), (ptrdiff_t)(op1), (vint16m8_t)(op2), (size_t)(op3))
#define vsse16_v_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_i16m8_m((vbool2_t)(op0), (int16_t *)(op1), (ptrdiff_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vsse16_v_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_i16mf2((int16_t *)(op0), (ptrdiff_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vsse16_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_i16mf2_m((vbool32_t)(op0), (int16_t *)(op1), (ptrdiff_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vsse16_v_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_i16mf4((int16_t *)(op0), (ptrdiff_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vsse16_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_i16mf4_m((vbool64_t)(op0), (int16_t *)(op1), (ptrdiff_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vsse16_v_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_u16m1((uint16_t *)(op0), (ptrdiff_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vsse16_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_u16m1_m((vbool16_t)(op0), (uint16_t *)(op1), (ptrdiff_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vsse16_v_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_u16m2((uint16_t *)(op0), (ptrdiff_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vsse16_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_u16m2_m((vbool8_t)(op0), (uint16_t *)(op1), (ptrdiff_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vsse16_v_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_u16m4((uint16_t *)(op0), (ptrdiff_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vsse16_v_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_u16m4_m((vbool4_t)(op0), (uint16_t *)(op1), (ptrdiff_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vsse16_v_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_u16m8((uint16_t *)(op0), (ptrdiff_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vsse16_v_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_u16m8_m((vbool2_t)(op0), (uint16_t *)(op1), (ptrdiff_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vsse16_v_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_u16mf2((uint16_t *)(op0), (ptrdiff_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vsse16_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_u16mf2_m((vbool32_t)(op0), (uint16_t *)(op1), (ptrdiff_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vsse16_v_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsse16_v_u16mf4((uint16_t *)(op0), (ptrdiff_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vsse16_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse16_v_u16mf4_m((vbool64_t)(op0), (uint16_t *)(op1), (ptrdiff_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vsse32_v_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vsse32_v_i32m1((int32_t *)(op0), (ptrdiff_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vsse32_v_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse32_v_i32m1_m((vbool32_t)(op0), (int32_t *)(op1), (ptrdiff_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vsse32_v_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vsse32_v_i32m2((int32_t *)(op0), (ptrdiff_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vsse32_v_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse32_v_i32m2_m((vbool16_t)(op0), (int32_t *)(op1), (ptrdiff_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vsse32_v_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vsse32_v_i32m4((int32_t *)(op0), (ptrdiff_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vsse32_v_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse32_v_i32m4_m((vbool8_t)(op0), (int32_t *)(op1), (ptrdiff_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vsse32_v_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vsse32_v_i32m8((int32_t *)(op0), (ptrdiff_t)(op1), (vint32m8_t)(op2), (size_t)(op3))
#define vsse32_v_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse32_v_i32m8_m((vbool4_t)(op0), (int32_t *)(op1), (ptrdiff_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vsse32_v_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vsse32_v_i32mf2((int32_t *)(op0), (ptrdiff_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vsse32_v_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse32_v_i32mf2_m((vbool64_t)(op0), (int32_t *)(op1), (ptrdiff_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vsse32_v_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vsse32_v_u32m1((uint32_t *)(op0), (ptrdiff_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vsse32_v_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse32_v_u32m1_m((vbool32_t)(op0), (uint32_t *)(op1), (ptrdiff_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vsse32_v_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vsse32_v_u32m2((uint32_t *)(op0), (ptrdiff_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vsse32_v_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse32_v_u32m2_m((vbool16_t)(op0), (uint32_t *)(op1), (ptrdiff_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vsse32_v_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vsse32_v_u32m4((uint32_t *)(op0), (ptrdiff_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vsse32_v_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse32_v_u32m4_m((vbool8_t)(op0), (uint32_t *)(op1), (ptrdiff_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vsse32_v_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vsse32_v_u32m8((uint32_t *)(op0), (ptrdiff_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vsse32_v_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse32_v_u32m8_m((vbool4_t)(op0), (uint32_t *)(op1), (ptrdiff_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vsse32_v_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vsse32_v_u32mf2((uint32_t *)(op0), (ptrdiff_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vsse32_v_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse32_v_u32mf2_m((vbool64_t)(op0), (uint32_t *)(op1), (ptrdiff_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vsse64_v_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vsse64_v_i64m1((int64_t *)(op0), (ptrdiff_t)(op1), (vint64m1_t)(op2), (size_t)(op3))
#define vsse64_v_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse64_v_i64m1_m((vbool64_t)(op0), (int64_t *)(op1), (ptrdiff_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vsse64_v_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vsse64_v_i64m2((int64_t *)(op0), (ptrdiff_t)(op1), (vint64m2_t)(op2), (size_t)(op3))
#define vsse64_v_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse64_v_i64m2_m((vbool32_t)(op0), (int64_t *)(op1), (ptrdiff_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vsse64_v_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vsse64_v_i64m4((int64_t *)(op0), (ptrdiff_t)(op1), (vint64m4_t)(op2), (size_t)(op3))
#define vsse64_v_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse64_v_i64m4_m((vbool16_t)(op0), (int64_t *)(op1), (ptrdiff_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vsse64_v_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vsse64_v_i64m8((int64_t *)(op0), (ptrdiff_t)(op1), (vint64m8_t)(op2), (size_t)(op3))
#define vsse64_v_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse64_v_i64m8_m((vbool8_t)(op0), (int64_t *)(op1), (ptrdiff_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vsse64_v_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vsse64_v_u64m1((uint64_t *)(op0), (ptrdiff_t)(op1), (vuint64m1_t)(op2), (size_t)(op3))
#define vsse64_v_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse64_v_u64m1_m((vbool64_t)(op0), (uint64_t *)(op1), (ptrdiff_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vsse64_v_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vsse64_v_u64m2((uint64_t *)(op0), (ptrdiff_t)(op1), (vuint64m2_t)(op2), (size_t)(op3))
#define vsse64_v_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse64_v_u64m2_m((vbool32_t)(op0), (uint64_t *)(op1), (ptrdiff_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vsse64_v_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vsse64_v_u64m4((uint64_t *)(op0), (ptrdiff_t)(op1), (vuint64m4_t)(op2), (size_t)(op3))
#define vsse64_v_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse64_v_u64m4_m((vbool16_t)(op0), (uint64_t *)(op1), (ptrdiff_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vsse64_v_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vsse64_v_u64m8((uint64_t *)(op0), (ptrdiff_t)(op1), (vuint64m8_t)(op2), (size_t)(op3))
#define vsse64_v_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse64_v_u64m8_m((vbool8_t)(op0), (uint64_t *)(op1), (ptrdiff_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vluxei16_v_i8m1(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i8m1((const int8_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vluxei16_v_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (const int8_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vluxei16_v_i8m2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i8m2((const int8_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vluxei16_v_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (const int8_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vluxei16_v_i8m4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i8m4((const int8_t *)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vluxei16_v_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (const int8_t *)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vluxei16_v_i8mf2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i8mf2((const int8_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vluxei16_v_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (const int8_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vluxei16_v_i8mf4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i8mf4((const int8_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vluxei16_v_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (const int8_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vluxei16_v_i8mf8(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i8mf8((const int8_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vluxei16_v_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (const int8_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vluxei16_v_u8m1(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u8m1((const uint8_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vluxei16_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (const uint8_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vluxei16_v_u8m2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u8m2((const uint8_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vluxei16_v_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (const uint8_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vluxei16_v_u8m4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u8m4((const uint8_t *)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vluxei16_v_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (const uint8_t *)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vluxei16_v_u8mf2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u8mf2((const uint8_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vluxei16_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (const uint8_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vluxei16_v_u8mf4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u8mf4((const uint8_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vluxei16_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (const uint8_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vluxei16_v_u8mf8(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u8mf8((const uint8_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vluxei16_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (const uint8_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vluxei32_v_i8m1(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i8m1((const int8_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vluxei32_v_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (const int8_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vluxei32_v_i8m2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i8m2((const int8_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vluxei32_v_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (const int8_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vluxei32_v_i8mf2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i8mf2((const int8_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vluxei32_v_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (const int8_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vluxei32_v_i8mf4(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i8mf4((const int8_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vluxei32_v_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (const int8_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vluxei32_v_i8mf8(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i8mf8((const int8_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vluxei32_v_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (const int8_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vluxei32_v_u8m1(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u8m1((const uint8_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vluxei32_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (const uint8_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vluxei32_v_u8m2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u8m2((const uint8_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vluxei32_v_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (const uint8_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vluxei32_v_u8mf2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u8mf2((const uint8_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vluxei32_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (const uint8_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vluxei32_v_u8mf4(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u8mf4((const uint8_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vluxei32_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (const uint8_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vluxei32_v_u8mf8(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u8mf8((const uint8_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vluxei32_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (const uint8_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vluxei64_v_i8m1(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i8m1((const int8_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vluxei64_v_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (const int8_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vluxei64_v_i8mf2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i8mf2((const int8_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vluxei64_v_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (const int8_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vluxei64_v_i8mf4(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i8mf4((const int8_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vluxei64_v_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (const int8_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vluxei64_v_i8mf8(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i8mf8((const int8_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vluxei64_v_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (const int8_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vluxei64_v_u8m1(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u8m1((const uint8_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vluxei64_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (const uint8_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vluxei64_v_u8mf2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u8mf2((const uint8_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vluxei64_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (const uint8_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vluxei64_v_u8mf4(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u8mf4((const uint8_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vluxei64_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (const uint8_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vluxei64_v_u8mf8(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u8mf8((const uint8_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vluxei64_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (const uint8_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vluxei8_v_i16m1(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i16m1((const int16_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vluxei8_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (const int16_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vluxei8_v_i16m2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i16m2((const int16_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vluxei8_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (const int16_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vluxei8_v_i16m4(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i16m4((const int16_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vluxei8_v_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (const int16_t *)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vluxei8_v_i16m8(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i16m8((const int16_t *)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vluxei8_v_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (const int16_t *)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vluxei8_v_i16mf2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i16mf2((const int16_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vluxei8_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (const int16_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vluxei8_v_i16mf4(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i16mf4((const int16_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vluxei8_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (const int16_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vluxei8_v_u16m1(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u16m1((const uint16_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vluxei8_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (const uint16_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vluxei8_v_u16m2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u16m2((const uint16_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vluxei8_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (const uint16_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vluxei8_v_u16m4(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u16m4((const uint16_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vluxei8_v_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (const uint16_t *)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vluxei8_v_u16m8(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u16m8((const uint16_t *)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vluxei8_v_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (const uint16_t *)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vluxei8_v_u16mf2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u16mf2((const uint16_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vluxei8_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (const uint16_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vluxei8_v_u16mf4(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u16mf4((const uint16_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vluxei8_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (const uint16_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vluxei16_v_i16m1(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i16m1((const int16_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vluxei16_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (const int16_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vluxei16_v_i16m2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i16m2((const int16_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vluxei16_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (const int16_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vluxei16_v_i16m4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i16m4((const int16_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vluxei16_v_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (const int16_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vluxei16_v_i16m8(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i16m8((const int16_t *)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vluxei16_v_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (const int16_t *)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vluxei16_v_i16mf2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i16mf2((const int16_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vluxei16_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (const int16_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vluxei16_v_i16mf4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i16mf4((const int16_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vluxei16_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (const int16_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vluxei16_v_u16m1(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u16m1((const uint16_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vluxei16_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (const uint16_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vluxei16_v_u16m2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u16m2((const uint16_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vluxei16_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (const uint16_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vluxei16_v_u16m4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u16m4((const uint16_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vluxei16_v_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (const uint16_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vluxei16_v_u16m8(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u16m8((const uint16_t *)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vluxei16_v_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (const uint16_t *)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vluxei16_v_u16mf2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u16mf2((const uint16_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vluxei16_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (const uint16_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vluxei16_v_u16mf4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u16mf4((const uint16_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vluxei16_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (const uint16_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vluxei32_v_i16m1(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i16m1((const int16_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vluxei32_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (const int16_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vluxei32_v_i16m2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i16m2((const int16_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vluxei32_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (const int16_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vluxei32_v_i16m4(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i16m4((const int16_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vluxei32_v_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (const int16_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vluxei32_v_i16mf2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i16mf2((const int16_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vluxei32_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (const int16_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vluxei32_v_i16mf4(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i16mf4((const int16_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vluxei32_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (const int16_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vluxei32_v_u16m1(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u16m1((const uint16_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vluxei32_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (const uint16_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vluxei32_v_u16m2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u16m2((const uint16_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vluxei32_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (const uint16_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vluxei32_v_u16m4(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u16m4((const uint16_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vluxei32_v_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (const uint16_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vluxei32_v_u16mf2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u16mf2((const uint16_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vluxei32_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (const uint16_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vluxei32_v_u16mf4(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u16mf4((const uint16_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vluxei32_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (const uint16_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vluxei64_v_i16m1(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i16m1((const int16_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vluxei64_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (const int16_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vluxei64_v_i16m2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i16m2((const int16_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vluxei64_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (const int16_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vluxei64_v_i16mf2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i16mf2((const int16_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vluxei64_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (const int16_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vluxei64_v_i16mf4(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i16mf4((const int16_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vluxei64_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (const int16_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vluxei64_v_u16m1(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u16m1((const uint16_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vluxei64_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (const uint16_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vluxei64_v_u16m2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u16m2((const uint16_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vluxei64_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (const uint16_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vluxei64_v_u16mf2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u16mf2((const uint16_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vluxei64_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (const uint16_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vluxei64_v_u16mf4(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u16mf4((const uint16_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vluxei64_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (const uint16_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vluxei8_v_i32m1(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i32m1((const int32_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vluxei8_v_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (const int32_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vluxei8_v_i32m2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i32m2((const int32_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vluxei8_v_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (const int32_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vluxei8_v_i32m4(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i32m4((const int32_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vluxei8_v_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (const int32_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vluxei8_v_i32m8(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i32m8((const int32_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vluxei8_v_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (const int32_t *)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vluxei8_v_i32mf2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i32mf2((const int32_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vluxei8_v_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (const int32_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vluxei8_v_u32m1(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u32m1((const uint32_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vluxei8_v_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (const uint32_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vluxei8_v_u32m2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u32m2((const uint32_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vluxei8_v_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (const uint32_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vluxei8_v_u32m4(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u32m4((const uint32_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vluxei8_v_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (const uint32_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vluxei8_v_u32m8(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u32m8((const uint32_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vluxei8_v_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (const uint32_t *)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vluxei8_v_u32mf2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u32mf2((const uint32_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vluxei8_v_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (const uint32_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vluxei16_v_i32m1(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i32m1((const int32_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vluxei16_v_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (const int32_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vluxei16_v_i32m2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i32m2((const int32_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vluxei16_v_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (const int32_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vluxei16_v_i32m4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i32m4((const int32_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vluxei16_v_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (const int32_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vluxei16_v_i32m8(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i32m8((const int32_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vluxei16_v_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (const int32_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vluxei16_v_i32mf2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i32mf2((const int32_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vluxei16_v_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (const int32_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vluxei16_v_u32m1(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u32m1((const uint32_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vluxei16_v_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (const uint32_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vluxei16_v_u32m2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u32m2((const uint32_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vluxei16_v_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (const uint32_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vluxei16_v_u32m4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u32m4((const uint32_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vluxei16_v_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (const uint32_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vluxei16_v_u32m8(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u32m8((const uint32_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vluxei16_v_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (const uint32_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vluxei16_v_u32mf2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u32mf2((const uint32_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vluxei16_v_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (const uint32_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vluxei32_v_i32m1(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i32m1((const int32_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vluxei32_v_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (const int32_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vluxei32_v_i32m2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i32m2((const int32_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vluxei32_v_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (const int32_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vluxei32_v_i32m4(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i32m4((const int32_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vluxei32_v_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (const int32_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vluxei32_v_i32m8(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i32m8((const int32_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vluxei32_v_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (const int32_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vluxei32_v_i32mf2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i32mf2((const int32_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vluxei32_v_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (const int32_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vluxei32_v_u32m1(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u32m1((const uint32_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vluxei32_v_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (const uint32_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vluxei32_v_u32m2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u32m2((const uint32_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vluxei32_v_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (const uint32_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vluxei32_v_u32m4(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u32m4((const uint32_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vluxei32_v_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (const uint32_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vluxei32_v_u32m8(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u32m8((const uint32_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vluxei32_v_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (const uint32_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vluxei32_v_u32mf2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u32mf2((const uint32_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vluxei32_v_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (const uint32_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vluxei64_v_i32m1(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i32m1((const int32_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vluxei64_v_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (const int32_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vluxei64_v_i32m2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i32m2((const int32_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vluxei64_v_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (const int32_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vluxei64_v_i32m4(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i32m4((const int32_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vluxei64_v_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (const int32_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vluxei64_v_i32mf2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i32mf2((const int32_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vluxei64_v_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (const int32_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vluxei64_v_u32m1(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u32m1((const uint32_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vluxei64_v_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (const uint32_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vluxei64_v_u32m2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u32m2((const uint32_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vluxei64_v_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (const uint32_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vluxei64_v_u32m4(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u32m4((const uint32_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vluxei64_v_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (const uint32_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vluxei64_v_u32mf2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u32mf2((const uint32_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vluxei64_v_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (const uint32_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vluxei8_v_i64m1(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i64m1((const int64_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vluxei8_v_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (const int64_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vluxei8_v_i64m2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i64m2((const int64_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vluxei8_v_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (const int64_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vluxei8_v_i64m4(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i64m4((const int64_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vluxei8_v_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (const int64_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vluxei8_v_i64m8(op0, op1, op2) \
__builtin_rvv_vluxei8_v_i64m8((const int64_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vluxei8_v_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (const int64_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vluxei8_v_u64m1(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u64m1((const uint64_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vluxei8_v_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (const uint64_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vluxei8_v_u64m2(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u64m2((const uint64_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vluxei8_v_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (const uint64_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vluxei8_v_u64m4(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u64m4((const uint64_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vluxei8_v_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (const uint64_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vluxei8_v_u64m8(op0, op1, op2) \
__builtin_rvv_vluxei8_v_u64m8((const uint64_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vluxei8_v_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei8_v_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (const uint64_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vluxei16_v_i64m1(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i64m1((const int64_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vluxei16_v_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (const int64_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vluxei16_v_i64m2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i64m2((const int64_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vluxei16_v_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (const int64_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vluxei16_v_i64m4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i64m4((const int64_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vluxei16_v_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (const int64_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vluxei16_v_i64m8(op0, op1, op2) \
__builtin_rvv_vluxei16_v_i64m8((const int64_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vluxei16_v_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (const int64_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vluxei16_v_u64m1(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u64m1((const uint64_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vluxei16_v_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (const uint64_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vluxei16_v_u64m2(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u64m2((const uint64_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vluxei16_v_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (const uint64_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vluxei16_v_u64m4(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u64m4((const uint64_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vluxei16_v_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (const uint64_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vluxei16_v_u64m8(op0, op1, op2) \
__builtin_rvv_vluxei16_v_u64m8((const uint64_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vluxei16_v_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei16_v_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (const uint64_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vluxei32_v_i64m1(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i64m1((const int64_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vluxei32_v_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (const int64_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vluxei32_v_i64m2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i64m2((const int64_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vluxei32_v_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (const int64_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vluxei32_v_i64m4(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i64m4((const int64_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vluxei32_v_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (const int64_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vluxei32_v_i64m8(op0, op1, op2) \
__builtin_rvv_vluxei32_v_i64m8((const int64_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vluxei32_v_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (const int64_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vluxei32_v_u64m1(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u64m1((const uint64_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vluxei32_v_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (const uint64_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vluxei32_v_u64m2(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u64m2((const uint64_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vluxei32_v_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (const uint64_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vluxei32_v_u64m4(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u64m4((const uint64_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vluxei32_v_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (const uint64_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vluxei32_v_u64m8(op0, op1, op2) \
__builtin_rvv_vluxei32_v_u64m8((const uint64_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vluxei32_v_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei32_v_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (const uint64_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vluxei64_v_i64m1(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i64m1((const int64_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vluxei64_v_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (const int64_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vluxei64_v_i64m2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i64m2((const int64_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vluxei64_v_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (const int64_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vluxei64_v_i64m4(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i64m4((const int64_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vluxei64_v_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (const int64_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vluxei64_v_i64m8(op0, op1, op2) \
__builtin_rvv_vluxei64_v_i64m8((const int64_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vluxei64_v_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (const int64_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vluxei64_v_u64m1(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u64m1((const uint64_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vluxei64_v_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (const uint64_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vluxei64_v_u64m2(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u64m2((const uint64_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vluxei64_v_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (const uint64_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vluxei64_v_u64m4(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u64m4((const uint64_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vluxei64_v_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (const uint64_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vluxei64_v_u64m8(op0, op1, op2) \
__builtin_rvv_vluxei64_v_u64m8((const uint64_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vluxei64_v_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vluxei64_v_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (const uint64_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vloxei8_v_i8m1(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i8m1((const int8_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vloxei8_v_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (const int8_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vloxei8_v_i8m2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i8m2((const int8_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vloxei8_v_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (const int8_t *)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vloxei8_v_i8m4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i8m4((const int8_t *)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vloxei8_v_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (const int8_t *)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vloxei8_v_i8m8(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i8m8((const int8_t *)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vloxei8_v_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (const int8_t *)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vloxei8_v_i8mf2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i8mf2((const int8_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vloxei8_v_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (const int8_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vloxei8_v_i8mf4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i8mf4((const int8_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vloxei8_v_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (const int8_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vloxei8_v_i8mf8(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i8mf8((const int8_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vloxei8_v_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (const int8_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vloxei8_v_u8m1(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u8m1((const uint8_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vloxei8_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (const uint8_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vloxei8_v_u8m2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u8m2((const uint8_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vloxei8_v_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (const uint8_t *)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vloxei8_v_u8m4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u8m4((const uint8_t *)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vloxei8_v_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (const uint8_t *)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vloxei8_v_u8m8(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u8m8((const uint8_t *)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vloxei8_v_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (const uint8_t *)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vloxei8_v_u8mf2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u8mf2((const uint8_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vloxei8_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (const uint8_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vloxei8_v_u8mf4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u8mf4((const uint8_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vloxei8_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (const uint8_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vloxei8_v_u8mf8(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u8mf8((const uint8_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vloxei8_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (const uint8_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vloxei16_v_i8m1(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i8m1((const int8_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vloxei16_v_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (const int8_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vloxei16_v_i8m2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i8m2((const int8_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vloxei16_v_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (const int8_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vloxei16_v_i8m4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i8m4((const int8_t *)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vloxei16_v_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (const int8_t *)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vloxei16_v_i8mf2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i8mf2((const int8_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vloxei16_v_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (const int8_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vloxei16_v_i8mf4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i8mf4((const int8_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vloxei16_v_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (const int8_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vloxei16_v_i8mf8(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i8mf8((const int8_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vloxei16_v_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (const int8_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vloxei16_v_u8m1(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u8m1((const uint8_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vloxei16_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (const uint8_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vloxei16_v_u8m2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u8m2((const uint8_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vloxei16_v_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (const uint8_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vloxei16_v_u8m4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u8m4((const uint8_t *)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vloxei16_v_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (const uint8_t *)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vloxei16_v_u8mf2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u8mf2((const uint8_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vloxei16_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (const uint8_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vloxei16_v_u8mf4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u8mf4((const uint8_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vloxei16_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (const uint8_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vloxei16_v_u8mf8(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u8mf8((const uint8_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vloxei16_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (const uint8_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vloxei32_v_i8m1(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i8m1((const int8_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vloxei32_v_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (const int8_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vloxei32_v_i8m2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i8m2((const int8_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vloxei32_v_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (const int8_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vloxei32_v_i8mf2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i8mf2((const int8_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vloxei32_v_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (const int8_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vloxei32_v_i8mf4(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i8mf4((const int8_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vloxei32_v_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (const int8_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vloxei32_v_i8mf8(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i8mf8((const int8_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vloxei32_v_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (const int8_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vloxei32_v_u8m1(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u8m1((const uint8_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vloxei32_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (const uint8_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vloxei32_v_u8m2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u8m2((const uint8_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vloxei32_v_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (const uint8_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vloxei32_v_u8mf2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u8mf2((const uint8_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vloxei32_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (const uint8_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vloxei32_v_u8mf4(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u8mf4((const uint8_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vloxei32_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (const uint8_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vloxei32_v_u8mf8(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u8mf8((const uint8_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vloxei32_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (const uint8_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vloxei64_v_i8m1(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i8m1((const int8_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vloxei64_v_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (const int8_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vloxei64_v_i8mf2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i8mf2((const int8_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vloxei64_v_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (const int8_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vloxei64_v_i8mf4(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i8mf4((const int8_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vloxei64_v_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (const int8_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vloxei64_v_i8mf8(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i8mf8((const int8_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vloxei64_v_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (const int8_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vloxei64_v_u8m1(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u8m1((const uint8_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vloxei64_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (const uint8_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vloxei64_v_u8mf2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u8mf2((const uint8_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vloxei64_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (const uint8_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vloxei64_v_u8mf4(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u8mf4((const uint8_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vloxei64_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (const uint8_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vloxei64_v_u8mf8(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u8mf8((const uint8_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vloxei64_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (const uint8_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vloxei8_v_i16m1(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i16m1((const int16_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vloxei8_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (const int16_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vloxei8_v_i16m2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i16m2((const int16_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vloxei8_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (const int16_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vloxei8_v_i16m4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i16m4((const int16_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vloxei8_v_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (const int16_t *)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vloxei8_v_i16m8(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i16m8((const int16_t *)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vloxei8_v_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (const int16_t *)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vloxei8_v_i16mf2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i16mf2((const int16_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vloxei8_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (const int16_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vloxei8_v_i16mf4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i16mf4((const int16_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vloxei8_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (const int16_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vloxei8_v_u16m1(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u16m1((const uint16_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vloxei8_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (const uint16_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vloxei8_v_u16m2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u16m2((const uint16_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vloxei8_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (const uint16_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vloxei8_v_u16m4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u16m4((const uint16_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vloxei8_v_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (const uint16_t *)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vloxei8_v_u16m8(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u16m8((const uint16_t *)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vloxei8_v_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (const uint16_t *)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vloxei8_v_u16mf2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u16mf2((const uint16_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vloxei8_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (const uint16_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vloxei8_v_u16mf4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u16mf4((const uint16_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vloxei8_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (const uint16_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vloxei16_v_i16m1(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i16m1((const int16_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vloxei16_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (const int16_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vloxei16_v_i16m2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i16m2((const int16_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vloxei16_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (const int16_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vloxei16_v_i16m4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i16m4((const int16_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vloxei16_v_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (const int16_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vloxei16_v_i16m8(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i16m8((const int16_t *)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vloxei16_v_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (const int16_t *)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vloxei16_v_i16mf2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i16mf2((const int16_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vloxei16_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (const int16_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vloxei16_v_i16mf4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i16mf4((const int16_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vloxei16_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (const int16_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vloxei16_v_u16m1(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u16m1((const uint16_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vloxei16_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (const uint16_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vloxei16_v_u16m2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u16m2((const uint16_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vloxei16_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (const uint16_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vloxei16_v_u16m4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u16m4((const uint16_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vloxei16_v_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (const uint16_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vloxei16_v_u16m8(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u16m8((const uint16_t *)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vloxei16_v_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (const uint16_t *)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vloxei16_v_u16mf2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u16mf2((const uint16_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vloxei16_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (const uint16_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vloxei16_v_u16mf4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u16mf4((const uint16_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vloxei16_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (const uint16_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vloxei32_v_i16m1(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i16m1((const int16_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vloxei32_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (const int16_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vloxei32_v_i16m2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i16m2((const int16_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vloxei32_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (const int16_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vloxei32_v_i16m4(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i16m4((const int16_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vloxei32_v_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (const int16_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vloxei32_v_i16mf2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i16mf2((const int16_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vloxei32_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (const int16_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vloxei32_v_i16mf4(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i16mf4((const int16_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vloxei32_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (const int16_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vloxei32_v_u16m1(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u16m1((const uint16_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vloxei32_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (const uint16_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vloxei32_v_u16m2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u16m2((const uint16_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vloxei32_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (const uint16_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vloxei32_v_u16m4(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u16m4((const uint16_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vloxei32_v_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (const uint16_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vloxei32_v_u16mf2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u16mf2((const uint16_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vloxei32_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (const uint16_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vloxei32_v_u16mf4(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u16mf4((const uint16_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vloxei32_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (const uint16_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vloxei64_v_i16m1(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i16m1((const int16_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vloxei64_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (const int16_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vloxei64_v_i16m2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i16m2((const int16_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vloxei64_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (const int16_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vloxei64_v_i16mf2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i16mf2((const int16_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vloxei64_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (const int16_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vloxei64_v_i16mf4(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i16mf4((const int16_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vloxei64_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (const int16_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vloxei64_v_u16m1(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u16m1((const uint16_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vloxei64_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (const uint16_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vloxei64_v_u16m2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u16m2((const uint16_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vloxei64_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (const uint16_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vloxei64_v_u16mf2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u16mf2((const uint16_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vloxei64_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (const uint16_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vloxei64_v_u16mf4(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u16mf4((const uint16_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vloxei64_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (const uint16_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vloxei8_v_i32m1(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i32m1((const int32_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vloxei8_v_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (const int32_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vloxei8_v_i32m2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i32m2((const int32_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vloxei8_v_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (const int32_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vloxei8_v_i32m4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i32m4((const int32_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vloxei8_v_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (const int32_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vloxei8_v_i32m8(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i32m8((const int32_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vloxei8_v_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (const int32_t *)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vloxei8_v_i32mf2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i32mf2((const int32_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vloxei8_v_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (const int32_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vloxei8_v_u32m1(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u32m1((const uint32_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vloxei8_v_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (const uint32_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vloxei8_v_u32m2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u32m2((const uint32_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vloxei8_v_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (const uint32_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vloxei8_v_u32m4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u32m4((const uint32_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vloxei8_v_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (const uint32_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vloxei8_v_u32m8(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u32m8((const uint32_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vloxei8_v_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (const uint32_t *)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vloxei8_v_u32mf2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u32mf2((const uint32_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vloxei8_v_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (const uint32_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vloxei16_v_i32m1(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i32m1((const int32_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vloxei16_v_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (const int32_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vloxei16_v_i32m2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i32m2((const int32_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vloxei16_v_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (const int32_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vloxei16_v_i32m4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i32m4((const int32_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vloxei16_v_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (const int32_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vloxei16_v_i32m8(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i32m8((const int32_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vloxei16_v_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (const int32_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vloxei16_v_i32mf2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i32mf2((const int32_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vloxei16_v_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (const int32_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vloxei16_v_u32m1(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u32m1((const uint32_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vloxei16_v_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (const uint32_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vloxei16_v_u32m2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u32m2((const uint32_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vloxei16_v_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (const uint32_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vloxei16_v_u32m4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u32m4((const uint32_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vloxei16_v_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (const uint32_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vloxei16_v_u32m8(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u32m8((const uint32_t *)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vloxei16_v_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (const uint32_t *)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vloxei16_v_u32mf2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u32mf2((const uint32_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vloxei16_v_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (const uint32_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vloxei32_v_i32m1(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i32m1((const int32_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vloxei32_v_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (const int32_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vloxei32_v_i32m2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i32m2((const int32_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vloxei32_v_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (const int32_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vloxei32_v_i32m4(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i32m4((const int32_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vloxei32_v_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (const int32_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vloxei32_v_i32m8(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i32m8((const int32_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vloxei32_v_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (const int32_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vloxei32_v_i32mf2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i32mf2((const int32_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vloxei32_v_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (const int32_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vloxei32_v_u32m1(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u32m1((const uint32_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vloxei32_v_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (const uint32_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vloxei32_v_u32m2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u32m2((const uint32_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vloxei32_v_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (const uint32_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vloxei32_v_u32m4(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u32m4((const uint32_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vloxei32_v_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (const uint32_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vloxei32_v_u32m8(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u32m8((const uint32_t *)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vloxei32_v_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (const uint32_t *)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vloxei32_v_u32mf2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u32mf2((const uint32_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vloxei32_v_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (const uint32_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vloxei64_v_i32m1(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i32m1((const int32_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vloxei64_v_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (const int32_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vloxei64_v_i32m2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i32m2((const int32_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vloxei64_v_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (const int32_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vloxei64_v_i32m4(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i32m4((const int32_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vloxei64_v_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (const int32_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vloxei64_v_i32mf2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i32mf2((const int32_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vloxei64_v_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (const int32_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vloxei64_v_u32m1(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u32m1((const uint32_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vloxei64_v_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (const uint32_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vloxei64_v_u32m2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u32m2((const uint32_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vloxei64_v_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (const uint32_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vloxei64_v_u32m4(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u32m4((const uint32_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vloxei64_v_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (const uint32_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vloxei64_v_u32mf2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u32mf2((const uint32_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vloxei64_v_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (const uint32_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vloxei8_v_i64m1(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i64m1((const int64_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vloxei8_v_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (const int64_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vloxei8_v_i64m2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i64m2((const int64_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vloxei8_v_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (const int64_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vloxei8_v_i64m4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i64m4((const int64_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vloxei8_v_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (const int64_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vloxei8_v_i64m8(op0, op1, op2) \
__builtin_rvv_vloxei8_v_i64m8((const int64_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vloxei8_v_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (const int64_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vse8_v_i8m1(op0, op1, op2) \
__builtin_rvv_vse8_v_i8m1((int8_t *)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vse8_v_i8m1_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_i8m1_m((vbool8_t)(op0), (int8_t *)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vse8_v_i8m2(op0, op1, op2) \
__builtin_rvv_vse8_v_i8m2((int8_t *)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vse8_v_i8m2_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_i8m2_m((vbool4_t)(op0), (int8_t *)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vse8_v_i8m4(op0, op1, op2) \
__builtin_rvv_vse8_v_i8m4((int8_t *)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vse8_v_i8m4_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_i8m4_m((vbool2_t)(op0), (int8_t *)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vse8_v_i8m8(op0, op1, op2) \
__builtin_rvv_vse8_v_i8m8((int8_t *)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vse8_v_i8m8_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_i8m8_m((vbool1_t)(op0), (int8_t *)(op1), (vint8m8_t)(op2), (size_t)(op3))
#define vse8_v_i8mf2(op0, op1, op2) \
__builtin_rvv_vse8_v_i8mf2((int8_t *)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vse8_v_i8mf2_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_i8mf2_m((vbool16_t)(op0), (int8_t *)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vse8_v_i8mf4(op0, op1, op2) \
__builtin_rvv_vse8_v_i8mf4((int8_t *)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vse8_v_i8mf4_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_i8mf4_m((vbool32_t)(op0), (int8_t *)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vse8_v_i8mf8(op0, op1, op2) \
__builtin_rvv_vse8_v_i8mf8((int8_t *)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vse8_v_i8mf8_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_i8mf8_m((vbool64_t)(op0), (int8_t *)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vloxei8_v_u64m1(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u64m1((const uint64_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vloxei8_v_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (const uint64_t *)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vloxei8_v_u64m2(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u64m2((const uint64_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vloxei8_v_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (const uint64_t *)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vloxei8_v_u64m4(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u64m4((const uint64_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vloxei8_v_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (const uint64_t *)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vloxei8_v_u64m8(op0, op1, op2) \
__builtin_rvv_vloxei8_v_u64m8((const uint64_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vloxei8_v_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei8_v_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (const uint64_t *)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vloxei16_v_i64m1(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i64m1((const int64_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vloxei16_v_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (const int64_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vloxei16_v_i64m2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i64m2((const int64_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vloxei16_v_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (const int64_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vloxei16_v_i64m4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i64m4((const int64_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vloxei16_v_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (const int64_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vloxei16_v_i64m8(op0, op1, op2) \
__builtin_rvv_vloxei16_v_i64m8((const int64_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vloxei16_v_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (const int64_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vloxei16_v_u64m1(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u64m1((const uint64_t *)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vloxei16_v_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (const uint64_t *)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vloxei16_v_u64m2(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u64m2((const uint64_t *)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vloxei16_v_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (const uint64_t *)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vloxei16_v_u64m4(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u64m4((const uint64_t *)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vloxei16_v_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (const uint64_t *)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vloxei16_v_u64m8(op0, op1, op2) \
__builtin_rvv_vloxei16_v_u64m8((const uint64_t *)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vloxei16_v_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei16_v_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (const uint64_t *)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vloxei32_v_i64m1(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i64m1((const int64_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vloxei32_v_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (const int64_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vloxei32_v_i64m2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i64m2((const int64_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vloxei32_v_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (const int64_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vloxei32_v_i64m4(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i64m4((const int64_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vloxei32_v_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (const int64_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vloxei32_v_i64m8(op0, op1, op2) \
__builtin_rvv_vloxei32_v_i64m8((const int64_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vloxei32_v_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (const int64_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vloxei32_v_u64m1(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u64m1((const uint64_t *)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vloxei32_v_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (const uint64_t *)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vloxei32_v_u64m2(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u64m2((const uint64_t *)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vloxei32_v_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (const uint64_t *)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vloxei32_v_u64m4(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u64m4((const uint64_t *)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vloxei32_v_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (const uint64_t *)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vloxei32_v_u64m8(op0, op1, op2) \
__builtin_rvv_vloxei32_v_u64m8((const uint64_t *)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vloxei32_v_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei32_v_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (const uint64_t *)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vloxei64_v_i64m1(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i64m1((const int64_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vloxei64_v_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (const int64_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vloxei64_v_i64m2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i64m2((const int64_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vloxei64_v_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (const int64_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vloxei64_v_i64m4(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i64m4((const int64_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vloxei64_v_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (const int64_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vloxei64_v_i64m8(op0, op1, op2) \
__builtin_rvv_vloxei64_v_i64m8((const int64_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vloxei64_v_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (const int64_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vloxei64_v_u64m1(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u64m1((const uint64_t *)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vloxei64_v_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (const uint64_t *)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vloxei64_v_u64m2(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u64m2((const uint64_t *)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vloxei64_v_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (const uint64_t *)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vloxei64_v_u64m4(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u64m4((const uint64_t *)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vloxei64_v_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (const uint64_t *)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vloxei64_v_u64m8(op0, op1, op2) \
__builtin_rvv_vloxei64_v_u64m8((const uint64_t *)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vloxei64_v_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vloxei64_v_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (const uint64_t *)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vse8_v_u8m1(op0, op1, op2) \
__builtin_rvv_vse8_v_u8m1((uint8_t *)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vse8_v_u8m1_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_u8m1_m((vbool8_t)(op0), (uint8_t *)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vse8_v_u8m2(op0, op1, op2) \
__builtin_rvv_vse8_v_u8m2((uint8_t *)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vse8_v_u8m2_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_u8m2_m((vbool4_t)(op0), (uint8_t *)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vse8_v_u8m4(op0, op1, op2) \
__builtin_rvv_vse8_v_u8m4((uint8_t *)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vse8_v_u8m4_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_u8m4_m((vbool2_t)(op0), (uint8_t *)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vse8_v_u8m8(op0, op1, op2) \
__builtin_rvv_vse8_v_u8m8((uint8_t *)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vse8_v_u8m8_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_u8m8_m((vbool1_t)(op0), (uint8_t *)(op1), (vuint8m8_t)(op2), (size_t)(op3))
#define vse8_v_u8mf2(op0, op1, op2) \
__builtin_rvv_vse8_v_u8mf2((uint8_t *)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vse8_v_u8mf2_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_u8mf2_m((vbool16_t)(op0), (uint8_t *)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vse8_v_u8mf4(op0, op1, op2) \
__builtin_rvv_vse8_v_u8mf4((uint8_t *)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vse8_v_u8mf4_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_u8mf4_m((vbool32_t)(op0), (uint8_t *)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vse8_v_u8mf8(op0, op1, op2) \
__builtin_rvv_vse8_v_u8mf8((uint8_t *)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vse8_v_u8mf8_m(op0, op1, op2, op3) \
__builtin_rvv_vse8_v_u8mf8_m((vbool64_t)(op0), (uint8_t *)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vwaddu_wv_u16mf4(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u16mf4((vuint16mf4_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vwaddu_wv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vwaddu_wv_u16mf2(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u16mf2((vuint16mf2_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vwaddu_wv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vwaddu_wv_u16m1(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u16m1((vuint16m1_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vwaddu_wv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vwaddu_wv_u16m2(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u16m2((vuint16m2_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vwaddu_wv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vwaddu_wv_u16m4(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u16m4((vuint16m4_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vwaddu_wv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vwaddu_wv_u16m8(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u16m8((vuint16m8_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vwaddu_wv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vwaddu_wv_u32mf2(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u32mf2((vuint32mf2_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vwaddu_wv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vwaddu_wv_u32m1(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u32m1((vuint32m1_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vwaddu_wv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vwaddu_wv_u32m2(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u32m2((vuint32m2_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vwaddu_wv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vwaddu_wv_u32m4(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u32m4((vuint32m4_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vwaddu_wv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vwaddu_wv_u32m8(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u32m8((vuint32m8_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vwaddu_wv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vwaddu_wv_u64m1(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u64m1((vuint64m1_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vwaddu_wv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vwaddu_wv_u64m2(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u64m2((vuint64m2_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vwaddu_wv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vwaddu_wv_u64m4(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u64m4((vuint64m4_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vwaddu_wv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vwaddu_wv_u64m8(op0, op1, op2) \
__builtin_rvv_vwaddu_wv_u64m8((vuint64m8_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vwaddu_wv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vsse8_v_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_i8m1((int8_t *)(op0), (ptrdiff_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vsse8_v_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_i8m1_m((vbool8_t)(op0), (int8_t *)(op1), (ptrdiff_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vsse8_v_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_i8m2((int8_t *)(op0), (ptrdiff_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vsse8_v_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_i8m2_m((vbool4_t)(op0), (int8_t *)(op1), (ptrdiff_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vsse8_v_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_i8m4((int8_t *)(op0), (ptrdiff_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vsse8_v_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_i8m4_m((vbool2_t)(op0), (int8_t *)(op1), (ptrdiff_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vsse8_v_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_i8m8((int8_t *)(op0), (ptrdiff_t)(op1), (vint8m8_t)(op2), (size_t)(op3))
#define vsse8_v_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_i8m8_m((vbool1_t)(op0), (int8_t *)(op1), (ptrdiff_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vsse8_v_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_i8mf2((int8_t *)(op0), (ptrdiff_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vsse8_v_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_i8mf2_m((vbool16_t)(op0), (int8_t *)(op1), (ptrdiff_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vsse8_v_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_i8mf4((int8_t *)(op0), (ptrdiff_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vsse8_v_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_i8mf4_m((vbool32_t)(op0), (int8_t *)(op1), (ptrdiff_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vsse8_v_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_i8mf8((int8_t *)(op0), (ptrdiff_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vsse8_v_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_i8mf8_m((vbool64_t)(op0), (int8_t *)(op1), (ptrdiff_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vsuxei16_v_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i8m1((int8_t *)(op0), (vuint16m2_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vsuxei16_v_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i8m1_m((vbool8_t)(op0), (int8_t *)(op1), (vuint16m2_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vsuxei16_v_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i8m2((int8_t *)(op0), (vuint16m4_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vsuxei16_v_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i8m2_m((vbool4_t)(op0), (int8_t *)(op1), (vuint16m4_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vsuxei16_v_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i8m4((int8_t *)(op0), (vuint16m8_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vsuxei16_v_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i8m4_m((vbool2_t)(op0), (int8_t *)(op1), (vuint16m8_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vsuxei16_v_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i8mf2((int8_t *)(op0), (vuint16m1_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vsuxei16_v_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i8mf2_m((vbool16_t)(op0), (int8_t *)(op1), (vuint16m1_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vsuxei16_v_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i8mf4((int8_t *)(op0), (vuint16mf2_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vsuxei16_v_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i8mf4_m((vbool32_t)(op0), (int8_t *)(op1), (vuint16mf2_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vsuxei16_v_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i8mf8((int8_t *)(op0), (vuint16mf4_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vsuxei16_v_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i8mf8_m((vbool64_t)(op0), (int8_t *)(op1), (vuint16mf4_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vsuxei16_v_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u8m1((uint8_t *)(op0), (vuint16m2_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vsuxei16_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u8m1_m((vbool8_t)(op0), (uint8_t *)(op1), (vuint16m2_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vsuxei16_v_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u8m2((uint8_t *)(op0), (vuint16m4_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vsuxei16_v_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u8m2_m((vbool4_t)(op0), (uint8_t *)(op1), (vuint16m4_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vsuxei16_v_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u8m4((uint8_t *)(op0), (vuint16m8_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vsuxei16_v_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u8m4_m((vbool2_t)(op0), (uint8_t *)(op1), (vuint16m8_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vsuxei16_v_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u8mf2((uint8_t *)(op0), (vuint16m1_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vsuxei16_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u8mf2_m((vbool16_t)(op0), (uint8_t *)(op1), (vuint16m1_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vsuxei16_v_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u8mf4((uint8_t *)(op0), (vuint16mf2_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vsuxei16_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u8mf4_m((vbool32_t)(op0), (uint8_t *)(op1), (vuint16mf2_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vsuxei16_v_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u8mf8((uint8_t *)(op0), (vuint16mf4_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vsuxei16_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u8mf8_m((vbool64_t)(op0), (uint8_t *)(op1), (vuint16mf4_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vsuxei32_v_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_i8m1((int8_t *)(op0), (vuint32m4_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vsuxei32_v_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_i8m1_m((vbool8_t)(op0), (int8_t *)(op1), (vuint32m4_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vsuxei32_v_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_i8m2((int8_t *)(op0), (vuint32m8_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vsuxei32_v_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_i8m2_m((vbool4_t)(op0), (int8_t *)(op1), (vuint32m8_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vsuxei32_v_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_i8mf2((int8_t *)(op0), (vuint32m2_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vsuxei32_v_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_i8mf2_m((vbool16_t)(op0), (int8_t *)(op1), (vuint32m2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vsuxei32_v_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_i8mf4((int8_t *)(op0), (vuint32m1_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vsuxei32_v_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_i8mf4_m((vbool32_t)(op0), (int8_t *)(op1), (vuint32m1_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vsuxei32_v_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_i8mf8((int8_t *)(op0), (vuint32mf2_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vsuxei32_v_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_i8mf8_m((vbool64_t)(op0), (int8_t *)(op1), (vuint32mf2_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vadd_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vadd_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vadd_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vadd_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vadd_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vadd_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vadd_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vadd_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vadd_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vadd_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vadd_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vadd_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vadd_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vadd_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vadd_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vadd_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vadd_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vadd_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vadd_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vadd_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vadd_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vadd_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vadd_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vadd_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vadd_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vadd_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vadd_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vadd_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vadd_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vadd_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vadd_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vadd_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vadd_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vadd_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vadd_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vadd_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vadd_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vadd_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vadd_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vadd_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vadd_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vadd_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vadd_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vadd_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vadd_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vadd_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vadd_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vadd_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vadd_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vadd_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vadd_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vadd_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vadd_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vadd_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vadd_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vadd_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vadd_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vadd_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vadd_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vadd_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vadd_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vadd_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vadd_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vadd_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vadd_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vadd_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vadd_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vadd_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vadd_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vadd_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vadd_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vadd_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vadd_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vadd_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vadd_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vadd_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vadd_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vadd_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vadd_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vadd_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vadd_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vadd_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vadd_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vadd_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vadd_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vadd_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vadd_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vadd_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vadd_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vadd_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vadd_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vadd_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vadd_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vadd_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vadd_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vadd_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vadd_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vadd_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vadd_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vadd_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vadd_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vadd_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vadd_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vadd_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vadd_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vadd_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vadd_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vadd_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vadd_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vadd_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vadd_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vadd_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vadd_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vadd_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vadd_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vadd_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vadd_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vadd_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vadd_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vadd_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vadd_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vadd_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vadd_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vadd_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vadd_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vadd_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vadd_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vadd_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vadd_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vadd_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vadd_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vadd_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vadd_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vadd_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vadd_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vadd_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vadd_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vadd_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vadd_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vadd_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vadd_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vadd_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vadd_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vadd_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vadd_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vadd_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vadd_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vadd_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vadd_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vadd_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vadd_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vadd_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vadd_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vadd_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vadd_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vadd_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vadd_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vadd_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vadd_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vadd_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vadd_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vadd_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vadd_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vadd_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vadd_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vadd_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vadd_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vadd_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vadd_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vadd_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vadd_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vadd_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vadd_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vadd_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vadd_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vadd_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vadd_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vadd_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vadd_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vadd_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vadd_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vadd_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vadd_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vadd_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vadd_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vadd_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vadd_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vadd_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vadd_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vadd_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vadd_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vadd_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vadd_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vadd_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vadd_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vadd_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vadd_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vadd_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vadd_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vsub_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vsub_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vsub_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vsub_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vsub_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vsub_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vsub_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vsub_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vsub_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vsub_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vsub_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vsub_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vsub_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vsub_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vsub_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vsub_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vsub_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vsub_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vsub_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vsub_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vsub_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vsub_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vsub_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vsub_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vsub_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vsub_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vsub_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vsub_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vsub_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vsub_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vsub_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vsub_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vsub_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vsub_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vsub_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vsub_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vsub_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vsub_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vsub_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vsub_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vsub_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vsub_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vsub_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vsub_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vsub_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vsub_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vsub_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vsub_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vsub_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vsub_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vsub_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vsub_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vsub_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vsub_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vsub_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vsub_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vsub_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vsub_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vsub_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vsub_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vsub_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vsub_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vsub_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vsub_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vsub_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vsub_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vsuxei32_v_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_u8m1((uint8_t *)(op0), (vuint32m4_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vsuxei32_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_u8m1_m((vbool8_t)(op0), (uint8_t *)(op1), (vuint32m4_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vsuxei32_v_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_u8m2((uint8_t *)(op0), (vuint32m8_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vsuxei32_v_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_u8m2_m((vbool4_t)(op0), (uint8_t *)(op1), (vuint32m8_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vsuxei32_v_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_u8mf2((uint8_t *)(op0), (vuint32m2_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vsuxei32_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_u8mf2_m((vbool16_t)(op0), (uint8_t *)(op1), (vuint32m2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vsuxei32_v_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_u8mf4((uint8_t *)(op0), (vuint32m1_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vsuxei32_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_u8mf4_m((vbool32_t)(op0), (uint8_t *)(op1), (vuint32m1_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vsuxei32_v_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_u8mf8((uint8_t *)(op0), (vuint32mf2_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vsuxei32_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_u8mf8_m((vbool64_t)(op0), (uint8_t *)(op1), (vuint32mf2_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vsub_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vsub_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vsub_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vsub_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vsub_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vsub_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vsub_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vsub_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vsub_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vsub_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vsub_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vsub_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vsub_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vsub_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vsub_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vsub_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vsub_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vsub_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vsub_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vsub_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vsub_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vsub_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vsub_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vsub_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vsub_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vsub_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vsub_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vsub_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vsub_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vsub_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vsub_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vsub_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vsub_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vsub_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vsub_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vsub_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vsub_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vsub_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vsub_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vsub_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vsub_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vsub_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vsub_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vsub_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vsub_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vsub_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vsub_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vsub_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vsub_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vsub_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vsub_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vsub_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vsub_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vsub_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vsub_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vsub_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vsub_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vsub_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vsub_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vsub_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vsub_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vsub_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vsub_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vsub_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vsub_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vsub_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vsub_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vsub_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vsub_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vsub_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vsub_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vsub_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vsub_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vsub_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vsub_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vsub_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vsub_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vsub_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vsub_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vsub_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vsub_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vsub_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vsub_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vsub_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vsub_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vsub_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vsub_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vsub_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vsub_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vsub_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vsub_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vsub_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vsub_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vsub_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vsub_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vsub_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vsub_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vsub_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vsub_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vsub_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vsub_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vsub_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vsub_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vsub_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vsub_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vsub_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vsub_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vsub_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vsub_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vsub_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vsub_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vsub_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vsub_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vsub_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vsub_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vsub_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vsub_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vsub_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vsub_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vsub_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vsub_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vsub_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vsub_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vsub_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vsub_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vsub_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vsub_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vsub_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vsub_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vsub_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vsub_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vsub_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vsub_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vsub_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vsub_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vsub_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vsub_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vsub_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vsub_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vsub_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vsub_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vsub_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vsub_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vsub_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vsub_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vsub_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vsub_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vsub_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vsub_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vsub_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vsub_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vsub_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vsub_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vsub_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vsub_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vsub_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vsub_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vsub_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vsub_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vsub_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vsub_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vsub_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vsub_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vsub_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vsub_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vsub_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vsub_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vsub_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vsub_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vsub_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vsub_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vsub_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vsub_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vsub_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vsub_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vsub_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vsub_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vsub_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vsub_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vsub_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vsub_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vsub_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vsub_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vsub_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vsub_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vsub_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vsub_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vsub_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vsub_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vsub_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vsub_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vsub_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vsub_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vsub_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vsub_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vsub_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vsub_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vsub_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsub_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vrsub_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrsub_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrsub_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrsub_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrsub_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrsub_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrsub_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrsub_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrsub_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrsub_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrsub_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrsub_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrsub_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrsub_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrsub_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrsub_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrsub_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrsub_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrsub_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrsub_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrsub_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrsub_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrsub_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrsub_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrsub_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrsub_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrsub_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vrsub_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vrsub_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vrsub_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vrsub_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vrsub_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vrsub_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vrsub_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vrsub_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vrsub_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vrsub_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vrsub_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vrsub_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vrsub_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vrsub_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vrsub_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vrsub_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vrsub_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vrsub_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vrsub_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vrsub_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vrsub_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vrsub_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vrsub_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vrsub_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vrsub_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vrsub_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vrsub_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vrsub_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vrsub_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vrsub_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vrsub_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vrsub_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vrsub_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vrsub_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vrsub_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vrsub_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vrsub_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vrsub_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vrsub_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vrsub_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vrsub_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vrsub_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vrsub_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vrsub_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vrsub_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vrsub_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vrsub_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vrsub_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vrsub_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vrsub_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vrsub_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vrsub_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vrsub_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vrsub_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vrsub_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vrsub_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vrsub_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vrsub_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vrsub_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vrsub_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vrsub_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vrsub_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vrsub_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrsub_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vwaddu_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u16mf4((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u16mf2((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u16m1((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u16m2((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u16m4((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u16m8((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u32mf2((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwaddu_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwaddu_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u32m1((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwaddu_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwaddu_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u32m2((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwaddu_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwaddu_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u32m4((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwaddu_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwaddu_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u32m8((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwaddu_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwaddu_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u64m1((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwaddu_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwaddu_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u64m2((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwaddu_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwaddu_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u64m4((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwaddu_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwaddu_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vwaddu_vx_u64m8((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwaddu_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwsubu_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u16mf4((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vwsubu_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vwsubu_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u16mf2((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vwsubu_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vwsubu_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u16m1((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vwsubu_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vwsubu_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u16m2((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vwsubu_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vwsubu_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u16m4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vwsubu_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vwsubu_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u16m8((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vwsubu_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vwsubu_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u32mf2((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vwsubu_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vwsubu_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u32m1((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vwsubu_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vwsubu_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u32m2((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vwsubu_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vwsubu_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u32m4((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vwsubu_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vwsubu_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u32m8((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vwsubu_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vwsubu_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u64m1((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vwsubu_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vwsubu_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u64m2((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vwsubu_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vwsubu_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u64m4((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vwsubu_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vwsubu_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vwsubu_vv_u64m8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vwsubu_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vwsubu_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u16mf4((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u16mf2((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u16m1((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u16m2((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u16m4((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u16m8((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u32mf2((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwsubu_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwsubu_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u32m1((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwsubu_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwsubu_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u32m2((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwsubu_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwsubu_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u32m4((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwsubu_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwsubu_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u32m8((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwsubu_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwsubu_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u64m1((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwsubu_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwsubu_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u64m2((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwsubu_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwsubu_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u64m4((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwsubu_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwsubu_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vwsubu_vx_u64m8((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwsubu_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwadd_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i16mf4((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vwadd_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vwadd_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i16mf2((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vwadd_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vwadd_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i16m1((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vwadd_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vwadd_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i16m2((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vwadd_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vwadd_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i16m4((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vwadd_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vwadd_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i16m8((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vwadd_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vwadd_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i32mf2((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vwadd_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vwadd_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i32m1((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vwadd_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vwadd_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i32m2((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vwadd_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vwadd_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i32m4((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vwadd_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vwadd_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i32m8((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vwadd_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vwadd_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i64m1((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vwadd_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vwadd_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i64m2((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vwadd_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vwadd_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i64m4((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vwadd_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vwadd_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vwadd_vv_i64m8((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vwadd_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vwadd_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i16mf4((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i16mf2((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i16m1((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i16m2((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i16m4((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i16m8((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i32mf2((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwadd_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwadd_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i32m1((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwadd_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwadd_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i32m2((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwadd_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwadd_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i32m4((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwadd_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwadd_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i32m8((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwadd_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwadd_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i64m1((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwadd_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwadd_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i64m2((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwadd_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwadd_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i64m4((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwadd_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwadd_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vwadd_vx_i64m8((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwadd_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vsuxei64_v_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_i8m1((int8_t *)(op0), (vuint64m8_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vsuxei64_v_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_i8m1_m((vbool8_t)(op0), (int8_t *)(op1), (vuint64m8_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vsuxei64_v_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_i8mf2((int8_t *)(op0), (vuint64m4_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vsuxei64_v_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_i8mf2_m((vbool16_t)(op0), (int8_t *)(op1), (vuint64m4_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vsuxei64_v_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_i8mf4((int8_t *)(op0), (vuint64m2_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vsuxei64_v_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_i8mf4_m((vbool32_t)(op0), (int8_t *)(op1), (vuint64m2_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vsuxei64_v_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_i8mf8((int8_t *)(op0), (vuint64m1_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vsuxei64_v_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_i8mf8_m((vbool64_t)(op0), (int8_t *)(op1), (vuint64m1_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vwsub_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i16mf4((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vwsub_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vwsub_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i16mf2((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vwsub_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vwsub_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i16m1((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vwsub_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vwsub_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i16m2((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vwsub_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vwsub_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i16m4((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vwsub_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vwsub_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i16m8((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vwsub_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vwsub_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i32mf2((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vwsub_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vwsub_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i32m1((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vwsub_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vwsub_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i32m2((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vwsub_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vwsub_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i32m4((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vwsub_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vwsub_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i32m8((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vwsub_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vwsub_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i64m1((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vwsub_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vwsub_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i64m2((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vwsub_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vwsub_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i64m4((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vwsub_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vwsub_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vwsub_vv_i64m8((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vwsub_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vwsub_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i16mf4((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i16mf2((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i16m1((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i16m2((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i16m4((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i16m8((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i32mf2((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwsub_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwsub_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i32m1((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwsub_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwsub_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i32m2((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwsub_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwsub_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i32m4((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwsub_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwsub_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i32m8((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwsub_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwsub_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i64m1((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwsub_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwsub_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i64m2((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwsub_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwsub_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i64m4((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwsub_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwsub_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vwsub_vx_i64m8((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwsub_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwaddu_wx_u16mf4(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u16mf4((vuint16mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_wx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_wx_u16mf2(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u16mf2((vuint16mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_wx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_wx_u16m1(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u16m1((vuint16m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_wx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_wx_u16m2(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u16m2((vuint16m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_wx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_wx_u16m4(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u16m4((vuint16m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_wx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_wx_u16m8(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u16m8((vuint16m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwaddu_wx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwaddu_wx_u32mf2(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u32mf2((vuint32mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwaddu_wx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwaddu_wx_u32m1(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u32m1((vuint32m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwaddu_wx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwaddu_wx_u32m2(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u32m2((vuint32m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwaddu_wx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwaddu_wx_u32m4(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u32m4((vuint32m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwaddu_wx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwaddu_wx_u32m8(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u32m8((vuint32m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwaddu_wx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwaddu_wx_u64m1(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u64m1((vuint64m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwaddu_wx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwaddu_wx_u64m2(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u64m2((vuint64m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwaddu_wx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwaddu_wx_u64m4(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u64m4((vuint64m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwaddu_wx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwaddu_wx_u64m8(op0, op1, op2) \
__builtin_rvv_vwaddu_wx_u64m8((vuint64m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwaddu_wx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwaddu_wx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwsubu_wv_u16mf4(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u16mf4((vuint16mf4_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vwsubu_wv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vwsubu_wv_u16mf2(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u16mf2((vuint16mf2_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vwsubu_wv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vwsubu_wv_u16m1(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u16m1((vuint16m1_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vwsubu_wv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vwsubu_wv_u16m2(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u16m2((vuint16m2_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vwsubu_wv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vwsubu_wv_u16m4(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u16m4((vuint16m4_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vwsubu_wv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vwsubu_wv_u16m8(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u16m8((vuint16m8_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vwsubu_wv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vwsubu_wv_u32mf2(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u32mf2((vuint32mf2_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vwsubu_wv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vwsubu_wv_u32m1(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u32m1((vuint32m1_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vwsubu_wv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vwsubu_wv_u32m2(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u32m2((vuint32m2_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vwsubu_wv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vwsubu_wv_u32m4(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u32m4((vuint32m4_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vwsubu_wv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vwsubu_wv_u32m8(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u32m8((vuint32m8_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vwsubu_wv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vwsubu_wv_u64m1(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u64m1((vuint64m1_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vwsubu_wv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vwsubu_wv_u64m2(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u64m2((vuint64m2_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vwsubu_wv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vwsubu_wv_u64m4(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u64m4((vuint64m4_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vwsubu_wv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vwsubu_wv_u64m8(op0, op1, op2) \
__builtin_rvv_vwsubu_wv_u64m8((vuint64m8_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vwsubu_wv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vwsubu_wx_u16mf4(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u16mf4((vuint16mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_wx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_wx_u16mf2(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u16mf2((vuint16mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_wx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_wx_u16m1(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u16m1((vuint16m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_wx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_wx_u16m2(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u16m2((vuint16m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_wx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_wx_u16m4(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u16m4((vuint16m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_wx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_wx_u16m8(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u16m8((vuint16m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwsubu_wx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwsubu_wx_u32mf2(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u32mf2((vuint32mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwsubu_wx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwsubu_wx_u32m1(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u32m1((vuint32m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwsubu_wx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwsubu_wx_u32m2(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u32m2((vuint32m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwsubu_wx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwsubu_wx_u32m4(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u32m4((vuint32m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwsubu_wx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwsubu_wx_u32m8(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u32m8((vuint32m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwsubu_wx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwsubu_wx_u64m1(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u64m1((vuint64m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwsubu_wx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwsubu_wx_u64m2(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u64m2((vuint64m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwsubu_wx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwsubu_wx_u64m4(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u64m4((vuint64m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwsubu_wx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwsubu_wx_u64m8(op0, op1, op2) \
__builtin_rvv_vwsubu_wx_u64m8((vuint64m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwsubu_wx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsubu_wx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwadd_wv_i16mf4(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i16mf4((vint16mf4_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vwadd_wv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vwadd_wv_i16mf2(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i16mf2((vint16mf2_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vwadd_wv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vwadd_wv_i16m1(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i16m1((vint16m1_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vwadd_wv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vwadd_wv_i16m2(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i16m2((vint16m2_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vwadd_wv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vwadd_wv_i16m4(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i16m4((vint16m4_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vwadd_wv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vwadd_wv_i16m8(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i16m8((vint16m8_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vwadd_wv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vwadd_wv_i32mf2(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i32mf2((vint32mf2_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vwadd_wv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vwadd_wv_i32m1(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i32m1((vint32m1_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vwadd_wv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vwadd_wv_i32m2(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i32m2((vint32m2_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vwadd_wv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vwadd_wv_i32m4(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i32m4((vint32m4_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vwadd_wv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vwadd_wv_i32m8(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i32m8((vint32m8_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vwadd_wv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vwadd_wv_i64m1(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i64m1((vint64m1_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vwadd_wv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vwadd_wv_i64m2(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i64m2((vint64m2_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vwadd_wv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vwadd_wv_i64m4(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i64m4((vint64m4_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vwadd_wv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vwadd_wv_i64m8(op0, op1, op2) \
__builtin_rvv_vwadd_wv_i64m8((vint64m8_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vwadd_wv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vwadd_wx_i16mf4(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i16mf4((vint16mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_wx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_wx_i16mf2(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i16mf2((vint16mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_wx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_wx_i16m1(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i16m1((vint16m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_wx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_wx_i16m2(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i16m2((vint16m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_wx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_wx_i16m4(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i16m4((vint16m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_wx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_wx_i16m8(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i16m8((vint16m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwadd_wx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwadd_wx_i32mf2(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i32mf2((vint32mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwadd_wx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwadd_wx_i32m1(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i32m1((vint32m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwadd_wx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwadd_wx_i32m2(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i32m2((vint32m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwadd_wx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwadd_wx_i32m4(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i32m4((vint32m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwadd_wx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwadd_wx_i32m8(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i32m8((vint32m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwadd_wx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwadd_wx_i64m1(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i64m1((vint64m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwadd_wx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwadd_wx_i64m2(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i64m2((vint64m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwadd_wx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwadd_wx_i64m4(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i64m4((vint64m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwadd_wx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwadd_wx_i64m8(op0, op1, op2) \
__builtin_rvv_vwadd_wx_i64m8((vint64m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwadd_wx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwadd_wx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwsub_wv_i16mf4(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i16mf4((vint16mf4_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vwsub_wv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vwsub_wv_i16mf2(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i16mf2((vint16mf2_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vwsub_wv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vwsub_wv_i16m1(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i16m1((vint16m1_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vwsub_wv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vwsub_wv_i16m2(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i16m2((vint16m2_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vwsub_wv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vwsub_wv_i16m4(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i16m4((vint16m4_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vwsub_wv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vwsub_wv_i16m8(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i16m8((vint16m8_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vwsub_wv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vwsub_wv_i32mf2(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i32mf2((vint32mf2_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vwsub_wv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vwsub_wv_i32m1(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i32m1((vint32m1_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vwsub_wv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vwsub_wv_i32m2(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i32m2((vint32m2_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vwsub_wv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vwsub_wv_i32m4(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i32m4((vint32m4_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vwsub_wv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vwsub_wv_i32m8(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i32m8((vint32m8_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vwsub_wv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vwsub_wv_i64m1(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i64m1((vint64m1_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vwsub_wv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vwsub_wv_i64m2(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i64m2((vint64m2_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vwsub_wv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vwsub_wv_i64m4(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i64m4((vint64m4_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vwsub_wv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vwsub_wv_i64m8(op0, op1, op2) \
__builtin_rvv_vwsub_wv_i64m8((vint64m8_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vwsub_wv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vwsub_wx_i16mf4(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i16mf4((vint16mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_wx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_wx_i16mf2(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i16mf2((vint16mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_wx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_wx_i16m1(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i16m1((vint16m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_wx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_wx_i16m2(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i16m2((vint16m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_wx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_wx_i16m4(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i16m4((vint16m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_wx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_wx_i16m8(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i16m8((vint16m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwsub_wx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwsub_wx_i32mf2(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i32mf2((vint32mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwsub_wx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwsub_wx_i32m1(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i32m1((vint32m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwsub_wx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwsub_wx_i32m2(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i32m2((vint32m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwsub_wx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwsub_wx_i32m4(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i32m4((vint32m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwsub_wx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwsub_wx_i32m8(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i32m8((vint32m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwsub_wx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwsub_wx_i64m1(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i64m1((vint64m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwsub_wx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwsub_wx_i64m2(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i64m2((vint64m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwsub_wx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwsub_wx_i64m4(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i64m4((vint64m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwsub_wx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwsub_wx_i64m8(op0, op1, op2) \
__builtin_rvv_vwsub_wx_i64m8((vint64m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwsub_wx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwsub_wx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwcvt_x_x_v_i16m2(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i16m2((vint8m1_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i16m2_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i16m4(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i16m4((vint8m2_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i16m4_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i16m8(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i16m8((vint8m4_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i16m8_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i16m1(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i16m1((vint8mf2_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i16m1_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i16mf2(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i16mf2((vint8mf4_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i16mf2_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i16mf4(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i16mf4((vint8mf8_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i16mf4_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i32m2(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i32m2((vint16m1_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i32m2_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i32m4(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i32m4((vint16m2_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i32m4_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i32m8(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i32m8((vint16m4_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i32m8_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i32m1(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i32m1((vint16mf2_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i32m1_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i32mf2(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i32mf2((vint16mf4_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i32mf2_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i64m2(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i64m2((vint32m1_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i64m2_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i64m4(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i64m4((vint32m2_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i64m4_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i64m8(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i64m8((vint32m4_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i64m8_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vwcvt_x_x_v_i64m1(op0, op1) \
__builtin_rvv_vwcvt_x_x_v_i64m1((vint32mf2_t)(op0), (size_t)(op1))
#define vwcvt_x_x_v_i64m1_m(op0, op1, op2, op3) \
__builtin_rvv_vwcvt_x_x_v_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vsuxei64_v_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_u8m1((uint8_t *)(op0), (vuint64m8_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vsuxei64_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_u8m1_m((vbool8_t)(op0), (uint8_t *)(op1), (vuint64m8_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vsuxei64_v_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_u8mf2((uint8_t *)(op0), (vuint64m4_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vsuxei64_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_u8mf2_m((vbool16_t)(op0), (uint8_t *)(op1), (vuint64m4_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vsuxei64_v_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_u8mf4((uint8_t *)(op0), (vuint64m2_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vsuxei64_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_u8mf4_m((vbool32_t)(op0), (uint8_t *)(op1), (vuint64m2_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vsuxei64_v_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_u8mf8((uint8_t *)(op0), (vuint64m1_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vsuxei64_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_u8mf8_m((vbool64_t)(op0), (uint8_t *)(op1), (vuint64m1_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vadc_vvm_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vvm_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vvm_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vadc_vvm_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vadc_vvm_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vvm_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vvm_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vvm_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vvm_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vvm_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vvm_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vadc_vvm_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vvm_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vvm_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vvm_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vvm_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vvm_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vvm_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vvm_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vvm_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vvm_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vvm_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vxm_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i8m1((vint8m1_t)(op0), (int8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vxm_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i8m2((vint8m2_t)(op0), (int8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vxm_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i8m4((vint8m4_t)(op0), (int8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vadc_vxm_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i8m8((vint8m8_t)(op0), (int8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vadc_vxm_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vxm_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vxm_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vxm_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i16m1((vint16m1_t)(op0), (int16_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vxm_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i16m2((vint16m2_t)(op0), (int16_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vxm_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i16m4((vint16m4_t)(op0), (int16_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vxm_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i16m8((vint16m8_t)(op0), (int16_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vadc_vxm_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vxm_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vxm_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i32m1((vint32m1_t)(op0), (int32_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vxm_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i32m2((vint32m2_t)(op0), (int32_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vxm_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i32m4((vint32m4_t)(op0), (int32_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vxm_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i32m8((vint32m8_t)(op0), (int32_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vxm_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vxm_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i64m1((vint64m1_t)(op0), (int64_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vxm_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i64m2((vint64m2_t)(op0), (int64_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vxm_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i64m4((vint64m4_t)(op0), (int64_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vxm_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_i64m8((vint64m8_t)(op0), (int64_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vvm_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vvm_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vvm_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vadc_vvm_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vadc_vvm_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vvm_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vvm_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vvm_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vvm_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vvm_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vvm_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vadc_vvm_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vvm_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vvm_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vvm_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vvm_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vvm_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vvm_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vvm_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vvm_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vvm_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vvm_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vvm_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vxm_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vxm_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vxm_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vadc_vxm_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vadc_vxm_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vxm_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vxm_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vxm_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vxm_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vxm_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vxm_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vadc_vxm_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vxm_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vxm_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vxm_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vxm_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vadc_vxm_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vadc_vxm_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vxm_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vadc_vxm_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vadc_vxm_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vadc_vxm_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vadc_vxm_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vvm_i8m1_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i8m1_b8((vint8m1_t)(op0), (vint8m1_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vvm_i8m2_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i8m2_b4((vint8m2_t)(op0), (vint8m2_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vvm_i8m4_b2(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i8m4_b2((vint8m4_t)(op0), (vint8m4_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmadc_vvm_i8m8_b1(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i8m8_b1((vint8m8_t)(op0), (vint8m8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vmadc_vvm_i8mf2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i8mf2_b16((vint8mf2_t)(op0), (vint8mf2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vvm_i8mf4_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i8mf4_b32((vint8mf4_t)(op0), (vint8mf4_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vvm_i8mf8_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i8mf8_b64((vint8mf8_t)(op0), (vint8mf8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vvm_i16m1_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i16m1_b16((vint16m1_t)(op0), (vint16m1_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vvm_i16m2_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i16m2_b8((vint16m2_t)(op0), (vint16m2_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vvm_i16m4_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i16m4_b4((vint16m4_t)(op0), (vint16m4_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vvm_i16m8_b2(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i16m8_b2((vint16m8_t)(op0), (vint16m8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmadc_vvm_i16mf2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i16mf2_b32((vint16mf2_t)(op0), (vint16mf2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vvm_i16mf4_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i16mf4_b64((vint16mf4_t)(op0), (vint16mf4_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vvm_i32m1_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i32m1_b32((vint32m1_t)(op0), (vint32m1_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vvm_i32m2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i32m2_b16((vint32m2_t)(op0), (vint32m2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vvm_i32m4_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i32m4_b8((vint32m4_t)(op0), (vint32m4_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vvm_i32m8_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i32m8_b4((vint32m8_t)(op0), (vint32m8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vvm_i32mf2_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i32mf2_b64((vint32mf2_t)(op0), (vint32mf2_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vvm_i64m1_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i64m1_b64((vint64m1_t)(op0), (vint64m1_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vvm_i64m2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i64m2_b32((vint64m2_t)(op0), (vint64m2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vvm_i64m4_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i64m4_b16((vint64m4_t)(op0), (vint64m4_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vvm_i64m8_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_i64m8_b8((vint64m8_t)(op0), (vint64m8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vxm_i8m1_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i8m1_b8((vint8m1_t)(op0), (int8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vxm_i8m2_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i8m2_b4((vint8m2_t)(op0), (int8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vxm_i8m4_b2(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i8m4_b2((vint8m4_t)(op0), (int8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmadc_vxm_i8m8_b1(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i8m8_b1((vint8m8_t)(op0), (int8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vmadc_vxm_i8mf2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i8mf2_b16((vint8mf2_t)(op0), (int8_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vxm_i8mf4_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i8mf4_b32((vint8mf4_t)(op0), (int8_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vxm_i8mf8_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i8mf8_b64((vint8mf8_t)(op0), (int8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vxm_i16m1_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i16m1_b16((vint16m1_t)(op0), (int16_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vxm_i16m2_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i16m2_b8((vint16m2_t)(op0), (int16_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vxm_i16m4_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i16m4_b4((vint16m4_t)(op0), (int16_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vxm_i16m8_b2(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i16m8_b2((vint16m8_t)(op0), (int16_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmadc_vxm_i16mf2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i16mf2_b32((vint16mf2_t)(op0), (int16_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vxm_i16mf4_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i16mf4_b64((vint16mf4_t)(op0), (int16_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vxm_i32m1_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i32m1_b32((vint32m1_t)(op0), (int32_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vxm_i32m2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i32m2_b16((vint32m2_t)(op0), (int32_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vxm_i32m4_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i32m4_b8((vint32m4_t)(op0), (int32_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vxm_i32m8_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i32m8_b4((vint32m8_t)(op0), (int32_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vxm_i32mf2_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i32mf2_b64((vint32mf2_t)(op0), (int32_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vxm_i64m1_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i64m1_b64((vint64m1_t)(op0), (int64_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vxm_i64m2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i64m2_b32((vint64m2_t)(op0), (int64_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vxm_i64m4_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i64m4_b16((vint64m4_t)(op0), (int64_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vxm_i64m8_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_i64m8_b8((vint64m8_t)(op0), (int64_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vvm_u8m1_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u8m1_b8((vuint8m1_t)(op0), (vuint8m1_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vvm_u8m2_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u8m2_b4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vvm_u8m4_b2(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u8m4_b2((vuint8m4_t)(op0), (vuint8m4_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmadc_vvm_u8m8_b1(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u8m8_b1((vuint8m8_t)(op0), (vuint8m8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vmadc_vvm_u8mf2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u8mf2_b16((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vvm_u8mf4_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u8mf4_b32((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vvm_u8mf8_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u8mf8_b64((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vvm_u16m1_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u16m1_b16((vuint16m1_t)(op0), (vuint16m1_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vvm_u16m2_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u16m2_b8((vuint16m2_t)(op0), (vuint16m2_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vvm_u16m4_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u16m4_b4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vvm_u16m8_b2(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u16m8_b2((vuint16m8_t)(op0), (vuint16m8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmadc_vvm_u16mf2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u16mf2_b32((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vvm_u16mf4_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u16mf4_b64((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vvm_u32m1_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u32m1_b32((vuint32m1_t)(op0), (vuint32m1_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vvm_u32m2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u32m2_b16((vuint32m2_t)(op0), (vuint32m2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vvm_u32m4_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u32m4_b8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vvm_u32m8_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u32m8_b4((vuint32m8_t)(op0), (vuint32m8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vvm_u32mf2_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u32mf2_b64((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vvm_u64m1_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u64m1_b64((vuint64m1_t)(op0), (vuint64m1_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vvm_u64m2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u64m2_b32((vuint64m2_t)(op0), (vuint64m2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vvm_u64m4_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u64m4_b16((vuint64m4_t)(op0), (vuint64m4_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vvm_u64m8_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vvm_u64m8_b8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vxm_u8m1_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u8m1_b8((vuint8m1_t)(op0), (uint8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vxm_u8m2_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u8m2_b4((vuint8m2_t)(op0), (uint8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vxm_u8m4_b2(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u8m4_b2((vuint8m4_t)(op0), (uint8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmadc_vxm_u8m8_b1(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u8m8_b1((vuint8m8_t)(op0), (uint8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vmadc_vxm_u8mf2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u8mf2_b16((vuint8mf2_t)(op0), (uint8_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vxm_u8mf4_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u8mf4_b32((vuint8mf4_t)(op0), (uint8_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vxm_u8mf8_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u8mf8_b64((vuint8mf8_t)(op0), (uint8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vxm_u16m1_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u16m1_b16((vuint16m1_t)(op0), (uint16_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vxm_u16m2_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u16m2_b8((vuint16m2_t)(op0), (uint16_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vxm_u16m4_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u16m4_b4((vuint16m4_t)(op0), (uint16_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vxm_u16m8_b2(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u16m8_b2((vuint16m8_t)(op0), (uint16_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmadc_vxm_u16mf2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u16mf2_b32((vuint16mf2_t)(op0), (uint16_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vxm_u16mf4_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u16mf4_b64((vuint16mf4_t)(op0), (uint16_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vxm_u32m1_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u32m1_b32((vuint32m1_t)(op0), (uint32_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vxm_u32m2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u32m2_b16((vuint32m2_t)(op0), (uint32_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vxm_u32m4_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u32m4_b8((vuint32m4_t)(op0), (uint32_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vxm_u32m8_b4(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u32m8_b4((vuint32m8_t)(op0), (uint32_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmadc_vxm_u32mf2_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u32mf2_b64((vuint32mf2_t)(op0), (uint32_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vxm_u64m1_b64(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u64m1_b64((vuint64m1_t)(op0), (uint64_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmadc_vxm_u64m2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u64m2_b32((vuint64m2_t)(op0), (uint64_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmadc_vxm_u64m4_b16(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u64m4_b16((vuint64m4_t)(op0), (uint64_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmadc_vxm_u64m8_b8(op0, op1, op2, op3) \
__builtin_rvv_vmadc_vxm_u64m8_b8((vuint64m8_t)(op0), (uint64_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmadc_vv_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i8m1_b8((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmadc_vv_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i8m2_b4((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmadc_vv_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i8m4_b2((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmadc_vv_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i8m8_b1((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmadc_vv_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i8mf2_b16((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmadc_vv_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i8mf4_b32((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmadc_vv_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i8mf8_b64((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmadc_vv_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i16m1_b16((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmadc_vv_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i16m2_b8((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmadc_vv_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i16m4_b4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmadc_vv_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i16m8_b2((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmadc_vv_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i16mf2_b32((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmadc_vv_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i16mf4_b64((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmadc_vv_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i32m1_b32((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmadc_vv_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i32m2_b16((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmadc_vv_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i32m4_b8((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmadc_vv_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i32m8_b4((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmadc_vv_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i32mf2_b64((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmadc_vv_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i64m1_b64((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmadc_vv_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i64m2_b32((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmadc_vv_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i64m4_b16((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmadc_vv_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vv_i64m8_b8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmadc_vx_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i8m1_b8((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmadc_vx_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i8m2_b4((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmadc_vx_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i8m4_b2((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmadc_vx_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i8m8_b1((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmadc_vx_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i8mf2_b16((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmadc_vx_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i8mf4_b32((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmadc_vx_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i8mf8_b64((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmadc_vx_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i16m1_b16((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmadc_vx_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i16m2_b8((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmadc_vx_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i16m4_b4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmadc_vx_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i16m8_b2((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmadc_vx_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i16mf2_b32((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmadc_vx_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i16mf4_b64((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmadc_vx_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i32m1_b32((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmadc_vx_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i32m2_b16((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmadc_vx_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i32m4_b8((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmadc_vx_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i32m8_b4((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmadc_vx_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i32mf2_b64((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmadc_vx_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i64m1_b64((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmadc_vx_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i64m2_b32((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmadc_vx_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i64m4_b16((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmadc_vx_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vx_i64m8_b8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vsuxei8_v_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_i16m1((int16_t *)(op0), (vuint8mf2_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vsuxei8_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_i16m1_m((vbool16_t)(op0), (int16_t *)(op1), (vuint8mf2_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vsuxei8_v_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_i16m2((int16_t *)(op0), (vuint8m1_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vsuxei8_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_i16m2_m((vbool8_t)(op0), (int16_t *)(op1), (vuint8m1_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vsuxei8_v_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_i16m4((int16_t *)(op0), (vuint8m2_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vsuxei8_v_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_i16m4_m((vbool4_t)(op0), (int16_t *)(op1), (vuint8m2_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vsuxei8_v_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_i16m8((int16_t *)(op0), (vuint8m4_t)(op1), (vint16m8_t)(op2), (size_t)(op3))
#define vsuxei8_v_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_i16m8_m((vbool2_t)(op0), (int16_t *)(op1), (vuint8m4_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vsuxei8_v_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_i16mf2((int16_t *)(op0), (vuint8mf4_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vsuxei8_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_i16mf2_m((vbool32_t)(op0), (int16_t *)(op1), (vuint8mf4_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vsuxei8_v_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_i16mf4((int16_t *)(op0), (vuint8mf8_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vsuxei8_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_i16mf4_m((vbool64_t)(op0), (int16_t *)(op1), (vuint8mf8_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmadc_vv_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u8m1_b8((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmadc_vv_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u8m2_b4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmadc_vv_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u8m4_b2((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmadc_vv_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u8m8_b1((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmadc_vv_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u8mf2_b16((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmadc_vv_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u8mf4_b32((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmadc_vv_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u8mf8_b64((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmadc_vv_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u16m1_b16((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmadc_vv_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u16m2_b8((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmadc_vv_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u16m4_b4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmadc_vv_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u16m8_b2((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmadc_vv_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u16mf2_b32((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmadc_vv_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u16mf4_b64((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmadc_vv_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u32m1_b32((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmadc_vv_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u32m2_b16((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmadc_vv_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u32m4_b8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmadc_vv_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u32m8_b4((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmadc_vv_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u32mf2_b64((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmadc_vv_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u64m1_b64((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmadc_vv_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u64m2_b32((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmadc_vv_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u64m4_b16((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmadc_vv_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vv_u64m8_b8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmadc_vx_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u8m1_b8((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmadc_vx_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u8m2_b4((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmadc_vx_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u8m4_b2((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmadc_vx_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u8m8_b1((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmadc_vx_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u8mf2_b16((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmadc_vx_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u8mf4_b32((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmadc_vx_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u8mf8_b64((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmadc_vx_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u16m1_b16((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmadc_vx_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u16m2_b8((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmadc_vx_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u16m4_b4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmadc_vx_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u16m8_b2((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmadc_vx_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u16mf2_b32((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmadc_vx_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u16mf4_b64((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmadc_vx_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u32m1_b32((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmadc_vx_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u32m2_b16((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmadc_vx_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u32m4_b8((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmadc_vx_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u32m8_b4((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmadc_vx_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u32mf2_b64((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmadc_vx_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u64m1_b64((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmadc_vx_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u64m2_b32((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmadc_vx_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u64m4_b16((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmadc_vx_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmadc_vx_u64m8_b8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vsbc_vvm_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vvm_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vvm_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vsbc_vvm_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vsbc_vvm_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vvm_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vvm_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vvm_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vvm_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vvm_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vvm_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vsbc_vvm_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vvm_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vvm_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vvm_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vvm_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vvm_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vvm_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vvm_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vvm_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vvm_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vvm_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vxm_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i8m1((vint8m1_t)(op0), (int8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vxm_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i8m2((vint8m2_t)(op0), (int8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vxm_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i8m4((vint8m4_t)(op0), (int8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vsbc_vxm_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i8m8((vint8m8_t)(op0), (int8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vsbc_vxm_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vxm_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vxm_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vxm_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i16m1((vint16m1_t)(op0), (int16_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vxm_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i16m2((vint16m2_t)(op0), (int16_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vxm_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i16m4((vint16m4_t)(op0), (int16_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vxm_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i16m8((vint16m8_t)(op0), (int16_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vsbc_vxm_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vxm_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vxm_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i32m1((vint32m1_t)(op0), (int32_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vxm_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i32m2((vint32m2_t)(op0), (int32_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vxm_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i32m4((vint32m4_t)(op0), (int32_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vxm_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i32m8((vint32m8_t)(op0), (int32_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vxm_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vxm_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i64m1((vint64m1_t)(op0), (int64_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vxm_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i64m2((vint64m2_t)(op0), (int64_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vxm_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i64m4((vint64m4_t)(op0), (int64_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vxm_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_i64m8((vint64m8_t)(op0), (int64_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vvm_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vvm_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vvm_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vsbc_vvm_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vsbc_vvm_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vvm_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vvm_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vvm_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vvm_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vvm_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vvm_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vsbc_vvm_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vvm_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vvm_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vvm_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vvm_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vvm_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vvm_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vvm_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vvm_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vvm_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vvm_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vvm_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vxm_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vxm_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vxm_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vsbc_vxm_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vsbc_vxm_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vxm_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vxm_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vxm_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vxm_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vxm_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vxm_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vsbc_vxm_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vxm_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vxm_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vxm_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vxm_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsbc_vxm_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vsbc_vxm_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vxm_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vsbc_vxm_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vsbc_vxm_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vsbc_vxm_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vsbc_vxm_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i8m1_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i8m1_b8((vint8m1_t)(op0), (vint8m1_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i8m2_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i8m2_b4((vint8m2_t)(op0), (vint8m2_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i8m4_b2(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i8m4_b2((vint8m4_t)(op0), (vint8m4_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i8m8_b1(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i8m8_b1((vint8m8_t)(op0), (vint8m8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i8mf2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i8mf2_b16((vint8mf2_t)(op0), (vint8mf2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i8mf4_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i8mf4_b32((vint8mf4_t)(op0), (vint8mf4_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i8mf8_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i8mf8_b64((vint8mf8_t)(op0), (vint8mf8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i16m1_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i16m1_b16((vint16m1_t)(op0), (vint16m1_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i16m2_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i16m2_b8((vint16m2_t)(op0), (vint16m2_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i16m4_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i16m4_b4((vint16m4_t)(op0), (vint16m4_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i16m8_b2(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i16m8_b2((vint16m8_t)(op0), (vint16m8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i16mf2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i16mf2_b32((vint16mf2_t)(op0), (vint16mf2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i16mf4_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i16mf4_b64((vint16mf4_t)(op0), (vint16mf4_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i32m1_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i32m1_b32((vint32m1_t)(op0), (vint32m1_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i32m2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i32m2_b16((vint32m2_t)(op0), (vint32m2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i32m4_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i32m4_b8((vint32m4_t)(op0), (vint32m4_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i32m8_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i32m8_b4((vint32m8_t)(op0), (vint32m8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i32mf2_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i32mf2_b64((vint32mf2_t)(op0), (vint32mf2_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i64m1_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i64m1_b64((vint64m1_t)(op0), (vint64m1_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i64m2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i64m2_b32((vint64m2_t)(op0), (vint64m2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i64m4_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i64m4_b16((vint64m4_t)(op0), (vint64m4_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vvm_i64m8_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_i64m8_b8((vint64m8_t)(op0), (vint64m8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i8m1_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i8m1_b8((vint8m1_t)(op0), (int8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i8m2_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i8m2_b4((vint8m2_t)(op0), (int8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i8m4_b2(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i8m4_b2((vint8m4_t)(op0), (int8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i8m8_b1(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i8m8_b1((vint8m8_t)(op0), (int8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i8mf2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i8mf2_b16((vint8mf2_t)(op0), (int8_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i8mf4_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i8mf4_b32((vint8mf4_t)(op0), (int8_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i8mf8_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i8mf8_b64((vint8mf8_t)(op0), (int8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i16m1_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i16m1_b16((vint16m1_t)(op0), (int16_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i16m2_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i16m2_b8((vint16m2_t)(op0), (int16_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i16m4_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i16m4_b4((vint16m4_t)(op0), (int16_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i16m8_b2(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i16m8_b2((vint16m8_t)(op0), (int16_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i16mf2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i16mf2_b32((vint16mf2_t)(op0), (int16_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i16mf4_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i16mf4_b64((vint16mf4_t)(op0), (int16_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i32m1_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i32m1_b32((vint32m1_t)(op0), (int32_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i32m2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i32m2_b16((vint32m2_t)(op0), (int32_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i32m4_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i32m4_b8((vint32m4_t)(op0), (int32_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i32m8_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i32m8_b4((vint32m8_t)(op0), (int32_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i32mf2_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i32mf2_b64((vint32mf2_t)(op0), (int32_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i64m1_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i64m1_b64((vint64m1_t)(op0), (int64_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i64m2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i64m2_b32((vint64m2_t)(op0), (int64_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i64m4_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i64m4_b16((vint64m4_t)(op0), (int64_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vxm_i64m8_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_i64m8_b8((vint64m8_t)(op0), (int64_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u8m1_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u8m1_b8((vuint8m1_t)(op0), (vuint8m1_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u8m2_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u8m2_b4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u8m4_b2(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u8m4_b2((vuint8m4_t)(op0), (vuint8m4_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u8m8_b1(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u8m8_b1((vuint8m8_t)(op0), (vuint8m8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u8mf2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u8mf2_b16((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u8mf4_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u8mf4_b32((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u8mf8_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u8mf8_b64((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u16m1_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u16m1_b16((vuint16m1_t)(op0), (vuint16m1_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u16m2_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u16m2_b8((vuint16m2_t)(op0), (vuint16m2_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u16m4_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u16m4_b4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u16m8_b2(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u16m8_b2((vuint16m8_t)(op0), (vuint16m8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u16mf2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u16mf2_b32((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u16mf4_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u16mf4_b64((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u32m1_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u32m1_b32((vuint32m1_t)(op0), (vuint32m1_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u32m2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u32m2_b16((vuint32m2_t)(op0), (vuint32m2_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u32m4_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u32m4_b8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u32m8_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u32m8_b4((vuint32m8_t)(op0), (vuint32m8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u32mf2_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u32mf2_b64((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u64m1_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u64m1_b64((vuint64m1_t)(op0), (vuint64m1_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u64m2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u64m2_b32((vuint64m2_t)(op0), (vuint64m2_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u64m4_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u64m4_b16((vuint64m4_t)(op0), (vuint64m4_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vvm_u64m8_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vvm_u64m8_b8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u8m1_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u8m1_b8((vuint8m1_t)(op0), (uint8_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u8m2_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u8m2_b4((vuint8m2_t)(op0), (uint8_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u8m4_b2(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u8m4_b2((vuint8m4_t)(op0), (uint8_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u8m8_b1(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u8m8_b1((vuint8m8_t)(op0), (uint8_t)(op1), (vbool1_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u8mf2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u8mf2_b16((vuint8mf2_t)(op0), (uint8_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u8mf4_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u8mf4_b32((vuint8mf4_t)(op0), (uint8_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u8mf8_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u8mf8_b64((vuint8mf8_t)(op0), (uint8_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u16m1_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u16m1_b16((vuint16m1_t)(op0), (uint16_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u16m2_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u16m2_b8((vuint16m2_t)(op0), (uint16_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u16m4_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u16m4_b4((vuint16m4_t)(op0), (uint16_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u16m8_b2(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u16m8_b2((vuint16m8_t)(op0), (uint16_t)(op1), (vbool2_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u16mf2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u16mf2_b32((vuint16mf2_t)(op0), (uint16_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u16mf4_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u16mf4_b64((vuint16mf4_t)(op0), (uint16_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u32m1_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u32m1_b32((vuint32m1_t)(op0), (uint32_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u32m2_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u32m2_b16((vuint32m2_t)(op0), (uint32_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u32m4_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u32m4_b8((vuint32m4_t)(op0), (uint32_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u32m8_b4(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u32m8_b4((vuint32m8_t)(op0), (uint32_t)(op1), (vbool4_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u32mf2_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u32mf2_b64((vuint32mf2_t)(op0), (uint32_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u64m1_b64(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u64m1_b64((vuint64m1_t)(op0), (uint64_t)(op1), (vbool64_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u64m2_b32(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u64m2_b32((vuint64m2_t)(op0), (uint64_t)(op1), (vbool32_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u64m4_b16(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u64m4_b16((vuint64m4_t)(op0), (uint64_t)(op1), (vbool16_t)(op2), (size_t)(op3))
#define vmsbc_vxm_u64m8_b8(op0, op1, op2, op3) \
__builtin_rvv_vmsbc_vxm_u64m8_b8((vuint64m8_t)(op0), (uint64_t)(op1), (vbool8_t)(op2), (size_t)(op3))
#define vsuxei8_v_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_u16m1((uint16_t *)(op0), (vuint8mf2_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vsuxei8_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_u16m1_m((vbool16_t)(op0), (uint16_t *)(op1), (vuint8mf2_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vsuxei8_v_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_u16m2((uint16_t *)(op0), (vuint8m1_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vsuxei8_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_u16m2_m((vbool8_t)(op0), (uint16_t *)(op1), (vuint8m1_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vsuxei8_v_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_u16m4((uint16_t *)(op0), (vuint8m2_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vsuxei8_v_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_u16m4_m((vbool4_t)(op0), (uint16_t *)(op1), (vuint8m2_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vsuxei8_v_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_u16m8((uint16_t *)(op0), (vuint8m4_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vsuxei8_v_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_u16m8_m((vbool2_t)(op0), (uint16_t *)(op1), (vuint8m4_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vsuxei8_v_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_u16mf2((uint16_t *)(op0), (vuint8mf4_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vsuxei8_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_u16mf2_m((vbool32_t)(op0), (uint16_t *)(op1), (vuint8mf4_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vsuxei8_v_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_u16mf4((uint16_t *)(op0), (vuint8mf8_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vsuxei8_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_u16mf4_m((vbool64_t)(op0), (uint16_t *)(op1), (vuint8mf8_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmsbc_vv_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i8m1_b8((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmsbc_vv_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i8m2_b4((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmsbc_vv_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i8m4_b2((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmsbc_vv_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i8m8_b1((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmsbc_vv_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i8mf2_b16((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmsbc_vv_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i8mf4_b32((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmsbc_vv_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i8mf8_b64((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmsbc_vv_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i16m1_b16((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmsbc_vv_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i16m2_b8((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmsbc_vv_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i16m4_b4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmsbc_vv_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i16m8_b2((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmsbc_vv_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i16mf2_b32((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmsbc_vv_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i16mf4_b64((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmsbc_vv_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i32m1_b32((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmsbc_vv_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i32m2_b16((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmsbc_vv_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i32m4_b8((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmsbc_vv_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i32m8_b4((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmsbc_vv_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i32mf2_b64((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmsbc_vv_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i64m1_b64((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmsbc_vv_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i64m2_b32((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmsbc_vv_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i64m4_b16((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmsbc_vv_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_i64m8_b8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmsbc_vx_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i8m1_b8((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsbc_vx_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i8m2_b4((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsbc_vx_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i8m4_b2((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsbc_vx_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i8m8_b1((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsbc_vx_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i8mf2_b16((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsbc_vx_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i8mf4_b32((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsbc_vx_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i8mf8_b64((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsbc_vx_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i16m1_b16((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsbc_vx_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i16m2_b8((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsbc_vx_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i16m4_b4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsbc_vx_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i16m8_b2((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsbc_vx_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i16mf2_b32((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsbc_vx_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i16mf4_b64((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsbc_vx_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i32m1_b32((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsbc_vx_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i32m2_b16((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsbc_vx_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i32m4_b8((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsbc_vx_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i32m8_b4((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsbc_vx_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i32mf2_b64((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsbc_vx_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i64m1_b64((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsbc_vx_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i64m2_b32((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsbc_vx_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i64m4_b16((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsbc_vx_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_i64m8_b8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsbc_vv_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u8m1_b8((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmsbc_vv_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u8m2_b4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmsbc_vv_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u8m4_b2((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmsbc_vv_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u8m8_b1((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmsbc_vv_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u8mf2_b16((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmsbc_vv_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u8mf4_b32((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmsbc_vv_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u8mf8_b64((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmsbc_vv_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u16m1_b16((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmsbc_vv_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u16m2_b8((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmsbc_vv_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u16m4_b4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmsbc_vv_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u16m8_b2((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmsbc_vv_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u16mf2_b32((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmsbc_vv_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u16mf4_b64((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmsbc_vv_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u32m1_b32((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmsbc_vv_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u32m2_b16((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmsbc_vv_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u32m4_b8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmsbc_vv_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u32m8_b4((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmsbc_vv_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u32mf2_b64((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmsbc_vv_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u64m1_b64((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmsbc_vv_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u64m2_b32((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmsbc_vv_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u64m4_b16((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmsbc_vv_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vv_u64m8_b8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmsbc_vx_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u8m1_b8((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsbc_vx_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u8m2_b4((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsbc_vx_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u8m4_b2((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsbc_vx_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u8m8_b1((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsbc_vx_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u8mf2_b16((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsbc_vx_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u8mf4_b32((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsbc_vx_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u8mf8_b64((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsbc_vx_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u16m1_b16((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsbc_vx_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u16m2_b8((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsbc_vx_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u16m4_b4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsbc_vx_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u16m8_b2((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsbc_vx_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u16mf2_b32((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsbc_vx_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u16mf4_b64((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsbc_vx_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u32m1_b32((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsbc_vx_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u32m2_b16((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsbc_vx_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u32m4_b8((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsbc_vx_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u32m8_b4((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsbc_vx_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u32mf2_b64((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsbc_vx_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u64m1_b64((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsbc_vx_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u64m2_b32((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsbc_vx_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u64m4_b16((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsbc_vx_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsbc_vx_u64m8_b8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vand_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vand_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vand_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vand_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vand_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vand_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vand_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vand_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vand_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vand_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vand_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vand_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vand_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vand_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vand_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vand_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vand_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vand_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vand_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vand_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vand_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vand_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vand_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vand_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vand_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vand_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vand_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vand_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vand_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vand_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vand_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vand_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vand_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vand_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vand_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vand_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vand_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vand_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vand_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vand_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vand_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vand_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vand_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vand_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vand_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vand_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vand_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vand_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vand_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vand_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vand_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vand_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vand_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vand_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vand_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vand_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vand_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vand_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vand_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vand_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vand_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vand_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vand_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vand_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vand_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vand_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vand_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vand_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vand_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vand_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vand_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vand_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vand_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vand_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vand_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vand_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vand_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vand_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vand_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vand_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vand_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vand_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vand_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vand_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vand_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vand_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vand_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vand_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vand_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vand_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vand_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vand_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vand_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vand_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vand_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vand_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vand_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vand_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vand_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vand_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vand_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vand_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vand_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vand_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vand_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vand_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vand_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vand_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vand_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vand_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vand_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vand_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vand_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vand_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vand_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vand_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vand_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vand_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vand_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vand_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vand_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vand_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vand_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vand_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vand_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vand_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vand_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vand_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vand_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vand_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vand_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vand_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vand_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vand_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vand_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vand_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vand_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vand_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vand_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vand_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vand_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vand_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vand_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vand_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vand_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vand_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vand_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vand_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vand_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vand_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vand_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vand_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vand_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vand_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vand_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vand_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vand_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vand_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vand_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vand_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vand_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vand_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vand_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vand_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vand_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vand_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vand_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vand_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vand_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vand_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vand_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vand_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vand_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vand_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vand_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vand_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vand_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vand_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vand_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vand_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vand_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vand_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vand_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vand_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vand_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vand_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vand_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vand_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vand_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vand_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vand_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vand_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vand_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vand_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vand_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vand_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vand_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vand_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vand_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vand_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vand_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vand_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vand_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vand_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vand_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vand_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vand_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vand_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vand_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vand_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vand_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vand_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vand_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vand_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vand_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vand_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vand_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vand_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vand_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vand_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vand_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vand_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vand_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vand_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vand_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vand_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vand_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vand_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vand_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vand_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vand_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vand_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vand_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vand_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vand_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vand_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vand_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vand_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vand_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vand_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vand_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vand_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vand_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vand_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vand_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vand_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vand_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vand_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vand_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vand_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vand_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vand_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vand_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vand_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vand_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vand_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vand_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vand_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vand_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vand_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vand_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vand_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vand_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vand_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vand_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vxor_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vxor_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vxor_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vxor_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vxor_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vxor_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vxor_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vxor_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vxor_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vxor_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vxor_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vxor_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vxor_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vxor_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vxor_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vxor_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vxor_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vxor_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vxor_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vxor_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vxor_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vxor_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vxor_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vxor_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vxor_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vxor_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vxor_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vxor_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vxor_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vxor_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vxor_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vxor_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vxor_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vxor_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vxor_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vxor_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vxor_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vxor_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vxor_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vxor_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vxor_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vxor_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vxor_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vxor_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vxor_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vxor_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vxor_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vxor_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vxor_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vxor_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vxor_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vxor_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vxor_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vxor_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vxor_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vxor_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vxor_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vxor_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vxor_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vxor_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vxor_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vxor_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vxor_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vxor_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vxor_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vxor_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vxor_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vxor_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vxor_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vxor_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vxor_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vxor_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vxor_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vxor_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vxor_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vxor_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vxor_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vxor_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vxor_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vxor_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vxor_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vxor_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vxor_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vxor_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vxor_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vxor_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vxor_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vxor_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vxor_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vxor_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vxor_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vxor_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vxor_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vxor_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vxor_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vxor_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vxor_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vxor_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vxor_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vxor_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vxor_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vxor_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vxor_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vxor_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vxor_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vxor_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vxor_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vxor_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vxor_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vxor_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vxor_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vxor_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vxor_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vxor_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vxor_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vxor_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vxor_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vxor_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vxor_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vxor_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vxor_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vxor_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vxor_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vxor_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vxor_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vxor_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vxor_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vxor_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vxor_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vxor_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vxor_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vxor_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vsuxei16_v_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i16m1((int16_t *)(op0), (vuint16m1_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vsuxei16_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i16m1_m((vbool16_t)(op0), (int16_t *)(op1), (vuint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vsuxei16_v_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i16m2((int16_t *)(op0), (vuint16m2_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vsuxei16_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i16m2_m((vbool8_t)(op0), (int16_t *)(op1), (vuint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vsuxei16_v_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i16m4((int16_t *)(op0), (vuint16m4_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vsuxei16_v_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i16m4_m((vbool4_t)(op0), (int16_t *)(op1), (vuint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vsuxei16_v_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i16m8((int16_t *)(op0), (vuint16m8_t)(op1), (vint16m8_t)(op2), (size_t)(op3))
#define vsuxei16_v_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i16m8_m((vbool2_t)(op0), (int16_t *)(op1), (vuint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vsuxei16_v_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i16mf2((int16_t *)(op0), (vuint16mf2_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vsuxei16_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i16mf2_m((vbool32_t)(op0), (int16_t *)(op1), (vuint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vsuxei16_v_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i16mf4((int16_t *)(op0), (vuint16mf4_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vsuxei16_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i16mf4_m((vbool64_t)(op0), (int16_t *)(op1), (vuint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vxor_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vxor_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vxor_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vxor_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vxor_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vxor_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vxor_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vxor_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vxor_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vxor_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vxor_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vxor_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vxor_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vxor_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vxor_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vxor_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vxor_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vxor_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vxor_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vxor_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vxor_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vxor_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vxor_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vxor_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vxor_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vxor_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vxor_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vxor_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vxor_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vxor_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vxor_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vxor_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vxor_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vxor_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vxor_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vxor_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vxor_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vxor_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vxor_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vxor_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vxor_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vxor_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vxor_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vxor_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vxor_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vxor_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vxor_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vxor_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vxor_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vxor_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vxor_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vxor_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vxor_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vxor_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vxor_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vxor_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vxor_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vxor_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vxor_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vxor_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vxor_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vxor_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vxor_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vxor_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vxor_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vxor_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vxor_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vxor_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vxor_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vxor_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vxor_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vxor_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vxor_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vxor_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vxor_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vxor_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vxor_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vxor_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vxor_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vxor_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vxor_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vxor_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vxor_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vxor_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vxor_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vxor_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vxor_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vxor_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vxor_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vxor_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vxor_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vxor_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vxor_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vxor_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vxor_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vxor_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vxor_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vxor_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vxor_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vxor_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vxor_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vxor_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vxor_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vxor_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vxor_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vxor_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vxor_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vxor_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vxor_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vxor_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vxor_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vxor_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vxor_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vxor_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vxor_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vxor_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vxor_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vxor_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vxor_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vxor_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vxor_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vxor_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vxor_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vxor_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vxor_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vxor_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vxor_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vxor_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vxor_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vxor_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vxor_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vxor_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vxor_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vor_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vor_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vor_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vor_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vor_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vor_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vor_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vor_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vor_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vor_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vor_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vor_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vor_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vor_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vor_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vor_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vor_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vor_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vor_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vor_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vor_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vor_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vor_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vor_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vor_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vor_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vor_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vor_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vor_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vor_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vor_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vor_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vor_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vor_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vor_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vor_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vor_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vor_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vor_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vor_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vor_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vor_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vor_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vor_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vor_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vor_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vor_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vor_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vor_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vor_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vor_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vor_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vor_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vor_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vor_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vor_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vor_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vor_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vor_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vor_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vor_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vor_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vor_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vor_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vor_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vor_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vor_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vor_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vor_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vor_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vor_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vor_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vor_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vor_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vor_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vor_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vor_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vor_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vor_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vor_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vor_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vor_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vor_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vor_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vor_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vor_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vor_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vor_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vor_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vor_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vor_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vor_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vor_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vor_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vor_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vor_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vor_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vor_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vor_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vor_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vor_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vor_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vor_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vor_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vor_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vor_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vor_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vor_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vor_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vor_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vor_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vor_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vor_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vor_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vor_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vor_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vor_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vor_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vor_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vor_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vor_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vor_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vor_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vor_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vor_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vor_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vor_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vor_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vor_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vor_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vor_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vor_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vor_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vor_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vor_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vor_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vor_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vor_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vor_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vor_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vor_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vor_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vor_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vor_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vor_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vor_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vor_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vor_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vor_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vor_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vor_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vor_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vor_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vor_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vor_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vor_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vor_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vor_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vor_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vor_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vor_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vor_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vor_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vor_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vor_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vor_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vor_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vor_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vor_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vor_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vor_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vor_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vor_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vor_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vor_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vor_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vor_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vor_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vor_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vor_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vor_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vor_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vor_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vor_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vor_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vor_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vor_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vor_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vor_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vor_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vor_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vor_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vor_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vor_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vor_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vor_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vor_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vor_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vor_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vor_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vor_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vor_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vor_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vor_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vor_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vor_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vor_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vor_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vor_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vor_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vor_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vor_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vor_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vor_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vor_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vor_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vor_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vor_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vor_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vor_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vor_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vor_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vor_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vor_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vor_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vor_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vor_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vor_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vor_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vor_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vor_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vor_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vor_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vor_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vor_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vor_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vor_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vor_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vor_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vor_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vor_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vor_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vor_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vor_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vor_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vor_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vor_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vor_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vor_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vor_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vor_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vor_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vor_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vor_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vor_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vor_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vor_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vor_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vor_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vor_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vor_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vor_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vor_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vor_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vor_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vsll_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vsll_vv_i8m1((vint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vsll_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vsll_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vsll_vv_i8m2((vint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vsll_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vsll_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vsll_vv_i8m4((vint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vsll_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vsll_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vsll_vv_i8m8((vint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vsll_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vsll_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vsll_vv_i8mf2((vint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vsll_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vsll_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vsll_vv_i8mf4((vint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vsll_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vsll_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vsll_vv_i8mf8((vint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vsll_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vsll_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vsll_vv_i16m1((vint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vsll_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vsll_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vsll_vv_i16m2((vint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vsll_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vsll_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vsll_vv_i16m4((vint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vsll_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vsll_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vsll_vv_i16m8((vint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vsll_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vsll_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vsll_vv_i16mf2((vint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vsll_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vsll_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vsll_vv_i16mf4((vint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vsll_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vsll_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vsll_vv_i32m1((vint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vsll_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vsll_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vsll_vv_i32m2((vint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vsll_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vsll_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vsll_vv_i32m4((vint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vsll_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vsll_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vsll_vv_i32m8((vint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vsll_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vsll_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vsll_vv_i32mf2((vint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vsll_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vsll_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vsll_vv_i64m1((vint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vsll_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vsll_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vsll_vv_i64m2((vint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vsll_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vsll_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vsll_vv_i64m4((vint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vsll_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vsll_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vsll_vv_i64m8((vint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vsll_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vsll_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vsll_vx_i8m1((vint8m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vsll_vx_i8m2((vint8m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vsll_vx_i8m4((vint8m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vsll_vx_i8m8((vint8m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vsll_vx_i8mf2((vint8mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vsll_vx_i8mf4((vint8mf4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vsll_vx_i8mf8((vint8mf8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vsll_vx_i16m1((vint16m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vsll_vx_i16m2((vint16m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vsll_vx_i16m4((vint16m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vsll_vx_i16m8((vint16m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vsll_vx_i16mf2((vint16mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vsll_vx_i16mf4((vint16mf4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vsll_vx_i32m1((vint32m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vsll_vx_i32m2((vint32m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vsll_vx_i32m4((vint32m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vsll_vx_i32m8((vint32m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vsll_vx_i32mf2((vint32mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vsll_vx_i64m1((vint64m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vsll_vx_i64m2((vint64m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vsll_vx_i64m4((vint64m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vsll_vx_i64m8((vint64m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vsll_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vsll_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vsll_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vsll_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vsll_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vsll_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vsll_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vsll_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vsll_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vsll_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vsll_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vsll_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vsll_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vsll_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vsll_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vsll_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vsll_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vsll_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vsll_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vsll_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vsll_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vsll_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vsll_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vsll_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vsll_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vsll_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vsll_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vsll_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vsll_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vsll_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vsll_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vsll_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vsll_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vsll_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vsll_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vsll_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vsll_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vsll_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vsll_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vsll_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vsll_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vsll_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vsll_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vsll_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vsll_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vsll_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vsll_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vsll_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vsll_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vsll_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vsll_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vsll_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vsll_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vsll_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vsll_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vsll_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vsll_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vsll_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vsll_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vsll_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vsll_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vsll_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vsll_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vsll_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vsll_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vsll_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vsll_vx_u8m1((vuint8m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vsll_vx_u8m2((vuint8m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vsll_vx_u8m4((vuint8m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vsll_vx_u8m8((vuint8m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vsll_vx_u8mf2((vuint8mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vsll_vx_u8mf4((vuint8mf4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vsll_vx_u8mf8((vuint8mf8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vsll_vx_u16m1((vuint16m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vsll_vx_u16m2((vuint16m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vsll_vx_u16m4((vuint16m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vsll_vx_u16m8((vuint16m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vsll_vx_u16mf2((vuint16mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vsll_vx_u16mf4((vuint16mf4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vsll_vx_u32m1((vuint32m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vsll_vx_u32m2((vuint32m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vsll_vx_u32m4((vuint32m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vsll_vx_u32m8((vuint32m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vsll_vx_u32mf2((vuint32mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vsll_vx_u64m1((vuint64m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vsll_vx_u64m2((vuint64m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vsll_vx_u64m4((vuint64m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsll_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vsll_vx_u64m8((vuint64m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsll_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsll_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsuxei16_v_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u16m1((uint16_t *)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vsuxei16_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u16m1_m((vbool16_t)(op0), (uint16_t *)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vsuxei16_v_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u16m2((uint16_t *)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vsuxei16_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u16m2_m((vbool8_t)(op0), (uint16_t *)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vsuxei16_v_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u16m4((uint16_t *)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vsuxei16_v_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u16m4_m((vbool4_t)(op0), (uint16_t *)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vsuxei16_v_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u16m8((uint16_t *)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vsuxei16_v_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u16m8_m((vbool2_t)(op0), (uint16_t *)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vsuxei16_v_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u16mf2((uint16_t *)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vsuxei16_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u16mf2_m((vbool32_t)(op0), (uint16_t *)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vsuxei16_v_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u16mf4((uint16_t *)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vsuxei16_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u16mf4_m((vbool64_t)(op0), (uint16_t *)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vsrl_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vsrl_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vsrl_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vsrl_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vsrl_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vsrl_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vsrl_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vsrl_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vsrl_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vsrl_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vsrl_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vsrl_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vsrl_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vsrl_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vsrl_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vsrl_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vsrl_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vsrl_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vsrl_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vsrl_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vsrl_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vsrl_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vsrl_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vsrl_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vsrl_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vsrl_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vsrl_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vsrl_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vsrl_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vsrl_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vsrl_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vsrl_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vsrl_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vsrl_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vsrl_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vsrl_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vsrl_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vsrl_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vsrl_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vsrl_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vsrl_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vsrl_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vsrl_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vsrl_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vsrl_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vsrl_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u8m1((vuint8m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u8m2((vuint8m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u8m4((vuint8m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u8m8((vuint8m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u8mf2((vuint8mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u8mf4((vuint8mf4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u8mf8((vuint8mf8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u16m1((vuint16m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u16m2((vuint16m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u16m4((vuint16m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u16m8((vuint16m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u16mf2((vuint16mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u16mf4((vuint16mf4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u32m1((vuint32m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u32m2((vuint32m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u32m4((vuint32m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u32m8((vuint32m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u32mf2((vuint32mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u64m1((vuint64m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u64m2((vuint64m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u64m4((vuint64m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsrl_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vsrl_vx_u64m8((vuint64m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsrl_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsrl_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vsra_vv_i8m1((vint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vsra_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vsra_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vsra_vv_i8m2((vint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vsra_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vsra_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vsra_vv_i8m4((vint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vsra_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vsra_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vsra_vv_i8m8((vint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vsra_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vsra_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vsra_vv_i8mf2((vint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vsra_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vsra_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vsra_vv_i8mf4((vint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vsra_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vsra_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vsra_vv_i8mf8((vint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vsra_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vsra_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vsra_vv_i16m1((vint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vsra_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vsra_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vsra_vv_i16m2((vint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vsra_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vsra_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vsra_vv_i16m4((vint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vsra_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vsra_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vsra_vv_i16m8((vint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vsra_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vsra_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vsra_vv_i16mf2((vint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vsra_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vsra_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vsra_vv_i16mf4((vint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vsra_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vsra_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vsra_vv_i32m1((vint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vsra_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vsra_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vsra_vv_i32m2((vint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vsra_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vsra_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vsra_vv_i32m4((vint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vsra_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vsra_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vsra_vv_i32m8((vint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vsra_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vsra_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vsra_vv_i32mf2((vint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vsra_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vsra_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vsra_vv_i64m1((vint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vsra_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vsra_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vsra_vv_i64m2((vint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vsra_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vsra_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vsra_vv_i64m4((vint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vsra_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vsra_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vsra_vv_i64m8((vint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vsra_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vsra_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vsra_vx_i8m1((vint8m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vsra_vx_i8m2((vint8m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vsra_vx_i8m4((vint8m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vsra_vx_i8m8((vint8m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vsra_vx_i8mf2((vint8mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vsra_vx_i8mf4((vint8mf4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vsra_vx_i8mf8((vint8mf8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vsra_vx_i16m1((vint16m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vsra_vx_i16m2((vint16m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vsra_vx_i16m4((vint16m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vsra_vx_i16m8((vint16m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vsra_vx_i16mf2((vint16mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vsra_vx_i16mf4((vint16mf4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vsra_vx_i32m1((vint32m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vsra_vx_i32m2((vint32m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vsra_vx_i32m4((vint32m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vsra_vx_i32m8((vint32m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vsra_vx_i32mf2((vint32mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vsra_vx_i64m1((vint64m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vsra_vx_i64m2((vint64m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vsra_vx_i64m4((vint64m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vsra_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vsra_vx_i64m8((vint64m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vsra_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsra_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wv_u8m1(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u8m1((vuint16m2_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vnsrl_wv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint16m2_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vnsrl_wv_u8m2(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u8m2((vuint16m4_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vnsrl_wv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint16m4_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vnsrl_wv_u8m4(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u8m4((vuint16m8_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vnsrl_wv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint16m8_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vnsrl_wv_u8mf2(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u8mf2((vuint16m1_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vnsrl_wv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint16m1_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vnsrl_wv_u8mf4(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u8mf4((vuint16mf2_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vnsrl_wv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint16mf2_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vnsrl_wv_u8mf8(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u8mf8((vuint16mf4_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vnsrl_wv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint16mf4_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vnsrl_wv_u16m1(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u16m1((vuint32m2_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vnsrl_wv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint32m2_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vnsrl_wv_u16m2(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u16m2((vuint32m4_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vnsrl_wv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint32m4_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vnsrl_wv_u16m4(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u16m4((vuint32m8_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vnsrl_wv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint32m8_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vnsrl_wv_u16mf2(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u16mf2((vuint32m1_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vnsrl_wv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint32m1_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vnsrl_wv_u16mf4(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u16mf4((vuint32mf2_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vnsrl_wv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint32mf2_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vnsrl_wv_u32m1(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u32m1((vuint64m2_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vnsrl_wv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint64m2_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vnsrl_wv_u32m2(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u32m2((vuint64m4_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vnsrl_wv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint64m4_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vnsrl_wv_u32m4(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u32m4((vuint64m8_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vnsrl_wv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint64m8_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vnsrl_wv_u32mf2(op0, op1, op2) \
__builtin_rvv_vnsrl_wv_u32mf2((vuint64m1_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vnsrl_wv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint64m1_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vnsrl_wx_u8m1(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u8m1((vuint16m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint16m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u8m2(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u8m2((vuint16m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint16m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u8m4(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u8m4((vuint16m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint16m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u8mf2(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u8mf2((vuint16m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint16m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u8mf4(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u8mf4((vuint16mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u8mf8(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u8mf8((vuint16mf4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u16m1(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u16m1((vuint32m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint32m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u16m2(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u16m2((vuint32m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint32m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u16m4(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u16m4((vuint32m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint32m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u16mf2(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u16mf2((vuint32m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint32m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u16mf4(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u16mf4((vuint32mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u32m1(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u32m1((vuint64m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint64m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u32m2(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u32m2((vuint64m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint64m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u32m4(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u32m4((vuint64m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint64m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsrl_wx_u32mf2(op0, op1, op2) \
__builtin_rvv_vnsrl_wx_u32mf2((vuint64m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsrl_wx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsrl_wx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint64m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wv_i8m1(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i8m1((vint16m2_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vnsra_wv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint16m2_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vnsra_wv_i8m2(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i8m2((vint16m4_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vnsra_wv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint16m4_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vnsra_wv_i8m4(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i8m4((vint16m8_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vnsra_wv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint16m8_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vnsra_wv_i8mf2(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i8mf2((vint16m1_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vnsra_wv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint16m1_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vnsra_wv_i8mf4(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i8mf4((vint16mf2_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vnsra_wv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint16mf2_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vnsra_wv_i8mf8(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i8mf8((vint16mf4_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vnsra_wv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint16mf4_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vnsra_wv_i16m1(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i16m1((vint32m2_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vnsra_wv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint32m2_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vnsra_wv_i16m2(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i16m2((vint32m4_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vnsra_wv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint32m4_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vnsra_wv_i16m4(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i16m4((vint32m8_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vnsra_wv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint32m8_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vnsra_wv_i16mf2(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i16mf2((vint32m1_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vnsra_wv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint32m1_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vnsra_wv_i16mf4(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i16mf4((vint32mf2_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vnsra_wv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint32mf2_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vnsra_wv_i32m1(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i32m1((vint64m2_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vnsra_wv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint64m2_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vnsra_wv_i32m2(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i32m2((vint64m4_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vnsra_wv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint64m4_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vnsra_wv_i32m4(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i32m4((vint64m8_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vnsra_wv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint64m8_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vnsra_wv_i32mf2(op0, op1, op2) \
__builtin_rvv_vnsra_wv_i32mf2((vint64m1_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vnsra_wv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint64m1_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vnsra_wx_i8m1(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i8m1((vint16m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint16m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i8m2(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i8m2((vint16m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint16m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i8m4(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i8m4((vint16m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint16m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i8mf2(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i8mf2((vint16m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint16m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i8mf4(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i8mf4((vint16mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint16mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i8mf8(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i8mf8((vint16mf4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint16mf4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i16m1(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i16m1((vint32m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint32m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i16m2(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i16m2((vint32m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint32m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i16m4(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i16m4((vint32m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint32m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i16mf2(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i16mf2((vint32m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint32m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i16mf4(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i16mf4((vint32mf2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint32mf2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i32m1(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i32m1((vint64m2_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint64m2_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i32m2(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i32m2((vint64m4_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint64m4_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i32m4(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i32m4((vint64m8_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint64m8_t)(op2), (size_t)(op3), (size_t)(op4))
#define vnsra_wx_i32mf2(op0, op1, op2) \
__builtin_rvv_vnsra_wx_i32mf2((vint64m1_t)(op0), (size_t)(op1), (size_t)(op2))
#define vnsra_wx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnsra_wx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint64m1_t)(op2), (size_t)(op3), (size_t)(op4))
#define vncvt_x_x_w_u8m1(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u8m1((vuint16m2_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u8m1_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u8m2(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u8m2((vuint16m4_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u8m2_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u8m4(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u8m4((vuint16m8_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u8m4_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u8mf2(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u8mf2((vuint16m1_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u8mf2_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u8mf4(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u8mf4((vuint16mf2_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u8mf4_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u8mf8(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u8mf8((vuint16mf4_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u8mf8_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u16m1(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u16m1((vuint32m2_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u16m1_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u16m2(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u16m2((vuint32m4_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u16m2_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u16m4(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u16m4((vuint32m8_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u16m4_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u16mf2(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u16mf2((vuint32m1_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u16mf2_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u16mf4(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u16mf4((vuint32mf2_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u16mf4_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u32m1(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u32m1((vuint64m2_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u32m1_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint64m2_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u32m2(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u32m2((vuint64m4_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u32m2_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint64m4_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u32m4(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u32m4((vuint64m8_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u32m4_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint64m8_t)(op2), (size_t)(op3))
#define vncvt_x_x_w_u32mf2(op0, op1) \
__builtin_rvv_vncvt_x_x_w_u32mf2((vuint64m1_t)(op0), (size_t)(op1))
#define vncvt_x_x_w_u32mf2_m(op0, op1, op2, op3) \
__builtin_rvv_vncvt_x_x_w_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint64m1_t)(op2), (size_t)(op3))
#define vmseq_vv_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i8m1_b8((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmseq_vv_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmseq_vv_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i8m2_b4((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmseq_vv_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmseq_vv_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i8m4_b2((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmseq_vv_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmseq_vv_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i8m8_b1((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmseq_vv_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmseq_vv_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i8mf2_b16((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmseq_vv_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmseq_vv_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i8mf4_b32((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmseq_vv_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmseq_vv_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i8mf8_b64((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmseq_vv_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmseq_vv_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i16m1_b16((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmseq_vv_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmseq_vv_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i16m2_b8((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmseq_vv_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmseq_vv_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i16m4_b4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmseq_vv_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmseq_vv_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i16m8_b2((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmseq_vv_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmseq_vv_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i16mf2_b32((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmseq_vv_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmseq_vv_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i16mf4_b64((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmseq_vv_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmseq_vv_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i32m1_b32((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmseq_vv_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmseq_vv_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i32m2_b16((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmseq_vv_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmseq_vv_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i32m4_b8((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmseq_vv_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmseq_vv_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i32m8_b4((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmseq_vv_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmseq_vv_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i32mf2_b64((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmseq_vv_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmseq_vv_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i64m1_b64((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmseq_vv_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmseq_vv_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i64m2_b32((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmseq_vv_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmseq_vv_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i64m4_b16((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmseq_vv_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmseq_vv_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vv_i64m8_b8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmseq_vv_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vsse8_v_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_u8m1((uint8_t *)(op0), (ptrdiff_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vsse8_v_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_u8m1_m((vbool8_t)(op0), (uint8_t *)(op1), (ptrdiff_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vsse8_v_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_u8m2((uint8_t *)(op0), (ptrdiff_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vsse8_v_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_u8m2_m((vbool4_t)(op0), (uint8_t *)(op1), (ptrdiff_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vsse8_v_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_u8m4((uint8_t *)(op0), (ptrdiff_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vsse8_v_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_u8m4_m((vbool2_t)(op0), (uint8_t *)(op1), (ptrdiff_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vsse8_v_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_u8m8((uint8_t *)(op0), (ptrdiff_t)(op1), (vuint8m8_t)(op2), (size_t)(op3))
#define vsse8_v_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_u8m8_m((vbool1_t)(op0), (uint8_t *)(op1), (ptrdiff_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vsse8_v_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_u8mf2((uint8_t *)(op0), (ptrdiff_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vsse8_v_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_u8mf2_m((vbool16_t)(op0), (uint8_t *)(op1), (ptrdiff_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vsse8_v_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_u8mf4((uint8_t *)(op0), (ptrdiff_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vsse8_v_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_u8mf4_m((vbool32_t)(op0), (uint8_t *)(op1), (ptrdiff_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vsse8_v_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vsse8_v_u8mf8((uint8_t *)(op0), (ptrdiff_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vsse8_v_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsse8_v_u8mf8_m((vbool64_t)(op0), (uint8_t *)(op1), (ptrdiff_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vsuxei32_v_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_i16m1((int16_t *)(op0), (vuint32m2_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vsuxei32_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_i16m1_m((vbool16_t)(op0), (int16_t *)(op1), (vuint32m2_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vsuxei32_v_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_i16m2((int16_t *)(op0), (vuint32m4_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vsuxei32_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_i16m2_m((vbool8_t)(op0), (int16_t *)(op1), (vuint32m4_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vsuxei32_v_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_i16m4((int16_t *)(op0), (vuint32m8_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vsuxei32_v_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_i16m4_m((vbool4_t)(op0), (int16_t *)(op1), (vuint32m8_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vsuxei32_v_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_i16mf2((int16_t *)(op0), (vuint32m1_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vsuxei32_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_i16mf2_m((vbool32_t)(op0), (int16_t *)(op1), (vuint32m1_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vsuxei32_v_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_i16mf4((int16_t *)(op0), (vuint32mf2_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vsuxei32_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_i16mf4_m((vbool64_t)(op0), (int16_t *)(op1), (vuint32mf2_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmseq_vx_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i8m1_b8((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmseq_vx_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmseq_vx_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i8m2_b4((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmseq_vx_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmseq_vx_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i8m4_b2((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmseq_vx_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmseq_vx_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i8m8_b1((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmseq_vx_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmseq_vx_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i8mf2_b16((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmseq_vx_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmseq_vx_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i8mf4_b32((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmseq_vx_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmseq_vx_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i8mf8_b64((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmseq_vx_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmseq_vx_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i16m1_b16((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmseq_vx_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmseq_vx_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i16m2_b8((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmseq_vx_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmseq_vx_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i16m4_b4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmseq_vx_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmseq_vx_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i16m8_b2((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmseq_vx_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmseq_vx_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i16mf2_b32((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmseq_vx_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmseq_vx_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i16mf4_b64((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmseq_vx_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmseq_vx_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i32m1_b32((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmseq_vx_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmseq_vx_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i32m2_b16((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmseq_vx_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmseq_vx_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i32m4_b8((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmseq_vx_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmseq_vx_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i32m8_b4((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmseq_vx_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmseq_vx_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i32mf2_b64((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmseq_vx_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmseq_vx_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i64m1_b64((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmseq_vx_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmseq_vx_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i64m2_b32((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmseq_vx_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmseq_vx_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i64m4_b16((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmseq_vx_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmseq_vx_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vx_i64m8_b8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmseq_vx_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmseq_vv_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u8m1_b8((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmseq_vv_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmseq_vv_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u8m2_b4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmseq_vv_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmseq_vv_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u8m4_b2((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmseq_vv_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmseq_vv_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u8m8_b1((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmseq_vv_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmseq_vv_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u8mf2_b16((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmseq_vv_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmseq_vv_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u8mf4_b32((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmseq_vv_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmseq_vv_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u8mf8_b64((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmseq_vv_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmseq_vv_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u16m1_b16((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmseq_vv_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmseq_vv_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u16m2_b8((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmseq_vv_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmseq_vv_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u16m4_b4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmseq_vv_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmseq_vv_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u16m8_b2((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmseq_vv_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmseq_vv_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u16mf2_b32((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmseq_vv_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmseq_vv_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u16mf4_b64((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmseq_vv_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmseq_vv_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u32m1_b32((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmseq_vv_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmseq_vv_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u32m2_b16((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmseq_vv_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmseq_vv_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u32m4_b8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmseq_vv_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmseq_vv_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u32m8_b4((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmseq_vv_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmseq_vv_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u32mf2_b64((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmseq_vv_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmseq_vv_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u64m1_b64((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmseq_vv_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmseq_vv_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u64m2_b32((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmseq_vv_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmseq_vv_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u64m4_b16((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmseq_vv_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmseq_vv_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vv_u64m8_b8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmseq_vv_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vv_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vmseq_vx_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u8m1_b8((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmseq_vx_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmseq_vx_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u8m2_b4((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmseq_vx_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmseq_vx_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u8m4_b2((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmseq_vx_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmseq_vx_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u8m8_b1((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmseq_vx_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmseq_vx_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u8mf2_b16((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmseq_vx_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmseq_vx_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u8mf4_b32((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmseq_vx_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmseq_vx_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u8mf8_b64((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmseq_vx_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmseq_vx_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u16m1_b16((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmseq_vx_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmseq_vx_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u16m2_b8((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmseq_vx_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmseq_vx_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u16m4_b4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmseq_vx_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmseq_vx_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u16m8_b2((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmseq_vx_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmseq_vx_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u16mf2_b32((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmseq_vx_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmseq_vx_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u16mf4_b64((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmseq_vx_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmseq_vx_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u32m1_b32((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmseq_vx_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmseq_vx_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u32m2_b16((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmseq_vx_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmseq_vx_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u32m4_b8((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmseq_vx_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmseq_vx_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u32m8_b4((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmseq_vx_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmseq_vx_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u32mf2_b64((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmseq_vx_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmseq_vx_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u64m1_b64((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmseq_vx_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmseq_vx_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u64m2_b32((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmseq_vx_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmseq_vx_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u64m4_b16((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmseq_vx_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmseq_vx_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmseq_vx_u64m8_b8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmseq_vx_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmseq_vx_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsne_vv_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i8m1_b8((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmsne_vv_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmsne_vv_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i8m2_b4((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmsne_vv_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmsne_vv_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i8m4_b2((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmsne_vv_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmsne_vv_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i8m8_b1((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmsne_vv_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmsne_vv_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i8mf2_b16((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmsne_vv_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmsne_vv_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i8mf4_b32((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmsne_vv_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmsne_vv_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i8mf8_b64((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmsne_vv_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmsne_vv_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i16m1_b16((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmsne_vv_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmsne_vv_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i16m2_b8((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmsne_vv_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmsne_vv_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i16m4_b4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmsne_vv_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmsne_vv_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i16m8_b2((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmsne_vv_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmsne_vv_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i16mf2_b32((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmsne_vv_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmsne_vv_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i16mf4_b64((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmsne_vv_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmsne_vv_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i32m1_b32((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmsne_vv_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmsne_vv_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i32m2_b16((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmsne_vv_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmsne_vv_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i32m4_b8((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmsne_vv_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmsne_vv_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i32m8_b4((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmsne_vv_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmsne_vv_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i32mf2_b64((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmsne_vv_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmsne_vv_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i64m1_b64((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmsne_vv_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmsne_vv_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i64m2_b32((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmsne_vv_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmsne_vv_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i64m4_b16((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmsne_vv_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmsne_vv_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vv_i64m8_b8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmsne_vv_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vmsne_vx_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i8m1_b8((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsne_vx_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsne_vx_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i8m2_b4((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsne_vx_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsne_vx_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i8m4_b2((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsne_vx_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsne_vx_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i8m8_b1((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsne_vx_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsne_vx_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i8mf2_b16((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsne_vx_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsne_vx_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i8mf4_b32((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsne_vx_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsne_vx_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i8mf8_b64((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsne_vx_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsne_vx_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i16m1_b16((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsne_vx_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsne_vx_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i16m2_b8((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsne_vx_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsne_vx_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i16m4_b4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsne_vx_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsne_vx_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i16m8_b2((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsne_vx_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsne_vx_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i16mf2_b32((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsne_vx_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsne_vx_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i16mf4_b64((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsne_vx_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsne_vx_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i32m1_b32((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsne_vx_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsne_vx_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i32m2_b16((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsne_vx_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsne_vx_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i32m4_b8((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsne_vx_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsne_vx_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i32m8_b4((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsne_vx_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsne_vx_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i32mf2_b64((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsne_vx_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsne_vx_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i64m1_b64((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsne_vx_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsne_vx_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i64m2_b32((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsne_vx_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsne_vx_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i64m4_b16((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsne_vx_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsne_vx_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vx_i64m8_b8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsne_vx_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsne_vv_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u8m1_b8((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmsne_vv_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmsne_vv_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u8m2_b4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmsne_vv_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmsne_vv_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u8m4_b2((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmsne_vv_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmsne_vv_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u8m8_b1((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmsne_vv_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmsne_vv_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u8mf2_b16((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmsne_vv_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmsne_vv_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u8mf4_b32((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmsne_vv_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmsne_vv_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u8mf8_b64((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmsne_vv_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmsne_vv_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u16m1_b16((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmsne_vv_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmsne_vv_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u16m2_b8((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmsne_vv_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmsne_vv_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u16m4_b4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmsne_vv_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmsne_vv_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u16m8_b2((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmsne_vv_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmsne_vv_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u16mf2_b32((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmsne_vv_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmsne_vv_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u16mf4_b64((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmsne_vv_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmsne_vv_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u32m1_b32((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmsne_vv_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmsne_vv_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u32m2_b16((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmsne_vv_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmsne_vv_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u32m4_b8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmsne_vv_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmsne_vv_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u32m8_b4((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmsne_vv_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmsne_vv_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u32mf2_b64((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmsne_vv_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmsne_vv_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u64m1_b64((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmsne_vv_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmsne_vv_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u64m2_b32((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmsne_vv_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmsne_vv_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u64m4_b16((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmsne_vv_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmsne_vv_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vv_u64m8_b8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmsne_vv_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vv_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vmsne_vx_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u8m1_b8((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsne_vx_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsne_vx_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u8m2_b4((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsne_vx_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsne_vx_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u8m4_b2((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsne_vx_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsne_vx_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u8m8_b1((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsne_vx_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsne_vx_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u8mf2_b16((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsne_vx_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsne_vx_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u8mf4_b32((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsne_vx_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsne_vx_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u8mf8_b64((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsne_vx_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsne_vx_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u16m1_b16((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsne_vx_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsne_vx_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u16m2_b8((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsne_vx_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsne_vx_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u16m4_b4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsne_vx_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsne_vx_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u16m8_b2((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsne_vx_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsne_vx_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u16mf2_b32((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsne_vx_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsne_vx_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u16mf4_b64((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsne_vx_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsne_vx_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u32m1_b32((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsne_vx_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsne_vx_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u32m2_b16((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsne_vx_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsne_vx_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u32m4_b8((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsne_vx_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsne_vx_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u32m8_b4((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsne_vx_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsne_vx_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u32mf2_b64((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsne_vx_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsne_vx_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u64m1_b64((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsne_vx_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsne_vx_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u64m2_b32((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsne_vx_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsne_vx_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u64m4_b16((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsne_vx_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsne_vx_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsne_vx_u64m8_b8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsne_vx_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsne_vx_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsltu_vv_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u8m1_b8((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmsltu_vv_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmsltu_vv_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u8m2_b4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmsltu_vv_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmsltu_vv_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u8m4_b2((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmsltu_vv_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmsltu_vv_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u8m8_b1((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmsltu_vv_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmsltu_vv_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u8mf2_b16((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmsltu_vv_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmsltu_vv_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u8mf4_b32((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmsltu_vv_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmsltu_vv_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u8mf8_b64((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmsltu_vv_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmsltu_vv_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u16m1_b16((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmsltu_vv_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmsltu_vv_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u16m2_b8((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmsltu_vv_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmsltu_vv_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u16m4_b4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmsltu_vv_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmsltu_vv_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u16m8_b2((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmsltu_vv_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmsltu_vv_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u16mf2_b32((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmsltu_vv_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmsltu_vv_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u16mf4_b64((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmsltu_vv_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmsltu_vv_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u32m1_b32((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmsltu_vv_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmsltu_vv_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u32m2_b16((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmsltu_vv_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmsltu_vv_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u32m4_b8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmsltu_vv_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmsltu_vv_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u32m8_b4((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmsltu_vv_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmsltu_vv_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u32mf2_b64((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmsltu_vv_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmsltu_vv_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u64m1_b64((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmsltu_vv_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmsltu_vv_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u64m2_b32((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmsltu_vv_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmsltu_vv_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u64m4_b16((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmsltu_vv_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmsltu_vv_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsltu_vv_u64m8_b8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmsltu_vv_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vv_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vmsltu_vx_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u8m1_b8((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsltu_vx_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsltu_vx_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u8m2_b4((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsltu_vx_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsltu_vx_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u8m4_b2((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsltu_vx_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsltu_vx_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u8m8_b1((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsltu_vx_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsltu_vx_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u8mf2_b16((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsltu_vx_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsltu_vx_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u8mf4_b32((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsltu_vx_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsltu_vx_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u8mf8_b64((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsltu_vx_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsltu_vx_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u16m1_b16((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsltu_vx_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsltu_vx_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u16m2_b8((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsltu_vx_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsltu_vx_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u16m4_b4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsltu_vx_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsltu_vx_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u16m8_b2((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsltu_vx_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsltu_vx_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u16mf2_b32((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsltu_vx_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsltu_vx_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u16mf4_b64((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsltu_vx_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsltu_vx_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u32m1_b32((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsltu_vx_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsltu_vx_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u32m2_b16((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsltu_vx_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsltu_vx_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u32m4_b8((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsltu_vx_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsltu_vx_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u32m8_b4((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsltu_vx_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsltu_vx_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u32mf2_b64((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsltu_vx_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsltu_vx_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u64m1_b64((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsltu_vx_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsltu_vx_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u64m2_b32((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsltu_vx_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsltu_vx_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u64m4_b16((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsltu_vx_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsltu_vx_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsltu_vx_u64m8_b8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsltu_vx_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsltu_vx_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmslt_vv_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i8m1_b8((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmslt_vv_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmslt_vv_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i8m2_b4((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmslt_vv_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmslt_vv_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i8m4_b2((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmslt_vv_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmslt_vv_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i8m8_b1((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmslt_vv_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmslt_vv_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i8mf2_b16((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmslt_vv_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmslt_vv_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i8mf4_b32((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmslt_vv_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmslt_vv_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i8mf8_b64((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmslt_vv_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmslt_vv_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i16m1_b16((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmslt_vv_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmslt_vv_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i16m2_b8((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmslt_vv_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmslt_vv_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i16m4_b4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmslt_vv_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmslt_vv_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i16m8_b2((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmslt_vv_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmslt_vv_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i16mf2_b32((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmslt_vv_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmslt_vv_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i16mf4_b64((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmslt_vv_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmslt_vv_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i32m1_b32((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmslt_vv_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmslt_vv_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i32m2_b16((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmslt_vv_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmslt_vv_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i32m4_b8((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmslt_vv_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmslt_vv_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i32m8_b4((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmslt_vv_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmslt_vv_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i32mf2_b64((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmslt_vv_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmslt_vv_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i64m1_b64((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmslt_vv_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmslt_vv_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i64m2_b32((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmslt_vv_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmslt_vv_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i64m4_b16((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmslt_vv_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmslt_vv_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmslt_vv_i64m8_b8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmslt_vv_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vv_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vsuxei32_v_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_u16m1((uint16_t *)(op0), (vuint32m2_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vsuxei32_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_u16m1_m((vbool16_t)(op0), (uint16_t *)(op1), (vuint32m2_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vsuxei32_v_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_u16m2((uint16_t *)(op0), (vuint32m4_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vsuxei32_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_u16m2_m((vbool8_t)(op0), (uint16_t *)(op1), (vuint32m4_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vsuxei32_v_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_u16m4((uint16_t *)(op0), (vuint32m8_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vsuxei32_v_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_u16m4_m((vbool4_t)(op0), (uint16_t *)(op1), (vuint32m8_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vsuxei32_v_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_u16mf2((uint16_t *)(op0), (vuint32m1_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vsuxei32_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_u16mf2_m((vbool32_t)(op0), (uint16_t *)(op1), (vuint32m1_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vsuxei32_v_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei32_v_u16mf4((uint16_t *)(op0), (vuint32mf2_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vsuxei32_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei32_v_u16mf4_m((vbool64_t)(op0), (uint16_t *)(op1), (vuint32mf2_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmslt_vx_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i8m1_b8((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmslt_vx_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmslt_vx_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i8m2_b4((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmslt_vx_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmslt_vx_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i8m4_b2((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmslt_vx_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmslt_vx_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i8m8_b1((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmslt_vx_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmslt_vx_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i8mf2_b16((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmslt_vx_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmslt_vx_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i8mf4_b32((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmslt_vx_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmslt_vx_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i8mf8_b64((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmslt_vx_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmslt_vx_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i16m1_b16((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmslt_vx_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmslt_vx_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i16m2_b8((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmslt_vx_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmslt_vx_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i16m4_b4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmslt_vx_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmslt_vx_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i16m8_b2((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmslt_vx_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmslt_vx_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i16mf2_b32((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmslt_vx_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmslt_vx_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i16mf4_b64((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmslt_vx_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmslt_vx_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i32m1_b32((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmslt_vx_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmslt_vx_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i32m2_b16((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmslt_vx_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmslt_vx_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i32m4_b8((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmslt_vx_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmslt_vx_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i32m8_b4((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmslt_vx_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmslt_vx_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i32mf2_b64((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmslt_vx_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmslt_vx_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i64m1_b64((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmslt_vx_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmslt_vx_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i64m2_b32((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmslt_vx_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmslt_vx_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i64m4_b16((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmslt_vx_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmslt_vx_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmslt_vx_i64m8_b8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmslt_vx_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmslt_vx_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsleu_vv_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u8m1_b8((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmsleu_vv_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmsleu_vv_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u8m2_b4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmsleu_vv_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmsleu_vv_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u8m4_b2((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmsleu_vv_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmsleu_vv_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u8m8_b1((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmsleu_vv_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmsleu_vv_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u8mf2_b16((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmsleu_vv_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmsleu_vv_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u8mf4_b32((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmsleu_vv_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmsleu_vv_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u8mf8_b64((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmsleu_vv_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmsleu_vv_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u16m1_b16((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmsleu_vv_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmsleu_vv_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u16m2_b8((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmsleu_vv_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmsleu_vv_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u16m4_b4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmsleu_vv_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmsleu_vv_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u16m8_b2((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmsleu_vv_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmsleu_vv_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u16mf2_b32((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmsleu_vv_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmsleu_vv_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u16mf4_b64((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmsleu_vv_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmsleu_vv_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u32m1_b32((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmsleu_vv_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmsleu_vv_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u32m2_b16((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmsleu_vv_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmsleu_vv_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u32m4_b8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmsleu_vv_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmsleu_vv_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u32m8_b4((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmsleu_vv_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmsleu_vv_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u32mf2_b64((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmsleu_vv_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmsleu_vv_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u64m1_b64((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmsleu_vv_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmsleu_vv_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u64m2_b32((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmsleu_vv_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmsleu_vv_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u64m4_b16((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmsleu_vv_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmsleu_vv_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsleu_vv_u64m8_b8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmsleu_vv_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vv_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vmsleu_vx_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u8m1_b8((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsleu_vx_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsleu_vx_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u8m2_b4((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsleu_vx_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsleu_vx_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u8m4_b2((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsleu_vx_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsleu_vx_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u8m8_b1((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsleu_vx_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsleu_vx_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u8mf2_b16((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsleu_vx_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsleu_vx_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u8mf4_b32((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsleu_vx_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsleu_vx_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u8mf8_b64((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsleu_vx_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsleu_vx_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u16m1_b16((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsleu_vx_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsleu_vx_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u16m2_b8((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsleu_vx_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsleu_vx_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u16m4_b4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsleu_vx_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsleu_vx_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u16m8_b2((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsleu_vx_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsleu_vx_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u16mf2_b32((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsleu_vx_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsleu_vx_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u16mf4_b64((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsleu_vx_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsleu_vx_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u32m1_b32((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsleu_vx_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsleu_vx_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u32m2_b16((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsleu_vx_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsleu_vx_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u32m4_b8((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsleu_vx_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsleu_vx_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u32m8_b4((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsleu_vx_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsleu_vx_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u32mf2_b64((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsleu_vx_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsleu_vx_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u64m1_b64((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsleu_vx_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsleu_vx_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u64m2_b32((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsleu_vx_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsleu_vx_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u64m4_b16((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsleu_vx_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsleu_vx_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsleu_vx_u64m8_b8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsleu_vx_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsleu_vx_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsle_vv_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i8m1_b8((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmsle_vv_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmsle_vv_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i8m2_b4((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmsle_vv_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmsle_vv_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i8m4_b2((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmsle_vv_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmsle_vv_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i8m8_b1((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmsle_vv_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmsle_vv_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i8mf2_b16((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmsle_vv_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmsle_vv_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i8mf4_b32((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmsle_vv_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmsle_vv_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i8mf8_b64((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmsle_vv_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmsle_vv_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i16m1_b16((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmsle_vv_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmsle_vv_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i16m2_b8((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmsle_vv_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmsle_vv_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i16m4_b4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmsle_vv_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmsle_vv_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i16m8_b2((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmsle_vv_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmsle_vv_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i16mf2_b32((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmsle_vv_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmsle_vv_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i16mf4_b64((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmsle_vv_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmsle_vv_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i32m1_b32((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmsle_vv_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmsle_vv_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i32m2_b16((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmsle_vv_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmsle_vv_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i32m4_b8((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmsle_vv_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmsle_vv_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i32m8_b4((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmsle_vv_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmsle_vv_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i32mf2_b64((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmsle_vv_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmsle_vv_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i64m1_b64((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmsle_vv_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmsle_vv_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i64m2_b32((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmsle_vv_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmsle_vv_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i64m4_b16((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmsle_vv_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmsle_vv_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsle_vv_i64m8_b8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmsle_vv_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vv_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vmsle_vx_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i8m1_b8((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsle_vx_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsle_vx_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i8m2_b4((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsle_vx_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsle_vx_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i8m4_b2((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsle_vx_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsle_vx_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i8m8_b1((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsle_vx_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsle_vx_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i8mf2_b16((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsle_vx_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsle_vx_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i8mf4_b32((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsle_vx_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsle_vx_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i8mf8_b64((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsle_vx_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsle_vx_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i16m1_b16((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsle_vx_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsle_vx_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i16m2_b8((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsle_vx_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsle_vx_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i16m4_b4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsle_vx_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsle_vx_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i16m8_b2((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsle_vx_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsle_vx_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i16mf2_b32((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsle_vx_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsle_vx_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i16mf4_b64((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsle_vx_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsle_vx_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i32m1_b32((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsle_vx_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsle_vx_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i32m2_b16((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsle_vx_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsle_vx_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i32m4_b8((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsle_vx_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsle_vx_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i32m8_b4((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsle_vx_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsle_vx_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i32mf2_b64((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsle_vx_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsle_vx_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i64m1_b64((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsle_vx_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsle_vx_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i64m2_b32((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsle_vx_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsle_vx_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i64m4_b16((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsle_vx_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsle_vx_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsle_vx_i64m8_b8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsle_vx_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsle_vx_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u8m1_b8((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u8m2_b4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u8m4_b2((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u8m8_b1((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u8mf2_b16((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u8mf4_b32((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u8mf8_b64((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u16m1_b16((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u16m2_b8((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u16m4_b4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u16m8_b2((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u16mf2_b32((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u16mf4_b64((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u32m1_b32((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u32m2_b16((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u32m4_b8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u32m8_b4((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u32mf2_b64((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u64m1_b64((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u64m2_b32((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u64m4_b16((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmsgtu_vv_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsgtu_vv_u64m8_b8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmsgtu_vv_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vv_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u8m1_b8((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u8m2_b4((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u8m4_b2((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u8m8_b1((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u8mf2_b16((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u8mf4_b32((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u8mf8_b64((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u16m1_b16((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u16m2_b8((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u16m4_b4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u16m8_b2((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u16mf2_b32((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u16mf4_b64((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u32m1_b32((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u32m2_b16((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u32m4_b8((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u32m8_b4((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u32mf2_b64((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u64m1_b64((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u64m2_b32((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u64m4_b16((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsgtu_vx_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsgtu_vx_u64m8_b8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsgtu_vx_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgtu_vx_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsgt_vv_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i8m1_b8((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmsgt_vv_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmsgt_vv_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i8m2_b4((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmsgt_vv_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmsgt_vv_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i8m4_b2((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmsgt_vv_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmsgt_vv_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i8m8_b1((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmsgt_vv_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmsgt_vv_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i8mf2_b16((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmsgt_vv_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmsgt_vv_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i8mf4_b32((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmsgt_vv_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmsgt_vv_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i8mf8_b64((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmsgt_vv_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmsgt_vv_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i16m1_b16((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmsgt_vv_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmsgt_vv_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i16m2_b8((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmsgt_vv_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmsgt_vv_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i16m4_b4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmsgt_vv_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmsgt_vv_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i16m8_b2((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmsgt_vv_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmsgt_vv_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i16mf2_b32((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmsgt_vv_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmsgt_vv_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i16mf4_b64((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmsgt_vv_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmsgt_vv_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i32m1_b32((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmsgt_vv_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmsgt_vv_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i32m2_b16((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmsgt_vv_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmsgt_vv_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i32m4_b8((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmsgt_vv_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmsgt_vv_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i32m8_b4((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmsgt_vv_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmsgt_vv_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i32mf2_b64((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmsgt_vv_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmsgt_vv_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i64m1_b64((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmsgt_vv_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmsgt_vv_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i64m2_b32((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmsgt_vv_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmsgt_vv_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i64m4_b16((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmsgt_vv_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmsgt_vv_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsgt_vv_i64m8_b8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmsgt_vv_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vv_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vmsgt_vx_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i8m1_b8((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsgt_vx_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsgt_vx_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i8m2_b4((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsgt_vx_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsgt_vx_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i8m4_b2((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsgt_vx_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsgt_vx_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i8m8_b1((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsgt_vx_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsgt_vx_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i8mf2_b16((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsgt_vx_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsgt_vx_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i8mf4_b32((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsgt_vx_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsgt_vx_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i8mf8_b64((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsgt_vx_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsgt_vx_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i16m1_b16((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsgt_vx_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsgt_vx_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i16m2_b8((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsgt_vx_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsgt_vx_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i16m4_b4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsgt_vx_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsgt_vx_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i16m8_b2((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsgt_vx_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsgt_vx_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i16mf2_b32((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsgt_vx_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsgt_vx_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i16mf4_b64((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsgt_vx_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsgt_vx_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i32m1_b32((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsgt_vx_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsgt_vx_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i32m2_b16((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsgt_vx_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsgt_vx_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i32m4_b8((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsgt_vx_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsgt_vx_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i32m8_b4((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsgt_vx_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsgt_vx_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i32mf2_b64((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsgt_vx_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsgt_vx_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i64m1_b64((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsgt_vx_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsgt_vx_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i64m2_b32((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsgt_vx_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsgt_vx_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i64m4_b16((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsgt_vx_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsgt_vx_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsgt_vx_i64m8_b8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsgt_vx_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgt_vx_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u8m1_b8((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u8m2_b4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u8m4_b2((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u8m8_b1((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u8mf2_b16((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u8mf4_b32((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u8mf8_b64((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u16m1_b16((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u16m2_b8((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u16m4_b4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u16m8_b2((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u16mf2_b32((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u16mf4_b64((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u32m1_b32((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u32m2_b16((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u32m4_b8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u32m8_b4((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u32mf2_b64((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u64m1_b64((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u64m2_b32((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u64m4_b16((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmsgeu_vv_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsgeu_vv_u64m8_b8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmsgeu_vv_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vv_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vsuxei64_v_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_i16m1((int16_t *)(op0), (vuint64m4_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vsuxei64_v_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_i16m1_m((vbool16_t)(op0), (int16_t *)(op1), (vuint64m4_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vsuxei64_v_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_i16m2((int16_t *)(op0), (vuint64m8_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vsuxei64_v_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_i16m2_m((vbool8_t)(op0), (int16_t *)(op1), (vuint64m8_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vsuxei64_v_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_i16mf2((int16_t *)(op0), (vuint64m2_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vsuxei64_v_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_i16mf2_m((vbool32_t)(op0), (int16_t *)(op1), (vuint64m2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vsuxei64_v_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_i16mf4((int16_t *)(op0), (vuint64m1_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vsuxei64_v_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_i16mf4_m((vbool64_t)(op0), (int16_t *)(op1), (vuint64m1_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u8m1_b8((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u8m2_b4((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u8m4_b2((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u8m8_b1((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u8mf2_b16((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u8mf4_b32((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u8mf8_b64((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u16m1_b16((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u16m2_b8((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u16m4_b4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u16m8_b2((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u16mf2_b32((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u16mf4_b64((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u32m1_b32((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u32m2_b16((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u32m4_b8((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u32m8_b4((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u32mf2_b64((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u64m1_b64((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u64m2_b32((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u64m4_b16((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsgeu_vx_u64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsgeu_vx_u64m8_b8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmsgeu_vx_u64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsgeu_vx_u64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmsge_vv_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i8m1_b8((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmsge_vv_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmsge_vv_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i8m2_b4((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmsge_vv_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmsge_vv_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i8m4_b2((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmsge_vv_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmsge_vv_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i8m8_b1((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmsge_vv_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmsge_vv_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i8mf2_b16((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmsge_vv_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmsge_vv_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i8mf4_b32((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmsge_vv_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmsge_vv_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i8mf8_b64((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmsge_vv_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmsge_vv_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i16m1_b16((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmsge_vv_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmsge_vv_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i16m2_b8((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmsge_vv_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmsge_vv_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i16m4_b4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmsge_vv_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmsge_vv_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i16m8_b2((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmsge_vv_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmsge_vv_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i16mf2_b32((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmsge_vv_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmsge_vv_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i16mf4_b64((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmsge_vv_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmsge_vv_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i32m1_b32((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmsge_vv_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmsge_vv_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i32m2_b16((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmsge_vv_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmsge_vv_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i32m4_b8((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmsge_vv_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmsge_vv_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i32m8_b4((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmsge_vv_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmsge_vv_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i32mf2_b64((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmsge_vv_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmsge_vv_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i64m1_b64((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmsge_vv_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmsge_vv_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i64m2_b32((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmsge_vv_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmsge_vv_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i64m4_b16((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmsge_vv_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmsge_vv_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsge_vv_i64m8_b8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmsge_vv_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vv_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vmsge_vx_i8m1_b8(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i8m1_b8((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsge_vx_i8m1_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i8m1_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsge_vx_i8m2_b4(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i8m2_b4((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsge_vx_i8m2_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i8m2_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsge_vx_i8m4_b2(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i8m4_b2((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsge_vx_i8m4_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i8m4_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsge_vx_i8m8_b1(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i8m8_b1((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsge_vx_i8m8_b1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i8m8_b1_m((vbool1_t)(op0), (vbool1_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsge_vx_i8mf2_b16(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i8mf2_b16((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsge_vx_i8mf2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i8mf2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsge_vx_i8mf4_b32(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i8mf4_b32((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsge_vx_i8mf4_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i8mf4_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsge_vx_i8mf8_b64(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i8mf8_b64((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmsge_vx_i8mf8_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i8mf8_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmsge_vx_i16m1_b16(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i16m1_b16((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsge_vx_i16m1_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i16m1_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsge_vx_i16m2_b8(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i16m2_b8((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsge_vx_i16m2_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i16m2_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsge_vx_i16m4_b4(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i16m4_b4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsge_vx_i16m4_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i16m4_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsge_vx_i16m8_b2(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i16m8_b2((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsge_vx_i16m8_b2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i16m8_b2_m((vbool2_t)(op0), (vbool2_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsge_vx_i16mf2_b32(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i16mf2_b32((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsge_vx_i16mf2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i16mf2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsge_vx_i16mf4_b64(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i16mf4_b64((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmsge_vx_i16mf4_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i16mf4_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmsge_vx_i32m1_b32(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i32m1_b32((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsge_vx_i32m1_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i32m1_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsge_vx_i32m2_b16(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i32m2_b16((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsge_vx_i32m2_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i32m2_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsge_vx_i32m4_b8(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i32m4_b8((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsge_vx_i32m4_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i32m4_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsge_vx_i32m8_b4(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i32m8_b4((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsge_vx_i32m8_b4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i32m8_b4_m((vbool4_t)(op0), (vbool4_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsge_vx_i32mf2_b64(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i32mf2_b64((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmsge_vx_i32mf2_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i32mf2_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmsge_vx_i64m1_b64(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i64m1_b64((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsge_vx_i64m1_b64_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i64m1_b64_m((vbool64_t)(op0), (vbool64_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsge_vx_i64m2_b32(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i64m2_b32((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsge_vx_i64m2_b32_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i64m2_b32_m((vbool32_t)(op0), (vbool32_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsge_vx_i64m4_b16(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i64m4_b16((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsge_vx_i64m4_b16_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i64m4_b16_m((vbool16_t)(op0), (vbool16_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmsge_vx_i64m8_b8(op0, op1, op2) \
__builtin_rvv_vmsge_vx_i64m8_b8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmsge_vx_i64m8_b8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmsge_vx_i64m8_b8_m((vbool8_t)(op0), (vbool8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vminu_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vminu_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vminu_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vminu_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vminu_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vminu_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vminu_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vminu_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vminu_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vminu_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vminu_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vminu_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vminu_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vminu_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vminu_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vminu_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vminu_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vminu_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vminu_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vminu_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vminu_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vminu_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vminu_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vminu_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vminu_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vminu_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vminu_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vminu_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vminu_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vminu_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vminu_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vminu_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vminu_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vminu_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vminu_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vminu_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vminu_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vminu_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vminu_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vminu_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vminu_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vminu_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vminu_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vminu_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vminu_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vminu_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vminu_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vminu_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vminu_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vminu_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vminu_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vminu_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vminu_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vminu_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vminu_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vminu_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vminu_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vminu_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vminu_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vminu_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vminu_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vminu_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vminu_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vminu_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vminu_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vminu_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vminu_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vminu_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vminu_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vminu_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vminu_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vminu_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vminu_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vminu_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vminu_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vminu_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vminu_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vminu_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vminu_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vminu_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vminu_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vminu_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vminu_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vminu_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vminu_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vminu_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vminu_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vminu_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vminu_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vminu_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vminu_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vminu_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vminu_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vminu_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vminu_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vminu_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vminu_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vminu_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vminu_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vminu_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vminu_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vminu_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vminu_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vminu_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vminu_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vminu_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vminu_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vminu_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vminu_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vminu_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vminu_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vminu_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vminu_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vminu_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vminu_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vminu_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vminu_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vminu_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vminu_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vminu_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vminu_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vminu_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vminu_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vminu_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vminu_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vminu_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vminu_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vminu_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vminu_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vminu_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vminu_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vminu_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vminu_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmin_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vmin_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmin_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmin_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vmin_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmin_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmin_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vmin_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmin_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmin_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vmin_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmin_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmin_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vmin_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmin_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmin_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vmin_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmin_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmin_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vmin_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmin_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmin_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vmin_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmin_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmin_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vmin_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmin_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmin_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vmin_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmin_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmin_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vmin_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmin_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmin_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vmin_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmin_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmin_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vmin_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmin_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmin_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vmin_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmin_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmin_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vmin_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmin_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmin_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vmin_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmin_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmin_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vmin_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmin_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmin_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vmin_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmin_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmin_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vmin_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmin_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmin_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vmin_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmin_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmin_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vmin_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmin_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmin_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vmin_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmin_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vmin_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vmin_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmin_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmin_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vmin_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmin_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmin_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vmin_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmin_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmin_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vmin_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmin_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmin_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vmin_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmin_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmin_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vmin_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmin_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmin_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vmin_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmin_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmin_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vmin_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmin_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmin_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vmin_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmin_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmin_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vmin_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmin_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmin_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vmin_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmin_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmin_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vmin_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmin_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmin_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vmin_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmin_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmin_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vmin_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmin_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmin_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vmin_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmin_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmin_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vmin_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmin_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmin_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vmin_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmin_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmin_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vmin_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmin_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmin_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vmin_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmin_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmin_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vmin_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmin_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmin_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vmin_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmin_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmin_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vmin_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmin_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmin_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmaxu_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmaxu_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmaxu_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmaxu_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmaxu_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmaxu_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmaxu_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmaxu_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmaxu_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmaxu_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmaxu_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmaxu_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmaxu_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmaxu_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmaxu_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmaxu_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmaxu_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmaxu_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmaxu_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmaxu_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmaxu_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmaxu_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmaxu_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmaxu_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmaxu_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmaxu_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmaxu_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmaxu_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmaxu_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmaxu_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmaxu_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmaxu_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmaxu_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmaxu_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmaxu_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmaxu_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmaxu_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmaxu_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmaxu_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmaxu_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmaxu_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmaxu_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmaxu_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vmaxu_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmaxu_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vmaxu_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmaxu_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmaxu_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmaxu_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmaxu_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmaxu_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmaxu_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmaxu_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmaxu_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmaxu_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmaxu_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmaxu_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmaxu_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmaxu_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmaxu_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmaxu_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmaxu_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmaxu_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmaxu_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmaxu_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmaxu_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmaxu_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmaxu_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmaxu_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmaxu_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmaxu_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmaxu_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmaxu_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmaxu_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmaxu_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmaxu_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmaxu_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmaxu_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmaxu_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmaxu_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmaxu_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmaxu_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmaxu_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmaxu_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmaxu_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmaxu_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmaxu_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmaxu_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vmaxu_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmaxu_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmaxu_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmax_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vmax_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmax_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmax_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vmax_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmax_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmax_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vmax_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmax_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmax_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vmax_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmax_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmax_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vmax_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmax_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmax_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vmax_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmax_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmax_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vmax_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmax_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmax_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vmax_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmax_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmax_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vmax_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmax_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmax_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vmax_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmax_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmax_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vmax_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmax_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmax_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vmax_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmax_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmax_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vmax_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmax_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmax_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vmax_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmax_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmax_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vmax_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmax_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmax_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vmax_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmax_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmax_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vmax_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmax_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmax_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vmax_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmax_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmax_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vmax_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmax_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmax_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vmax_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmax_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmax_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vmax_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmax_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmax_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vmax_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmax_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vsuxei64_v_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_u16m1((uint16_t *)(op0), (vuint64m4_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vsuxei64_v_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_u16m1_m((vbool16_t)(op0), (uint16_t *)(op1), (vuint64m4_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vsuxei64_v_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_u16m2((uint16_t *)(op0), (vuint64m8_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vsuxei64_v_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_u16m2_m((vbool8_t)(op0), (uint16_t *)(op1), (vuint64m8_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vsuxei64_v_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_u16mf2((uint16_t *)(op0), (vuint64m2_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vsuxei64_v_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_u16mf2_m((vbool32_t)(op0), (uint16_t *)(op1), (vuint64m2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vsuxei64_v_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei64_v_u16mf4((uint16_t *)(op0), (vuint64m1_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vsuxei64_v_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei64_v_u16mf4_m((vbool64_t)(op0), (uint16_t *)(op1), (vuint64m1_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmax_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vmax_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmax_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmax_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vmax_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmax_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmax_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vmax_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmax_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmax_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vmax_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmax_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmax_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vmax_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmax_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmax_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vmax_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmax_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmax_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vmax_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmax_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmax_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vmax_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmax_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmax_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vmax_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmax_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmax_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vmax_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmax_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmax_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vmax_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmax_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmax_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vmax_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmax_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmax_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vmax_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmax_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmax_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vmax_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmax_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmax_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vmax_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmax_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmax_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vmax_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmax_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmax_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vmax_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmax_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmax_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vmax_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmax_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmax_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vmax_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmax_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmax_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vmax_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmax_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmax_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vmax_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmax_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmax_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vmax_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmax_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmax_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmul_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vmul_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmul_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmul_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vmul_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmul_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmul_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vmul_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmul_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmul_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vmul_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmul_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmul_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vmul_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmul_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmul_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vmul_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmul_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmul_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vmul_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmul_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmul_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vmul_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmul_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmul_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vmul_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmul_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmul_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vmul_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmul_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmul_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vmul_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmul_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmul_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vmul_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmul_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmul_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vmul_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmul_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmul_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vmul_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmul_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmul_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vmul_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmul_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmul_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vmul_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmul_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmul_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vmul_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmul_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmul_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vmul_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmul_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmul_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vmul_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmul_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmul_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vmul_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmul_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmul_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vmul_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmul_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmul_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vmul_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmul_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vmul_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vmul_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmul_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmul_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vmul_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmul_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmul_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vmul_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmul_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmul_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vmul_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmul_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmul_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vmul_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmul_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmul_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vmul_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmul_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmul_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vmul_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmul_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmul_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vmul_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmul_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmul_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vmul_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmul_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmul_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vmul_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmul_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmul_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vmul_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmul_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmul_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vmul_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmul_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmul_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vmul_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmul_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmul_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vmul_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmul_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmul_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vmul_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmul_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmul_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vmul_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmul_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmul_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vmul_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmul_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmul_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vmul_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmul_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmul_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vmul_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmul_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmul_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vmul_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmul_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmul_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vmul_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmul_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmul_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vmul_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmul_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmul_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vmul_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmul_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmul_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vmul_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmul_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmul_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vmul_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmul_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmul_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vmul_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmul_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmul_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vmul_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmul_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmul_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vmul_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmul_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmul_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vmul_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmul_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmul_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vmul_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmul_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmul_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vmul_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmul_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmul_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vmul_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmul_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmul_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vmul_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmul_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmul_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vmul_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmul_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmul_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vmul_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmul_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmul_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vmul_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmul_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmul_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vmul_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmul_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmul_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vmul_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmul_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmul_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vmul_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmul_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmul_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vmul_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmul_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmul_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vmul_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmul_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmul_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vmul_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmul_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmul_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vmul_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmul_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmul_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vmul_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmul_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vmul_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vmul_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmul_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmul_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vmul_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmul_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmul_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vmul_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmul_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmul_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vmul_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmul_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmul_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vmul_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmul_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmul_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vmul_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmul_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmul_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vmul_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmul_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmul_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vmul_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmul_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmul_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vmul_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmul_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmul_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vmul_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmul_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmul_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vmul_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmul_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmul_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vmul_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmul_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmul_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vmul_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmul_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmul_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vmul_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmul_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmul_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vmul_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmul_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmul_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vmul_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmul_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmul_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vmul_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmul_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmul_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vmul_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmul_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmul_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vmul_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmul_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmul_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vmul_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmul_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmul_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vmul_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmul_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmul_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vmul_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmul_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmul_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmulh_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vmulh_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmulh_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vmulh_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmulh_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vmulh_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmulh_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vmulh_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmulh_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vmulh_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmulh_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vmulh_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmulh_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vmulh_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmulh_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vmulh_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmulh_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vmulh_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmulh_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vmulh_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmulh_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vmulh_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmulh_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vmulh_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmulh_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vmulh_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmulh_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vmulh_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmulh_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vmulh_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmulh_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vmulh_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmulh_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vmulh_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmulh_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vmulh_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmulh_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vmulh_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmulh_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vmulh_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmulh_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vmulh_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmulh_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vmulh_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vmulh_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vmulh_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmulh_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmulh_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmulh_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmulh_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmulh_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmulh_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmulh_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmulh_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmulh_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmulh_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmulh_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmulh_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vmulh_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vmulh_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmulh_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmulh_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmulh_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmulh_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmulh_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmulh_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmulh_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmulh_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmulh_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmulh_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vmulh_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vmulh_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmulh_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmulh_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmulh_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmulh_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmulh_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmulh_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmulh_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmulh_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vmulh_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vmulh_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmulh_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmulh_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmulh_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmulh_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmulh_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmulh_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vmulh_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vmulh_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulh_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vmulhu_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmulhu_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmulhu_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmulhu_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmulhu_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmulhu_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmulhu_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmulhu_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmulhu_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmulhu_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmulhu_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmulhu_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmulhu_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmulhu_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmulhu_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmulhu_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmulhu_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmulhu_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmulhu_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmulhu_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmulhu_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmulhu_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmulhu_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmulhu_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmulhu_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmulhu_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmulhu_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmulhu_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmulhu_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmulhu_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmulhu_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmulhu_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmulhu_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmulhu_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmulhu_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmulhu_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmulhu_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmulhu_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmulhu_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmulhu_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmulhu_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmulhu_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmulhu_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vmulhu_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmulhu_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vmulhu_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhu_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhu_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhu_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhu_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhu_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhu_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhu_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhu_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhu_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhu_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhu_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhu_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhu_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhu_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhu_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhu_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhu_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhu_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhu_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhu_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhu_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhu_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhu_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhu_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhu_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhu_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmulhu_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmulhu_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmulhu_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmulhu_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmulhu_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmulhu_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmulhu_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmulhu_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmulhu_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmulhu_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmulhu_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmulhu_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmulhu_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmulhu_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmulhu_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmulhu_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vmulhu_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmulhu_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhu_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i8m1((vint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i8m2((vint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i8m4((vint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i8m8((vint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i8mf2((vint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i8mf4((vint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i8mf8((vint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i16m1((vint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i16m2((vint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i16m4((vint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i16m8((vint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i16mf2((vint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i16mf4((vint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i32m1((vint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i32m2((vint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i32m4((vint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i32m8((vint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i32mf2((vint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i64m1((vint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i64m2((vint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i64m4((vint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmulhsu_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vmulhsu_vv_i64m8((vint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vmulhsu_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vsuxei8_v_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_i32m1((int32_t *)(op0), (vuint8mf4_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vsuxei8_v_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_i32m1_m((vbool32_t)(op0), (int32_t *)(op1), (vuint8mf4_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vsuxei8_v_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_i32m2((int32_t *)(op0), (vuint8mf2_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vsuxei8_v_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_i32m2_m((vbool16_t)(op0), (int32_t *)(op1), (vuint8mf2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vsuxei8_v_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_i32m4((int32_t *)(op0), (vuint8m1_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vsuxei8_v_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_i32m4_m((vbool8_t)(op0), (int32_t *)(op1), (vuint8m1_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vsuxei8_v_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_i32m8((int32_t *)(op0), (vuint8m2_t)(op1), (vint32m8_t)(op2), (size_t)(op3))
#define vsuxei8_v_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_i32m8_m((vbool4_t)(op0), (int32_t *)(op1), (vuint8m2_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vsuxei8_v_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_i32mf2((int32_t *)(op0), (vuint8mf8_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vsuxei8_v_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_i32mf2_m((vbool64_t)(op0), (int32_t *)(op1), (vuint8mf8_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i8m1((vint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i8m2((vint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i8m4((vint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i8m8((vint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i8mf2((vint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i8mf4((vint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i8mf8((vint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i16m1((vint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i16m2((vint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i16m4((vint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i16m8((vint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i16mf2((vint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i16mf4((vint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i32m1((vint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i32m2((vint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i32m4((vint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i32m8((vint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i32mf2((vint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i64m1((vint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i64m2((vint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i64m4((vint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vmulhsu_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vmulhsu_vx_i64m8((vint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vmulhsu_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmulhsu_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vdivu_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vdivu_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vdivu_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vdivu_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vdivu_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vdivu_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vdivu_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vdivu_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vdivu_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vdivu_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vdivu_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vdivu_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vdivu_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vdivu_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vdivu_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vdivu_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vdivu_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vdivu_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vdivu_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vdivu_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vdivu_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vdivu_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vdivu_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vdivu_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vdivu_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vdivu_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vdivu_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vdivu_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vdivu_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vdivu_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vdivu_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vdivu_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vdivu_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vdivu_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vdivu_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vdivu_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vdivu_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vdivu_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vdivu_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vdivu_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vdivu_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vdivu_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vdivu_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vdivu_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vdivu_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vdivu_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vdivu_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vdivu_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vdivu_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vdivu_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vdivu_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vdivu_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vdivu_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vdivu_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vdivu_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vdivu_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vdivu_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vdivu_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vdivu_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vdivu_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vdivu_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vdivu_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vdivu_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vdivu_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vdivu_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vdivu_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vdivu_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vdivu_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vdivu_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vdivu_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vdivu_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vdivu_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vdivu_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vdivu_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vdivu_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vdivu_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vdivu_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vdivu_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vdivu_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vdivu_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vdivu_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vdivu_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vdivu_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vdivu_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vdivu_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vdivu_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vdivu_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vdivu_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vdivu_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vdivu_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdivu_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vdiv_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vdiv_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vdiv_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vdiv_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vdiv_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vdiv_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vdiv_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vdiv_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vdiv_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vdiv_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vdiv_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vdiv_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vdiv_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vdiv_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vdiv_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vdiv_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vdiv_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vdiv_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vdiv_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vdiv_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vdiv_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vdiv_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vdiv_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vdiv_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vdiv_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vdiv_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vdiv_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vdiv_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vdiv_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vdiv_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vdiv_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vdiv_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vdiv_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vdiv_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vdiv_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vdiv_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vdiv_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vdiv_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vdiv_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vdiv_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vdiv_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vdiv_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vdiv_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vdiv_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vdiv_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vdiv_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vdiv_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vdiv_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vdiv_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vdiv_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vdiv_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vdiv_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vdiv_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vdiv_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vdiv_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vdiv_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vdiv_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vdiv_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vdiv_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vdiv_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vdiv_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vdiv_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vdiv_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vdiv_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vdiv_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vdiv_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vdiv_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vdiv_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vdiv_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vdiv_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vdiv_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vdiv_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vdiv_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vdiv_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vdiv_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vdiv_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vdiv_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vdiv_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vdiv_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vdiv_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vdiv_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vdiv_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vdiv_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vdiv_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vdiv_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vdiv_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vdiv_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vdiv_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vdiv_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vdiv_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vdiv_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vremu_vv_u8m1(op0, op1, op2) \
__builtin_rvv_vremu_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vremu_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vremu_vv_u8m2(op0, op1, op2) \
__builtin_rvv_vremu_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vremu_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vremu_vv_u8m4(op0, op1, op2) \
__builtin_rvv_vremu_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vremu_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vremu_vv_u8m8(op0, op1, op2) \
__builtin_rvv_vremu_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (size_t)(op2))
#define vremu_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vremu_vv_u8mf2(op0, op1, op2) \
__builtin_rvv_vremu_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vremu_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vremu_vv_u8mf4(op0, op1, op2) \
__builtin_rvv_vremu_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vremu_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vremu_vv_u8mf8(op0, op1, op2) \
__builtin_rvv_vremu_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vremu_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vremu_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vremu_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vremu_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vremu_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vremu_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vremu_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vremu_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vremu_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vremu_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vremu_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vremu_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (size_t)(op2))
#define vremu_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vremu_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vremu_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vremu_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vremu_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vremu_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vremu_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vremu_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vremu_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vremu_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vremu_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vremu_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vremu_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vremu_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vremu_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vremu_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vremu_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vremu_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (size_t)(op2))
#define vremu_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vremu_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vremu_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vremu_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vremu_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vremu_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (size_t)(op2))
#define vremu_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vremu_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vremu_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (size_t)(op2))
#define vremu_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vremu_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vremu_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (size_t)(op2))
#define vremu_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vremu_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vremu_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (size_t)(op2))
#define vremu_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vremu_vx_u8m1(op0, op1, op2) \
__builtin_rvv_vremu_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vremu_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vremu_vx_u8m2(op0, op1, op2) \
__builtin_rvv_vremu_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vremu_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vremu_vx_u8m4(op0, op1, op2) \
__builtin_rvv_vremu_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vremu_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vremu_vx_u8m8(op0, op1, op2) \
__builtin_rvv_vremu_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vremu_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vremu_vx_u8mf2(op0, op1, op2) \
__builtin_rvv_vremu_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vremu_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vremu_vx_u8mf4(op0, op1, op2) \
__builtin_rvv_vremu_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vremu_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vremu_vx_u8mf8(op0, op1, op2) \
__builtin_rvv_vremu_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vremu_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vremu_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vremu_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vremu_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vremu_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vremu_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vremu_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vremu_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vremu_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vremu_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vremu_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vremu_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vremu_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vremu_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vremu_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vremu_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vremu_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vremu_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vremu_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vremu_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vremu_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vremu_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vremu_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vremu_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vremu_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vremu_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vremu_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vremu_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vremu_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vremu_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vremu_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vremu_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vremu_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vremu_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vremu_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vremu_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vremu_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vremu_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vremu_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vremu_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vremu_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vremu_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vremu_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vremu_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vremu_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (size_t)(op2))
#define vremu_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vremu_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (uint64_t)(op3), (size_t)(op4))
#define vrem_vv_i8m1(op0, op1, op2) \
__builtin_rvv_vrem_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vrem_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vrem_vv_i8m2(op0, op1, op2) \
__builtin_rvv_vrem_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vrem_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vrem_vv_i8m4(op0, op1, op2) \
__builtin_rvv_vrem_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vrem_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vrem_vv_i8m8(op0, op1, op2) \
__builtin_rvv_vrem_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (size_t)(op2))
#define vrem_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vrem_vv_i8mf2(op0, op1, op2) \
__builtin_rvv_vrem_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vrem_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vrem_vv_i8mf4(op0, op1, op2) \
__builtin_rvv_vrem_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vrem_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vrem_vv_i8mf8(op0, op1, op2) \
__builtin_rvv_vrem_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vrem_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vrem_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vrem_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vrem_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vrem_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vrem_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vrem_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vrem_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vrem_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vrem_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vrem_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vrem_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (size_t)(op2))
#define vrem_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vrem_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vrem_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vrem_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vrem_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vrem_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vrem_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vrem_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vrem_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vrem_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vrem_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vrem_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vrem_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vrem_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vrem_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vrem_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vrem_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vrem_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (size_t)(op2))
#define vrem_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vrem_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vrem_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vrem_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vrem_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vrem_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (size_t)(op2))
#define vrem_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vrem_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vrem_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (size_t)(op2))
#define vrem_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vrem_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vrem_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (size_t)(op2))
#define vrem_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vrem_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vrem_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (size_t)(op2))
#define vrem_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vrem_vx_i8m1(op0, op1, op2) \
__builtin_rvv_vrem_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrem_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrem_vx_i8m2(op0, op1, op2) \
__builtin_rvv_vrem_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrem_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrem_vx_i8m4(op0, op1, op2) \
__builtin_rvv_vrem_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrem_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrem_vx_i8m8(op0, op1, op2) \
__builtin_rvv_vrem_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrem_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrem_vx_i8mf2(op0, op1, op2) \
__builtin_rvv_vrem_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrem_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrem_vx_i8mf4(op0, op1, op2) \
__builtin_rvv_vrem_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrem_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrem_vx_i8mf8(op0, op1, op2) \
__builtin_rvv_vrem_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vrem_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vrem_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vrem_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrem_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrem_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vrem_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrem_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrem_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vrem_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrem_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrem_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vrem_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrem_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrem_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vrem_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrem_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrem_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vrem_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vrem_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vrem_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vrem_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vrem_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vrem_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vrem_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vrem_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vrem_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vrem_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vrem_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vrem_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vrem_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vrem_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vrem_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vrem_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vrem_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vrem_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vrem_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vrem_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vrem_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vrem_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vrem_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vrem_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vrem_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vrem_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vrem_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vrem_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (size_t)(op2))
#define vrem_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vrem_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (int64_t)(op3), (size_t)(op4))
#define vwmul_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i16mf4((vint8mf8_t)(op0), (vint8mf8_t)(op1), (size_t)(op2))
#define vwmul_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vwmul_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i16mf2((vint8mf4_t)(op0), (vint8mf4_t)(op1), (size_t)(op2))
#define vwmul_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vwmul_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i16m1((vint8mf2_t)(op0), (vint8mf2_t)(op1), (size_t)(op2))
#define vwmul_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vwmul_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i16m2((vint8m1_t)(op0), (vint8m1_t)(op1), (size_t)(op2))
#define vwmul_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vwmul_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i16m4((vint8m2_t)(op0), (vint8m2_t)(op1), (size_t)(op2))
#define vwmul_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vwmul_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i16m8((vint8m4_t)(op0), (vint8m4_t)(op1), (size_t)(op2))
#define vwmul_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vwmul_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i32mf2((vint16mf4_t)(op0), (vint16mf4_t)(op1), (size_t)(op2))
#define vwmul_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vwmul_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i32m1((vint16mf2_t)(op0), (vint16mf2_t)(op1), (size_t)(op2))
#define vwmul_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vwmul_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i32m2((vint16m1_t)(op0), (vint16m1_t)(op1), (size_t)(op2))
#define vwmul_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vwmul_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i32m4((vint16m2_t)(op0), (vint16m2_t)(op1), (size_t)(op2))
#define vwmul_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vwmul_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i32m8((vint16m4_t)(op0), (vint16m4_t)(op1), (size_t)(op2))
#define vwmul_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vwmul_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i64m1((vint32mf2_t)(op0), (vint32mf2_t)(op1), (size_t)(op2))
#define vwmul_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vwmul_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i64m2((vint32m1_t)(op0), (vint32m1_t)(op1), (size_t)(op2))
#define vwmul_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vwmul_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i64m4((vint32m2_t)(op0), (vint32m2_t)(op1), (size_t)(op2))
#define vwmul_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vwmul_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vwmul_vv_i64m8((vint32m4_t)(op0), (vint32m4_t)(op1), (size_t)(op2))
#define vwmul_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vsuxei8_v_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_u32m1((uint32_t *)(op0), (vuint8mf4_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vsuxei8_v_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_u32m1_m((vbool32_t)(op0), (uint32_t *)(op1), (vuint8mf4_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vsuxei8_v_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_u32m2((uint32_t *)(op0), (vuint8mf2_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vsuxei8_v_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_u32m2_m((vbool16_t)(op0), (uint32_t *)(op1), (vuint8mf2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vsuxei8_v_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_u32m4((uint32_t *)(op0), (vuint8m1_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vsuxei8_v_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_u32m4_m((vbool8_t)(op0), (uint32_t *)(op1), (vuint8m1_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vsuxei8_v_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_u32m8((uint32_t *)(op0), (vuint8m2_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vsuxei8_v_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_u32m8_m((vbool4_t)(op0), (uint32_t *)(op1), (vuint8m2_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vsuxei8_v_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei8_v_u32mf2((uint32_t *)(op0), (vuint8mf8_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vsuxei8_v_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei8_v_u32mf2_m((vbool64_t)(op0), (uint32_t *)(op1), (vuint8mf8_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vwmul_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i16mf4((vint8mf8_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwmul_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint8mf8_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwmul_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i16mf2((vint8mf4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwmul_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint8mf4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwmul_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i16m1((vint8mf2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwmul_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint8mf2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwmul_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i16m2((vint8m1_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwmul_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint8m1_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwmul_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i16m4((vint8m2_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwmul_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint8m2_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwmul_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i16m8((vint8m4_t)(op0), (int8_t)(op1), (size_t)(op2))
#define vwmul_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint8m4_t)(op2), (int8_t)(op3), (size_t)(op4))
#define vwmul_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i32mf2((vint16mf4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwmul_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint16mf4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwmul_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i32m1((vint16mf2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwmul_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint16mf2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwmul_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i32m2((vint16m1_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwmul_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint16m1_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwmul_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i32m4((vint16m2_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwmul_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint16m2_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwmul_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i32m8((vint16m4_t)(op0), (int16_t)(op1), (size_t)(op2))
#define vwmul_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint16m4_t)(op2), (int16_t)(op3), (size_t)(op4))
#define vwmul_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i64m1((vint32mf2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwmul_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint32mf2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwmul_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i64m2((vint32m1_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwmul_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint32m1_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwmul_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i64m4((vint32m2_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwmul_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint32m2_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwmul_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vwmul_vx_i64m8((vint32m4_t)(op0), (int32_t)(op1), (size_t)(op2))
#define vwmul_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmul_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint32m4_t)(op2), (int32_t)(op3), (size_t)(op4))
#define vwmulu_vv_u16mf4(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u16mf4((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vwmulu_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vwmulu_vv_u16mf2(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u16mf2((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vwmulu_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vwmulu_vv_u16m1(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u16m1((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vwmulu_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vwmulu_vv_u16m2(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u16m2((vuint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vwmulu_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vwmulu_vv_u16m4(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u16m4((vuint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vwmulu_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vwmulu_vv_u16m8(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u16m8((vuint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vwmulu_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vwmulu_vv_u32mf2(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u32mf2((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vwmulu_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vwmulu_vv_u32m1(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u32m1((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vwmulu_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vwmulu_vv_u32m2(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u32m2((vuint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vwmulu_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vwmulu_vv_u32m4(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u32m4((vuint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vwmulu_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vwmulu_vv_u32m8(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u32m8((vuint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vwmulu_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vwmulu_vv_u64m1(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u64m1((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vwmulu_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vwmulu_vv_u64m2(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u64m2((vuint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vwmulu_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vwmulu_vv_u64m4(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u64m4((vuint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vwmulu_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vwmulu_vv_u64m8(op0, op1, op2) \
__builtin_rvv_vwmulu_vv_u64m8((vuint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vwmulu_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vwmulu_vx_u16mf4(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u16mf4((vuint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulu_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulu_vx_u16mf2(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u16mf2((vuint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulu_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulu_vx_u16m1(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u16m1((vuint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulu_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulu_vx_u16m2(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u16m2((vuint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulu_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulu_vx_u16m4(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u16m4((vuint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulu_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulu_vx_u16m8(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u16m8((vuint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulu_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulu_vx_u32mf2(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u32mf2((vuint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwmulu_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwmulu_vx_u32m1(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u32m1((vuint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwmulu_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwmulu_vx_u32m2(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u32m2((vuint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwmulu_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwmulu_vx_u32m4(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u32m4((vuint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwmulu_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwmulu_vx_u32m8(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u32m8((vuint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwmulu_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwmulu_vx_u64m1(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u64m1((vuint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwmulu_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwmulu_vx_u64m2(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u64m2((vuint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwmulu_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwmulu_vx_u64m4(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u64m4((vuint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwmulu_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwmulu_vx_u64m8(op0, op1, op2) \
__builtin_rvv_vwmulu_vx_u64m8((vuint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwmulu_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulu_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i16mf4(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i16mf4((vint8mf8_t)(op0), (vuint8mf8_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i16mf2(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i16mf2((vint8mf4_t)(op0), (vuint8mf4_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i16m1(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i16m1((vint8mf2_t)(op0), (vuint8mf2_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i16m2(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i16m2((vint8m1_t)(op0), (vuint8m1_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i16m4(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i16m4((vint8m2_t)(op0), (vuint8m2_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i16m8(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i16m8((vint8m4_t)(op0), (vuint8m4_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i32mf2(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i32mf2((vint16mf4_t)(op0), (vuint16mf4_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i32m1(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i32m1((vint16mf2_t)(op0), (vuint16mf2_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i32m2(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i32m2((vint16m1_t)(op0), (vuint16m1_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i32m4(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i32m4((vint16m2_t)(op0), (vuint16m2_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i32m8(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i32m8((vint16m4_t)(op0), (vuint16m4_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i64m1(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i64m1((vint32mf2_t)(op0), (vuint32mf2_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i64m2(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i64m2((vint32m1_t)(op0), (vuint32m1_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i64m4(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i64m4((vint32m2_t)(op0), (vuint32m2_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vwmulsu_vv_i64m8(op0, op1, op2) \
__builtin_rvv_vwmulsu_vv_i64m8((vint32m4_t)(op0), (vuint32m4_t)(op1), (size_t)(op2))
#define vwmulsu_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i16mf4(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i16mf4((vint8mf8_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint8mf8_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i16mf2(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i16mf2((vint8mf4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint8mf4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i16m1(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i16m1((vint8mf2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint8mf2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i16m2(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i16m2((vint8m1_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint8m1_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i16m4(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i16m4((vint8m2_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint8m2_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i16m8(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i16m8((vint8m4_t)(op0), (uint8_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint8m4_t)(op2), (uint8_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i32mf2(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i32mf2((vint16mf4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint16mf4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i32m1(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i32m1((vint16mf2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint16mf2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i32m2(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i32m2((vint16m1_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint16m1_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i32m4(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i32m4((vint16m2_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint16m2_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i32m8(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i32m8((vint16m4_t)(op0), (uint16_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint16m4_t)(op2), (uint16_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i64m1(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i64m1((vint32mf2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint32mf2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i64m2(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i64m2((vint32m1_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint32m1_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i64m4(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i64m4((vint32m2_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint32m2_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vwmulsu_vx_i64m8(op0, op1, op2) \
__builtin_rvv_vwmulsu_vx_i64m8((vint32m4_t)(op0), (uint32_t)(op1), (size_t)(op2))
#define vwmulsu_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmulsu_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint32m4_t)(op2), (uint32_t)(op3), (size_t)(op4))
#define vmacc_vv_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vmacc_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmacc_vv_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vmacc_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmacc_vv_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vmacc_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmacc_vv_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (size_t)(op3))
#define vmacc_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmacc_vv_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vmacc_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmacc_vv_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vmacc_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmacc_vv_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vmacc_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmacc_vv_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vmacc_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmacc_vv_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vmacc_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmacc_vv_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vmacc_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmacc_vv_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (size_t)(op3))
#define vmacc_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmacc_vv_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vmacc_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmacc_vv_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vmacc_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmacc_vv_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vmacc_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmacc_vv_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vmacc_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmacc_vv_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vmacc_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmacc_vv_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (size_t)(op3))
#define vmacc_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmacc_vv_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vmacc_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmacc_vv_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (size_t)(op3))
#define vmacc_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmacc_vv_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (size_t)(op3))
#define vmacc_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmacc_vv_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (size_t)(op3))
#define vmacc_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmacc_vv_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (size_t)(op3))
#define vmacc_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vmacc_vx_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vmacc_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (int8_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmacc_vx_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vmacc_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (int8_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmacc_vx_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vmacc_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (int8_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmacc_vx_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (vint8m8_t)(op2), (size_t)(op3))
#define vmacc_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (int8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmacc_vx_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vmacc_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (int8_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmacc_vx_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vmacc_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (int8_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmacc_vx_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vmacc_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (int8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmacc_vx_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vmacc_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (int16_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmacc_vx_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vmacc_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (int16_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmacc_vx_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vmacc_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (int16_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmacc_vx_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (vint16m8_t)(op2), (size_t)(op3))
#define vmacc_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (int16_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmacc_vx_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vmacc_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (int16_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmacc_vx_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vmacc_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (int16_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmacc_vx_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vmacc_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (int32_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmacc_vx_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vmacc_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (int32_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmacc_vx_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vmacc_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (int32_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmacc_vx_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (vint32m8_t)(op2), (size_t)(op3))
#define vmacc_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (int32_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmacc_vx_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vmacc_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (int32_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmacc_vx_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (vint64m1_t)(op2), (size_t)(op3))
#define vmacc_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (int64_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmacc_vx_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (vint64m2_t)(op2), (size_t)(op3))
#define vmacc_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (int64_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmacc_vx_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (vint64m4_t)(op2), (size_t)(op3))
#define vmacc_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (int64_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmacc_vx_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (vint64m8_t)(op2), (size_t)(op3))
#define vmacc_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (int64_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vmacc_vv_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vmacc_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmacc_vv_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vmacc_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmacc_vv_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vmacc_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmacc_vv_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (size_t)(op3))
#define vmacc_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmacc_vv_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vmacc_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmacc_vv_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vmacc_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmacc_vv_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vmacc_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmacc_vv_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vmacc_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmacc_vv_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vmacc_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmacc_vv_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vmacc_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmacc_vv_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vmacc_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmacc_vv_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vmacc_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmacc_vv_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vmacc_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmacc_vv_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vmacc_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmacc_vv_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vmacc_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmacc_vv_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vmacc_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmacc_vv_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vmacc_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmacc_vv_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vmacc_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmacc_vv_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (size_t)(op3))
#define vmacc_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmacc_vv_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (size_t)(op3))
#define vmacc_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmacc_vv_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (size_t)(op3))
#define vmacc_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmacc_vv_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (size_t)(op3))
#define vmacc_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vmacc_vx_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vmacc_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (uint8_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmacc_vx_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vmacc_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (uint8_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmacc_vx_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vmacc_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (uint8_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmacc_vx_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (vuint8m8_t)(op2), (size_t)(op3))
#define vmacc_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (uint8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmacc_vx_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vmacc_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (uint8_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmacc_vx_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vmacc_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (uint8_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmacc_vx_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vmacc_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (uint8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmacc_vx_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vmacc_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (uint16_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmacc_vx_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vmacc_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (uint16_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmacc_vx_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vmacc_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (uint16_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmacc_vx_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vmacc_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (uint16_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmacc_vx_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vmacc_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (uint16_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmacc_vx_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vmacc_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (uint16_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmacc_vx_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vmacc_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (uint32_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmacc_vx_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vmacc_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (uint32_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmacc_vx_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vmacc_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (uint32_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmacc_vx_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vmacc_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (uint32_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmacc_vx_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vmacc_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (uint32_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmacc_vx_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (vuint64m1_t)(op2), (size_t)(op3))
#define vmacc_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (uint64_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmacc_vx_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (vuint64m2_t)(op2), (size_t)(op3))
#define vmacc_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (uint64_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmacc_vx_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (vuint64m4_t)(op2), (size_t)(op3))
#define vmacc_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (uint64_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmacc_vx_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vmacc_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (vuint64m8_t)(op2), (size_t)(op3))
#define vmacc_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmacc_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (uint64_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vnmsac_vv_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vnmsac_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vnmsac_vv_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vnmsac_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vnmsac_vv_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vnmsac_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vnmsac_vv_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (size_t)(op3))
#define vnmsac_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vnmsac_vv_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vnmsac_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vnmsac_vv_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vnmsac_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vnmsac_vv_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vnmsac_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vnmsac_vv_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vnmsac_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vnmsac_vv_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vnmsac_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vnmsac_vv_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vnmsac_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vnmsac_vv_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (size_t)(op3))
#define vnmsac_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vnmsac_vv_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vnmsac_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vnmsac_vv_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vnmsac_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vnmsac_vv_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vnmsac_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vnmsac_vv_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vnmsac_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vnmsac_vv_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vnmsac_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vnmsac_vv_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (size_t)(op3))
#define vnmsac_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vnmsac_vv_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vnmsac_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vnmsac_vv_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (size_t)(op3))
#define vnmsac_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vnmsac_vv_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (size_t)(op3))
#define vnmsac_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vnmsac_vv_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (size_t)(op3))
#define vnmsac_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vnmsac_vv_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (size_t)(op3))
#define vnmsac_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vsuxei16_v_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i32m1((int32_t *)(op0), (vuint16mf2_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vsuxei16_v_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i32m1_m((vbool32_t)(op0), (int32_t *)(op1), (vuint16mf2_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vsuxei16_v_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i32m2((int32_t *)(op0), (vuint16m1_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vsuxei16_v_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i32m2_m((vbool16_t)(op0), (int32_t *)(op1), (vuint16m1_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vsuxei16_v_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i32m4((int32_t *)(op0), (vuint16m2_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vsuxei16_v_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i32m4_m((vbool8_t)(op0), (int32_t *)(op1), (vuint16m2_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vsuxei16_v_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i32m8((int32_t *)(op0), (vuint16m4_t)(op1), (vint32m8_t)(op2), (size_t)(op3))
#define vsuxei16_v_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i32m8_m((vbool4_t)(op0), (int32_t *)(op1), (vuint16m4_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vsuxei16_v_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_i32mf2((int32_t *)(op0), (vuint16mf4_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vsuxei16_v_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_i32mf2_m((vbool64_t)(op0), (int32_t *)(op1), (vuint16mf4_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vnmsac_vx_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vnmsac_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (int8_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vnmsac_vx_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vnmsac_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (int8_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vnmsac_vx_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vnmsac_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (int8_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vnmsac_vx_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (vint8m8_t)(op2), (size_t)(op3))
#define vnmsac_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (int8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vnmsac_vx_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vnmsac_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (int8_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vnmsac_vx_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vnmsac_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (int8_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vnmsac_vx_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vnmsac_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (int8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vnmsac_vx_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vnmsac_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (int16_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vnmsac_vx_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vnmsac_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (int16_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vnmsac_vx_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vnmsac_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (int16_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vnmsac_vx_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (vint16m8_t)(op2), (size_t)(op3))
#define vnmsac_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (int16_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vnmsac_vx_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vnmsac_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (int16_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vnmsac_vx_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vnmsac_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (int16_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vnmsac_vx_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vnmsac_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (int32_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vnmsac_vx_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vnmsac_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (int32_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vnmsac_vx_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vnmsac_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (int32_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vnmsac_vx_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (vint32m8_t)(op2), (size_t)(op3))
#define vnmsac_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (int32_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vnmsac_vx_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vnmsac_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (int32_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vnmsac_vx_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (vint64m1_t)(op2), (size_t)(op3))
#define vnmsac_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (int64_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vnmsac_vx_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (vint64m2_t)(op2), (size_t)(op3))
#define vnmsac_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (int64_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vnmsac_vx_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (vint64m4_t)(op2), (size_t)(op3))
#define vnmsac_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (int64_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vnmsac_vx_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (vint64m8_t)(op2), (size_t)(op3))
#define vnmsac_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (int64_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vnmsac_vv_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vnmsac_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vnmsac_vv_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vnmsac_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vnmsac_vv_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vnmsac_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vnmsac_vv_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (size_t)(op3))
#define vnmsac_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vnmsac_vv_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vnmsac_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vnmsac_vv_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vnmsac_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vnmsac_vv_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vnmsac_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vnmsac_vv_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vnmsac_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vnmsac_vv_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vnmsac_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vnmsac_vv_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vnmsac_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vnmsac_vv_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vnmsac_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vnmsac_vv_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vnmsac_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vnmsac_vv_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vnmsac_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vnmsac_vv_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vnmsac_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vnmsac_vv_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vnmsac_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vnmsac_vv_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vnmsac_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vnmsac_vv_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vnmsac_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vnmsac_vv_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vnmsac_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vnmsac_vv_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (size_t)(op3))
#define vnmsac_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vnmsac_vv_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (size_t)(op3))
#define vnmsac_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vnmsac_vv_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (size_t)(op3))
#define vnmsac_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vnmsac_vv_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (size_t)(op3))
#define vnmsac_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vnmsac_vx_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vnmsac_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (uint8_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vnmsac_vx_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vnmsac_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (uint8_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vnmsac_vx_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vnmsac_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (uint8_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vnmsac_vx_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (vuint8m8_t)(op2), (size_t)(op3))
#define vnmsac_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (uint8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vnmsac_vx_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vnmsac_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (uint8_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vnmsac_vx_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vnmsac_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (uint8_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vnmsac_vx_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vnmsac_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (uint8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vnmsac_vx_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vnmsac_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (uint16_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vnmsac_vx_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vnmsac_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (uint16_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vnmsac_vx_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vnmsac_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (uint16_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vnmsac_vx_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vnmsac_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (uint16_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vnmsac_vx_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vnmsac_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (uint16_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vnmsac_vx_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vnmsac_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (uint16_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vnmsac_vx_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vnmsac_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (uint32_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vnmsac_vx_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vnmsac_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (uint32_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vnmsac_vx_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vnmsac_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (uint32_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vnmsac_vx_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vnmsac_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (uint32_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vnmsac_vx_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vnmsac_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (uint32_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vnmsac_vx_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (vuint64m1_t)(op2), (size_t)(op3))
#define vnmsac_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (uint64_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vnmsac_vx_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (vuint64m2_t)(op2), (size_t)(op3))
#define vnmsac_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (uint64_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vnmsac_vx_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (vuint64m4_t)(op2), (size_t)(op3))
#define vnmsac_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (uint64_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vnmsac_vx_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsac_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (vuint64m8_t)(op2), (size_t)(op3))
#define vnmsac_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsac_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (uint64_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vmadd_vv_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vmadd_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmadd_vv_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vmadd_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmadd_vv_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vmadd_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmadd_vv_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (size_t)(op3))
#define vmadd_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmadd_vv_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vmadd_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmadd_vv_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vmadd_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmadd_vv_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vmadd_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmadd_vv_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vmadd_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmadd_vv_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vmadd_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmadd_vv_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vmadd_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmadd_vv_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (size_t)(op3))
#define vmadd_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmadd_vv_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vmadd_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmadd_vv_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vmadd_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmadd_vv_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vmadd_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmadd_vv_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vmadd_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmadd_vv_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vmadd_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmadd_vv_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (size_t)(op3))
#define vmadd_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmadd_vv_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vmadd_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmadd_vv_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (size_t)(op3))
#define vmadd_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmadd_vv_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (size_t)(op3))
#define vmadd_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmadd_vv_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (size_t)(op3))
#define vmadd_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmadd_vv_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (size_t)(op3))
#define vmadd_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vmadd_vx_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vmadd_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (int8_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vmadd_vx_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vmadd_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (int8_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vmadd_vx_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vmadd_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (int8_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vmadd_vx_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (vint8m8_t)(op2), (size_t)(op3))
#define vmadd_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (int8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vmadd_vx_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vmadd_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (int8_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vmadd_vx_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vmadd_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (int8_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vmadd_vx_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vmadd_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (int8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vmadd_vx_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vmadd_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (int16_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vmadd_vx_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vmadd_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (int16_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vmadd_vx_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vmadd_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (int16_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vmadd_vx_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (vint16m8_t)(op2), (size_t)(op3))
#define vmadd_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (int16_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vmadd_vx_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vmadd_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (int16_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vmadd_vx_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vmadd_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (int16_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vmadd_vx_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vmadd_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (int32_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vmadd_vx_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vmadd_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (int32_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vmadd_vx_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vmadd_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (int32_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vmadd_vx_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (vint32m8_t)(op2), (size_t)(op3))
#define vmadd_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (int32_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vmadd_vx_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vmadd_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (int32_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vmadd_vx_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (vint64m1_t)(op2), (size_t)(op3))
#define vmadd_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (int64_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vmadd_vx_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (vint64m2_t)(op2), (size_t)(op3))
#define vmadd_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (int64_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vmadd_vx_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (vint64m4_t)(op2), (size_t)(op3))
#define vmadd_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (int64_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vmadd_vx_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (vint64m8_t)(op2), (size_t)(op3))
#define vmadd_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (int64_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vmadd_vv_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vmadd_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmadd_vv_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vmadd_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmadd_vv_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vmadd_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmadd_vv_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (size_t)(op3))
#define vmadd_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmadd_vv_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vmadd_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmadd_vv_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vmadd_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmadd_vv_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vmadd_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmadd_vv_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vmadd_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmadd_vv_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vmadd_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmadd_vv_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vmadd_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmadd_vv_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vmadd_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmadd_vv_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vmadd_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmadd_vv_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vmadd_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmadd_vv_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vmadd_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmadd_vv_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vmadd_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmadd_vv_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vmadd_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmadd_vv_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vmadd_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmadd_vv_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vmadd_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmadd_vv_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (size_t)(op3))
#define vmadd_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmadd_vv_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (size_t)(op3))
#define vmadd_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmadd_vv_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (size_t)(op3))
#define vmadd_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmadd_vv_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (size_t)(op3))
#define vmadd_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vmadd_vx_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vmadd_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (uint8_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vmadd_vx_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vmadd_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (uint8_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vmadd_vx_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vmadd_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (uint8_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vmadd_vx_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (vuint8m8_t)(op2), (size_t)(op3))
#define vmadd_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (uint8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vmadd_vx_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vmadd_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (uint8_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vmadd_vx_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vmadd_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (uint8_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vmadd_vx_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vmadd_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (uint8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vmadd_vx_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vmadd_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (uint16_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vmadd_vx_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vmadd_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (uint16_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vmadd_vx_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vmadd_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (uint16_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vmadd_vx_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vmadd_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (uint16_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vmadd_vx_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vmadd_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (uint16_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vmadd_vx_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vmadd_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (uint16_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vmadd_vx_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vmadd_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (uint32_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vmadd_vx_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vmadd_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (uint32_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vmadd_vx_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vmadd_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (uint32_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vmadd_vx_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vmadd_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (uint32_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vmadd_vx_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vmadd_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (uint32_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vmadd_vx_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (vuint64m1_t)(op2), (size_t)(op3))
#define vmadd_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (uint64_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vmadd_vx_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (vuint64m2_t)(op2), (size_t)(op3))
#define vmadd_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (uint64_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vmadd_vx_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (vuint64m4_t)(op2), (size_t)(op3))
#define vmadd_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (uint64_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vmadd_vx_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vmadd_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (vuint64m8_t)(op2), (size_t)(op3))
#define vmadd_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vmadd_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (uint64_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vnmsub_vv_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i8m1((vint8m1_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vnmsub_vv_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vnmsub_vv_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i8m2((vint8m2_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vnmsub_vv_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vnmsub_vv_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i8m4((vint8m4_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vnmsub_vv_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vnmsub_vv_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i8m8((vint8m8_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (size_t)(op3))
#define vnmsub_vv_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (vint8m8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vnmsub_vv_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i8mf2((vint8mf2_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vnmsub_vv_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vnmsub_vv_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i8mf4((vint8mf4_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vnmsub_vv_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vnmsub_vv_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i8mf8((vint8mf8_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vnmsub_vv_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vnmsub_vv_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i16m1((vint16m1_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vnmsub_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vnmsub_vv_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i16m2((vint16m2_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vnmsub_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vnmsub_vv_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i16m4((vint16m4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vnmsub_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vnmsub_vv_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i16m8((vint16m8_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (size_t)(op3))
#define vnmsub_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint16m8_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vnmsub_vv_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i16mf2((vint16mf2_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vnmsub_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vnmsub_vv_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i16mf4((vint16mf4_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vnmsub_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vnmsub_vv_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i32m1((vint32m1_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vnmsub_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vnmsub_vv_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i32m2((vint32m2_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vnmsub_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vnmsub_vv_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i32m4((vint32m4_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vnmsub_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vnmsub_vv_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i32m8((vint32m8_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (size_t)(op3))
#define vnmsub_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint32m8_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vnmsub_vv_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i32mf2((vint32mf2_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vnmsub_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vnmsub_vv_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i64m1((vint64m1_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (size_t)(op3))
#define vnmsub_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint64m1_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vnmsub_vv_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i64m2((vint64m2_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (size_t)(op3))
#define vnmsub_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint64m2_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vnmsub_vv_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i64m4((vint64m4_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (size_t)(op3))
#define vnmsub_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint64m4_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vnmsub_vv_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_i64m8((vint64m8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (size_t)(op3))
#define vnmsub_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint64m8_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vnmsub_vx_i8m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i8m1((vint8m1_t)(op0), (int8_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vnmsub_vx_i8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i8m1_m((vbool8_t)(op0), (vint8m1_t)(op1), (int8_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vnmsub_vx_i8m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i8m2((vint8m2_t)(op0), (int8_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vnmsub_vx_i8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i8m2_m((vbool4_t)(op0), (vint8m2_t)(op1), (int8_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vnmsub_vx_i8m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i8m4((vint8m4_t)(op0), (int8_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vnmsub_vx_i8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i8m4_m((vbool2_t)(op0), (vint8m4_t)(op1), (int8_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vnmsub_vx_i8m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i8m8((vint8m8_t)(op0), (int8_t)(op1), (vint8m8_t)(op2), (size_t)(op3))
#define vnmsub_vx_i8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i8m8_m((vbool1_t)(op0), (vint8m8_t)(op1), (int8_t)(op2), (vint8m8_t)(op3), (size_t)(op4))
#define vnmsub_vx_i8mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i8mf2((vint8mf2_t)(op0), (int8_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vnmsub_vx_i8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i8mf2_m((vbool16_t)(op0), (vint8mf2_t)(op1), (int8_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vnmsub_vx_i8mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i8mf4((vint8mf4_t)(op0), (int8_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vnmsub_vx_i8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i8mf4_m((vbool32_t)(op0), (vint8mf4_t)(op1), (int8_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vnmsub_vx_i8mf8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i8mf8((vint8mf8_t)(op0), (int8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vnmsub_vx_i8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i8mf8_m((vbool64_t)(op0), (vint8mf8_t)(op1), (int8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vnmsub_vx_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i16m1((vint16m1_t)(op0), (int16_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vnmsub_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (int16_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vnmsub_vx_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i16m2((vint16m2_t)(op0), (int16_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vnmsub_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (int16_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vnmsub_vx_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i16m4((vint16m4_t)(op0), (int16_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vnmsub_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (int16_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vnmsub_vx_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i16m8((vint16m8_t)(op0), (int16_t)(op1), (vint16m8_t)(op2), (size_t)(op3))
#define vnmsub_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (int16_t)(op2), (vint16m8_t)(op3), (size_t)(op4))
#define vnmsub_vx_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i16mf2((vint16mf2_t)(op0), (int16_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vnmsub_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (int16_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vnmsub_vx_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i16mf4((vint16mf4_t)(op0), (int16_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vnmsub_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (int16_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vnmsub_vx_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i32m1((vint32m1_t)(op0), (int32_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vnmsub_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (int32_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vnmsub_vx_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i32m2((vint32m2_t)(op0), (int32_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vnmsub_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (int32_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vnmsub_vx_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i32m4((vint32m4_t)(op0), (int32_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vnmsub_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (int32_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vnmsub_vx_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i32m8((vint32m8_t)(op0), (int32_t)(op1), (vint32m8_t)(op2), (size_t)(op3))
#define vnmsub_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (int32_t)(op2), (vint32m8_t)(op3), (size_t)(op4))
#define vnmsub_vx_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i32mf2((vint32mf2_t)(op0), (int32_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vnmsub_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (int32_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vnmsub_vx_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i64m1((vint64m1_t)(op0), (int64_t)(op1), (vint64m1_t)(op2), (size_t)(op3))
#define vnmsub_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (int64_t)(op2), (vint64m1_t)(op3), (size_t)(op4))
#define vnmsub_vx_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i64m2((vint64m2_t)(op0), (int64_t)(op1), (vint64m2_t)(op2), (size_t)(op3))
#define vnmsub_vx_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (int64_t)(op2), (vint64m2_t)(op3), (size_t)(op4))
#define vnmsub_vx_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i64m4((vint64m4_t)(op0), (int64_t)(op1), (vint64m4_t)(op2), (size_t)(op3))
#define vnmsub_vx_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (int64_t)(op2), (vint64m4_t)(op3), (size_t)(op4))
#define vnmsub_vx_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_i64m8((vint64m8_t)(op0), (int64_t)(op1), (vint64m8_t)(op2), (size_t)(op3))
#define vnmsub_vx_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (int64_t)(op2), (vint64m8_t)(op3), (size_t)(op4))
#define vnmsub_vv_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u8m1((vuint8m1_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vnmsub_vv_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vnmsub_vv_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u8m2((vuint8m2_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vnmsub_vv_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vnmsub_vv_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u8m4((vuint8m4_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vnmsub_vv_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vnmsub_vv_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u8m8((vuint8m8_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (size_t)(op3))
#define vnmsub_vv_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (vuint8m8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vnmsub_vv_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u8mf2((vuint8mf2_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vnmsub_vv_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vnmsub_vv_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u8mf4((vuint8mf4_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vnmsub_vv_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vnmsub_vv_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u8mf8((vuint8mf8_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vnmsub_vv_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vnmsub_vv_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u16m1((vuint16m1_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vnmsub_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vnmsub_vv_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u16m2((vuint16m2_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vnmsub_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vnmsub_vv_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u16m4((vuint16m4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vnmsub_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vnmsub_vv_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u16m8((vuint16m8_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vnmsub_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint16m8_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vnmsub_vv_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u16mf2((vuint16mf2_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vnmsub_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vnmsub_vv_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u16mf4((vuint16mf4_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vnmsub_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vnmsub_vv_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u32m1((vuint32m1_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vnmsub_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vnmsub_vv_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u32m2((vuint32m2_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vnmsub_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vnmsub_vv_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u32m4((vuint32m4_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vnmsub_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vnmsub_vv_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u32m8((vuint32m8_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vnmsub_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint32m8_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vnmsub_vv_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u32mf2((vuint32mf2_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vnmsub_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vnmsub_vv_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u64m1((vuint64m1_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (size_t)(op3))
#define vnmsub_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint64m1_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vnmsub_vv_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u64m2((vuint64m2_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (size_t)(op3))
#define vnmsub_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint64m2_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vnmsub_vv_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u64m4((vuint64m4_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (size_t)(op3))
#define vnmsub_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint64m4_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vnmsub_vv_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vv_u64m8((vuint64m8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (size_t)(op3))
#define vnmsub_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint64m8_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vsuxei16_v_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u32m1((uint32_t *)(op0), (vuint16mf2_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vsuxei16_v_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u32m1_m((vbool32_t)(op0), (uint32_t *)(op1), (vuint16mf2_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vsuxei16_v_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u32m2((uint32_t *)(op0), (vuint16m1_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vsuxei16_v_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u32m2_m((vbool16_t)(op0), (uint32_t *)(op1), (vuint16m1_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vsuxei16_v_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u32m4((uint32_t *)(op0), (vuint16m2_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vsuxei16_v_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u32m4_m((vbool8_t)(op0), (uint32_t *)(op1), (vuint16m2_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vsuxei16_v_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u32m8((uint32_t *)(op0), (vuint16m4_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vsuxei16_v_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u32m8_m((vbool4_t)(op0), (uint32_t *)(op1), (vuint16m4_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vsuxei16_v_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vsuxei16_v_u32mf2((uint32_t *)(op0), (vuint16mf4_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vsuxei16_v_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vsuxei16_v_u32mf2_m((vbool64_t)(op0), (uint32_t *)(op1), (vuint16mf4_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vnmsub_vx_u8m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u8m1((vuint8m1_t)(op0), (uint8_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vnmsub_vx_u8m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u8m1_m((vbool8_t)(op0), (vuint8m1_t)(op1), (uint8_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vnmsub_vx_u8m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u8m2((vuint8m2_t)(op0), (uint8_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vnmsub_vx_u8m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u8m2_m((vbool4_t)(op0), (vuint8m2_t)(op1), (uint8_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vnmsub_vx_u8m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u8m4((vuint8m4_t)(op0), (uint8_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vnmsub_vx_u8m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u8m4_m((vbool2_t)(op0), (vuint8m4_t)(op1), (uint8_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vnmsub_vx_u8m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u8m8((vuint8m8_t)(op0), (uint8_t)(op1), (vuint8m8_t)(op2), (size_t)(op3))
#define vnmsub_vx_u8m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u8m8_m((vbool1_t)(op0), (vuint8m8_t)(op1), (uint8_t)(op2), (vuint8m8_t)(op3), (size_t)(op4))
#define vnmsub_vx_u8mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u8mf2((vuint8mf2_t)(op0), (uint8_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vnmsub_vx_u8mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u8mf2_m((vbool16_t)(op0), (vuint8mf2_t)(op1), (uint8_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vnmsub_vx_u8mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u8mf4((vuint8mf4_t)(op0), (uint8_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vnmsub_vx_u8mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u8mf4_m((vbool32_t)(op0), (vuint8mf4_t)(op1), (uint8_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vnmsub_vx_u8mf8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u8mf8((vuint8mf8_t)(op0), (uint8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vnmsub_vx_u8mf8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u8mf8_m((vbool64_t)(op0), (vuint8mf8_t)(op1), (uint8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vnmsub_vx_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u16m1((vuint16m1_t)(op0), (uint16_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vnmsub_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (uint16_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vnmsub_vx_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u16m2((vuint16m2_t)(op0), (uint16_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vnmsub_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (uint16_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vnmsub_vx_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u16m4((vuint16m4_t)(op0), (uint16_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vnmsub_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (uint16_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vnmsub_vx_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u16m8((vuint16m8_t)(op0), (uint16_t)(op1), (vuint16m8_t)(op2), (size_t)(op3))
#define vnmsub_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (uint16_t)(op2), (vuint16m8_t)(op3), (size_t)(op4))
#define vnmsub_vx_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u16mf2((vuint16mf2_t)(op0), (uint16_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vnmsub_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (uint16_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vnmsub_vx_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u16mf4((vuint16mf4_t)(op0), (uint16_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vnmsub_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (uint16_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vnmsub_vx_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u32m1((vuint32m1_t)(op0), (uint32_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vnmsub_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (uint32_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vnmsub_vx_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u32m2((vuint32m2_t)(op0), (uint32_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vnmsub_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (uint32_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vnmsub_vx_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u32m4((vuint32m4_t)(op0), (uint32_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vnmsub_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (uint32_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vnmsub_vx_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u32m8((vuint32m8_t)(op0), (uint32_t)(op1), (vuint32m8_t)(op2), (size_t)(op3))
#define vnmsub_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (uint32_t)(op2), (vuint32m8_t)(op3), (size_t)(op4))
#define vnmsub_vx_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u32mf2((vuint32mf2_t)(op0), (uint32_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vnmsub_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (uint32_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vnmsub_vx_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u64m1((vuint64m1_t)(op0), (uint64_t)(op1), (vuint64m1_t)(op2), (size_t)(op3))
#define vnmsub_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (uint64_t)(op2), (vuint64m1_t)(op3), (size_t)(op4))
#define vnmsub_vx_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u64m2((vuint64m2_t)(op0), (uint64_t)(op1), (vuint64m2_t)(op2), (size_t)(op3))
#define vnmsub_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (uint64_t)(op2), (vuint64m2_t)(op3), (size_t)(op4))
#define vnmsub_vx_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u64m4((vuint64m4_t)(op0), (uint64_t)(op1), (vuint64m4_t)(op2), (size_t)(op3))
#define vnmsub_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (uint64_t)(op2), (vuint64m4_t)(op3), (size_t)(op4))
#define vnmsub_vx_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vnmsub_vx_u64m8((vuint64m8_t)(op0), (uint64_t)(op1), (vuint64m8_t)(op2), (size_t)(op3))
#define vnmsub_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vnmsub_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (uint64_t)(op2), (vuint64m8_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u16mf4((vuint16mf4_t)(op0), (vuint8mf8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (vuint8mf8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u16mf2((vuint16mf2_t)(op0), (vuint8mf4_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (vuint8mf4_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u16m1((vuint16m1_t)(op0), (vuint8mf2_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (vuint8mf2_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u16m2((vuint16m2_t)(op0), (vuint8m1_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (vuint8m1_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u16m4((vuint16m4_t)(op0), (vuint8m2_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (vuint8m2_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u16m8((vuint16m8_t)(op0), (vuint8m4_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (vuint8m4_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u32mf2((vuint32mf2_t)(op0), (vuint16mf4_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (vuint16mf4_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u32m1((vuint32m1_t)(op0), (vuint16mf2_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (vuint16mf2_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u32m2((vuint32m2_t)(op0), (vuint16m1_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (vuint16m1_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u32m4((vuint32m4_t)(op0), (vuint16m2_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (vuint16m2_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u32m8((vuint32m8_t)(op0), (vuint16m4_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (vuint16m4_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u64m1((vuint64m1_t)(op0), (vuint32mf2_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (vuint32mf2_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u64m2((vuint64m2_t)(op0), (vuint32m1_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (vuint32m1_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u64m4((vuint64m4_t)(op0), (vuint32m2_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (vuint32m2_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vwmaccu_vv_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vv_u64m8((vuint64m8_t)(op0), (vuint32m4_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vwmaccu_vv_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vv_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (vuint32m4_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u16mf4(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u16mf4((vuint16mf4_t)(op0), (uint8_t)(op1), (vuint8mf8_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u16mf4_m((vbool64_t)(op0), (vuint16mf4_t)(op1), (uint8_t)(op2), (vuint8mf8_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u16mf2(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u16mf2((vuint16mf2_t)(op0), (uint8_t)(op1), (vuint8mf4_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u16mf2_m((vbool32_t)(op0), (vuint16mf2_t)(op1), (uint8_t)(op2), (vuint8mf4_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u16m1(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u16m1((vuint16m1_t)(op0), (uint8_t)(op1), (vuint8mf2_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u16m1_m((vbool16_t)(op0), (vuint16m1_t)(op1), (uint8_t)(op2), (vuint8mf2_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u16m2(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u16m2((vuint16m2_t)(op0), (uint8_t)(op1), (vuint8m1_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u16m2_m((vbool8_t)(op0), (vuint16m2_t)(op1), (uint8_t)(op2), (vuint8m1_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u16m4(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u16m4((vuint16m4_t)(op0), (uint8_t)(op1), (vuint8m2_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u16m4_m((vbool4_t)(op0), (vuint16m4_t)(op1), (uint8_t)(op2), (vuint8m2_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u16m8(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u16m8((vuint16m8_t)(op0), (uint8_t)(op1), (vuint8m4_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u16m8_m((vbool2_t)(op0), (vuint16m8_t)(op1), (uint8_t)(op2), (vuint8m4_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u32mf2(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u32mf2((vuint32mf2_t)(op0), (uint16_t)(op1), (vuint16mf4_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u32mf2_m((vbool64_t)(op0), (vuint32mf2_t)(op1), (uint16_t)(op2), (vuint16mf4_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u32m1(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u32m1((vuint32m1_t)(op0), (uint16_t)(op1), (vuint16mf2_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u32m1_m((vbool32_t)(op0), (vuint32m1_t)(op1), (uint16_t)(op2), (vuint16mf2_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u32m2(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u32m2((vuint32m2_t)(op0), (uint16_t)(op1), (vuint16m1_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u32m2_m((vbool16_t)(op0), (vuint32m2_t)(op1), (uint16_t)(op2), (vuint16m1_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u32m4(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u32m4((vuint32m4_t)(op0), (uint16_t)(op1), (vuint16m2_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u32m4_m((vbool8_t)(op0), (vuint32m4_t)(op1), (uint16_t)(op2), (vuint16m2_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u32m8(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u32m8((vuint32m8_t)(op0), (uint16_t)(op1), (vuint16m4_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u32m8_m((vbool4_t)(op0), (vuint32m8_t)(op1), (uint16_t)(op2), (vuint16m4_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u64m1(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u64m1((vuint64m1_t)(op0), (uint32_t)(op1), (vuint32mf2_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u64m1_m((vbool64_t)(op0), (vuint64m1_t)(op1), (uint32_t)(op2), (vuint32mf2_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u64m2(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u64m2((vuint64m2_t)(op0), (uint32_t)(op1), (vuint32m1_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u64m2_m((vbool32_t)(op0), (vuint64m2_t)(op1), (uint32_t)(op2), (vuint32m1_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u64m4(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u64m4((vuint64m4_t)(op0), (uint32_t)(op1), (vuint32m2_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u64m4_m((vbool16_t)(op0), (vuint64m4_t)(op1), (uint32_t)(op2), (vuint32m2_t)(op3), (size_t)(op4))
#define vwmaccu_vx_u64m8(op0, op1, op2, op3) \
__builtin_rvv_vwmaccu_vx_u64m8((vuint64m8_t)(op0), (uint32_t)(op1), (vuint32m4_t)(op2), (size_t)(op3))
#define vwmaccu_vx_u64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmaccu_vx_u64m8_m((vbool8_t)(op0), (vuint64m8_t)(op1), (uint32_t)(op2), (vuint32m4_t)(op3), (size_t)(op4))
#define vwmacc_vv_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i16mf4((vint16mf4_t)(op0), (vint8mf8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vwmacc_vv_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (vint8mf8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vwmacc_vv_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i16mf2((vint16mf2_t)(op0), (vint8mf4_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vwmacc_vv_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (vint8mf4_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vwmacc_vv_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i16m1((vint16m1_t)(op0), (vint8mf2_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vwmacc_vv_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (vint8mf2_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vwmacc_vv_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i16m2((vint16m2_t)(op0), (vint8m1_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vwmacc_vv_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (vint8m1_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vwmacc_vv_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i16m4((vint16m4_t)(op0), (vint8m2_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vwmacc_vv_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (vint8m2_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vwmacc_vv_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i16m8((vint16m8_t)(op0), (vint8m4_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vwmacc_vv_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (vint8m4_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vwmacc_vv_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i32mf2((vint32mf2_t)(op0), (vint16mf4_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vwmacc_vv_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (vint16mf4_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vwmacc_vv_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i32m1((vint32m1_t)(op0), (vint16mf2_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vwmacc_vv_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (vint16mf2_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vwmacc_vv_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i32m2((vint32m2_t)(op0), (vint16m1_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vwmacc_vv_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (vint16m1_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vwmacc_vv_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i32m4((vint32m4_t)(op0), (vint16m2_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vwmacc_vv_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (vint16m2_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vwmacc_vv_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i32m8((vint32m8_t)(op0), (vint16m4_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vwmacc_vv_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (vint16m4_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vwmacc_vv_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i64m1((vint64m1_t)(op0), (vint32mf2_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vwmacc_vv_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i64m1_m((vbool64_t)(op0), (vint64m1_t)(op1), (vint32mf2_t)(op2), (vint32mf2_t)(op3), (size_t)(op4))
#define vwmacc_vv_i64m2(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i64m2((vint64m2_t)(op0), (vint32m1_t)(op1), (vint32m1_t)(op2), (size_t)(op3))
#define vwmacc_vv_i64m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i64m2_m((vbool32_t)(op0), (vint64m2_t)(op1), (vint32m1_t)(op2), (vint32m1_t)(op3), (size_t)(op4))
#define vwmacc_vv_i64m4(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i64m4((vint64m4_t)(op0), (vint32m2_t)(op1), (vint32m2_t)(op2), (size_t)(op3))
#define vwmacc_vv_i64m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i64m4_m((vbool16_t)(op0), (vint64m4_t)(op1), (vint32m2_t)(op2), (vint32m2_t)(op3), (size_t)(op4))
#define vwmacc_vv_i64m8(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vv_i64m8((vint64m8_t)(op0), (vint32m4_t)(op1), (vint32m4_t)(op2), (size_t)(op3))
#define vwmacc_vv_i64m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vv_i64m8_m((vbool8_t)(op0), (vint64m8_t)(op1), (vint32m4_t)(op2), (vint32m4_t)(op3), (size_t)(op4))
#define vwmacc_vx_i16mf4(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i16mf4((vint16mf4_t)(op0), (int8_t)(op1), (vint8mf8_t)(op2), (size_t)(op3))
#define vwmacc_vx_i16mf4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vx_i16mf4_m((vbool64_t)(op0), (vint16mf4_t)(op1), (int8_t)(op2), (vint8mf8_t)(op3), (size_t)(op4))
#define vwmacc_vx_i16mf2(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i16mf2((vint16mf2_t)(op0), (int8_t)(op1), (vint8mf4_t)(op2), (size_t)(op3))
#define vwmacc_vx_i16mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vx_i16mf2_m((vbool32_t)(op0), (vint16mf2_t)(op1), (int8_t)(op2), (vint8mf4_t)(op3), (size_t)(op4))
#define vwmacc_vx_i16m1(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i16m1((vint16m1_t)(op0), (int8_t)(op1), (vint8mf2_t)(op2), (size_t)(op3))
#define vwmacc_vx_i16m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vx_i16m1_m((vbool16_t)(op0), (vint16m1_t)(op1), (int8_t)(op2), (vint8mf2_t)(op3), (size_t)(op4))
#define vwmacc_vx_i16m2(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i16m2((vint16m2_t)(op0), (int8_t)(op1), (vint8m1_t)(op2), (size_t)(op3))
#define vwmacc_vx_i16m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vx_i16m2_m((vbool8_t)(op0), (vint16m2_t)(op1), (int8_t)(op2), (vint8m1_t)(op3), (size_t)(op4))
#define vwmacc_vx_i16m4(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i16m4((vint16m4_t)(op0), (int8_t)(op1), (vint8m2_t)(op2), (size_t)(op3))
#define vwmacc_vx_i16m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vx_i16m4_m((vbool4_t)(op0), (vint16m4_t)(op1), (int8_t)(op2), (vint8m2_t)(op3), (size_t)(op4))
#define vwmacc_vx_i16m8(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i16m8((vint16m8_t)(op0), (int8_t)(op1), (vint8m4_t)(op2), (size_t)(op3))
#define vwmacc_vx_i16m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vx_i16m8_m((vbool2_t)(op0), (vint16m8_t)(op1), (int8_t)(op2), (vint8m4_t)(op3), (size_t)(op4))
#define vwmacc_vx_i32mf2(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i32mf2((vint32mf2_t)(op0), (int16_t)(op1), (vint16mf4_t)(op2), (size_t)(op3))
#define vwmacc_vx_i32mf2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vx_i32mf2_m((vbool64_t)(op0), (vint32mf2_t)(op1), (int16_t)(op2), (vint16mf4_t)(op3), (size_t)(op4))
#define vwmacc_vx_i32m1(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i32m1((vint32m1_t)(op0), (int16_t)(op1), (vint16mf2_t)(op2), (size_t)(op3))
#define vwmacc_vx_i32m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vx_i32m1_m((vbool32_t)(op0), (vint32m1_t)(op1), (int16_t)(op2), (vint16mf2_t)(op3), (size_t)(op4))
#define vwmacc_vx_i32m2(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i32m2((vint32m2_t)(op0), (int16_t)(op1), (vint16m1_t)(op2), (size_t)(op3))
#define vwmacc_vx_i32m2_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vx_i32m2_m((vbool16_t)(op0), (vint32m2_t)(op1), (int16_t)(op2), (vint16m1_t)(op3), (size_t)(op4))
#define vwmacc_vx_i32m4(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i32m4((vint32m4_t)(op0), (int16_t)(op1), (vint16m2_t)(op2), (size_t)(op3))
#define vwmacc_vx_i32m4_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vx_i32m4_m((vbool8_t)(op0), (vint32m4_t)(op1), (int16_t)(op2), (vint16m2_t)(op3), (size_t)(op4))
#define vwmacc_vx_i32m8(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i32m8((vint32m8_t)(op0), (int16_t)(op1), (vint16m4_t)(op2), (size_t)(op3))
#define vwmacc_vx_i32m8_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmacc_vx_i32m8_m((vbool4_t)(op0), (vint32m8_t)(op1), (int16_t)(op2), (vint16m4_t)(op3), (size_t)(op4))
#define vwmacc_vx_i64m1(op0, op1, op2, op3) \
__builtin_rvv_vwmacc_vx_i64m1((vint64m1_t)(op0), (int32_t)(op1), (vint32mf2_t)(op2), (size_t)(op3))
#define vwmacc_vx_i64m1_m(op0, op1, op2, op3, op4) \
__builtin_rvv_vwmac