/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeConverterBinding;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.sisu.bean.BeanProperties;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.plexus.PlexusBeanConverter;
import org.eclipse.sisu.plexus.Roles;

@Singleton
public final class PlexusXmlBeanConverter
implements PlexusBeanConverter {
    private static final String CONVERSION_ERROR = "Cannot convert: \"%s\" to: %s";
    private final Collection<TypeConverterBinding> typeConverterBindings;

    @Inject
    PlexusXmlBeanConverter(Injector injector) {
        this.typeConverterBindings = injector.getTypeConverterBindings();
    }

    public Object convert(TypeLiteral role, String value) {
        if (value.trim().startsWith("<")) {
            try {
                MXParser parser = new MXParser();
                parser.setInput(new StringReader(value));
                parser.nextTag();
                return this.parse(parser, role);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException(String.format(CONVERSION_ERROR, value, role), e2);
            }
        }
        return this.convertText(value, role);
    }

    private Object parse(MXParser parser, TypeLiteral<?> toType) throws Exception {
        parser.require(2, null, null);
        Class<?> rawType = toType.getRawType();
        if (Xpp3Dom.class.isAssignableFrom(rawType)) {
            return PlexusXmlBeanConverter.parseXpp3Dom(parser);
        }
        if (Properties.class.isAssignableFrom(rawType)) {
            return PlexusXmlBeanConverter.parseProperties(parser);
        }
        if (Map.class.isAssignableFrom(rawType)) {
            return this.parseMap(parser, TypeArguments.get(toType.getSupertype(Map.class), 1));
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            return this.parseCollection(parser, TypeArguments.get(toType.getSupertype(Collection.class), 0));
        }
        if (rawType.isArray()) {
            return this.parseArray(parser, TypeArguments.get(toType, 0));
        }
        return this.parseBean(parser, toType, rawType);
    }

    private static Xpp3Dom parseXpp3Dom(XmlPullParser parser) throws Exception {
        return Xpp3DomBuilder.build(parser);
    }

    private static Properties parseProperties(XmlPullParser parser) throws Exception {
        Properties properties = PlexusXmlBeanConverter.newImplementation(parser, Properties.class);
        while (parser.nextTag() == 2) {
            parser.nextTag();
            if ("name".equals(parser.getName())) {
                String name2 = parser.nextText();
                parser.nextTag();
                properties.put(name2, parser.nextText());
            } else {
                String value = parser.nextText();
                parser.nextTag();
                properties.put(parser.nextText(), value);
            }
            parser.nextTag();
        }
        return properties;
    }

    private Map<String, Object> parseMap(MXParser parser, TypeLiteral<?> toType) throws Exception {
        Map map2 = PlexusXmlBeanConverter.newImplementation(parser, HashMap.class);
        while (parser.nextTag() == 2) {
            map2.put(parser.getName(), this.parse(parser, toType));
        }
        return map2;
    }

    private Collection<Object> parseCollection(MXParser parser, TypeLiteral<?> toType) throws Exception {
        Collection collection = PlexusXmlBeanConverter.newImplementation(parser, ArrayList.class);
        while (parser.nextTag() == 2) {
            collection.add(this.parse(parser, toType));
        }
        return collection;
    }

    private Object parseArray(MXParser parser, TypeLiteral<?> toType) throws Exception {
        Collection<Object> collection = this.parseCollection(parser, toType);
        Object array2 = Array.newInstance(toType.getRawType(), collection.size());
        int i = 0;
        for (Object element : collection) {
            Array.set(array2, i++, element);
        }
        return array2;
    }

    private Object parseBean(MXParser parser, TypeLiteral<?> toType, Class<?> rawType) throws Exception {
        Class<?> clazz = PlexusXmlBeanConverter.loadImplementation(PlexusXmlBeanConverter.parseImplementation(parser), rawType);
        if (parser.next() == 4) {
            String text = parser.getText();
            if (parser.next() != 2) {
                return this.convertText(text, clazz == rawType ? toType : TypeLiteral.get(clazz));
            }
        }
        if (String.class == clazz) {
            while (parser.getEventType() == 2) {
                String pos = parser.getPositionDescription();
                Logs.warn("Expected TEXT, not XML: {}", pos, new Throwable());
                parser.skipSubTree();
                parser.nextTag();
            }
            return "";
        }
        Object bean2 = PlexusXmlBeanConverter.newImplementation(clazz);
        HashMap<String, BeanProperty> propertyMap = new HashMap<String, BeanProperty>();
        for (BeanProperty property : new BeanProperties(clazz)) {
            String name2 = property.getName();
            if (propertyMap.containsKey(name2)) continue;
            propertyMap.put(name2, property);
        }
        while (parser.getEventType() == 2) {
            BeanProperty property;
            property = (BeanProperty)propertyMap.get(Roles.camelizeName(parser.getName()));
            if (property != null) {
                property.set(bean2, this.parse(parser, property.getType()));
                parser.nextTag();
                continue;
            }
            throw new XmlPullParserException("Unknown bean property: " + parser.getName(), parser, null);
        }
        return bean2;
    }

    private static String parseImplementation(XmlPullParser parser) {
        return parser.getAttributeValue(null, "implementation");
    }

    private static Class<?> loadImplementation(String name2, Class<?> defaultClazz) {
        ClassLoader peer;
        if (name2 == null) {
            return defaultClazz;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null) {
            try {
                return tccl.loadClass(name2);
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {}
        }
        if ((peer = defaultClazz.getClassLoader()) != null) {
            try {
                return peer.loadClass(name2);
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {}
        }
        try {
            return Class.forName(name2);
        }
        catch (Exception e2) {
            throw new TypeNotPresentException(name2, e2);
        }
        catch (LinkageError e3) {
            throw new TypeNotPresentException(name2, e3);
        }
    }

    private static <T> T newImplementation(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Cannot create instance of: " + clazz, e2);
        }
        catch (LinkageError e3) {
            throw new IllegalArgumentException("Cannot create instance of: " + clazz, e3);
        }
    }

    private static <T> T newImplementation(Class<T> clazz, String value) {
        try {
            return clazz.getConstructor(String.class).newInstance(value);
        }
        catch (Exception e2) {
            Throwable cause = e2 instanceof InvocationTargetException ? e2.getCause() : e2;
            throw new IllegalArgumentException(String.format(CONVERSION_ERROR, value, clazz), cause);
        }
        catch (LinkageError e3) {
            throw new IllegalArgumentException(String.format(CONVERSION_ERROR, value, clazz), e3);
        }
    }

    private static <T> T newImplementation(XmlPullParser parser, Class<T> defaultClazz) {
        return (T)PlexusXmlBeanConverter.newImplementation(PlexusXmlBeanConverter.loadImplementation(PlexusXmlBeanConverter.parseImplementation(parser), defaultClazz));
    }

    private Object convertText(String value, TypeLiteral<?> toType) {
        String text = value.trim();
        Class<String> rawType = toType.getRawType();
        if (rawType.isAssignableFrom(String.class)) {
            return text;
        }
        TypeLiteral<?> boxedType = rawType.isPrimitive() ? Key.get(rawType).getTypeLiteral() : toType;
        for (TypeConverterBinding b : this.typeConverterBindings) {
            if (!b.getTypeMatcher().matches(boxedType)) continue;
            return b.getTypeConverter().convert(text, toType);
        }
        return text.length() == 0 ? PlexusXmlBeanConverter.newImplementation(rawType) : PlexusXmlBeanConverter.newImplementation(rawType, text);
    }
}

