/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.exif.ExifReader;
import org.fibs.geotag.exif.Exiftool;
import org.fibs.geotag.exif.ExiftoolReader;
import org.fibs.geotag.exif.MetadataExtractorReader;
import org.fibs.geotag.image.FileTypes;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.util.FileUtil;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ExifReaderTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(ExifReaderTask.class);
    private ImagesTableModel tableModel;
    private File[] files;
    private int currentProgress = 0;
    private List<ImageInfo> images = new ArrayList<ImageInfo>();

    public ExifReaderTask(String name, ImagesTableModel tableModel, File[] files) {
        super(null, name);
        this.tableModel = tableModel;
        this.files = files;
    }

    private ImageInfo readExifData(File file) {
        ImageInfo result = null;
        ExifReader exifReader = null;
        FileTypes fileType = FileTypes.fileType(file);
        switch (fileType) {
            case JPEG: {
                exifReader = new MetadataExtractorReader();
                break;
            }
            case RAW_READ_ONLY: 
            case RAW_READ_WRITE: 
            case TIFF: 
            case CUSTOM_FILE_WITH_XMP: {
                exifReader = new ExiftoolReader();
                break;
            }
            case UNKOWN: 
            case XMP: {
                break;
            }
        }
        if (exifReader != null) {
            File xmpFile;
            String xmpFileName;
            if (FileTypes.CUSTOM_FILE_WITH_XMP != fileType) {
                result = exifReader.readExifData(file, null);
            }
            if ((xmpFileName = FileUtil.replaceExtension(file.getPath(), "xmp")) != null && (xmpFile = new File(xmpFileName)).exists()) {
                System.out.println(xmpFileName);
                exifReader = new ExiftoolReader();
                result = exifReader.readExifData(xmpFile, result);
            }
        }
        return result;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getMaxProgress() {
        return this.files.length;
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        int imagesPublished = 0;
        int imagesFailed = 0;
        File[] fileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.interruptRequested()) break;
            ++this.currentProgress;
            this.setProgressMessage();
            try {
                ImageInfo imageInfo = this.readExifData(file);
                if (imageInfo != null) {
                    this.publish(imageInfo);
                    ++imagesPublished;
                } else {
                    ++imagesFailed;
                }
            }
            catch (RuntimeException e) {
                ++imagesFailed;
                e.printStackTrace();
            }
            ++n2;
        }
        StringBuilder result = new StringBuilder();
        if (imagesPublished == 1) {
            result.append(i18n.tr("One image loaded."));
        } else {
            try {
                result.append(String.format(i18n.tr("%d images loaded."), imagesPublished));
            }
            catch (IllegalFormatException e) {
                e.printStackTrace();
            }
        }
        if (imagesFailed > 0 && !Exiftool.isAvailable()) {
            result.append(i18n.tr("Exiftool not found"));
        }
        return result.toString();
    }

    @Override
    protected void process(List<ImageInfo> chunks) {
        for (ImageInfo imageInfo : chunks) {
            int row = this.tableModel.getRow(imageInfo);
            if (row == -1) {
                this.images.add(imageInfo);
                this.tableModel.addImageInfo(imageInfo);
                continue;
            }
            this.tableModel.fireTableRowsUpdated(row, row);
        }
    }

    @Override
    public void redo() {
        super.redo();
        for (ImageInfo imageInfo : this.images) {
            this.tableModel.addImageInfo(imageInfo);
        }
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public void undo() {
        super.undo();
        for (ImageInfo imageInfo : this.images) {
            int row = this.tableModel.getRow(imageInfo);
            this.tableModel.removeRow(row);
        }
        this.tableModel.fireTableDataChanged();
    }
}

