/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoDeleteMarked
implements UndoOperation {
    private DataPoint[] _contents = null;
    protected int _numPointsDeleted = -1;
    private boolean[] _segmentStarts = null;

    public UndoDeleteMarked(Track track) {
        this._contents = track.cloneContents();
        this._segmentStarts = new boolean[track.getNumPoints()];
        int n = 0;
        while (n < track.getNumPoints()) {
            this._segmentStarts[n] = track.getPoint(n).getSegmentStart();
            ++n;
        }
    }

    public void setNumPointsDeleted(int n) {
        this._numPointsDeleted = n;
    }

    @Override
    public String getDescription() {
        String string = I18nManager.getText("undo.deletemarked");
        if (this._numPointsDeleted > 0) {
            string = String.valueOf(string) + " (" + this._numPointsDeleted + ")";
        }
        return string;
    }

    @Override
    public void performUndo(TrackInfo trackInfo) throws UndoException {
        trackInfo.getTrack().replaceContents(this._contents);
        Track track = trackInfo.getTrack();
        if (this._segmentStarts.length != track.getNumPoints()) {
            throw new UndoException("Cannot undo delete - track length no longer matches");
        }
        int n = 0;
        while (n < this._segmentStarts.length) {
            track.getPoint(n).setSegmentStart(this._segmentStarts[n]);
            ++n;
        }
        trackInfo.getSelection().clearAll();
    }
}

