/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataCallback;
import groovyx.gpars.dataflow.DataCallbackWithPool;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowChannel;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.expression.DataflowExpression;
import groovyx.gpars.dataflow.impl.DataflowChannelEventListenerManager;
import groovyx.gpars.dataflow.impl.DataflowChannelEventOrchestrator;
import groovyx.gpars.dataflow.impl.ThenMessagingRunnable;
import groovyx.gpars.dataflow.operator.BinaryChoiceClosure;
import groovyx.gpars.dataflow.operator.ChainWithClosure;
import groovyx.gpars.dataflow.operator.ChoiceClosure;
import groovyx.gpars.dataflow.operator.CopyChannelsClosure;
import groovyx.gpars.dataflow.operator.FilterClosure;
import groovyx.gpars.dataflow.operator.SeparationClosure;
import groovyx.gpars.group.DefaultPGroup;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Pool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DataflowQueue<T>
implements DataflowChannel<T> {
    private final Object queueLock = new Object();
    private final LinkedBlockingQueue<DataflowVariable<T>> queue = new LinkedBlockingQueue();
    private final Queue<DataflowVariable<T>> requests = new LinkedList<DataflowVariable<T>>();
    private final Collection<MessageStream> wheneverBoundListeners = new CopyOnWriteArrayList<MessageStream>();
    private volatile DataflowChannelEventOrchestrator<T> eventManager;

    @Override
    public final DataflowWriteChannel<T> leftShift(DataflowReadChannel<T> ref) {
        final DataflowVariable<T> originalRef = this.retrieveForBind();
        this.hookWheneverBoundListeners(originalRef);
        ref.getValAsync(new MessageStream(){
            private static final long serialVersionUID = -4966523895011173569L;

            @Override
            public MessageStream send(Object message) {
                originalRef.bind(message);
                DataflowQueue.this.fireOnMessage(message);
                return this;
            }
        });
        return this;
    }

    @Override
    public final DataflowWriteChannel<T> leftShift(T value) {
        this.hookWheneverBoundListeners(this.retrieveForBind()).bind(value);
        this.fireOnMessage(value);
        return this;
    }

    @Override
    public final void bind(T value) {
        this.hookWheneverBoundListeners(this.retrieveForBind()).bind(value);
        this.fireOnMessage(value);
    }

    private DataflowExpression<T> hookWheneverBoundListeners(DataflowExpression<T> expr) {
        for (MessageStream listener : this.wheneverBoundListeners) {
            expr.whenBound(listener);
        }
        return expr;
    }

    private DataflowVariable<T> retrieveForBind() {
        return this.copyDFV(this.requests, this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataflowVariable<T> copyDFV(Queue<DataflowVariable<T>> from, Queue<DataflowVariable<T>> to) {
        DataflowVariable<T> ref;
        Object object = this.queueLock;
        synchronized (object) {
            ref = from.poll();
            if (ref == null) {
                ref = this.createVariable();
                to.offer(ref);
            }
        }
        return ref;
    }

    protected DataflowVariable<T> createVariable() {
        return new DataflowVariable();
    }

    @Override
    public final T getVal() throws InterruptedException {
        return this.retrieveOrCreateVariable().getVal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T getVal(long timeout, TimeUnit units) throws InterruptedException {
        DataflowVariable<T> variable = this.retrieveOrCreateVariable();
        variable.getVal(timeout, units);
        Object object = this.queueLock;
        synchronized (object) {
            if (!variable.isBound()) {
                this.requests.remove(variable);
                return null;
            }
        }
        return variable.getVal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DataflowExpression<T> poll() {
        Object object = this.queueLock;
        synchronized (object) {
            DataflowVariable<T> df = this.queue.peek();
            if (df != null && df.isBound()) {
                this.queue.poll();
                return df;
            }
            return null;
        }
    }

    @Override
    public final void getValAsync(MessageStream callback) {
        this.getValAsync(null, callback);
    }

    @Override
    public final void getValAsync(Object attachment, MessageStream callback) {
        this.retrieveOrCreateVariable().getValAsync(attachment, callback);
    }

    @Override
    public final <V> Promise<V> rightShift(Closure<V> closure) {
        return this.then(closure);
    }

    @Override
    public final <V> void whenBound(Closure<V> closure) {
        this.getValAsync(new DataCallback(closure, Dataflow.retrieveCurrentDFPGroup()));
    }

    @Override
    public final <V> void whenBound(Pool pool, Closure<V> closure) {
        this.getValAsync(new DataCallbackWithPool(pool, closure));
    }

    @Override
    public <V> void whenBound(PGroup group, Closure<V> closure) {
        this.getValAsync(new DataCallback(closure, group));
    }

    @Override
    public final void whenBound(MessageStream stream) {
        this.getValAsync(stream);
    }

    @Override
    public final <V> Promise<V> then(Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public <V> Promise<V> then(Pool pool, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(pool, new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public <V> Promise<V> then(PGroup group, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(group, new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public final <V> void wheneverBound(Closure<V> closure) {
        this.wheneverBoundListeners.add(new DataCallback(closure, Dataflow.retrieveCurrentDFPGroup()));
    }

    @Override
    public final void wheneverBound(MessageStream stream) {
        this.wheneverBoundListeners.add(stream);
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Closure<V> closure) {
        return this.chainWith(Dataflow.retrieveCurrentDFPGroup(), closure);
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Pool pool, Closure<V> closure) {
        return this.chainWith(new DefaultPGroup(pool), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> chainWith(PGroup group, Closure<V> closure) {
        DataflowQueue<T> result = new DataflowQueue<T>();
        group.operator(this, result, new ChainWithClosure(closure));
        return result;
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Map<String, Object> params, Closure<V> closure) {
        return this.chainWith(Dataflow.retrieveCurrentDFPGroup(), params, closure);
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Pool pool, Map<String, Object> params, Closure<V> closure) {
        return this.chainWith(new DefaultPGroup(pool), params, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> chainWith(PGroup group, Map<String, Object> params, Closure<V> closure) {
        DataflowQueue<T> result = new DataflowQueue<T>();
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", Arrays.asList(this));
        parameters.put("outputs", Arrays.asList(result));
        group.operator(parameters, new ChainWithClosure(closure));
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> or(Closure<V> closure) {
        return this.chainWith(closure);
    }

    @Override
    public DataflowReadChannel<T> filter(Closure<Boolean> closure) {
        return this.chainWith(new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(Pool pool, Closure<Boolean> closure) {
        return this.chainWith(pool, new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(PGroup group, Closure<Boolean> closure) {
        return this.chainWith(group, new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(Map<String, Object> params, Closure<Boolean> closure) {
        return this.chainWith(params, new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(Pool pool, Map<String, Object> params, Closure<Boolean> closure) {
        return this.chainWith(pool, params, new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(PGroup group, Map<String, Object> params, Closure<Boolean> closure) {
        return this.chainWith(group, params, new FilterClosure(closure));
    }

    @Override
    public void into(DataflowWriteChannel<T> target) {
        this.into(Dataflow.retrieveCurrentDFPGroup(), target);
    }

    @Override
    public void into(Pool pool, DataflowWriteChannel<T> target) {
        this.into(new DefaultPGroup(pool), target);
    }

    @Override
    public void into(PGroup group, DataflowWriteChannel<T> target) {
        group.operator(this, target, new ChainWithClosure(new CopyChannelsClosure()));
    }

    @Override
    public void into(Map<String, Object> params, DataflowWriteChannel<T> target) {
        this.into(Dataflow.retrieveCurrentDFPGroup(), params, target);
    }

    @Override
    public void into(Pool pool, Map<String, Object> params, DataflowWriteChannel<T> target) {
        this.into(new DefaultPGroup(pool), params, target);
    }

    @Override
    public void into(PGroup group, Map<String, Object> params, DataflowWriteChannel<T> target) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", Arrays.asList(this));
        parameters.put("outputs", Arrays.asList(target));
        group.operator(parameters, new ChainWithClosure(new CopyChannelsClosure()));
    }

    @Override
    public void or(DataflowWriteChannel<T> target) {
        this.into(target);
    }

    @Override
    public void split(DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), target1, target2);
    }

    @Override
    public void split(Pool pool, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split((PGroup)new DefaultPGroup(pool), target1, target2);
    }

    @Override
    public void split(PGroup group, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(group, Arrays.asList(target1, target2));
    }

    @Override
    public void split(List<DataflowWriteChannel<T>> targets) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), targets);
    }

    @Override
    public void split(Pool pool, List<DataflowWriteChannel<T>> targets) {
        this.split(new DefaultPGroup(pool), targets);
    }

    @Override
    public void split(PGroup group, List<DataflowWriteChannel<T>> targets) {
        group.operator(Arrays.asList(this), targets, new ChainWithClosure(new CopyChannelsClosure()));
    }

    @Override
    public void split(Map<String, Object> params, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), params, target1, target2);
    }

    @Override
    public void split(Pool pool, Map<String, Object> params, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(new DefaultPGroup(pool), params, target1, target2);
    }

    @Override
    public void split(PGroup group, Map<String, Object> params, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(group, params, Arrays.asList(target1, target2));
    }

    @Override
    public void split(Map<String, Object> params, List<DataflowWriteChannel<T>> targets) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), params, targets);
    }

    @Override
    public void split(Pool pool, Map<String, Object> params, List<DataflowWriteChannel<T>> targets) {
        this.split((PGroup)new DefaultPGroup(pool), params, targets);
    }

    @Override
    public void split(PGroup group, Map<String, Object> params, List<DataflowWriteChannel<T>> targets) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", Arrays.asList(this));
        parameters.put("outputs", Arrays.asList(targets));
        group.operator(parameters, new ChainWithClosure(new CopyChannelsClosure()));
    }

    @Override
    public DataflowReadChannel<T> tap(DataflowWriteChannel<T> target) {
        return this.tap(Dataflow.retrieveCurrentDFPGroup(), target);
    }

    @Override
    public DataflowReadChannel<T> tap(Pool pool, DataflowWriteChannel<T> target) {
        return this.tap(new DefaultPGroup(pool), target);
    }

    @Override
    public DataflowReadChannel<T> tap(PGroup group, DataflowWriteChannel<T> target) {
        DataflowQueue<T> result = new DataflowQueue<T>();
        group.operator(Arrays.asList(this), Arrays.asList(result, target), new ChainWithClosure(new CopyChannelsClosure()));
        return result;
    }

    @Override
    public DataflowReadChannel<T> tap(Map<String, Object> params, DataflowWriteChannel<T> target) {
        return this.tap(Dataflow.retrieveCurrentDFPGroup(), params, target);
    }

    @Override
    public DataflowReadChannel<T> tap(Pool pool, Map<String, Object> params, DataflowWriteChannel<T> target) {
        return this.tap(new DefaultPGroup(pool), params, target);
    }

    @Override
    public DataflowReadChannel<T> tap(PGroup group, Map<String, Object> params, DataflowWriteChannel<T> target) {
        DataflowQueue<T> result = new DataflowQueue<T>();
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", Arrays.asList(this));
        parameters.put("outputs", Arrays.asList(result, target));
        group.operator(parameters, new ChainWithClosure(new CopyChannelsClosure()));
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> merge(DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(pool, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(group, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge(Dataflow.retrieveCurrentDFPGroup(), others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge((PGroup)new DefaultPGroup(pool), others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        DataflowQueue<T> result = new DataflowQueue<T>();
        ArrayList<DataflowReadChannel<Object>> inputs = new ArrayList<DataflowReadChannel<Object>>();
        inputs.add(this);
        inputs.addAll(others);
        group.operator(inputs, Arrays.asList(result), new ChainWithClosure(closure));
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Map<String, Object> params, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(params, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, Map<String, Object> params, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(pool, params, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, Map<String, Object> params, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(group, params, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Map<String, Object> params, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge(Dataflow.retrieveCurrentDFPGroup(), params, others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, Map<String, Object> params, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge((PGroup)new DefaultPGroup(pool), params, others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, Map<String, Object> params, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        DataflowQueue<T> result = new DataflowQueue<T>();
        ArrayList<DataflowReadChannel<Object>> inputs = new ArrayList<DataflowReadChannel<Object>>();
        inputs.add(this);
        inputs.addAll(others);
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", inputs);
        parameters.put("outputs", Arrays.asList(result));
        group.operator(parameters, new ChainWithClosure(closure));
        return result;
    }

    @Override
    public void binaryChoice(DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(Dataflow.retrieveCurrentDFPGroup(), trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(Pool pool, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(new DefaultPGroup(pool), trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(PGroup group, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        group.operator(Arrays.asList(this), Arrays.asList(trueBranch, falseBranch), (Closure)new BinaryChoiceClosure(code));
    }

    @Override
    public void binaryChoice(Map<String, Object> params, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(Dataflow.retrieveCurrentDFPGroup(), params, trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(Pool pool, Map<String, Object> params, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(new DefaultPGroup(pool), params, trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(PGroup group, Map<String, Object> params, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", Arrays.asList(this));
        parameters.put("outputs", Arrays.asList(trueBranch, falseBranch));
        group.operator(parameters, new BinaryChoiceClosure(code));
    }

    @Override
    public void choice(List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(Dataflow.retrieveCurrentDFPGroup(), outputs, code);
    }

    @Override
    public void choice(Pool pool, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(new DefaultPGroup(pool), outputs, code);
    }

    @Override
    public void choice(PGroup group, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        group.operator(Arrays.asList(this), outputs, (Closure)new ChoiceClosure(code));
    }

    @Override
    public void choice(Map<String, Object> params, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(Dataflow.retrieveCurrentDFPGroup(), params, outputs, code);
    }

    @Override
    public void choice(Pool pool, Map<String, Object> params, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(new DefaultPGroup(pool), params, outputs, code);
    }

    @Override
    public void choice(PGroup group, Map<String, Object> params, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", Arrays.asList(this));
        parameters.put("outputs", Arrays.asList(outputs));
        group.operator(parameters, new ChoiceClosure(code));
    }

    @Override
    public void separate(List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(Dataflow.retrieveCurrentDFPGroup(), outputs, code);
    }

    @Override
    public void separate(Pool pool, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(new DefaultPGroup(pool), outputs, code);
    }

    @Override
    public void separate(PGroup group, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        group.operator(Arrays.asList(this), outputs, (Closure)new SeparationClosure(code));
    }

    @Override
    public void separate(Map<String, Object> params, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(Dataflow.retrieveCurrentDFPGroup(), params, outputs, code);
    }

    @Override
    public void separate(Pool pool, Map<String, Object> params, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(new DefaultPGroup(pool), params, outputs, code);
    }

    @Override
    public void separate(PGroup group, Map<String, Object> params, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.put("inputs", Arrays.asList(this));
        parameters.put("outputs", Arrays.asList(outputs));
        group.operator(parameters, new SeparationClosure(code));
    }

    @Override
    public final boolean isBound() {
        return !this.queue.isEmpty();
    }

    private DataflowVariable<T> retrieveOrCreateVariable() {
        return this.copyDFV(this.queue, this.requests);
    }

    @Override
    public final int length() {
        return this.queue.size();
    }

    public final Iterator<T> iterator() {
        final Iterator<DataflowVariable<T>> iterator = this.queue.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                try {
                    return ((DataflowVariable)iterator.next()).getVal();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("The thread has been interrupted, which prevented the iterator from retrieving the next element.", e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not available");
            }
        };
    }

    @Override
    public synchronized DataflowChannelEventListenerManager<T> getEventManager() {
        if (this.eventManager != null) {
            return this.eventManager;
        }
        this.eventManager = new DataflowChannelEventOrchestrator();
        return this.eventManager;
    }

    private void fireOnMessage(T value) {
        if (this.eventManager != null) {
            this.eventManager.fireOnMessage(value);
        }
    }

    final LinkedBlockingQueue<DataflowVariable<T>> getQueue() {
        return this.queue;
    }

    public String toString() {
        return "DataflowQueue(queue=" + new ArrayList<DataflowVariable<T>>(this.queue).toString() + ')';
    }
}

