/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import com.intellij.openapi.project.Project;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.metadata.CommonAnalysisKt;
import org.jetbrains.kotlin.cli.metadata.MetadataSerializerExtension;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMappingKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J8\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\u000e\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\f\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer;", "", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "dependOnOldBuiltIns", "", "(Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;Z)V", "totalFiles", "", "getTotalFiles", "()I", "setTotalFiles", "(I)V", "totalSize", "getTotalSize", "setTotalSize", "createSerializerExtension", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "getClassFilePath", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackageFilePath", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "fileName", "performSerialization", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "destDir", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "serialize", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "PackageSerializer", "cli"})
public class MetadataSerializer {
    @NotNull
    private final BuiltInsBinaryVersion metadataVersion;
    private final boolean dependOnOldBuiltIns;
    private int totalSize;
    private int totalFiles;

    public MetadataSerializer(@NotNull BuiltInsBinaryVersion metadataVersion, boolean dependOnOldBuiltIns) {
        Intrinsics.checkParameterIsNotNull(metadataVersion, "metadataVersion");
        this.metadataVersion = metadataVersion;
        this.dependOnOldBuiltIns = dependOnOldBuiltIns;
    }

    protected final int getTotalSize() {
        return this.totalSize;
    }

    protected final void setTotalSize(int n) {
        this.totalSize = n;
    }

    protected final int getTotalFiles() {
        return this.totalFiles;
    }

    protected final void setTotalFiles(int n) {
        this.totalFiles = n;
    }

    public final void serialize(@NotNull KotlinCoreEnvironment environment) {
        Intrinsics.checkParameterIsNotNull(environment, "environment");
        AnalyzerWithCompilerReport analyzer2 = CommonAnalysisKt.runCommonAnalysisForSerialization(environment, this.dependOnOldBuiltIns, null);
        if (analyzer2 == null || analyzer2.hasErrors()) {
            return;
        }
        AnalysisResult analysisResult2 = analyzer2.getAnalysisResult();
        BindingContext bindingContext = analysisResult2.component1();
        ModuleDescriptor moduleDescriptor = analysisResult2.component2();
        File file2 = CommonAnalysisKt.getDestDir(environment);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (file2 == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        File destDir = file2;
        this.performSerialization((Collection<? extends KtFile>)environment.getSourceFiles(), bindingContext, moduleDescriptor, destDir, environment.getProject());
    }

    protected void performSerialization(@NotNull Collection<? extends KtFile> files2, @NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2, @NotNull File destDir, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull(files2, "files");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(destDir, "destDir");
        boolean bl = false;
        HashMap packageTable = new HashMap();
        for (KtFile ktFile : files2) {
            Object object;
            FqName packageFqName = ktFile.getPackageFqName();
            boolean bl4 = false;
            ArrayList<DeclarationDescriptor> members = new ArrayList<DeclarationDescriptor>();
            for (KtDeclaration declaration232 : ktFile.getDeclarations()) {
                declaration232.accept(new KtVisitorVoid(members, bindingContext, destDir, this, packageFqName, project){
                    final /* synthetic */ ArrayList<DeclarationDescriptor> $members;
                    final /* synthetic */ BindingContext $bindingContext;
                    final /* synthetic */ File $destDir;
                    final /* synthetic */ MetadataSerializer this$0;
                    final /* synthetic */ FqName $packageFqName;
                    final /* synthetic */ Project $project;
                    {
                        this.$members = $members;
                        this.$bindingContext = $bindingContext;
                        this.$destDir = $destDir;
                        this.this$0 = $receiver;
                        this.$packageFqName = $packageFqName;
                        this.$project = $project;
                    }

                    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                        Intrinsics.checkParameterIsNotNull(function2, "function");
                        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.$bindingContext.get(BindingContext.FUNCTION, function2);
                        if (simpleFunctionDescriptor == null) {
                            String string2 = Intrinsics.stringPlus("No descriptor found for function ", function2.getFqName());
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        this.$members.add(simpleFunctionDescriptor);
                    }

                    public void visitProperty(@NotNull KtProperty property2) {
                        Intrinsics.checkParameterIsNotNull(property2, "property");
                        VariableDescriptor variableDescriptor = (VariableDescriptor)this.$bindingContext.get(BindingContext.VARIABLE, property2);
                        if (variableDescriptor == null) {
                            String string2 = Intrinsics.stringPlus("No descriptor found for property ", property2.getFqName());
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        this.$members.add(variableDescriptor);
                    }

                    public void visitTypeAlias(@NotNull KtTypeAlias typeAlias) {
                        Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
                        TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)this.$bindingContext.get(BindingContext.TYPE_ALIAS, typeAlias);
                        if (typeAliasDescriptor == null) {
                            String string2 = Intrinsics.stringPlus("No descriptor found for type alias ", typeAlias.getFqName());
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        this.$members.add(typeAliasDescriptor);
                    }

                    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
                        ClassDescriptor classDescriptor;
                        Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
                        ClassDescriptor classDescriptor2 = (ClassDescriptor)this.$bindingContext.get(BindingContext.CLASS, classOrObject);
                        if (classDescriptor2 == null) {
                            String string2 = Intrinsics.stringPlus("No descriptor found for class ", classOrObject.getFqName());
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        ClassDescriptor classDescriptor3 = classDescriptor = classDescriptor2;
                        File destFile = new File(this.$destDir, MetadataSerializer.access$getClassFilePath(this.this$0, new ClassId(this.$packageFqName, classDescriptor3.getName())));
                        this.this$0.new PackageSerializer((Collection<? extends DeclarationDescriptor>)CollectionsKt.listOf(classDescriptor3), (Collection<? extends DeclarationDescriptor>)CollectionsKt.emptyList(), this.$packageFqName, destFile, this.$project).run();
                    }
                });
            }
            Collection bl2 = members;
            boolean declaration232 = false;
            if (!(!bl2.isEmpty())) continue;
            String declaration232 = ktFile.getName();
            Intrinsics.checkExpressionValueIsNotNull(declaration232, "file.name");
            File destFile = new File(destDir, this.getPackageFilePath(packageFqName, declaration232));
            new PackageSerializer(CollectionsKt.emptyList(), (Collection<? extends DeclarationDescriptor>)members, packageFqName, destFile, project).run();
            Map $this$getOrPut$iv = packageTable;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(packageFqName);
            if (value$iv == null) {
                boolean bl3 = false;
                String string2 = packageFqName.asString();
                Intrinsics.checkExpressionValueIsNotNull(string2, "packageFqName.asString()");
                PackageParts answer$iv = new PackageParts(string2);
                $this$getOrPut$iv.put(packageFqName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((PackageParts)object).addMetadataPart(FilesKt.getNameWithoutExtension(destFile));
        }
        File kotlinModuleFile = new File(destDir, JvmCodegenUtil.getMappingFileName(JvmCodegenUtil.getModuleName(module2)));
        JvmModuleProtoBuf.Module.Builder builder2 = JvmModuleProtoBuf.Module.newBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        JvmModuleProtoBuf.Module.Builder $this$performSerialization_u24lambda_u2d1 = builder2;
        boolean bl6 = false;
        for (PackageParts table : packageTable.values()) {
            Intrinsics.checkExpressionValueIsNotNull($this$performSerialization_u24lambda_u2d1, "this");
            table.addTo($this$performSerialization_u24lambda_u2d1);
        }
        JvmModuleProtoBuf.Module module3 = builder2.build();
        Intrinsics.checkExpressionValueIsNotNull(module3, "newBuilder().apply {\n            for (table in packageTable.values) {\n                table.addTo(this)\n            }\n        }.build()");
        byte[] byArray = ModuleMappingKt.serializeToByteArray(module3, JvmMetadataVersion.INSTANCE, 0);
        kotlinModuleFile.getParentFile().mkdirs();
        FilesKt.writeBytes(kotlinModuleFile, byArray);
    }

    @NotNull
    protected KotlinSerializerExtensionBase createSerializerExtension() {
        return new MetadataSerializerExtension(this.metadataVersion);
    }

    private final String getPackageFilePath(FqName packageFqName, String fileName) {
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = packageFqName.asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "packageFqName.asString()");
        return stringBuilder2.append(StringsKt.replace$default(string2, '.', '/', false, 4, null)).append('/').append(PackagePartClassUtils.getFilePartShortName(fileName)).append(".kotlin_metadata").toString();
    }

    private final String getClassFilePath(ClassId classId) {
        String string2 = classId.asSingleFqName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "classId.asSingleFqName().asString()");
        return Intrinsics.stringPlus(StringsKt.replace$default(string2, '.', '/', false, 4, null), ".kotlin_metadata");
    }

    public static final /* synthetic */ String access$getClassFilePath(MetadataSerializer $this, ClassId classId) {
        return $this.getClassFilePath(classId);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0002J(\u0010\u0015\u001a\u00020\u00132\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u001e\u0010\u0018\u001a\u00020\u00132\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer$PackageSerializer;", "", "classes", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "members", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "destFile", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer;Ljava/util/Collection;Ljava/util/Collection;Lorg/jetbrains/kotlin/name/FqName;Ljava/io/File;Lcom/intellij/openapi/project/Project;)V", "extension", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment$Builder;", "kotlin.jvm.PlatformType", "run", "", "serializeBuiltInsFile", "serializeClasses", "parentSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "serializeMembers", "serializer", "serializeStringTable", "write", "stream", "Ljava/io/ByteArrayOutputStream;", "cli"})
    protected final class PackageSerializer {
        @NotNull
        private final Collection<DeclarationDescriptor> classes;
        @NotNull
        private final Collection<DeclarationDescriptor> members;
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final File destFile;
        @Nullable
        private final Project project;
        private final ProtoBuf.PackageFragment.Builder proto;
        @NotNull
        private final KotlinSerializerExtensionBase extension;

        public PackageSerializer(@NotNull Collection<? extends DeclarationDescriptor> classes2, @NotNull Collection<? extends DeclarationDescriptor> members, @NotNull FqName packageFqName, @Nullable File destFile, Project project) {
            Intrinsics.checkParameterIsNotNull(MetadataSerializer.this, "this$0");
            Intrinsics.checkParameterIsNotNull(classes2, "classes");
            Intrinsics.checkParameterIsNotNull(members, "members");
            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
            Intrinsics.checkParameterIsNotNull(destFile, "destFile");
            this.classes = classes2;
            this.members = members;
            this.packageFqName = packageFqName;
            this.destFile = destFile;
            this.project = project;
            this.proto = ProtoBuf.PackageFragment.newBuilder();
            this.extension = MetadataSerializer.this.createSerializerExtension();
        }

        public /* synthetic */ PackageSerializer(Collection collection, Collection collection2, FqName fqName2, File file2, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                project = null;
            }
            this(collection, collection2, fqName2, file2, project);
        }

        public final void run() {
            DescriptorSerializer serializer2 = DescriptorSerializer.Companion.createTopLevel(this.extension);
            this.serializeClasses(this.classes, serializer2, this.project);
            this.serializeMembers(this.members, serializer2);
            this.serializeStringTable();
            this.serializeBuiltInsFile();
        }

        private final void serializeClasses(Collection<? extends DeclarationDescriptor> classes2, DescriptorSerializer parentSerializer, Project project) {
            for (DeclarationDescriptor declarationDescriptor : DescriptorSerializer.Companion.sort(classes2)) {
                if (!(declarationDescriptor instanceof ClassDescriptor) || ((ClassDescriptor)declarationDescriptor).getKind() == ClassKind.ENUM_ENTRY) continue;
                DescriptorSerializer serializer2 = DescriptorSerializer.Companion.create((ClassDescriptor)declarationDescriptor, this.extension, parentSerializer, project);
                MemberScope memberScope2 = ((ClassDescriptor)declarationDescriptor).getUnsubstitutedInnerClassesScope();
                Intrinsics.checkExpressionValueIsNotNull(memberScope2, "descriptor.unsubstitutedInnerClassesScope");
                this.serializeClasses(ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, DescriptorKindFilter.CLASSIFIERS, null, 2, null), serializer2, project);
                this.proto.addClass_(serializer2.classProto((ClassDescriptor)declarationDescriptor).build());
            }
        }

        private final void serializeMembers(Collection<? extends DeclarationDescriptor> members, DescriptorSerializer serializer2) {
            this.proto.setPackage(serializer2.packagePartProto(this.packageFqName, members).build());
        }

        private final void serializeStringTable() {
            Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = this.extension.getStringTable().buildProto();
            ProtoBuf.StringTable strings2 = pair.component1();
            ProtoBuf.QualifiedNameTable qualifiedNames = pair.component2();
            this.proto.setStrings(strings2);
            this.proto.setQualifiedNames(qualifiedNames);
        }

        private final void serializeBuiltInsFile() {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(stream);
            boolean bl = false;
            boolean bl2 = false;
            DataOutputStream $this$serializeBuiltInsFile_u24lambda_u2d1 = dataOutputStream;
            boolean bl3 = false;
            int[] version = this.extension.getMetadataVersion().toArray();
            $this$serializeBuiltInsFile_u24lambda_u2d1.writeInt(version.length);
            int[] $this$forEach$iv = version;
            boolean $i$f$forEach = false;
            int[] nArray = $this$forEach$iv;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int element$iv;
                int it = element$iv = nArray[i];
                boolean bl4 = false;
                $this$serializeBuiltInsFile_u24lambda_u2d1.writeInt(it);
            }
            this.proto.build().writeTo(stream);
            this.write(stream);
        }

        private final void write(ByteArrayOutputStream stream) {
            MetadataSerializer metadataSerializer = MetadataSerializer.this;
            metadataSerializer.setTotalSize(metadataSerializer.getTotalSize() + stream.size());
            metadataSerializer = MetadataSerializer.this;
            int n = metadataSerializer.getTotalFiles();
            metadataSerializer.setTotalFiles(n + 1);
            boolean bl = !this.destFile.isDirectory();
            n = 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = Intrinsics.stringPlus("Cannot write because output destination is a directory: ", this.destFile);
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            this.destFile.getParentFile().mkdirs();
            byte[] byArray = stream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "stream.toByteArray()");
            FilesKt.writeBytes(this.destFile, byArray);
        }
    }
}

