/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirReservedUnderscoreCheckersKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.stubs.elements.KtDotQualifiedExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtNameReferenceExpressionElementType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReservedUnderscoreExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "reportIfUnderscoreInQualifiedAccess", "source", "Lorg/jetbrains/kotlin/fir/FirLightSourceElement;", "Lorg/jetbrains/kotlin/fir/FirPsiSourceElement;", "checkers"})
public final class FirReservedUnderscoreExpressionChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirReservedUnderscoreExpressionChecker INSTANCE = new FirReservedUnderscoreExpressionChecker();

    private FirReservedUnderscoreExpressionChecker() {
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSourceElement source = expression2.getSource();
        if (expression2 instanceof FirFunctionCall) {
            FirSourceElement calleeReferenceSource = ((FirFunctionCall)expression2).getCalleeReference().getSource();
            if (calleeReferenceSource instanceof FirLightSourceElement && Intrinsics.areEqual(((FirLightSourceElement)calleeReferenceSource).getLighterASTNode().getTokenType(), KtNodeTypes.OPERATION_REFERENCE)) {
                return;
            }
            FirReservedUnderscoreCheckersKt.reportIfUnderscore$default(FirSourceElementKt.getText(((FirFunctionCall)expression2).getCalleeReference().getSource()), ((FirFunctionCall)expression2).getCalleeReference().getSource(), context2, reporter, false, true, 16, null);
        } else if (expression2 instanceof FirQualifiedAccess) {
            if (source instanceof FirPsiSourceElement) {
                this.reportIfUnderscoreInQualifiedAccess((FirPsiSourceElement)source, expression2, context2, reporter);
            } else if (source instanceof FirLightSourceElement) {
                this.reportIfUnderscoreInQualifiedAccess((FirLightSourceElement)source, expression2, context2, reporter);
            }
        } else if (expression2 instanceof FirGetClassCall) {
            for (FirExpression argument2 : ((FirGetClassCall)expression2).getArgumentList().getArguments()) {
                FirReservedUnderscoreCheckersKt.reportIfUnderscore$default(FirSourceElementKt.getText(argument2.getSource()), expression2.getSource(), context2, reporter, false, true, 16, null);
            }
        } else if (expression2 instanceof FirReturnExpression) {
            LighterASTNode parent2;
            String labelName = null;
            if (source instanceof FirPsiSourceElement) {
                PsiElement psiElement = ((FirPsiSourceElement)source).getPsi().getParent();
                KtLabeledExpression argument2 = psiElement instanceof KtLabeledExpression ? (KtLabeledExpression)psiElement : null;
                labelName = argument2 == null ? null : argument2.getLabelName();
            } else if (source instanceof FirLightSourceElement && (parent2 = ((FirLightSourceElement)source).getTreeStructure().getParent(((FirLightSourceElement)source).getLighterASTNode())) != null && Intrinsics.areEqual(parent2.getTokenType(), KtNodeTypes.LABELED_EXPRESSION)) {
                FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = ((FirLightSourceElement)source).getTreeStructure();
                Object object = KtNodeTypes.LABEL;
                Intrinsics.checkNotNullExpressionValue(object, "LABEL");
                labelName = String.valueOf(LightTreePositioningStrategiesKt.findDescendantByType(flyweightCapableTreeStructure, parent2, (IElementType)object));
                object = labelName;
                int n = 0;
                int n2 = labelName.length() - 1;
                boolean bl = false;
                Object object2 = object;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object2).substring(n, n2);
                Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                labelName = string2;
            }
            FirReservedUnderscoreCheckersKt.reportIfUnderscore$default(labelName, expression2.getSource(), context2, reporter, false, false, 48, null);
        }
    }

    private final void reportIfUnderscoreInQualifiedAccess(FirPsiSourceElement<?> source, FirStatement expression2, CheckerContext context2, DiagnosticReporter reporter) {
        Object psi = source.getPsi();
        if (!(psi.getParent() instanceof KtDotQualifiedExpression) && !(psi.getParent() instanceof KtCallableReferenceExpression)) {
            FirReservedUnderscoreExpressionChecker.reportIfUnderscoreInQualifiedAccess$processQualifiedAccess(expression2, context2, reporter, psi);
        }
    }

    private final void reportIfUnderscoreInQualifiedAccess(FirLightSourceElement source, FirStatement expression2, CheckerContext context2, DiagnosticReporter reporter) {
        LighterASTNode astNode = source.getLighterASTNode();
        LighterASTNode parent2 = source.getTreeStructure().getParent(astNode);
        LighterASTNode lighterASTNode2 = parent2;
        if (!((lighterASTNode2 == null ? null : lighterASTNode2.getTokenType()) instanceof KtDotQualifiedExpressionElementType) && !Intrinsics.areEqual((lighterASTNode2 = parent2) == null ? null : lighterASTNode2.getTokenType(), KtNodeTypes.CALLABLE_REFERENCE_EXPRESSION)) {
            FirReservedUnderscoreExpressionChecker.reportIfUnderscoreInQualifiedAccess$processQualifiedAccess-0(expression2, context2, reporter, source, astNode);
        }
    }

    private static final void reportIfUnderscoreInQualifiedAccess$processQualifiedAccess(FirStatement $expression, CheckerContext $context, DiagnosticReporter $reporter, PsiElement psi) {
        if (psi instanceof KtNameReferenceExpression) {
            FirReservedUnderscoreCheckersKt.reportIfUnderscore$default(((KtNameReferenceExpression)psi).getText(), $expression.getSource(), $context, $reporter, false, true, 16, null);
        } else if (psi instanceof KtDotQualifiedExpression || psi instanceof KtCallableReferenceExpression) {
            FirReservedUnderscoreExpressionChecker.reportIfUnderscoreInQualifiedAccess$processQualifiedAccess($expression, $context, $reporter, psi.getFirstChild());
            FirReservedUnderscoreExpressionChecker.reportIfUnderscoreInQualifiedAccess$processQualifiedAccess($expression, $context, $reporter, psi.getLastChild());
        }
    }

    private static final void reportIfUnderscoreInQualifiedAccess$processQualifiedAccess-0(FirStatement $expression, CheckerContext $context, DiagnosticReporter $reporter, FirLightSourceElement $source, LighterASTNode lightSourceElement) {
        IElementType tokenType;
        LighterASTNode lighterASTNode2 = lightSourceElement;
        IElementType iElementType = tokenType = lighterASTNode2 == null ? null : lighterASTNode2.getTokenType();
        if (tokenType instanceof KtNameReferenceExpressionElementType) {
            FirReservedUnderscoreCheckersKt.reportIfUnderscore$default(lightSourceElement.toString(), $expression.getSource(), $context, $reporter, false, true, 16, null);
        } else if (lightSourceElement != null && (tokenType instanceof KtDotQualifiedExpressionElementType || Intrinsics.areEqual(tokenType, KtNodeTypes.CALLABLE_REFERENCE_EXPRESSION))) {
            List<LighterASTNode> children2 = SourceHelpersKt.getChildren(lightSourceElement, $source.getTreeStructure());
            FirReservedUnderscoreExpressionChecker.reportIfUnderscoreInQualifiedAccess$processQualifiedAccess-0($expression, $context, $reporter, $source, CollectionsKt.first(children2));
            FirReservedUnderscoreExpressionChecker.reportIfUnderscoreInQualifiedAccess$processQualifiedAccess-0($expression, $context, $reporter, $source, CollectionsKt.last(children2));
        }
    }
}

