/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u00020\u00032\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dumpValue", "value", "process", "", "srcFile", "newMap", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "sourceFile", "kotlin-build-common"})
final class InlineFunctionsMap
extends BasicStringMap<Map<String, ? extends Long>> {
    @NotNull
    private final FileToPathConverter pathConverter;

    public InlineFunctionsMap(@NotNull File storageFile, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter(storageFile, "storageFile");
        Intrinsics.checkNotNullParameter(pathConverter, "pathConverter");
        super(storageFile, StringToLongMapExternalizer.INSTANCE);
        this.pathConverter = pathConverter;
    }

    public final void process(@NotNull File srcFile, @NotNull Map<String, Long> newMap2, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter(srcFile, "srcFile");
        Intrinsics.checkNotNullParameter(newMap2, "newMap");
        Intrinsics.checkNotNullParameter(changesCollector, "changesCollector");
        String key = this.pathConverter.toPath(srcFile);
        Object object = (Map<String, Long>)this.getStorage().get(key);
        Map<String, Long> oldMap2 = object == null ? MapsKt.emptyMap() : object;
        object = newMap2;
        boolean bl = false;
        if (!object.isEmpty()) {
            this.getStorage().set(key, newMap2);
        } else {
            this.getStorage().remove(key);
        }
        for (String fn : SetsKt.plus(oldMap2.keySet(), (Iterable)newMap2.keySet())) {
            String[] stringArray = new String[]{"."};
            List fqNameSegments = StringsKt.split$default((CharSequence)StringsKt.removePrefix(StringsKt.removePrefix(fn, (CharSequence)"<get>"), (CharSequence)"<set>"), stringArray, false, 0, 6, null);
            Object object2 = FqName.fromSegments(fqNameSegments);
            Intrinsics.checkNotNullExpressionValue(object2, "fromSegments(fqNameSegments)");
            FqName fqName2 = object2;
            object2 = fqName2.parent();
            Intrinsics.checkNotNullExpressionValue(object2, "fqName.parent()");
            FqName fqName3 = object2;
            object2 = fqName2.shortName().asString();
            Intrinsics.checkNotNullExpressionValue(object2, "fqName.shortName().asString()");
            changesCollector.collectMemberIfValueWasChanged(fqName3, (String)object2, oldMap2.get(fn), newMap2.get(fn));
        }
    }

    public final void remove(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        this.getStorage().remove(this.pathConverter.toPath(sourceFile));
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Map<String, Long> value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        return IncrementalJvmCacheKt.dumpMap(value2, dumpValue.1.INSTANCE);
    }
}

